/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import net.i2p.I2PAppContext;
import net.i2p.data.i2np.EncryptedBuildRecord;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.ShortEncryptedBuildRecord;
import net.i2p.data.i2np.TunnelBuildMessage;

public class ShortTunnelBuildMessage
extends TunnelBuildMessage {
    public static final int MESSAGE_TYPE = 25;
    public static final int SHORT_RECORD_SIZE = 236;

    public ShortTunnelBuildMessage(I2PAppContext context) {
        super(context, 0);
    }

    public ShortTunnelBuildMessage(I2PAppContext context, int records) {
        super(context, records);
    }

    @Override
    protected int calculateWrittenLength() {
        return 1 + this.RECORD_COUNT * 236;
    }

    @Override
    public int getType() {
        return 25;
    }

    @Override
    public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException {
        if (type != 25) {
            throw new I2NPMessageException("Message type is incorrect for this message");
        }
        int r = data[offset] & 0xFF;
        if (r <= 0 || r > 8) {
            throw new I2NPMessageException("Bad record count " + r);
        }
        this.RECORD_COUNT = r;
        if (dataSize != this.calculateWrittenLength()) {
            throw new I2NPMessageException("Wrong length (expects " + this.calculateWrittenLength() + ", recv " + dataSize + ")");
        }
        this._records = new EncryptedBuildRecord[this.RECORD_COUNT];
        ++offset;
        for (int i = 0; i < this.RECORD_COUNT; ++i) {
            byte[] rec = new byte[236];
            System.arraycopy(data, offset, rec, 0, 236);
            this.setRecord(i, new ShortEncryptedBuildRecord(rec));
            offset += 236;
        }
    }

    @Override
    protected int writeMessageBody(byte[] out, int curIndex) throws I2NPMessageException {
        int remaining = out.length - (curIndex + this.calculateWrittenLength());
        if (remaining < 0) {
            throw new I2NPMessageException("Not large enough (too short by " + remaining + ")");
        }
        if (this.RECORD_COUNT <= 0 || this.RECORD_COUNT > 8) {
            throw new I2NPMessageException("Bad record count " + this.RECORD_COUNT);
        }
        out[curIndex++] = (byte)this.RECORD_COUNT;
        for (int i = 0; i < this.RECORD_COUNT; ++i) {
            System.arraycopy(this._records[i].getData(), 0, out, curIndex, 236);
            curIndex += 236;
        }
        return curIndex;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("[ShortTunnelBuildMessage: \n\tRecords: ").append(this.getRecordCount()).append(']');
        return buf.toString();
    }
}

