"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var interactions_1 = require("../../utils/interactions");
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var get_projected_pointer_position_1 = require("./get_projected_pointer_position");
exports.getOrientedProjectedPointerPositionSelector = re_reselect_1.default([get_projected_pointer_position_1.getProjectedPointerPositionSelector, compute_chart_dimensions_1.computeChartDimensionsSelector, get_settings_specs_1.getSettingsSpecSelector], getOrientedProjectedPointerPosition)(get_chart_id_1.getChartIdSelector);
function getOrientedProjectedPointerPosition(projectedPointerPosition, chartDimensions, settingsSpec) {
    var xPos = projectedPointerPosition.x;
    var yPos = projectedPointerPosition.y;
    var x = interactions_1.getOrientedXPosition(xPos, yPos, settingsSpec.rotation, chartDimensions.chartDimensions);
    var y = interactions_1.getOrientedYPosition(xPos, yPos, settingsSpec.rotation, chartDimensions.chartDimensions);
    return {
        x: x,
        y: y,
    };
}
//# sourceMappingURL=get_oriented_projected_pointer_position.js.map