/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGL14;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class EGL15
extends EGL14 {
    public static final int EGL_CONTEXT_MAJOR_VERSION = 12440;
    public static final int EGL_CONTEXT_MINOR_VERSION = 12539;
    public static final int EGL_CONTEXT_OPENGL_PROFILE_MASK = 12541;
    public static final int EGL_CONTEXT_OPENGL_RESET_NOTIFICATION_STRATEGY = 12733;
    public static final int EGL_NO_RESET_NOTIFICATION = 12734;
    public static final int EGL_LOSE_CONTEXT_ON_RESET = 12735;
    public static final int EGL_CONTEXT_OPENGL_CORE_PROFILE_BIT = 1;
    public static final int EGL_CONTEXT_OPENGL_COMPATIBILITY_PROFILE_BIT = 2;
    public static final int EGL_CONTEXT_OPENGL_DEBUG = 12720;
    public static final int EGL_CONTEXT_OPENGL_FORWARD_COMPATIBLE = 12721;
    public static final int EGL_CONTEXT_OPENGL_ROBUST_ACCESS = 12722;
    public static final int EGL_OPENGL_ES3_BIT = 64;
    public static final int EGL_CL_EVENT_HANDLE = 12444;
    public static final int EGL_SYNC_CL_EVENT = 12542;
    public static final int EGL_SYNC_CL_EVENT_COMPLETE = 12543;
    public static final int EGL_SYNC_PRIOR_COMMANDS_COMPLETE = 12528;
    public static final int EGL_SYNC_TYPE = 12535;
    public static final int EGL_SYNC_STATUS = 12529;
    public static final int EGL_SYNC_CONDITION = 12536;
    public static final int EGL_SIGNALED = 12530;
    public static final int EGL_UNSIGNALED = 12531;
    public static final int EGL_SYNC_FLUSH_COMMANDS_BIT = 1;
    public static final int EGL_TIMEOUT_EXPIRED = 12533;
    public static final int EGL_CONDITION_SATISFIED = 12534;
    public static final int EGL_SYNC_FENCE = 12537;
    public static final int EGL_GL_COLORSPACE = 12445;
    public static final int EGL_GL_COLORSPACE_SRGB = 12425;
    public static final int EGL_GL_COLORSPACE_LINEAR = 12426;
    public static final int EGL_GL_RENDERBUFFER = 12473;
    public static final int EGL_GL_TEXTURE_2D = 12465;
    public static final int EGL_GL_TEXTURE_LEVEL = 12476;
    public static final int EGL_GL_TEXTURE_3D = 12466;
    public static final int EGL_GL_TEXTURE_ZOFFSET = 12477;
    public static final int EGL_GL_TEXTURE_CUBE_MAP_POSITIVE_X = 12467;
    public static final int EGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_X = 12468;
    public static final int EGL_GL_TEXTURE_CUBE_MAP_POSITIVE_Y = 12469;
    public static final int EGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = 12470;
    public static final int EGL_GL_TEXTURE_CUBE_MAP_POSITIVE_Z = 12471;
    public static final int EGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = 12472;
    public static final int EGL_IMAGE_PRESERVED = 12498;
    public static final long EGL_FOREVER = -1L;
    public static final long EGL_NO_SYNC = 0L;
    public static final long EGL_NO_IMAGE = 0L;

    protected EGL15() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.eglCreateSync, caps.eglDestroySync, caps.eglClientWaitSync, caps.eglGetSyncAttrib, caps.eglCreateImage, caps.eglDestroyImage, caps.eglGetPlatformDisplay, caps.eglCreatePlatformWindowSurface, caps.eglCreatePlatformPixmapSurface, caps.eglWaitSync});
    }

    public static long neglCreateSync(long dpy, int type, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateSync;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)dpy);
        }
        return JNI.callPPP((long)dpy, (int)type, (long)attrib_list, (long)__functionAddress);
    }

    @NativeType(value="EGLSync")
    public static long eglCreateSync(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLenum") int type, @NativeType(value="EGLAttrib const *") PointerBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNT((PointerBuffer)attrib_list, (long)12344L);
        }
        return EGL15.neglCreateSync(dpy, type, MemoryUtil.memAddress((CustomBuffer)attrib_list));
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglDestroySync(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLSync") long sync) {
        long __functionAddress = EGL.getCapabilities().eglDestroySync;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)dpy);
            Checks.check((long)sync);
        }
        return JNI.callPPI((long)dpy, (long)sync, (long)__functionAddress) != 0;
    }

    @NativeType(value="EGLint")
    public static int eglClientWaitSync(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLSync") long sync, @NativeType(value="EGLint") int flags, @NativeType(value="EGLTime") long timeout) {
        long __functionAddress = EGL.getCapabilities().eglClientWaitSync;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)dpy);
            Checks.check((long)sync);
        }
        return JNI.callPPJI((long)dpy, (long)sync, (int)flags, (long)timeout, (long)__functionAddress);
    }

    public static int neglGetSyncAttrib(long dpy, long sync, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglGetSyncAttrib;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)dpy);
            Checks.check((long)sync);
        }
        return JNI.callPPPI((long)dpy, (long)sync, (int)attribute, (long)value, (long)__functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglGetSyncAttrib(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLSync") long sync, @NativeType(value="EGLint") int attribute, @NativeType(value="EGLAttrib const *") PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)value, (int)1);
        }
        return EGL15.neglGetSyncAttrib(dpy, sync, attribute, MemoryUtil.memAddress((CustomBuffer)value)) != 0;
    }

    public static long neglCreateImage(long dpy, long ctx, int target, long buffer, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateImage;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)dpy);
            Checks.check((long)ctx);
            Checks.check((long)buffer);
        }
        return JNI.callPPPPP((long)dpy, (long)ctx, (int)target, (long)buffer, (long)attrib_list, (long)__functionAddress);
    }

    @NativeType(value="EGLImage")
    public static long eglCreateImage(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLContext") long ctx, @NativeType(value="EGLenum") int target, @NativeType(value="EGLClientBuffer") long buffer, @Nullable @NativeType(value="EGLAttrib const *") PointerBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((PointerBuffer)attrib_list, (long)12344L);
        }
        return EGL15.neglCreateImage(dpy, ctx, target, buffer, MemoryUtil.memAddressSafe((Pointer)attrib_list));
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglDestroyImage(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLImage") long image) {
        long __functionAddress = EGL.getCapabilities().eglDestroyImage;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)dpy);
            Checks.check((long)image);
        }
        return JNI.callPPI((long)dpy, (long)image, (long)__functionAddress) != 0;
    }

    public static long neglGetPlatformDisplay(int platform, long native_display, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglGetPlatformDisplay;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)native_display);
        }
        return JNI.callPPP((int)platform, (long)native_display, (long)attrib_list, (long)__functionAddress);
    }

    @NativeType(value="EGLDisplay")
    public static long eglGetPlatformDisplay(@NativeType(value="EGLenum") int platform, @NativeType(value="void *") long native_display, @Nullable @NativeType(value="EGLAttrib const *") PointerBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((PointerBuffer)attrib_list, (long)12344L);
        }
        return EGL15.neglGetPlatformDisplay(platform, native_display, MemoryUtil.memAddressSafe((Pointer)attrib_list));
    }

    public static long neglCreatePlatformWindowSurface(long dpy, long config, long native_window, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreatePlatformWindowSurface;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)dpy);
            Checks.check((long)config);
            Checks.check((long)native_window);
        }
        return JNI.callPPPPP((long)dpy, (long)config, (long)native_window, (long)attrib_list, (long)__functionAddress);
    }

    @NativeType(value="EGLSurface")
    public static long eglCreatePlatformWindowSurface(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLConfig") long config, @NativeType(value="void *") long native_window, @Nullable @NativeType(value="EGLAttrib const *") PointerBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((PointerBuffer)attrib_list, (long)12344L);
        }
        return EGL15.neglCreatePlatformWindowSurface(dpy, config, native_window, MemoryUtil.memAddressSafe((Pointer)attrib_list));
    }

    public static long neglCreatePlatformPixmapSurface(long dpy, long config, long native_pixmap, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreatePlatformPixmapSurface;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)dpy);
            Checks.check((long)config);
            Checks.check((long)native_pixmap);
        }
        return JNI.callPPPPP((long)dpy, (long)config, (long)native_pixmap, (long)attrib_list, (long)__functionAddress);
    }

    @NativeType(value="EGLSurface")
    public static long eglCreatePlatformPixmapSurface(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLConfig") long config, @NativeType(value="void *") long native_pixmap, @Nullable @NativeType(value="EGLAttrib const *") PointerBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((PointerBuffer)attrib_list, (long)12344L);
        }
        return EGL15.neglCreatePlatformPixmapSurface(dpy, config, native_pixmap, MemoryUtil.memAddressSafe((Pointer)attrib_list));
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglWaitSync(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLSync") long sync, @NativeType(value="EGLint") int flags) {
        long __functionAddress = EGL.getCapabilities().eglWaitSync;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)dpy);
            Checks.check((long)sync);
        }
        return JNI.callPPI((long)dpy, (long)sync, (int)flags, (long)__functionAddress) != 0;
    }
}

