/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bullet;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct b3BodyInfo")
public class B3BodyInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M_BASENAME;
    public static final int M_BODYNAME;

    public B3BodyInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), B3BodyInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[1024]")
    public ByteBuffer m_baseName() {
        return B3BodyInfo.nm_baseName(this.address());
    }

    @NativeType(value="char[1024]")
    public String m_baseNameString() {
        return B3BodyInfo.nm_baseNameString(this.address());
    }

    @NativeType(value="char[1024]")
    public ByteBuffer m_bodyName() {
        return B3BodyInfo.nm_bodyName(this.address());
    }

    @NativeType(value="char[1024]")
    public String m_bodyNameString() {
        return B3BodyInfo.nm_bodyNameString(this.address());
    }

    public B3BodyInfo m_baseName(@NativeType(value="char[1024]") ByteBuffer value) {
        B3BodyInfo.nm_baseName(this.address(), value);
        return this;
    }

    public B3BodyInfo m_bodyName(@NativeType(value="char[1024]") ByteBuffer value) {
        B3BodyInfo.nm_bodyName(this.address(), value);
        return this;
    }

    public B3BodyInfo set(ByteBuffer m_baseName, ByteBuffer m_bodyName) {
        this.m_baseName(m_baseName);
        this.m_bodyName(m_bodyName);
        return this;
    }

    public B3BodyInfo set(B3BodyInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static B3BodyInfo malloc() {
        return (B3BodyInfo)B3BodyInfo.wrap(B3BodyInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static B3BodyInfo calloc() {
        return (B3BodyInfo)B3BodyInfo.wrap(B3BodyInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static B3BodyInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (B3BodyInfo)B3BodyInfo.wrap(B3BodyInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static B3BodyInfo create(long address) {
        return (B3BodyInfo)B3BodyInfo.wrap(B3BodyInfo.class, (long)address);
    }

    @Nullable
    public static B3BodyInfo createSafe(long address) {
        return address == 0L ? null : (B3BodyInfo)B3BodyInfo.wrap(B3BodyInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)B3BodyInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)B3BodyInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)B3BodyInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = B3BodyInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)B3BodyInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)B3BodyInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)B3BodyInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static B3BodyInfo mallocStack() {
        return B3BodyInfo.mallocStack(MemoryStack.stackGet());
    }

    public static B3BodyInfo callocStack() {
        return B3BodyInfo.callocStack(MemoryStack.stackGet());
    }

    public static B3BodyInfo mallocStack(MemoryStack stack) {
        return (B3BodyInfo)B3BodyInfo.wrap(B3BodyInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static B3BodyInfo callocStack(MemoryStack stack) {
        return (B3BodyInfo)B3BodyInfo.wrap(B3BodyInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return B3BodyInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return B3BodyInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)B3BodyInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)B3BodyInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ByteBuffer nm_baseName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)M_BASENAME), (int)1024);
    }

    public static String nm_baseNameString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)M_BASENAME));
    }

    public static ByteBuffer nm_bodyName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)M_BODYNAME), (int)1024);
    }

    public static String nm_bodyNameString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)M_BODYNAME));
    }

    public static void nm_baseName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
            Checks.checkGT((java.nio.Buffer)value, (int)1024);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)M_BASENAME), (long)value.remaining());
    }

    public static void nm_bodyName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
            Checks.checkGT((java.nio.Buffer)value, (int)1024);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)M_BODYNAME), (long)value.remaining());
    }

    static {
        Struct.Layout layout = B3BodyInfo.__struct((Struct.Member[])new Struct.Member[]{B3BodyInfo.__array((int)1, (int)1024), B3BodyInfo.__array((int)1, (int)1024)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M_BASENAME = layout.offsetof(0);
        M_BODYNAME = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<B3BodyInfo, Buffer>
    implements NativeResource {
        private static final B3BodyInfo ELEMENT_FACTORY = B3BodyInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected B3BodyInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[1024]")
        public ByteBuffer m_baseName() {
            return B3BodyInfo.nm_baseName(this.address());
        }

        @NativeType(value="char[1024]")
        public String m_baseNameString() {
            return B3BodyInfo.nm_baseNameString(this.address());
        }

        @NativeType(value="char[1024]")
        public ByteBuffer m_bodyName() {
            return B3BodyInfo.nm_bodyName(this.address());
        }

        @NativeType(value="char[1024]")
        public String m_bodyNameString() {
            return B3BodyInfo.nm_bodyNameString(this.address());
        }

        public Buffer m_baseName(@NativeType(value="char[1024]") ByteBuffer value) {
            B3BodyInfo.nm_baseName(this.address(), value);
            return this;
        }

        public Buffer m_bodyName(@NativeType(value="char[1024]") ByteBuffer value) {
            B3BodyInfo.nm_bodyName(this.address(), value);
            return this;
        }
    }
}

