/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.llvm.CXCursor;
import org.lwjgl.llvm.CXIdxContainerInfo;
import org.lwjgl.llvm.CXIdxEntityInfo;
import org.lwjgl.llvm.CXIdxLoc;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXIdxDeclInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ENTITYINFO;
    public static final int CURSOR;
    public static final int LOC;
    public static final int SEMANTICCONTAINER;
    public static final int LEXICALCONTAINER;
    public static final int ISREDECLARATION;
    public static final int ISDEFINITION;
    public static final int ISCONTAINER;
    public static final int DECLASCONTAINER;
    public static final int ISIMPLICIT;
    public static final int ATTRIBUTES;
    public static final int NUMATTRIBUTES;
    public static final int FLAGS;

    public CXIdxDeclInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXIdxDeclInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CXIdxEntityInfo const *")
    public CXIdxEntityInfo entityInfo() {
        return CXIdxDeclInfo.nentityInfo(this.address());
    }

    public CXCursor cursor() {
        return CXIdxDeclInfo.ncursor(this.address());
    }

    public CXIdxLoc loc() {
        return CXIdxDeclInfo.nloc(this.address());
    }

    @NativeType(value="CXIdxContainerInfo const *")
    public CXIdxContainerInfo semanticContainer() {
        return CXIdxDeclInfo.nsemanticContainer(this.address());
    }

    @NativeType(value="CXIdxContainerInfo const *")
    public CXIdxContainerInfo lexicalContainer() {
        return CXIdxDeclInfo.nlexicalContainer(this.address());
    }

    @NativeType(value="int")
    public boolean isRedeclaration() {
        return CXIdxDeclInfo.nisRedeclaration(this.address()) != 0;
    }

    @NativeType(value="int")
    public boolean isDefinition() {
        return CXIdxDeclInfo.nisDefinition(this.address()) != 0;
    }

    @NativeType(value="int")
    public boolean isContainer() {
        return CXIdxDeclInfo.nisContainer(this.address()) != 0;
    }

    @NativeType(value="CXIdxContainerInfo const *")
    public CXIdxContainerInfo declAsContainer() {
        return CXIdxDeclInfo.ndeclAsContainer(this.address());
    }

    @NativeType(value="int")
    public boolean isImplicit() {
        return CXIdxDeclInfo.nisImplicit(this.address()) != 0;
    }

    @NativeType(value="CXIdxAttrInfo const * const *")
    public PointerBuffer attributes() {
        return CXIdxDeclInfo.nattributes(this.address());
    }

    @NativeType(value="unsigned")
    public int numAttributes() {
        return CXIdxDeclInfo.nnumAttributes(this.address());
    }

    @NativeType(value="unsigned")
    public int flags() {
        return CXIdxDeclInfo.nflags(this.address());
    }

    public static CXIdxDeclInfo malloc() {
        return (CXIdxDeclInfo)CXIdxDeclInfo.wrap(CXIdxDeclInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CXIdxDeclInfo calloc() {
        return (CXIdxDeclInfo)CXIdxDeclInfo.wrap(CXIdxDeclInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CXIdxDeclInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CXIdxDeclInfo)CXIdxDeclInfo.wrap(CXIdxDeclInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CXIdxDeclInfo create(long address) {
        return (CXIdxDeclInfo)CXIdxDeclInfo.wrap(CXIdxDeclInfo.class, (long)address);
    }

    @Nullable
    public static CXIdxDeclInfo createSafe(long address) {
        return address == 0L ? null : (CXIdxDeclInfo)CXIdxDeclInfo.wrap(CXIdxDeclInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CXIdxDeclInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CXIdxDeclInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CXIdxDeclInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXIdxDeclInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CXIdxDeclInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CXIdxDeclInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CXIdxDeclInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CXIdxDeclInfo mallocStack() {
        return CXIdxDeclInfo.mallocStack(MemoryStack.stackGet());
    }

    public static CXIdxDeclInfo callocStack() {
        return CXIdxDeclInfo.callocStack(MemoryStack.stackGet());
    }

    public static CXIdxDeclInfo mallocStack(MemoryStack stack) {
        return (CXIdxDeclInfo)CXIdxDeclInfo.wrap(CXIdxDeclInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CXIdxDeclInfo callocStack(MemoryStack stack) {
        return (CXIdxDeclInfo)CXIdxDeclInfo.wrap(CXIdxDeclInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CXIdxDeclInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CXIdxDeclInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)CXIdxDeclInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)CXIdxDeclInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static CXIdxEntityInfo nentityInfo(long struct) {
        return CXIdxEntityInfo.create(MemoryUtil.memGetAddress((long)(struct + (long)ENTITYINFO)));
    }

    public static CXCursor ncursor(long struct) {
        return CXCursor.create(struct + (long)CURSOR);
    }

    public static CXIdxLoc nloc(long struct) {
        return CXIdxLoc.create(struct + (long)LOC);
    }

    public static CXIdxContainerInfo nsemanticContainer(long struct) {
        return CXIdxContainerInfo.create(MemoryUtil.memGetAddress((long)(struct + (long)SEMANTICCONTAINER)));
    }

    public static CXIdxContainerInfo nlexicalContainer(long struct) {
        return CXIdxContainerInfo.create(MemoryUtil.memGetAddress((long)(struct + (long)LEXICALCONTAINER)));
    }

    public static int nisRedeclaration(long struct) {
        return UNSAFE.getInt(null, struct + (long)ISREDECLARATION);
    }

    public static int nisDefinition(long struct) {
        return UNSAFE.getInt(null, struct + (long)ISDEFINITION);
    }

    public static int nisContainer(long struct) {
        return UNSAFE.getInt(null, struct + (long)ISCONTAINER);
    }

    public static CXIdxContainerInfo ndeclAsContainer(long struct) {
        return CXIdxContainerInfo.create(MemoryUtil.memGetAddress((long)(struct + (long)DECLASCONTAINER)));
    }

    public static int nisImplicit(long struct) {
        return UNSAFE.getInt(null, struct + (long)ISIMPLICIT);
    }

    public static PointerBuffer nattributes(long struct) {
        return MemoryUtil.memPointerBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)ATTRIBUTES)), (int)CXIdxDeclInfo.nnumAttributes(struct));
    }

    public static int nnumAttributes(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUMATTRIBUTES);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    static {
        Struct.Layout layout = CXIdxDeclInfo.__struct((Struct.Member[])new Struct.Member[]{CXIdxDeclInfo.__member((int)POINTER_SIZE), CXIdxDeclInfo.__member((int)CXCursor.SIZEOF, (int)CXCursor.ALIGNOF), CXIdxDeclInfo.__member((int)CXIdxLoc.SIZEOF, (int)CXIdxLoc.ALIGNOF), CXIdxDeclInfo.__member((int)POINTER_SIZE), CXIdxDeclInfo.__member((int)POINTER_SIZE), CXIdxDeclInfo.__member((int)4), CXIdxDeclInfo.__member((int)4), CXIdxDeclInfo.__member((int)4), CXIdxDeclInfo.__member((int)POINTER_SIZE), CXIdxDeclInfo.__member((int)4), CXIdxDeclInfo.__member((int)POINTER_SIZE), CXIdxDeclInfo.__member((int)4), CXIdxDeclInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ENTITYINFO = layout.offsetof(0);
        CURSOR = layout.offsetof(1);
        LOC = layout.offsetof(2);
        SEMANTICCONTAINER = layout.offsetof(3);
        LEXICALCONTAINER = layout.offsetof(4);
        ISREDECLARATION = layout.offsetof(5);
        ISDEFINITION = layout.offsetof(6);
        ISCONTAINER = layout.offsetof(7);
        DECLASCONTAINER = layout.offsetof(8);
        ISIMPLICIT = layout.offsetof(9);
        ATTRIBUTES = layout.offsetof(10);
        NUMATTRIBUTES = layout.offsetof(11);
        FLAGS = layout.offsetof(12);
    }

    public static class Buffer
    extends StructBuffer<CXIdxDeclInfo, Buffer>
    implements NativeResource {
        private static final CXIdxDeclInfo ELEMENT_FACTORY = CXIdxDeclInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CXIdxDeclInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CXIdxEntityInfo const *")
        public CXIdxEntityInfo entityInfo() {
            return CXIdxDeclInfo.nentityInfo(this.address());
        }

        public CXCursor cursor() {
            return CXIdxDeclInfo.ncursor(this.address());
        }

        public CXIdxLoc loc() {
            return CXIdxDeclInfo.nloc(this.address());
        }

        @NativeType(value="CXIdxContainerInfo const *")
        public CXIdxContainerInfo semanticContainer() {
            return CXIdxDeclInfo.nsemanticContainer(this.address());
        }

        @NativeType(value="CXIdxContainerInfo const *")
        public CXIdxContainerInfo lexicalContainer() {
            return CXIdxDeclInfo.nlexicalContainer(this.address());
        }

        @NativeType(value="int")
        public boolean isRedeclaration() {
            return CXIdxDeclInfo.nisRedeclaration(this.address()) != 0;
        }

        @NativeType(value="int")
        public boolean isDefinition() {
            return CXIdxDeclInfo.nisDefinition(this.address()) != 0;
        }

        @NativeType(value="int")
        public boolean isContainer() {
            return CXIdxDeclInfo.nisContainer(this.address()) != 0;
        }

        @NativeType(value="CXIdxContainerInfo const *")
        public CXIdxContainerInfo declAsContainer() {
            return CXIdxDeclInfo.ndeclAsContainer(this.address());
        }

        @NativeType(value="int")
        public boolean isImplicit() {
            return CXIdxDeclInfo.nisImplicit(this.address()) != 0;
        }

        @NativeType(value="CXIdxAttrInfo const * const *")
        public PointerBuffer attributes() {
            return CXIdxDeclInfo.nattributes(this.address());
        }

        @NativeType(value="unsigned")
        public int numAttributes() {
            return CXIdxDeclInfo.nnumAttributes(this.address());
        }

        @NativeType(value="unsigned")
        public int flags() {
            return CXIdxDeclInfo.nflags(this.address());
        }
    }
}

