/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkClearColorValue;
import org.lwjgl.vulkan.VkClearDepthStencilValue;

public class VkClearValue
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int COLOR;
    public static final int DEPTHSTENCIL;

    public VkClearValue(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkClearValue.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public VkClearColorValue color() {
        return VkClearValue.ncolor(this.address());
    }

    public VkClearDepthStencilValue depthStencil() {
        return VkClearValue.ndepthStencil(this.address());
    }

    public VkClearValue color(VkClearColorValue value) {
        VkClearValue.ncolor(this.address(), value);
        return this;
    }

    public VkClearValue color(Consumer<VkClearColorValue> consumer) {
        consumer.accept(this.color());
        return this;
    }

    public VkClearValue depthStencil(VkClearDepthStencilValue value) {
        VkClearValue.ndepthStencil(this.address(), value);
        return this;
    }

    public VkClearValue depthStencil(Consumer<VkClearDepthStencilValue> consumer) {
        consumer.accept(this.depthStencil());
        return this;
    }

    public VkClearValue set(VkClearValue src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkClearValue malloc() {
        return (VkClearValue)VkClearValue.wrap(VkClearValue.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkClearValue calloc() {
        return (VkClearValue)VkClearValue.wrap(VkClearValue.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkClearValue create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkClearValue)VkClearValue.wrap(VkClearValue.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkClearValue create(long address) {
        return (VkClearValue)VkClearValue.wrap(VkClearValue.class, (long)address);
    }

    @Nullable
    public static VkClearValue createSafe(long address) {
        return address == 0L ? null : (VkClearValue)VkClearValue.wrap(VkClearValue.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkClearValue.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkClearValue.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkClearValue.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkClearValue.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkClearValue.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkClearValue.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkClearValue.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkClearValue mallocStack() {
        return VkClearValue.mallocStack(MemoryStack.stackGet());
    }

    public static VkClearValue callocStack() {
        return VkClearValue.callocStack(MemoryStack.stackGet());
    }

    public static VkClearValue mallocStack(MemoryStack stack) {
        return (VkClearValue)VkClearValue.wrap(VkClearValue.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkClearValue callocStack(MemoryStack stack) {
        return (VkClearValue)VkClearValue.wrap(VkClearValue.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkClearValue.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkClearValue.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkClearValue.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkClearValue.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static VkClearColorValue ncolor(long struct) {
        return VkClearColorValue.create(struct + (long)COLOR);
    }

    public static VkClearDepthStencilValue ndepthStencil(long struct) {
        return VkClearDepthStencilValue.create(struct + (long)DEPTHSTENCIL);
    }

    public static void ncolor(long struct, VkClearColorValue value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)COLOR), (long)VkClearColorValue.SIZEOF);
    }

    public static void ndepthStencil(long struct, VkClearDepthStencilValue value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DEPTHSTENCIL), (long)VkClearDepthStencilValue.SIZEOF);
    }

    static {
        Struct.Layout layout = VkClearValue.__union((Struct.Member[])new Struct.Member[]{VkClearValue.__member((int)VkClearColorValue.SIZEOF, (int)VkClearColorValue.ALIGNOF), VkClearValue.__member((int)VkClearDepthStencilValue.SIZEOF, (int)VkClearDepthStencilValue.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        COLOR = layout.offsetof(0);
        DEPTHSTENCIL = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkClearValue, Buffer>
    implements NativeResource {
        private static final VkClearValue ELEMENT_FACTORY = VkClearValue.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkClearValue getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkClearColorValue color() {
            return VkClearValue.ncolor(this.address());
        }

        public VkClearDepthStencilValue depthStencil() {
            return VkClearValue.ndepthStencil(this.address());
        }

        public Buffer color(VkClearColorValue value) {
            VkClearValue.ncolor(this.address(), value);
            return this;
        }

        public Buffer color(Consumer<VkClearColorValue> consumer) {
            consumer.accept(this.color());
            return this;
        }

        public Buffer depthStencil(VkClearDepthStencilValue value) {
            VkClearValue.ndepthStencil(this.address(), value);
            return this;
        }

        public Buffer depthStencil(Consumer<VkClearDepthStencilValue> consumer) {
            consumer.accept(this.depthStencil());
            return this;
        }
    }
}

