/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectOutput;
import org.apache.derby.iapi.types.StreamHeaderGenerator;

public final class CharStreamHeaderGenerator
implements StreamHeaderGenerator {
    private static final int MAX_ENCODABLE_LENGTH = 65535;

    public boolean expectsCharCount() {
        return false;
    }

    public int generateInto(byte[] byArray, int n, long l) {
        if (l > 0L && l <= 65535L) {
            byArray[n] = (byte)(l >>> 8);
            byArray[n + 1] = (byte)(l >>> 0);
        } else {
            byArray[n] = 0;
            byArray[n + 1] = 0;
        }
        return 2;
    }

    public int generateInto(ObjectOutput objectOutput, long l) throws IOException {
        if (l > 0L && l <= 65535L) {
            objectOutput.writeByte((byte)(l >>> 8));
            objectOutput.writeByte((byte)(l >>> 0));
        } else {
            objectOutput.writeByte(0);
            objectOutput.writeByte(0);
        }
        return 2;
    }

    public int writeEOF(byte[] byArray, int n, long l) {
        if (l < 0L || l > 65535L) {
            System.arraycopy(DERBY_EOF_MARKER, 0, byArray, n, DERBY_EOF_MARKER.length);
            return DERBY_EOF_MARKER.length;
        }
        return 0;
    }

    public int writeEOF(ObjectOutput objectOutput, long l) throws IOException {
        if (l < 0L || l > 65535L) {
            objectOutput.write(DERBY_EOF_MARKER);
            return DERBY_EOF_MARKER.length;
        }
        return 0;
    }

    public int getMaxHeaderLength() {
        return 2;
    }
}

