/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import java.net.SocketAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Context;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.config.Keys;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class XirgoProtocolDecoder
extends BaseProtocolDecoder {
    private Boolean newFormat;
    private String form = Context.getConfig().getString(Keys.PROTOCOL_FORM.withPrefix(this.getProtocolName()));
    private static final Pattern PATTERN_OLD = new PatternBuilder().text("$$").number("(d+),").number("(d+),").number("(dddd)/(dd)/(dd),").number("(dd):(dd):(dd),").number("(-?d+.?d*),").number("(-?d+.?d*),").number("(-?d+.?d*),").number("(d+.?d*),").number("(d+.?d*),").number("(d+),").number("(d+.?d*),").number("(d+.d+),").number("(d+),").number("(d+.?d*),").number("(d+),").any().compile();
    private static final Pattern PATTERN_NEW = new PatternBuilder().text("$$").number("(d+),").number("(d+),").number("(dddd)/(dd)/(dd),").number("(dd):(dd):(dd),").number("(-?d+.?d*),").number("(-?d+.?d*),").number("(-?d+.?d*),").number("(d+.?d*),").number("d+.?d*,").number("d+.?d*,").number("d+,").number("(d+.?d*),").number("(d+),").number("(d+.?d*),").number("(d+.?d*),").number("(d+.?d*),").number("(d+.d+),").number("(d+),").number("(d+),").groupBegin().number("d,").expression("([01])").expression("([01])").expression("([01])").expression("([01]),").number("(d+.?d*),").number("(d+.?d*),").number("d+,").number("(d+),").number("(d+),").number("(d+),").number("(-?d+),").number("(d+),").number("(d+),").number("(-?d+)").groupEnd("?").any().compile();

    public XirgoProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    public void setForm(String form) {
        this.form = form;
    }

    private void decodeEvent(Position position, int event) {
        position.set("event", event);
        switch (event) {
            case 4001: 
            case 4003: 
            case 6011: 
            case 6013: {
                position.set("ignition", true);
                break;
            }
            case 4002: 
            case 4004: 
            case 6012: 
            case 6014: {
                position.set("ignition", false);
                break;
            }
            case 4005: {
                position.set("charge", false);
                break;
            }
            case 6002: {
                position.set("alarm", "overspeed");
                break;
            }
            case 6006: {
                position.set("alarm", "hardAcceleration");
                break;
            }
            case 6007: {
                position.set("alarm", "hardBraking");
                break;
            }
            case 6008: {
                position.set("alarm", "lowPower");
                break;
            }
            case 6009: {
                position.set("alarm", "powerCut");
                break;
            }
            case 6010: {
                position.set("alarm", "powerRestored");
                break;
            }
            case 6016: {
                position.set("alarm", "idle");
                break;
            }
            case 6017: {
                position.set("alarm", "tow");
                break;
            }
            case 6030: 
            case 6071: {
                position.set("motion", true);
                break;
            }
            case 6031: {
                position.set("motion", false);
                break;
            }
            case 6032: {
                position.set("alarm", "parking");
                break;
            }
            case 6090: {
                position.set("alarm", "removing");
                break;
            }
            case 6091: {
                position.set("alarm", "lowBattery");
                break;
            }
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Matcher matcher;
        String sentence = (String)msg;
        if (channel instanceof NioDatagramChannel && (matcher = Pattern.compile("\\$\\$\\d+,(\\d+),.*,(\\d+)##").matcher(sentence)).matches()) {
            String response = "!UDP_ACK," + matcher.group(1) + "," + matcher.group(2);
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
        if (this.form != null) {
            return this.decodeCustom(channel, remoteAddress, sentence);
        }
        return this.decodeFixed(channel, remoteAddress, sentence);
    }

    private Object decodeCustom(Channel channel, SocketAddress remoteAddress, String sentence) {
        String[] keys = this.form.split(",");
        String[] values = sentence.replace("$$", "").replace("##", "").split(",");
        if (values.length < keys.length) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        DateBuilder dateBuilder = new DateBuilder();
        block39: for (int i = 0; i < keys.length; ++i) {
            switch (keys[i]) {
                case "UID": 
                case "IM": {
                    DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, values[i]);
                    if (deviceSession == null) continue block39;
                    position.setDeviceId(deviceSession.getDeviceId());
                    continue block39;
                }
                case "EV": {
                    this.decodeEvent(position, Integer.parseInt(values[i]));
                    continue block39;
                }
                case "D": {
                    String[] date = values[i].split("/");
                    dateBuilder.setMonth(Integer.parseInt(date[0]));
                    dateBuilder.setDay(Integer.parseInt(date[1]));
                    dateBuilder.setYear(Integer.parseInt(date[2]));
                    continue block39;
                }
                case "T": {
                    String[] time = values[i].split(":");
                    dateBuilder.setHour(Integer.parseInt(time[0]));
                    dateBuilder.setMinute(Integer.parseInt(time[1]));
                    dateBuilder.setSecond(Integer.parseInt(time[2]));
                    continue block39;
                }
                case "LT": {
                    position.setLatitude(Double.parseDouble(values[i]));
                    continue block39;
                }
                case "LN": {
                    position.setLongitude(Double.parseDouble(values[i]));
                    continue block39;
                }
                case "AL": {
                    position.setAltitude(Integer.parseInt(values[i]));
                    continue block39;
                }
                case "GSPT": {
                    position.setSpeed(UnitsConverter.knotsFromKph(Double.parseDouble(values[i])));
                    continue block39;
                }
                case "HD": {
                    if (values[i].contains(".")) {
                        position.setCourse(Double.parseDouble(values[i]));
                        continue block39;
                    }
                    position.setCourse((double)Integer.parseInt(values[i]) * 0.1);
                    continue block39;
                }
                case "SV": {
                    position.set("sat", Integer.parseInt(values[i]));
                    continue block39;
                }
                case "BV": {
                    position.set("battery", Double.parseDouble(values[i]));
                    continue block39;
                }
                case "CQ": {
                    position.set("rssi", Integer.parseInt(values[i]));
                    continue block39;
                }
                case "MI": {
                    position.set("odometer", Integer.parseInt(values[i]));
                    continue block39;
                }
                case "GS": {
                    position.setValid(Integer.parseInt(values[i]) == 3);
                    continue block39;
                }
                case "SI": {
                    position.set("iccid", values[i]);
                    continue block39;
                }
                case "IG": {
                    int ignition = Integer.parseInt(values[i]);
                    if (ignition <= 0) continue block39;
                    position.set("ignition", ignition == 1);
                    continue block39;
                }
                case "OT": {
                    position.set("output", Integer.parseInt(values[i]));
                    continue block39;
                }
            }
        }
        position.setTime(dateBuilder.getDate());
        return position.getDeviceId() > 0L ? position : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object decodeFixed(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser;
        if (this.newFormat == null) {
            parser = new Parser(PATTERN_NEW, sentence);
            if (parser.matches()) {
                this.newFormat = true;
            } else {
                parser = new Parser(PATTERN_OLD, sentence);
                if (!parser.matches()) return null;
                this.newFormat = false;
            }
        } else {
            parser = this.newFormat != false ? new Parser(PATTERN_NEW, sentence) : new Parser(PATTERN_OLD, sentence);
            if (!parser.matches()) {
                return null;
            }
        }
        Position position = new Position(this.getProtocolName());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        this.decodeEvent(position, parser.nextInt());
        position.setTime(parser.nextDateTime());
        position.setLatitude(parser.nextDouble(0.0));
        position.setLongitude(parser.nextDouble(0.0));
        position.setAltitude(parser.nextDouble(0.0));
        position.setSpeed(UnitsConverter.knotsFromMph(parser.nextDouble(0.0)));
        position.setCourse(parser.nextDouble(0.0));
        position.set("sat", parser.nextInt());
        position.set("hdop", parser.nextDouble());
        if (this.newFormat.booleanValue()) {
            position.set("odometer", UnitsConverter.metersFromMiles(parser.nextDouble(0.0)));
            position.set("fuelConsumption", parser.next());
        }
        position.set("battery", parser.nextDouble(0.0));
        position.set("rssi", parser.nextDouble());
        if (!this.newFormat.booleanValue()) {
            position.set("odometer", UnitsConverter.metersFromMiles(parser.nextDouble(0.0)));
        }
        position.setValid(parser.nextInt(0) == 1);
        if (!this.newFormat.booleanValue() || !parser.hasNext(13)) return position;
        position.set("in1", parser.nextInt());
        position.set("in2", parser.nextInt());
        position.set("in3", parser.nextInt());
        position.set("out1", parser.nextInt());
        position.set("adc1", parser.nextDouble());
        position.set("fuel", parser.nextDouble());
        position.set("hours", UnitsConverter.msFromHours(parser.nextInt().intValue()));
        position.set("oilPressure", parser.nextInt());
        position.set("oilLevel", parser.nextInt());
        position.set("oilTemp", parser.nextInt());
        position.set("coolantPressure", parser.nextInt());
        position.set("coolantLevel", parser.nextInt());
        position.set("coolantTemp", parser.nextInt());
        return position;
    }
}

