/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.hibernate;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.exception.TemplatedViolatedConstraintNameExtracter;
import org.hibernate.exception.ViolatedConstraintNameExtracter;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public class VirtuosoDialect
extends Dialect {
    private static ViolatedConstraintNameExtracter EXTRACTER = new TemplatedViolatedConstraintNameExtracter(){

        public String extractConstraintName(SQLException sQLException) {
            int n = sQLException.getErrorCode();
            String string = sQLException.getMessage();
            if (n == -8) {
                if (string.startsWith("SR304:")) {
                    return this.extractUsingTemplate("statement conflicted with COLUMN REFERENCE constraint \"", "\"", string);
                }
                if (string.startsWith("SR305:")) {
                    return this.extractUsingTemplate("statement conflicted with COLUMN REFERENCE constraint \"", "\"", string);
                }
                if (string.startsWith("SR306:")) {
                    return this.extractUsingTemplate("__03 => 'SR306',\n", ":", string);
                }
                if (string.startsWith("SR363:")) {
                    return this.extractUsingTemplate("__03 => 'SR363',\n", ":", string);
                }
                if (string.startsWith("SR175:")) {
                    return this.extractUsingTemplate(": Violating unique index ", " on", string);
                }
                return null;
            }
            return null;
        }
    };

    public VirtuosoDialect() {
        this.registerColumnType(-7, "SMALLINT");
        this.registerColumnType(-6, "SMALLINT");
        this.registerColumnType(5, "SMALLINT");
        this.registerColumnType(4, "INTEGER");
        this.registerColumnType(-5, "DECIMAL(20,0)");
        this.registerColumnType(7, "REAL");
        this.registerColumnType(6, "FLOAT");
        this.registerColumnType(8, "DOUBLE PRECISION");
        this.registerColumnType(2, "DECIMAL($p, $s)");
        this.registerColumnType(3, "DECIMAL($p, $s)");
        this.registerColumnType(-2, 2000, "BINARY($l)");
        this.registerColumnType(-3, 2000, "VARBINARY($l)");
        this.registerColumnType(-4, "LONG VARBINARY");
        this.registerColumnType(1, 2000, "CHARACTER($l)");
        this.registerColumnType(12, 2000, "VARCHAR($l)");
        this.registerColumnType(-1, "LONG VARCHAR");
        this.registerColumnType(91, "DATE");
        this.registerColumnType(92, "TIME");
        this.registerColumnType(93, "DATETIME");
        this.registerColumnType(2004, "LONG VARBINARY");
        this.registerColumnType(2005, "LONG VARCHAR");
        this.registerFunction("iszero", (SQLFunction)new StandardSQLFunction("iszero", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("atod", (SQLFunction)new StandardSQLFunction("atod", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("atof", (SQLFunction)new StandardSQLFunction("atof", (Type)StandardBasicTypes.FLOAT));
        this.registerFunction("atoi", (SQLFunction)new StandardSQLFunction("atoi", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("mod", (SQLFunction)new StandardSQLFunction("mod"));
        this.registerFunction("abs", (SQLFunction)new StandardSQLFunction("abs"));
        this.registerFunction("sign", (SQLFunction)new StandardSQLFunction("sign", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("acos", (SQLFunction)new StandardSQLFunction("acos", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("asin", (SQLFunction)new StandardSQLFunction("asin", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("atan", (SQLFunction)new StandardSQLFunction("atan", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("cos", (SQLFunction)new StandardSQLFunction("cos", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("sin", (SQLFunction)new StandardSQLFunction("sin", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("tan", (SQLFunction)new StandardSQLFunction("tan", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("cot", (SQLFunction)new StandardSQLFunction("cot", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("frexp", (SQLFunction)new StandardSQLFunction("frexp", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("degrees", (SQLFunction)new StandardSQLFunction("degrees", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("radians", (SQLFunction)new StandardSQLFunction("radians", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("exp", (SQLFunction)new StandardSQLFunction("exp", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("log", (SQLFunction)new StandardSQLFunction("log", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("log10", (SQLFunction)new StandardSQLFunction("log10", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("sqrt", (SQLFunction)new StandardSQLFunction("sqrt", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("atan2", (SQLFunction)new StandardSQLFunction("atan2", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("power", (SQLFunction)new StandardSQLFunction("power", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("ceiling", (SQLFunction)new StandardSQLFunction("ceiling", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("floor", (SQLFunction)new StandardSQLFunction("floor", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("pi", (SQLFunction)new NoArgSQLFunction("pi", (Type)StandardBasicTypes.DOUBLE, true));
        this.registerFunction("round", (SQLFunction)new StandardSQLFunction("round", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("rand", (SQLFunction)new StandardSQLFunction("rand"));
        this.registerFunction("rnd", (SQLFunction)new StandardSQLFunction("rnd"));
        this.registerFunction("randomize", (SQLFunction)new StandardSQLFunction("randomize"));
        this.registerFunction("hash", (SQLFunction)new StandardSQLFunction("hash", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("md5_box", (SQLFunction)new StandardSQLFunction("md5_box", (Type)StandardBasicTypes.STRING));
        this.registerFunction("box_hash", (SQLFunction)new StandardSQLFunction("box_hash", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("bit_and", (SQLFunction)new StandardSQLFunction("bit_and", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("bit_or", (SQLFunction)new StandardSQLFunction("bit_or", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("bit_xor", (SQLFunction)new StandardSQLFunction("bit_xor", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("bit_not", (SQLFunction)new StandardSQLFunction("bit_not", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("bit_shift", (SQLFunction)new StandardSQLFunction("bit_shift", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("length", (SQLFunction)new StandardSQLFunction("length", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("char_length", (SQLFunction)new StandardSQLFunction("char_length", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("character_length", (SQLFunction)new StandardSQLFunction("character_length", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("octet_length", (SQLFunction)new StandardSQLFunction("octet_length", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("ascii", (SQLFunction)new StandardSQLFunction("ascii", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("chr", (SQLFunction)new StandardSQLFunction("chr", (Type)StandardBasicTypes.CHARACTER));
        this.registerFunction("chr1", (SQLFunction)new StandardSQLFunction("chr1", (Type)StandardBasicTypes.CHARACTER));
        this.registerFunction("subseq", (SQLFunction)new StandardSQLFunction("subseq", (Type)StandardBasicTypes.STRING));
        this.registerFunction("substring", (SQLFunction)new StandardSQLFunction("substring", (Type)StandardBasicTypes.STRING));
        this.registerFunction("left", (SQLFunction)new StandardSQLFunction("left", (Type)StandardBasicTypes.STRING));
        this.registerFunction("right", (SQLFunction)new StandardSQLFunction("right", (Type)StandardBasicTypes.STRING));
        this.registerFunction("ltrim", (SQLFunction)new StandardSQLFunction("ltrim", (Type)StandardBasicTypes.STRING));
        this.registerFunction("rtrim", (SQLFunction)new StandardSQLFunction("rtrim", (Type)StandardBasicTypes.STRING));
        this.registerFunction("trim", (SQLFunction)new StandardSQLFunction("trim", (Type)StandardBasicTypes.STRING));
        this.registerFunction("repeat", (SQLFunction)new StandardSQLFunction("repeat", (Type)StandardBasicTypes.STRING));
        this.registerFunction("space", (SQLFunction)new StandardSQLFunction("space", (Type)StandardBasicTypes.STRING));
        this.registerFunction("make_string", (SQLFunction)new StandardSQLFunction("make_string", (Type)StandardBasicTypes.STRING));
        this.registerFunction("make_wstring", (SQLFunction)new StandardSQLFunction("make_wstring", (Type)StandardBasicTypes.STRING));
        this.registerFunction("make_bin_string", (SQLFunction)new StandardSQLFunction("make_bin_string", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("concatenate", (SQLFunction)new StandardSQLFunction("concatenate", (Type)StandardBasicTypes.STRING));
        this.registerFunction("concat", (SQLFunction)new StandardSQLFunction("concat", (Type)StandardBasicTypes.STRING));
        this.registerFunction("replace", (SQLFunction)new StandardSQLFunction("replace", (Type)StandardBasicTypes.STRING));
        this.registerFunction("sprintf", (SQLFunction)new StandardSQLFunction("sprintf", (Type)StandardBasicTypes.STRING));
        this.registerFunction("sprintf_or_null", (SQLFunction)new StandardSQLFunction("sprintf_or_null", (Type)StandardBasicTypes.STRING));
        this.registerFunction("sprintf_iri", (SQLFunction)new StandardSQLFunction("sprintf_iri", (Type)StandardBasicTypes.STRING));
        this.registerFunction("sprintf_iri_or_null", (SQLFunction)new StandardSQLFunction("sprintf_iri_or_null", (Type)StandardBasicTypes.STRING));
        this.registerFunction("strchr", (SQLFunction)new StandardSQLFunction("strchr", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("strrchr", (SQLFunction)new StandardSQLFunction("strrchr", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("strstr", (SQLFunction)new StandardSQLFunction("strstr", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("strindex", (SQLFunction)new StandardSQLFunction("strindex", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("strcasestr", (SQLFunction)new StandardSQLFunction("strcasestr", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("locate", (SQLFunction)new StandardSQLFunction("locate", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("matches_like", (SQLFunction)new StandardSQLFunction("matches_like", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("__like_min", (SQLFunction)new StandardSQLFunction("__like_min", (Type)StandardBasicTypes.STRING));
        this.registerFunction("__like_max", (SQLFunction)new StandardSQLFunction("__like_max", (Type)StandardBasicTypes.STRING));
        this.registerFunction("fix_identifier_case", (SQLFunction)new StandardSQLFunction("fix_identifier_case", (Type)StandardBasicTypes.STRING));
        this.registerFunction("casemode_strcmp", (SQLFunction)new StandardSQLFunction("casemode_strcmp", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("lcase", (SQLFunction)new StandardSQLFunction("lcase", (Type)StandardBasicTypes.STRING));
        this.registerFunction("lower", (SQLFunction)new StandardSQLFunction("lower", (Type)StandardBasicTypes.STRING));
        this.registerFunction("ucase", (SQLFunction)new StandardSQLFunction("ucase", (Type)StandardBasicTypes.STRING));
        this.registerFunction("upper", (SQLFunction)new StandardSQLFunction("upper", (Type)StandardBasicTypes.STRING));
        this.registerFunction("initcap", (SQLFunction)new StandardSQLFunction("initcap", (Type)StandardBasicTypes.STRING));
        this.registerFunction("table_type", (SQLFunction)new StandardSQLFunction("table_type", (Type)StandardBasicTypes.STRING));
        this.registerFunction("internal_type_name", (SQLFunction)new StandardSQLFunction("internal_type_name", (Type)StandardBasicTypes.STRING));
        this.registerFunction("internal_type", (SQLFunction)new StandardSQLFunction("internal_type", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("isinteger", (SQLFunction)new StandardSQLFunction("isinteger", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("isnumeric", (SQLFunction)new StandardSQLFunction("isnumeric", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("isfloat", (SQLFunction)new StandardSQLFunction("isfloat", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("isdouble", (SQLFunction)new StandardSQLFunction("isdouble", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("isnull", (SQLFunction)new StandardSQLFunction("isnull", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("isnotnull", (SQLFunction)new StandardSQLFunction("isnotnull", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("isblob", (SQLFunction)new StandardSQLFunction("isblob", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("isentity", (SQLFunction)new StandardSQLFunction("isentity", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("isstring", (SQLFunction)new StandardSQLFunction("isstring", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("isbinary", (SQLFunction)new StandardSQLFunction("isbinary", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("isarray", (SQLFunction)new StandardSQLFunction("isarray", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("isiri_id", (SQLFunction)new StandardSQLFunction("isiri_id", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("is_named_iri_id", (SQLFunction)new StandardSQLFunction("is_named_iri_id", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("is_bnode_iri_id", (SQLFunction)new StandardSQLFunction("is_bnode_iri_id", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("isuname", (SQLFunction)new StandardSQLFunction("isuname", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("username", (SQLFunction)new NoArgSQLFunction("username", (Type)StandardBasicTypes.STRING, true));
        this.registerFunction("dbname", (SQLFunction)new NoArgSQLFunction("dbname", (Type)StandardBasicTypes.STRING, true));
        this.registerFunction("ifnull", (SQLFunction)new VarArgsSQLFunction("ifnull(", ",", ")"));
        this.registerFunction("get_user", (SQLFunction)new NoArgSQLFunction("get_user", (Type)StandardBasicTypes.STRING, true));
        this.registerFunction("dayname", (SQLFunction)new StandardSQLFunction("dayname", (Type)StandardBasicTypes.STRING));
        this.registerFunction("monthname", (SQLFunction)new StandardSQLFunction("monthname", (Type)StandardBasicTypes.STRING));
        this.registerFunction("now", (SQLFunction)new NoArgSQLFunction("now", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("curdate", (SQLFunction)new NoArgSQLFunction("curdate", (Type)StandardBasicTypes.DATE));
        this.registerFunction("dayofmonth", (SQLFunction)new StandardSQLFunction("dayofmonth", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("dayofweek", (SQLFunction)new StandardSQLFunction("dayofweek", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("dayofyear", (SQLFunction)new StandardSQLFunction("dayofyear", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("quarter", (SQLFunction)new StandardSQLFunction("quarter", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("week", (SQLFunction)new StandardSQLFunction("week", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("month", (SQLFunction)new StandardSQLFunction("month", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("year", (SQLFunction)new StandardSQLFunction("year", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("hour", (SQLFunction)new StandardSQLFunction("hour", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("minute", (SQLFunction)new StandardSQLFunction("minute", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("second", (SQLFunction)new StandardSQLFunction("second", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("timezone", (SQLFunction)new StandardSQLFunction("timezone", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("curtime", (SQLFunction)new StandardSQLFunction("curtime", (Type)StandardBasicTypes.TIME));
        this.registerFunction("getdate", (SQLFunction)new NoArgSQLFunction("getdate", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("curdatetime", (SQLFunction)new NoArgSQLFunction("curdatetime", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("datediff", (SQLFunction)new StandardSQLFunction("datediff", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("dateadd", (SQLFunction)new StandardSQLFunction("dateadd", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("timestampdiff", (SQLFunction)new StandardSQLFunction("timestampdiff", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("timestampadd", (SQLFunction)new StandardSQLFunction("timestampadd", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerKeyword("top");
        this.registerKeyword("char");
        this.registerKeyword("int");
        this.registerKeyword("name");
        this.registerKeyword("string");
        this.registerKeyword("intnum");
        this.registerKeyword("approxnum");
        this.registerKeyword("ammsc");
        this.registerKeyword("parameter");
        this.registerKeyword("as");
        this.registerKeyword("or");
        this.registerKeyword("and");
        this.registerKeyword("not");
        this.registerKeyword("uminus");
        this.registerKeyword("all");
        this.registerKeyword("ammsc");
        this.registerKeyword("any");
        this.registerKeyword("attach");
        this.registerKeyword("asc");
        this.registerKeyword("authorization");
        this.registerKeyword("between");
        this.registerKeyword("by");
        this.registerKeyword("character");
        this.registerKeyword("check");
        this.registerKeyword("close");
        this.registerKeyword("commit");
        this.registerKeyword("continue");
        this.registerKeyword("create");
        this.registerKeyword("current");
        this.registerKeyword("cursor");
        this.registerKeyword("decimal");
        this.registerKeyword("declare");
        this.registerKeyword("default");
        this.registerKeyword("delete");
        this.registerKeyword("desc");
        this.registerKeyword("distinct");
        this.registerKeyword("double");
        this.registerKeyword("drop");
        this.registerKeyword("escape");
        this.registerKeyword("exists");
        this.registerKeyword("fetch");
        this.registerKeyword("float");
        this.registerKeyword("for");
        this.registerKeyword("foreign");
        this.registerKeyword("found");
        this.registerKeyword("from");
        this.registerKeyword("goto");
        this.registerKeyword("go");
        this.registerKeyword("grant ");
        this.registerKeyword("group");
        this.registerKeyword("having");
        this.registerKeyword("in");
        this.registerKeyword("index");
        this.registerKeyword("indicator");
        this.registerKeyword("insert");
        this.registerKeyword("integer");
        this.registerKeyword("into");
        this.registerKeyword("is");
        this.registerKeyword("key");
        this.registerKeyword("language");
        this.registerKeyword("like");
        this.registerKeyword("nullx");
        this.registerKeyword("numeric");
        this.registerKeyword("of");
        this.registerKeyword("on");
        this.registerKeyword("open");
        this.registerKeyword("option");
        this.registerKeyword("order");
        this.registerKeyword("precision");
        this.registerKeyword("primary");
        this.registerKeyword("privileges");
        this.registerKeyword("procedure");
        this.registerKeyword("public");
        this.registerKeyword("real");
        this.registerKeyword("references");
        this.registerKeyword("rollback");
        this.registerKeyword("schema");
        this.registerKeyword("select");
        this.registerKeyword("set");
        this.registerKeyword("smallint");
        this.registerKeyword("some");
        this.registerKeyword("sqlcode");
        this.registerKeyword("sqlerror");
        this.registerKeyword("table");
        this.registerKeyword("to");
        this.registerKeyword("union");
        this.registerKeyword("unique");
        this.registerKeyword("update");
        this.registerKeyword("user");
        this.registerKeyword("values");
        this.registerKeyword("view");
        this.registerKeyword("whenever");
        this.registerKeyword("where");
        this.registerKeyword("with");
        this.registerKeyword("work");
        this.registerKeyword("continues");
        this.registerKeyword("object_id");
        this.registerKeyword("under");
        this.registerKeyword("clustered");
        this.registerKeyword("varchar");
        this.registerKeyword("varbinary");
        this.registerKeyword("long");
        this.registerKeyword("replacing");
        this.registerKeyword("soft");
        this.registerKeyword("shutdown");
        this.registerKeyword("checkpoint");
        this.registerKeyword("backup");
        this.registerKeyword("replication");
        this.registerKeyword("sync");
        this.registerKeyword("alter");
        this.registerKeyword("add");
        this.registerKeyword("rename");
        this.registerKeyword("disconnect");
        this.registerKeyword("before");
        this.registerKeyword("after");
        this.registerKeyword("instead");
        this.registerKeyword("trigger");
        this.registerKeyword("referencing");
        this.registerKeyword("old");
        this.registerKeyword("procedure");
        this.registerKeyword("function");
        this.registerKeyword("out");
        this.registerKeyword("inout");
        this.registerKeyword("handler");
        this.registerKeyword("if");
        this.registerKeyword("then");
        this.registerKeyword("else");
        this.registerKeyword("elseif");
        this.registerKeyword("while");
        this.registerKeyword("beginx");
        this.registerKeyword("endx");
        this.registerKeyword("equals");
        this.registerKeyword("return");
        this.registerKeyword("call");
        this.registerKeyword("returns");
        this.registerKeyword("do");
        this.registerKeyword("exclusive");
        this.registerKeyword("prefetch");
        this.registerKeyword("sqlstate");
        this.registerKeyword("found");
        this.registerKeyword("revoke");
        this.registerKeyword("password");
        this.registerKeyword("off");
        this.registerKeyword("logx");
        this.registerKeyword("sqlstate");
        this.registerKeyword("timestamp");
        this.registerKeyword("date");
        this.registerKeyword("datetime");
        this.registerKeyword("time");
        this.registerKeyword("execute");
        this.registerKeyword("owner");
        this.registerKeyword("begin_fn_x");
        this.registerKeyword("begin_oj_x");
        this.registerKeyword("convert");
        this.registerKeyword("case");
        this.registerKeyword("when");
        this.registerKeyword("then");
        this.registerKeyword("identity");
        this.registerKeyword("left");
        this.registerKeyword("right");
        this.registerKeyword("full");
        this.registerKeyword("outer");
        this.registerKeyword("join");
        this.registerKeyword("use");
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    protected String getIdentitySelectString() throws MappingException {
        return "select identity_value()";
    }

    protected String getIdentityColumnString() throws MappingException {
        return " identity";
    }

    public boolean supportsInsertSelectIdentity() {
        return false;
    }

    public boolean supportsSequences() {
        return true;
    }

    public boolean supportsPooledSequences() {
        return true;
    }

    protected String getCreateSequenceString(String string) throws MappingException {
        return "sequence_set('" + string + "', 0, 1)";
    }

    public String getSelectSequenceNextValString(String string) throws MappingException {
        return "sequence_next('" + string + "')";
    }

    public String getSequenceNextValString(String string) throws MappingException {
        return "select sequence_next('" + string + "')";
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean bindLimitParametersFirst() {
        return true;
    }

    public String getLimitString(String string, int n, int n2) {
        int n3 = string.toLowerCase().startsWith("select distinct") ? 15 : 6;
        StringBuffer stringBuffer = new StringBuffer(string.length() + 64);
        stringBuffer.append(string);
        if (n > 0) {
            stringBuffer.insert(n3, " TOP " + n + "," + n2 + " ");
        } else {
            stringBuffer.insert(n3, " TOP " + n2 + " ");
        }
        return stringBuffer.toString();
    }

    protected String getLimitString(String string, boolean bl) {
        int n = string.toLowerCase().startsWith("select distinct") ? 15 : 6;
        return new StringBuffer(string.length() + 16).append(string).insert(n, bl ? " TOP ? " : " TOP ?,? ").toString();
    }

    public int registerResultSetOutParameter(CallableStatement callableStatement, int n) throws SQLException {
        return n;
    }

    public ResultSet getResultSet(CallableStatement callableStatement) throws SQLException {
        boolean bl = callableStatement.execute();
        while (!bl && callableStatement.getUpdateCount() != -1) {
            bl = callableStatement.getMoreResults();
        }
        return callableStatement.getResultSet();
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public String getCurrentTimestampSelectString() {
        return "select getdate()";
    }

    public String getCurrentTimestampSQLFunctionName() {
        return "getdate";
    }

    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return EXTRACTER;
    }

    public String getSelectClauseNullString(int n) {
        switch (n) {
            case -7: 
            case -6: 
            case 5: {
                return "cast(null as smallint)";
            }
            case 4: {
                return "cast(null as int)";
            }
            case -5: {
                return "cast(null as smallint)";
            }
            case 6: {
                return "cast(null as float)";
            }
            case 7: {
                return "cast(null as real)";
            }
            case 8: {
                return "cast(null as double precision)";
            }
            case 2: 
            case 3: {
                return "cast(null as decimal)";
            }
            case 1: 
            case 12: {
                return "cast(null as varchar)";
            }
            case -1: 
            case 2005: {
                return "cast(null as long varchar)";
            }
            case 91: {
                return "cast(null as date)";
            }
            case 92: {
                return "cast(null as time)";
            }
            case 93: {
                return "cast(null as datetime)";
            }
            case -3: 
            case -2: {
                return "cast(null as varbinary)";
            }
            case -4: 
            case 2004: {
                return "cast(null as long varbinary)";
            }
        }
        return "null";
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public String getNoColumnsInsertString() {
        throw new UnsupportedOperationException("Database can not insert a row without specifying any column values");
    }

    public int getMaxAliasLength() {
        return 100;
    }

    public String toBooleanValueString(boolean bl) {
        return bl ? "1" : "0";
    }

    public boolean dropConstraints() {
        return false;
    }

    public boolean supportsUniqueConstraintInCreateAlterTable() {
        return true;
    }

    public String getAddColumnString() {
        return "add";
    }

    public String getDropForeignKeyString() {
        return " drop foreign key ";
    }

    public String getAddForeignKeyConstraintString(String string, String[] stringArray, String string2, String[] stringArray2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append(" add foreign key (").append(StringHelper.join((String)", ", (String[])stringArray)).append(") references ").append(string2);
        if (!bl) {
            stringBuffer.append(" (").append(StringHelper.join((String)", ", (String[])stringArray2)).append(')');
        }
        return stringBuffer.toString();
    }

    public String getAddPrimaryKeyConstraintString(String string) {
        return " modify primary key ";
    }

    public boolean hasSelfReferentialForeignKeyBug() {
        return true;
    }

    public String getNullColumnString() {
        return " null";
    }

    public boolean supportsIfExistsBeforeTableName() {
        return false;
    }

    public boolean supportsIfExistsAfterTableName() {
        return false;
    }

    public boolean supportsEmptyInList() {
        return false;
    }

    public boolean areStringComparisonsCaseInsensitive() {
        return false;
    }

    public boolean useInputStreamToInsertBlob() {
        return false;
    }

    public boolean supportsCircularCascadeDeleteConstraints() {
        return true;
    }

    public boolean supportsLobValueChangePropogation() {
        return false;
    }

    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }
}

