// Generated by gmmproc 2.68.0 -- DO NOT MODIFY!
#ifndef _GTKMM_PANED_H
#define _GTKMM_PANED_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtkmm/widget.h>
#include <gtkmm/orientable.h>
#include <gtkmm/enums.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkPaned = struct _GtkPaned;
using GtkPanedClass = struct _GtkPanedClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class GTKMM_API Paned_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

/** A widget with two adjustable panes.
 *
 * Gtk::Paned has two panes, arranged either
 * horizontally or vertically. The division between
 * the two panes is adjustable by the user by dragging
 * a handle.
 *
 * Child widgets are added to the panes of the widget with
 * set_start_child() and set_end_child().
 * The division between the two children is set by default from the size
 * requests of the children, but it can be adjusted by the user.
 *
 * A paned widget draws a separator between the two child widgets and a small
 * handle that the user can drag to adjust the division. It does not draw any
 * relief around the children or around the separator.  (The space
 * in which the separator is called the gutter.) Often, it is useful to
 * put each child inside a Gtk::Frame so that the gutter appears as a ridge.
 * No separator is drawn if one of the children is missing.
 *
 * Each child has two options that can be set - resize and shrink. If resize is
 * true, then when the GtkPaned is resized, that child will expand or shrink
 * along with the paned widget. If shrink is true, then when that child can be
 * made smaller than it's requisition. Setting shrink to false allows the
 * application to set a minimum size. If resize is false for both children,
 * then this is treated as if resize is true for both children.
 *
 * The application can set the position of the slider as if it were set by the
 * user, by calling set_position().
 *
 * @ingroup Widgets
 * @ingroup Containers
 */

class GTKMM_API Paned
 : public Widget,
   public Orientable
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Paned CppObjectType;
  typedef Paned_Class CppClassType;
  typedef GtkPaned BaseObjectType;
  typedef GtkPanedClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  Paned(Paned&& src) noexcept;
  Paned& operator=(Paned&& src) noexcept;

  // noncopyable
  Paned(const Paned&) = delete;
  Paned& operator=(const Paned&) = delete;

  ~Paned() noexcept override;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend GTKMM_API class Paned_Class;
  static CppClassType paned_class_;

protected:
  explicit Paned(const Glib::ConstructParams& construct_params);
  explicit Paned(GtkPaned* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  /// Provides access to the underlying C GObject.
  GtkPaned*       gobj()       { return reinterpret_cast<GtkPaned*>(gobject_); }

  /// Provides access to the underlying C GObject.
  const GtkPaned* gobj() const { return reinterpret_cast<GtkPaned*>(gobject_); }

private:

  
public:

  //Note that we try to use the same defaul parameter value as the default property value.
    explicit Paned(Orientation orientation =  Orientation::HORIZONTAL);


  /** Sets the start child of @a paned to @a child.
   * 
   * @param child The widget to add.
   */
  void set_start_child(Widget& child);
  
  /** Retrieves the start child of the given Gtk::Paned.
   * 
   * See also: Gtk::Paned::property_start_child()
   * 
   * @return The start child widget.
   */
  Widget* get_start_child();
  
  /** Retrieves the start child of the given Gtk::Paned.
   * 
   * See also: Gtk::Paned::property_start_child()
   * 
   * @return The start child widget.
   */
  const Widget* get_start_child() const;
  
  /** Sets the Gtk::Paned::property_resize_start_child() property
   * 
   * @param resize <tt>true</tt> to let the start child be resized.
   */
  void set_resize_start_child(bool resize =  true);
  
  /** Returns whether the start child can be resized.
   * 
   * @return <tt>true</tt> if the start child is resizable.
   */
  bool get_resize_start_child() const;
  
  /** Sets the Gtk::Paned::property_shrink_start_child() property
   * 
   * @param resize <tt>true</tt> to let the start child be shrunk.
   */
  void set_shrink_start_child(bool resize =  true);
  
  /** Returns whether the start child can be shrunk.
   * 
   * @return <tt>true</tt> if the start child is shrinkable.
   */
  bool get_shrink_start_child() const;

  
  /** Sets the end child of @a paned to @a child.
   * 
   * @param child The widget to add.
   */
  void set_end_child(Widget& child);
  
  /** Retrieves the end child of the given Gtk::Paned.
   * 
   * See also: Gtk::Paned::property_end_child()
   * 
   * @return The end child widget.
   */
  Widget* get_end_child();
  
  /** Retrieves the end child of the given Gtk::Paned.
   * 
   * See also: Gtk::Paned::property_end_child()
   * 
   * @return The end child widget.
   */
  const Widget* get_end_child() const;
  
  /** Sets the Gtk::Paned::property_resize_end_child() property
   * 
   * @param resize <tt>true</tt> to let the end child be resized.
   */
  void set_resize_end_child(bool resize =  true);
  
  /** Returns whether the end child can be resized.
   * 
   * @return <tt>true</tt> if the end child is resizable.
   */
  bool get_resize_end_child() const;
  
  /** Sets the Gtk::Paned::property_shrink_end_child() property
   * 
   * @param resize <tt>true</tt> to let the end child be shrunk.
   */
  void set_shrink_end_child(bool resize =  true);
  
  /** Returns whether the end child can be shrunk.
   * 
   * @return <tt>true</tt> if the end child is shrinkable.
   */
  bool get_shrink_end_child() const;

  
  /** Obtains the position of the divider between the two panes.
   * 
   * @return Position of the divider.
   */
  int get_position() const;
  
  /** Sets the position of the divider between the two panes.
   * 
   * @param position Pixel position of divider, a negative value means that the position
   * is unset.
   */
  void set_position(int position);

  
  /** Sets the Gtk::Paned::property_wide_handle() property.
   * 
   * @param wide The new value for the Gtk::Paned::property_wide_handle() property.
   */
  void set_wide_handle(bool wide =  true);
  
  /** Gets the Gtk::Paned::property_wide_handle() property.
   * 
   * @return <tt>true</tt> if the paned should have a wide handle.
   */
  bool get_wide_handle() const;

  //Keybinding signals:
  
  
  /** Position of paned separator in pixels (0 means all the way to the left/top).
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_position() ;

/** Position of paned separator in pixels (0 means all the way to the left/top).
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_position() const;

  /** <tt>true</tt> if the Position property should be used.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_position_set() ;

/** <tt>true</tt> if the Position property should be used.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_position_set() const;

  /** The smallest possible value for the position property.
   * This property is derived from the size and shrinkability
   * of the widget's children.
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_min_position() const;


  /** The largest possible value for the position property.
   * This property is derived from the size and shrinkability
   * of the widget's children.
   *
   * Default value: 2147483647
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_max_position() const;


  /** Setting this property to <tt>true</tt> indicates that the paned needs
   * to provide stronger visual separation (e.g.\ because it separates
   * between two notebooks, whose tab rows would otherwise merge visually).
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_wide_handle() ;

/** Setting this property to <tt>true</tt> indicates that the paned needs
   * to provide stronger visual separation (e.g.\ because it separates
   * between two notebooks, whose tab rows would otherwise merge visually).
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_wide_handle() const;

  /** The "resize-start-child" property determines whether the first child expands and
   * shrinks along with the paned widget.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_resize_start_child() ;

/** The "resize-start-child" property determines whether the first child expands and
   * shrinks along with the paned widget.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_resize_start_child() const;

  /** The "resize-end-child" property determines whether the second child expands and
   * shrinks along with the paned widget.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_resize_end_child() ;

/** The "resize-end-child" property determines whether the second child expands and
   * shrinks along with the paned widget.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_resize_end_child() const;

  /** The "shrink-start-child" property determines whether the first child can be made
   * smaller than its requisition.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_shrink_start_child() ;

/** The "shrink-start-child" property determines whether the first child can be made
   * smaller than its requisition.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_shrink_start_child() const;

  /** The "shrink-end-child" property determines whether the second child can be made
   * smaller than its requisition.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_shrink_end_child() ;

/** The "shrink-end-child" property determines whether the second child can be made
   * smaller than its requisition.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_shrink_end_child() const;

  /** The first child.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Widget* > property_start_child() ;

/** The first child.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Widget* > property_start_child() const;

  /** The second child.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Widget* > property_end_child() ;

/** The second child.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Widget* > property_end_child() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::Paned
   */
  GTKMM_API
  Gtk::Paned* wrap(GtkPaned* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_PANED_H */

