"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_chart_theme_1 = require("../../../../state/selectors/get_chart_theme");
var commons_1 = require("../../../../utils/commons");
var get_specs_1 = require("./get_specs");
exports.getAxesStylesSelector = re_reselect_1.default([get_specs_1.getAxisSpecsSelector, get_chart_theme_1.getChartThemeSelector], function (axesSpecs, _a) {
    var sharedAxesStyle = _a.axes;
    var axesStyles = new Map();
    axesSpecs.forEach(function (_a) {
        var id = _a.id, style = _a.style;
        var newStyle = style
            ? commons_1.mergePartial(sharedAxesStyle, style, {
                mergeOptionalPartialValues: true,
            })
            : null;
        axesStyles.set(id, newStyle);
    });
    return axesStyles;
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=get_axis_styles.js.map