"""Generated message classes for networkservices version v1alpha1.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'networkservices'


class AddHeader(_messages.Message):
  r"""Describes a header to add.

  Fields:
    headerName: Required. The name of the header to add.
    headerValue: Required. The value of the header to add.
    replace: Optional. Whether to replace all existing headers with the same
      name.
  """

  headerName = _messages.StringField(1)
  headerValue = _messages.StringField(2)
  replace = _messages.BooleanField(3)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts jose@example.com from DATA_READ logging, and
  aliya@example.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the members in this binding.
      To learn which resources support conditions in their IAM policies, see
      the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. * `user:{emailid}`: An email address that
      represents a specific Google account. For example, `alice@example.com` .
      * `serviceAccount:{emailid}`: An email address that represents a service
      account. For example, `my-other-app@appspot.gserviceaccount.com`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `domain:{domain}`: The G Suite
      domain (primary) that represents all the users of that domain. For
      example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CDNPolicy(_messages.Message):
  r"""The CDNPolicy to apply to the configured route.

  Enums:
    CacheModeValueValuesEnum: Optional. Cache modes allow users to control the
      behaviour of the cache, what content it should cache automatically,
      whether to respect origin headers, or whether to unconditionally cache
      all responses. For all cache modes, Cache-Control headers will be passed
      to the client. Use clientTtl to override what is sent to the client.
    SignedRequestModeValueValuesEnum: Optional. Whether to enforce signed
      requests. The default value is DISABLED, which means all content is
      public, and does not authorize access. You must also set a
      signedRequestKeyset to enable signed requests. When set to
      REQUIRE_SIGNATURES, all matching requests will have their signature
      validated. Requests that were not signed with the corresponding private
      key, or that are otherwise invalid (expired, do not match the signature,
      IP address, or header) will be rejected with a HTTP 403 and (if enabled)
      logged.

  Messages:
    NegativeCachingPolicyValue: Optional. Sets a cache TTL for the specified
      HTTP status code. negativeCaching must be enabled to configure
      negativeCachingPolicy. - Omitting the policy and leaving negativeCaching
      enabled will use the default TTLs for each status code, defined in
      negativeCaching. - TTLs must be >= 0 (where 0 is "always revalidate")
      and <= 86400s (1 day) Note that when specifying an explicit
      negativeCachingPolicy, you should take care to specify a cache TTL for
      all response codes that you wish to cache. The CDNPolicy will not apply
      any default negative caching when a policy exists.

  Fields:
    cacheKeyPolicy: Optional. Defines the request parameters that contribute
      to the cache key.
    cacheMode: Optional. Cache modes allow users to control the behaviour of
      the cache, what content it should cache automatically, whether to
      respect origin headers, or whether to unconditionally cache all
      responses. For all cache modes, Cache-Control headers will be passed to
      the client. Use clientTtl to override what is sent to the client.
    clientTtl: Optional. Specifies a separate client (e.g. browser client)
      TTL, separate from the TTL used by the edge caches. Leaving this empty
      will use the same cache TTL for both the CDN and the client-facing
      response. - The TTL must be > 0 and <= 86400s (1 day) - The clientTtl
      cannot be larger than the defaultTtl (if set) - Fractions of a second
      are not allowed. Omit this field to use the defaultTtl, or the max-age
      set by the origin, as the client-facing TTL. When the cache mode is set
      to "USE_ORIGIN_HEADERS" or "BYPASS_CACHE", you must omit this field.
    defaultTtl: Optional. Specifies the default TTL for cached content served
      by this origin for responses that do not have an existing valid TTL
      (max-age or s-max-age). Defaults to 3600s (1 hour). - The TTL must be >=
      0 and <= 31,536,000 seconds (1 year) - Setting a TTL of "0" means
      "always revalidate" (equivalent to must-revalidate) - The value of
      defaultTTL cannot be set to a value greater than that of maxTTL. -
      Fractions of a second are not allowed. - When the cacheMode is set to
      FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all
      responses. Note that infrequently accessed objects may be evicted from
      the cache before the defined TTL. Objects that expire will be
      revalidated with the origin. When the cache mode is set to
      "USE_ORIGIN_HEADERS" or "BYPASS_CACHE", you must omit this field.
    maxTtl: Optional. Specifies the maximum allowed TTL for cached content
      served by this origin. Defaults to 86400s (1 day). Cache directives that
      attempt to set a max-age or s-maxage higher than this, or an Expires
      header more than maxTtl seconds in the future will be capped at the
      value of maxTTL, as if it were the value of an s-maxage Cache-Control
      directive. - The TTL must be >= 0 and <= 31,536,000 seconds (1 year) -
      Setting a TTL of "0" means "always revalidate" - The value of maxTtl
      must be equal to or greater than defaultTtl. - Fractions of a second are
      not allowed. When the cache mode is set to "USE_ORIGIN_HEADERS",
      "FORCE_CACHE_ALL", or "BYPASS_CACHE", you must omit this field.
    negativeCaching: Optional. Negative caching allows per-status code TTLs to
      be set, in order to apply fine-grained caching for common errors or
      redirects. This can reduce the load on your origin and improve end-user
      experience by reducing response latency. By default, the CDNPolicy will
      apply the following default TTLs to these status codes: - HTTP 300
      (Multiple Choice), 301, 308 (Permanent Redirects): 10m - HTTP 404 (Not
      Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s - HTTP 405
      (Method Not Found), 414 (URI Too Long), 501 (Not Implemented): 60s These
      defaults can be overridden in negativeCachingPolicy
    negativeCachingPolicy: Optional. Sets a cache TTL for the specified HTTP
      status code. negativeCaching must be enabled to configure
      negativeCachingPolicy. - Omitting the policy and leaving negativeCaching
      enabled will use the default TTLs for each status code, defined in
      negativeCaching. - TTLs must be >= 0 (where 0 is "always revalidate")
      and <= 86400s (1 day) Note that when specifying an explicit
      negativeCachingPolicy, you should take care to specify a cache TTL for
      all response codes that you wish to cache. The CDNPolicy will not apply
      any default negative caching when a policy exists.
    signedRequestKeyset: Optional. The EdgeCacheKeyset containing the set of
      public keys used to validate signed requests at the edge. For example,
      the following are both valid URLs to an EdgeCacheKeyset resource: - netw
      orkservices/v1alpha1/projects/project/global/edgeCacheKeysets/yourKeyset
      - /global/edgeCacheKeysets/yourKeyset signedRequestMode must be set to a
      value other than DISABLED when a keyset is provided.
    signedRequestMode: Optional. Whether to enforce signed requests. The
      default value is DISABLED, which means all content is public, and does
      not authorize access. You must also set a signedRequestKeyset to enable
      signed requests. When set to REQUIRE_SIGNATURES, all matching requests
      will have their signature validated. Requests that were not signed with
      the corresponding private key, or that are otherwise invalid (expired,
      do not match the signature, IP address, or header) will be rejected with
      a HTTP 403 and (if enabled) logged.
  """

  class CacheModeValueValuesEnum(_messages.Enum):
    r"""Optional. Cache modes allow users to control the behaviour of the
    cache, what content it should cache automatically, whether to respect
    origin headers, or whether to unconditionally cache all responses. For all
    cache modes, Cache-Control headers will be passed to the client. Use
    clientTtl to override what is sent to the client.

    Values:
      CACHE_MODE_UNSPECIFIED: Unspecified value. Will default to
        CACHE_ALL_STATIC.
      CACHE_ALL_STATIC: Automatically cache static content, including common
        image formats, media (video & audio), web assets (JavaScript & CSS).
        Requests and responses that are marked as uncacheable, as well as
        dynamic content (including HTML), will not be cached.
      USE_ORIGIN_HEADERS: Only cache responses with valid HTTP caching
        directives. Responses without these headers will not be cached at
        Google's edge, and will require a full trip to the origin on every
        request, potentially impacting performance and increasing load on the
        origin server.
      FORCE_CACHE_ALL: Cache all content, ignoring any "private", "no-store"
        or "no-cache" directives in Cache-Control response headers. Warning:
        this may result in caching private, per-user (user identifiable)
        content. You should only enable this on backends that are not serving
        private or dynamic content, such as storage buckets.
      BYPASS_CACHE: Bypass all caching for requests that match routes with
        this CDNPolicy applied. Enabling this will cause the edge cache to
        ignore all HTTP caching directives. All responses will be fulfilled
        from the origin.
    """
    CACHE_MODE_UNSPECIFIED = 0
    CACHE_ALL_STATIC = 1
    USE_ORIGIN_HEADERS = 2
    FORCE_CACHE_ALL = 3
    BYPASS_CACHE = 4

  class SignedRequestModeValueValuesEnum(_messages.Enum):
    r"""Optional. Whether to enforce signed requests. The default value is
    DISABLED, which means all content is public, and does not authorize
    access. You must also set a signedRequestKeyset to enable signed requests.
    When set to REQUIRE_SIGNATURES, all matching requests will have their
    signature validated. Requests that were not signed with the corresponding
    private key, or that are otherwise invalid (expired, do not match the
    signature, IP address, or header) will be rejected with a HTTP 403 and (if
    enabled) logged.

    Values:
      SIGNED_REQUEST_MODE_UNSPECIFIED: Unspecified value. Will default to
        DISABLED.
      DISABLED: Do not enforce signed requests.
      REQUIRE_SIGNATURES: Enforce signed requests. All requests must have a
        valid signature. Requests that are missing the signature (URL or
        cookie -based) will be rejected as if the signature was invalid.
    """
    SIGNED_REQUEST_MODE_UNSPECIFIED = 0
    DISABLED = 1
    REQUIRE_SIGNATURES = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class NegativeCachingPolicyValue(_messages.Message):
    r"""Optional. Sets a cache TTL for the specified HTTP status code.
    negativeCaching must be enabled to configure negativeCachingPolicy. -
    Omitting the policy and leaving negativeCaching enabled will use the
    default TTLs for each status code, defined in negativeCaching. - TTLs must
    be >= 0 (where 0 is "always revalidate") and <= 86400s (1 day) Note that
    when specifying an explicit negativeCachingPolicy, you should take care to
    specify a cache TTL for all response codes that you wish to cache. The
    CDNPolicy will not apply any default negative caching when a policy
    exists.

    Messages:
      AdditionalProperty: An additional property for a
        NegativeCachingPolicyValue object.

    Fields:
      additionalProperties: Additional properties of type
        NegativeCachingPolicyValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a NegativeCachingPolicyValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  cacheKeyPolicy = _messages.MessageField('CacheKeyPolicy', 1)
  cacheMode = _messages.EnumField('CacheModeValueValuesEnum', 2)
  clientTtl = _messages.StringField(3)
  defaultTtl = _messages.StringField(4)
  maxTtl = _messages.StringField(5)
  negativeCaching = _messages.BooleanField(6)
  negativeCachingPolicy = _messages.MessageField('NegativeCachingPolicyValue', 7)
  signedRequestKeyset = _messages.StringField(8)
  signedRequestMode = _messages.EnumField('SignedRequestModeValueValuesEnum', 9)


class CORSPolicy(_messages.Message):
  r"""CORSPolicy defines Cross-Origin-Resource-Sharing configuration,
  including which CORS response headers will be set.

  Fields:
    allowCredentials: Optional. In response to a preflight request, setting
      this to true indicates that the actual request can include user
      credentials. This translates to the Access-Control-Allow-Credentials
      response header.
    allowHeaders: Optional. Specifies the content for the Access-Control-
      Allow-Headers response header. You may specify up to 5 headers to
      include in the Access-Control-Allow-Headers header.
    allowMethods: Optional. Specifies the content for the Access-Control-
      Allow-Methods response header. You may specify up to 5 allowed methods.
    allowOrigins: Optional. Specifies the list of origins that will be allowed
      to do CORS requests. This translates to the Access-Control-Allow-Origin
      response header. You may specify up to 5 allowed origins.
    disabled: Optional. If true, specifies the CORS policy is disabled. The
      default value is false, which indicates that the CORS policy is in
      effect.
    exposeHeaders: Optional. Specifies the content for the Access-Control-
      Expose-Headers response header. You may specify up to 5 headers to
      expose in the Access-Control-Expose-Headers header.
    maxAge: Required. Specifies how long results of a preflight request can be
      cached by a client in seconds. Note that many browser clients enforce a
      maximum TTL of 600s (10 minutes). - Setting the value to -1 forces a
      pre-flight check for all requests (not recommended) - A maximum TTL of
      86400s can be set, but note that (as above) some clients may force pre-
      flight checks at a more regular interval. This translates to the Access-
      Control-Max-Age header.
  """

  allowCredentials = _messages.BooleanField(1)
  allowHeaders = _messages.StringField(2, repeated=True)
  allowMethods = _messages.StringField(3, repeated=True)
  allowOrigins = _messages.StringField(4, repeated=True)
  disabled = _messages.BooleanField(5)
  exposeHeaders = _messages.StringField(6, repeated=True)
  maxAge = _messages.StringField(7)


class CacheKeyPolicy(_messages.Message):
  r"""Defines the request parameters that contribute to the cache key.

  Fields:
    excludeHost: Optional. If true, requests to different hosts will be cached
      separately. Note: this should only be enabled if hosts share the same
      origin and content Removing the host from the cache key may
      inadvertently result in different objects being cached than intended,
      depending on which route the first user matched.
    excludedQueryParameters: Optional. Names of query string parameters to
      exclude from cache keys. All other parameters will be included. Either
      specify includedQueryParameters or excludedQueryParameters, not both.
      '&' and '=' will be percent encoded and not treated as delimiters. You
      may exclude up to 10 query parameters.
    includeProtocol: Optional. If true, http and https requests will be cached
      separately.
    includeQueryString: Optional. If true, include query string parameters in
      the cache key according to includeQueryParameters and
      excludeQueryParameters. If neither is set, the entire query string will
      be included. If false, the query string will be excluded from the cache
      key entirely.
    includedHeaderNames: Optional. Names of HTTP request headers to include in
      cache keys. The value of the header field will be used as part of the
      cache key. - Header names must be valid HTTP RFC 7230 header field
      values. - Header field names are case insensitive - You may specify up
      to five header names. - To include the HTTP method, use ":method" Refer
      to the documentation for the allowed list of header names. range of
      values (e.g. per-user) will dramatically impact the cache hit rate, and
      may result in a higher eviction rate and reduced performance. You may
      specify up to 5 header names.
    includedQueryParameters: Optional. Names of query string parameters to
      include in cache keys. All other parameters will be excluded. Either
      specify includedQueryParameters or excludedQueryParameters, not both.
      '&' and '=' will be percent encoded and not treated as delimiters. You
      may include up to 10 query parameters.
  """

  excludeHost = _messages.BooleanField(1)
  excludedQueryParameters = _messages.StringField(2, repeated=True)
  includeProtocol = _messages.BooleanField(3)
  includeQueryString = _messages.BooleanField(4)
  includedHeaderNames = _messages.StringField(5, repeated=True)
  includedQueryParameters = _messages.StringField(6, repeated=True)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class EdgeCacheKeyset(_messages.Message):
  r"""EdgeCacheKeyset represents a collection of public keys used for
  validating signed requests. Next ID: 8

  Messages:
    LabelsValue: Optional. Set of label tags associated with the EdgeCache
      resource.

  Fields:
    createTime: Output only. Creation timestamp in RFC3339 text format.
    description: Optional. A human-readable description of the resource.
    labels: Optional. Set of label tags associated with the EdgeCache
      resource.
    name: Required. Name of the resource; provided by the client when the
      resource is created. The name must be 1-64 characters long, and match
      the regular expression a-zA-Z* which means the first character must be a
      letter, and all following characters must be a dash, underscore, letter
      or digit.
    publicKeys: Required. An ordered list of Ed25519 public keys to use for
      validating signed requests. You must specify at least one (1) key, and
      may have up to three (3) keys. Ed25519 public keys are not secret, and
      only allow Google to validate a request was signed by your corresponding
      private key. You should ensure that the private key is kept secret, and
      that only authorized users can add public keys to a keyset. You can
      rotate keys by appending (pushing) a new key to the list of public keys,
      and removing any superseded keys.
    updateTime: Output only. Update timestamp in RFC3339 text format.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Set of label tags associated with the EdgeCache resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  publicKeys = _messages.MessageField('PublicKey', 5, repeated=True)
  updateTime = _messages.StringField(6)


class EdgeCacheOrigin(_messages.Message):
  r"""EdgeCacheOrigin represents a HTTP-reachable backend for an
  EdgeCacheService. Next ID: 14

  Enums:
    ProtocolValueValuesEnum: Optional. The protocol to use to connect to the
      configured origin. Defaults to HTTP2, and it is strongly recommended
      that users use HTTP2 for both security & performance. When using HTTP2
      or HTTPS as the protocol, a valid, publicly-signed, unexpired TLS (SSL)
      certificate must be presented by the origin server.
    RetryConditionsValueListEntryValuesEnum:

  Messages:
    LabelsValue: Optional. Set of label tags associated with the EdgeCache
      resource.

  Fields:
    createTime: Output only. A human-readable description of the resource.
      Creation timestamp in RFC3339 text format.
    description: Optional. A human-readable description of the resource.
    failoverOrigin: Optional. The Origin resource to try when the current
      origin cannot be reached. After maxAttempts is reached, the configured
      failoverOrigin will be used to fulfil the request. For example, the
      following are both valid URLs to an EdgeCacheOrigin resource: - networks
      ervices/v1alpha1/projects/project/global/edgeCacheOrigins/yourOrigin -
      /global/edgeCacheOrigins/yourOrigin The value of
      timeout.maxAttemptsTimeout dictates the timeout across all origins.
    labels: Optional. Set of label tags associated with the EdgeCache
      resource.
    maxAttempts: Optional. The maximum number of attempts to cache fill from
      this origin. Another attempt is made when a cache fill fails with one of
      the retry_conditions. Once max_attempts to this origin have failed the
      failover_origin will be used, if one is specified. That failover_origin
      may specify its own max_attempts, retry_conditions and failover_origin
      to control its own cache fill failures. The total number of allowed
      attempts to cache fill across this and failover origins is limited to
      four. The total time allowed for cache fill attempts across this and
      failover origins can be controlled with max_attempts_timeout. The last
      valid response from an origin will be returned to the client. If no
      origin returns a valid response, an HTTP 503 will be returned to the
      client. Defaults to 1. Must be a value greater than 0 and less than 4.
    name: Required. Name of the resource; provided by the client when the
      resource is created. The name must be 1-64 characters long, and match
      the regular expression a-zA-Z* which means the first character must be a
      letter, and all following characters must be a dash, underscore, letter
      or digit.
    originAddress: Required. A fully qualified domain name (FQDN) or IP
      address reachable over the public Internet, or the address of a Google
      Cloud Storage bucket. This address will be used as the origin for cache
      requests - e.g. FQDN: media-backend.example.com IPv4:35.218.1.1
      IPv6:[2607:f8b0:4012:809::200e] Cloud Storage: gs://bucketname or
      bucketname.storage.googleapis.com When providing an FQDN (hostname), it
      must be publicly resolvable (e.g. via Google public DNS). It must not
      contain a protocol (e.g. https://) and it must not contain any slashes.
      When providing an IP address, it must be publicly routable. IPv6
      addresses may be optionally enclosed in square brackets.
    port: Optional. The port to connect to the origin on. Defaults to port 443
      for HTTP2 and HTTPS protocols, and port 80 for HTTP.
    protocol: Optional. The protocol to use to connect to the configured
      origin. Defaults to HTTP2, and it is strongly recommended that users use
      HTTP2 for both security & performance. When using HTTP2 or HTTPS as the
      protocol, a valid, publicly-signed, unexpired TLS (SSL) certificate must
      be presented by the origin server.
    retryConditions: Optional. Specifies one or more retry conditions for the
      configured origin. If the failure mode during a connection attempt to
      the origin matches the configured retryCondition(s), the origin request
      will be retried up to maxAttempts times. The failoverOrigin, if
      configured, will then be used to satisfy the request. The default
      retryCondition is "CONNECT_FAILURE". retryConditions apply to this
      origin, and not subsequent failoverOrigin(s), which may specify their
      own retryConditions and maxAttempts. Valid values are: -
      CONNECT_FAILURE: Retry on failures connecting to origins, for example
      due to connection timeouts. - HTTP_5XX: Retry if the origin responds
      with any 5xx response code, or if the origin does not respond at all,
      example: disconnects, reset, read timeout, connection failure, and
      refused streams. - GATEWAY_ERROR: Similar to 5xx, but only applies to
      response codes 502, 503 or 504. - RETRIABLE_4XX: Retry for retriable 4xx
      response codes, which include HTTP 409 (Conflict) and HTTP 429 (Too Many
      Requests) - NOT_FOUND: Retry if the origin returns a HTTP 404 (Not
      Found). This can be useful when generating video content, and the
      segment is not available yet.
    timeout: Optional. The connection and HTTP timeout configuration for this
      origin.
    updateTime: Output only. Update timestamp in RFC3339 text format.
  """

  class ProtocolValueValuesEnum(_messages.Enum):
    r"""Optional. The protocol to use to connect to the configured origin.
    Defaults to HTTP2, and it is strongly recommended that users use HTTP2 for
    both security & performance. When using HTTP2 or HTTPS as the protocol, a
    valid, publicly-signed, unexpired TLS (SSL) certificate must be presented
    by the origin server.

    Values:
      PROTOCOL_UNSPECIFIED: Unspecified value. Will default to HTTP2.
      HTTP2: The HTTP/2 protocol. HTTP/2 refers to "h2", which requires TLS
        (HTTPS). Requires a valid (public, unexpired) TLS certificate to be
        present on the origin.
      HTTPS: HTTP/1.1 with TLS (SSL). Requires a valid (public, unexpired) TLS
        certificate to be present on the origin.
      HTTP: HTTP without TLS (SSL). This is not recommended, as communication
        outside of Google's network will be unencrypted to the public endpoint
        (origin).
    """
    PROTOCOL_UNSPECIFIED = 0
    HTTP2 = 1
    HTTPS = 2
    HTTP = 3

  class RetryConditionsValueListEntryValuesEnum(_messages.Enum):
    r"""RetryConditionsValueListEntryValuesEnum enum type.

    Values:
      RETRY_CONDITIONS_UNSPECIFIED: Unspecified
      CONNECT_FAILURE: Retry on failures include routing, DNS and TLS
        handshake errors, as well as TCP/UDP timeouts.
      HTTP_5XX: Retry on any 5xx response code.
      GATEWAY_ERROR: Similar to 5xx, but only applies to response codes 502,
        503 or 504.
      RETRIABLE_4XX: Retry for retriable 4xx response codes, including 409 and
        429.
      NOT_FOUND: Retry on a HTTP 404.
    """
    RETRY_CONDITIONS_UNSPECIFIED = 0
    CONNECT_FAILURE = 1
    HTTP_5XX = 2
    GATEWAY_ERROR = 3
    RETRIABLE_4XX = 4
    NOT_FOUND = 5

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Set of label tags associated with the EdgeCache resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  failoverOrigin = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  maxAttempts = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  name = _messages.StringField(6)
  originAddress = _messages.StringField(7)
  port = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  protocol = _messages.EnumField('ProtocolValueValuesEnum', 9)
  retryConditions = _messages.EnumField('RetryConditionsValueListEntryValuesEnum', 10, repeated=True)
  timeout = _messages.MessageField('Timeout', 11)
  updateTime = _messages.StringField(12)


class EdgeCacheService(_messages.Message):
  r"""EdgeCacheService defines the IP addresses, protocols, security policies,
  cache policies and routing configuration. Next ID: 16

  Messages:
    LabelsValue: Optional. Set of label tags associated with the EdgeCache
      resource.

  Fields:
    createTime: Output only. Creation timestamp in RFC3339 text format.
    description: Optional. A human-readable description of the resource.
    disableQuic: Optional. HTTP/3 (IETF QUIC) and Google QUIC are enabled by
      default.
    edgeSecurityPolicy: Optional. Resource URL that points at the Cloud Armor
      edge security policy that is applied on each request against the
      EdgeCacheService.
    edgeSslCertificates: Optional. URLs to sslCertificate resources that are
      used to authenticate connections between users and the EdgeCacheService.
      Note that only "global" certificates with a "scope" of "EDGE_CACHE" can
      be attached to an EdgeCacheService. The following are both valid URLs to
      a Certificate resource: -
      /v1/projects/project/locations/global/certificates/media-example-com-
      cert - /global/certificates/media-example-com-cert You may specify up to
      5 SSL certificates.
    ipv4Addresses: Output only. The IPv4 addresses associated with this
      service. Addresses are static for the lifetime of the service. IP
      addresses provisioned via Bring-Your-Own-IP (BYOIP) are not supported.
    ipv6Addresses: Output only. The IPv6 addresses associated with this
      service. Addresses are static for the lifetime of the service. IP
      addresses provisioned via Bring-Your-Own-IP (BYOIP) are not supported.
    labels: Optional. Set of label tags associated with the EdgeCache
      resource.
    logConfig: Optional. Specifies the logging options for the traffic served
      by this service. If logging is enabled, logs will be exported to Cloud
      Logging.
    name: Required. Name of the resource; provided by the client when the
      resource is created. The name must be 1-64 characters long, and match
      the regular expression a-zA-Z* which means the first character must be a
      letter, and all following characters must be a dash, underscore, letter
      or digit.
    requireTls: Optional. Require TLS (HTTPS) for all clients connecting to
      this service. Clients who connect over HTTP (port 80) will receive a
      HTTP 301 to the same URL over HTTPS (port 443). You must have at least
      one (1) edgeSslCertificate specified to enable this.
    routing: Required. Defines how requests are routed, modified, cached
      and/or which origin content is filled from.
    updateTime: Output only. Update timestamp in RFC3339 text format.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Set of label tags associated with the EdgeCache resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  disableQuic = _messages.BooleanField(3)
  edgeSecurityPolicy = _messages.StringField(4)
  edgeSslCertificates = _messages.StringField(5, repeated=True)
  ipv4Addresses = _messages.StringField(6, repeated=True)
  ipv6Addresses = _messages.StringField(7, repeated=True)
  labels = _messages.MessageField('LabelsValue', 8)
  logConfig = _messages.MessageField('LogConfig', 9)
  name = _messages.StringField(10)
  requireTls = _messages.BooleanField(11)
  routing = _messages.MessageField('Routing', 12)
  updateTime = _messages.StringField(13)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class EndpointConfigSelector(_messages.Message):
  r"""EndpointConfigSelector is a resource that helps apply desired
  configuration on the endpoints that match specific criteria. For example,
  this resource can be used to apply "authentication config" an all endpoints
  that serve on port 8080.

  Enums:
    TypeValueValuesEnum: Required. The type of endpoint config. This is
      primarily used to validate the configuration.

  Messages:
    LabelsValue: Optional. Set of label tags associated with the
      EndpointConfigSelector resource.

  Fields:
    authorizationPolicy: Optional. This field specifies the URL of
      AuthorizationPolicy resource that applies authorization policies to the
      inbound traffic at the matched endpoints. Refer to Authorization. If
      this field is not specified, authorization is disabled(no authz checks)
      for this endpoint. Applicable only when EndpointConfigSelectorType is
      SIDECAR_PROXY.
    clientTlsPolicy: Optional. A URL referring to a ClientTlsPolicy resource.
      ClientTlsPolicy can be set to specify the authentication for traffic
      from the proxy to the actual endpoints. More specifically, it is applied
      to the outgoing traffic from the proxy to the endpoint. This is
      typically used for sidecar model where the proxy identifies itself as
      endpoint to the control plane, with the connection between sidecar and
      endpoint requiring authentication. If this field is not set,
      authentication is disabled(open). Applicable only when
      EndpointConfigSelectorType is SIDECAR_PROXY.
    createTime: Output only. The timestamp when the resource was created.
    description: Optional. A free-text description of the resource. Max length
      1024 characters.
    endpointMatcher: Required. A matcher that selects endpoints to which the
      policies should be applied.
    httpFilters: Optional. HTTP filters configuration for the endpoint.
      Applicable only when EndpointConfigSelectorType is SIDECAR_PROXY.
    labels: Optional. Set of label tags associated with the
      EndpointConfigSelector resource.
    name: Required. Name of the EndpointConfigSelector resource. It matches
      pattern `projects/*/locations/global/endpointConfigSelectors/`.
    serverTlsPolicy: Optional. A URL referring to ServerTlsPolicy resource.
      ServerTlsPolicy is used to determine the authentication policy to be
      applied to terminate the inbound traffic at the identified backends. If
      this field is not set, authentication is disabled(open) for this
      endpoint.
    trafficPortSelector: Optional. Port selector for the (matched) endpoints.
      If no port selector is provided, the matched config is applied to all
      ports.
    type: Required. The type of endpoint config. This is primarily used to
      validate the configuration.
    updateTime: Output only. The timestamp when the resource was updated.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of endpoint config. This is primarily used to
    validate the configuration.

    Values:
      ENDPOINT_CONFIG_SELECTOR_TYPE_UNSPECIFIED: <no description>
      SIDECAR_PROXY: Represents a proxy deployed as a sidecar.
      GRPC_SERVER: Represents a proxyless gRPC backend.
    """
    ENDPOINT_CONFIG_SELECTOR_TYPE_UNSPECIFIED = 0
    SIDECAR_PROXY = 1
    GRPC_SERVER = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Set of label tags associated with the EndpointConfigSelector
    resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  authorizationPolicy = _messages.StringField(1)
  clientTlsPolicy = _messages.StringField(2)
  createTime = _messages.StringField(3)
  description = _messages.StringField(4)
  endpointMatcher = _messages.MessageField('EndpointMatcher', 5)
  httpFilters = _messages.MessageField('HttpFilters', 6)
  labels = _messages.MessageField('LabelsValue', 7)
  name = _messages.StringField(8)
  serverTlsPolicy = _messages.StringField(9)
  trafficPortSelector = _messages.MessageField('TrafficPortSelector', 10)
  type = _messages.EnumField('TypeValueValuesEnum', 11)
  updateTime = _messages.StringField(12)


class EndpointMatcher(_messages.Message):
  r"""A definition of a matcher that selects endpoints to which the policies
  should be applied.

  Fields:
    metadataLabelMatcher: The matcher is based on node metadata presented by
      xDS clients.
  """

  metadataLabelMatcher = _messages.MessageField('MetadataLabelMatcher', 1)


class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class HeaderAction(_messages.Message):
  r"""HeaderAction defines the addition and removal of HTTP headers for
  requests/responses.

  Fields:
    requestHeadersToAdd: Optional. Describes a header to add. You may add a
      maximum of 5 request headers.
    requestHeadersToRemove: Optional. A list of header names for headers that
      need to be removed from the request prior to forwarding the request to
      the origin. You may specify up to 10 request headers to remove.
    responseHeadersToAdd: Optional. Headers to add to the response prior to
      sending it back to the client. You may add a maximum of 5 response
      headers. Response headers are only sent to the client, and do not have
      an effect on the cache serving the response.
    responseHeadersToRemove: Optional. Headers to remove from the response
      prior to sending it back to the client. Response headers are only sent
      to the client, and do not have an effect on the cache serving the
      response. You may specify up to 10 response headers to remove.
  """

  requestHeadersToAdd = _messages.MessageField('AddHeader', 1, repeated=True)
  requestHeadersToRemove = _messages.MessageField('RemoveHeader', 2, repeated=True)
  responseHeadersToAdd = _messages.MessageField('AddHeader', 3, repeated=True)
  responseHeadersToRemove = _messages.MessageField('RemoveHeader', 4, repeated=True)


class HeaderMatch(_messages.Message):
  r"""HeaderMatch defines the match conditions for HTTP request headers.

  Fields:
    exactMatch: Optional. The value of the header should exactly match
      contents of exactMatch. Only one of exactMatch, prefixMatch, suffixMatch
      or presentMatch must be set.
    headerName: Required. The header name to match on.
    invertMatch: Optional. If set to false (default), the headerMatch is
      considered a match if the match criteria above are met. If set to true,
      the headerMatch is considered a match if the match criteria above are
      NOT met. The default setting is false.
    prefixMatch: Optional. The value of the header must start with the
      contents of prefixMatch. Only one of exactMatch, prefixMatch,
      suffixMatch or presentMatch must be set.
    presentMatch: Optional. A header with the contents of headerName must
      exist. The match takes place whether or not the request's header has a
      value. Only one of exactMatch, prefixMatch, suffixMatch or presentMatch
      must be set.
    suffixMatch: Optional. The value of the header must end with the contents
      of suffixMatch. Only one of exactMatch, prefixMatch, suffixMatch or
      presentMatch must be set.
  """

  exactMatch = _messages.StringField(1)
  headerName = _messages.StringField(2)
  invertMatch = _messages.BooleanField(3)
  prefixMatch = _messages.StringField(4)
  presentMatch = _messages.BooleanField(5)
  suffixMatch = _messages.StringField(6)


class HostRule(_messages.Message):
  r"""The hostname configured for the EdgeCacheService. A hostRule associates
  a hostname (or hostnames) with a set of routing rules, which define path-
  and header- based configuration.

  Fields:
    description: Optional. A human-readable description of the hostRule.
    hosts: Required. The list of host patterns to match. Host patterns must be
      valid hostnames with optional port numbers in the format host:port. *
      matches any string of ([a-z0-9-.]*). The only accepted ports are :80 and
      :443. Hosts are matched against the HTTP Host header, or for HTTP/2 and
      HTTP/3, the ":authority" header, from the incoming request. You may
      specify up to 10 hosts.
    pathMatcher: Required. The name of the pathMatcher associated with this
      hostRule.
  """

  description = _messages.StringField(1)
  hosts = _messages.StringField(2, repeated=True)
  pathMatcher = _messages.StringField(3)


class HttpFilter(_messages.Message):
  r"""HttpFilter is a resource representing http filter definition to be
  programmed in the xDS API compatible clients.

  Messages:
    LabelsValue: Optional. Set of label tags associated with the HttpFilter
      resource.

  Fields:
    config: Required. The configuration needed to enable the HTTP filter. The
      configuration must be JSON formatted and only contain fields defined in
      the protobuf identified in config_type_url.
    configTypeUrl: Required. The fully qualified versioned proto3 type url
      that the filter expects for its configuration. For example:
      'type.googleapis.com/envoy.config.wasm.v2.WasmService'.
    createTime: Output only. The timestamp when the resource was created.
    description: Optional. A free-text description of the resource. Max length
      1024 characters.
    filterName: Required. Name of the HTTP filter defined in the `config`
      field. It is used by the xDS API client to identify specific filter
      implementation the `config` must be applied to. It is different from the
      name of the HttpFilter resource and does not have to be unique. Example:
      'envoy.wasm'.
    labels: Optional. Set of label tags associated with the HttpFilter
      resource.
    name: Required. Name of the HttpFilter resource. It matches pattern
      `projects/*/locations/global/httpFilters/`.
    updateTime: Output only. The timestamp when the resource was updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Set of label tags associated with the HttpFilter resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  config = _messages.StringField(1)
  configTypeUrl = _messages.StringField(2)
  createTime = _messages.StringField(3)
  description = _messages.StringField(4)
  filterName = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  updateTime = _messages.StringField(8)


class HttpFilters(_messages.Message):
  r"""HTTP filters configuration for the endpoint.

  Fields:
    httpFilters: Required. The list of URLs to HttpFilter resources enabled
      for xDS clients using this configuration. Only filters that handle
      inbound connection and stream events must be specified. These filters
      work in conjunction with a default set of HTTP filters that may already
      be configured by Traffic Director. Traffic Director will determine the
      final location of these filters within xDS configuration based on the
      name of the HTTP filter. If Traffic Director positions multiple filters
      at the same location, those filters will be in the same order as
      specified in this list.
  """

  httpFilters = _messages.StringField(1, repeated=True)


class ListEdgeCacheKeysetsResponse(_messages.Message):
  r"""Response returned by the ListEdgeCacheKeysets method.

  Fields:
    edgeCacheKeysets: List of EdgeCacheKeyset resources.
    nextPageToken: If there might be more results than those appearing in this
      response, then `next_page_token` is included. To get the next set of
      results, call this method again using the value of `next_page_token` as
      `page_token`.
  """

  edgeCacheKeysets = _messages.MessageField('EdgeCacheKeyset', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListEdgeCacheOriginsResponse(_messages.Message):
  r"""Response returned by the ListEdgeCacheOrigins method.

  Fields:
    edgeCacheOrigins: List of EdgeCacheOrigin resources.
    nextPageToken: If there might be more results than those appearing in this
      response, then `next_page_token` is included. To get the next set of
      results, call this method again using the value of `next_page_token` as
      `page_token`.
  """

  edgeCacheOrigins = _messages.MessageField('EdgeCacheOrigin', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListEdgeCacheServicesResponse(_messages.Message):
  r"""Response returned by the ListEdgeCacheServices method.

  Fields:
    edgeCacheServices: List of EdgeCacheService resources.
    nextPageToken: If there might be more results than those appearing in this
      response, then `next_page_token` is included. To get the next set of
      results, call this method again using the value of `next_page_token` as
      `page_token`.
  """

  edgeCacheServices = _messages.MessageField('EdgeCacheService', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListEndpointConfigSelectorsResponse(_messages.Message):
  r"""Response returned by the ListEndpointConfigSelectors method.

  Fields:
    endpointConfigSelectors: List of EndpointConfigSelector resources.
    nextPageToken: If there might be more results than those appearing in this
      response, then `next_page_token` is included. To get the next set of
      results, call this method again using the value of `next_page_token` as
      `page_token`.
  """

  endpointConfigSelectors = _messages.MessageField('EndpointConfigSelector', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListHttpFiltersResponse(_messages.Message):
  r"""Response returned by the ListHttpFilters method.

  Fields:
    httpFilters: List of HttpFilter resources.
    nextPageToken: If there might be more results than those appearing in this
      response, then `next_page_token` is included. To get the next set of
      results, call this method again using the value of `next_page_token` as
      `page_token`.
  """

  httpFilters = _messages.MessageField('HttpFilter', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListRoutersResponse(_messages.Message):
  r"""Response returned by the ListRouters method.

  Fields:
    nextPageToken: If there might be more results than those appearing in this
      response, then `next_page_token` is included. To get the next set of
      results, call this method again using the value of `next_page_token` as
      `page_token`.
    routers: List of Router resources.
  """

  nextPageToken = _messages.StringField(1)
  routers = _messages.MessageField('Router', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class LogConfig(_messages.Message):
  r"""Specifies the logging options for the traffic served by this service. If
  logging is enabled, logs will be exported to Cloud Logging.

  Fields:
    enable: Optional. Specifies whether to enable logging for traffic served
      by this service. Defaults to false.
    sampleRate: Optional. Configures the sampling rate of requests, where 1.0
      means all logged requests are reported and 0.0 means no logged requests
      are reported. The default value is 1.0, and the value of the field must
      be in [0, 1]. This field can only be specified if logging is enabled for
      this service.
  """

  enable = _messages.BooleanField(1)
  sampleRate = _messages.FloatField(2, variant=_messages.Variant.FLOAT)


class MatchRule(_messages.Message):
  r"""MatchRule is a collection of match conditions (e.g. query, header, URI)
  for a request.

  Fields:
    fullPathMatch: Optional. For satisfying the matchRule condition, the path
      of the request must exactly match the value specified in fullPathMatch
      after removing any query parameters and anchor that may be part of the
      original URL. fullPathMatch must be between 1 and 1024 characters. Only
      one of prefixMatch or fullPathMatch must be specified.
    headerMatches: Optional. Specifies a list of header match criteria, all of
      which must match corresponding headers in the request. You may specify
      up to 3 headers to match on.
    ignoreCase: Optional. Specifies that prefixMatch and fullPathMatch matches
      are case sensitive. The default value is false.
    prefixMatch: Optional. For satisfying the matchRule condition, the
      request's path must begin with the specified prefixMatch. prefixMatch
      must begin with a /. The value must be between 1 and 1024 characters.
      Only one of prefixMatch or fullPathMatch must be specified.
    queryParameterMatches: Optional. Specifies a list of query parameter match
      criteria, all of which must match corresponding query parameters in the
      request. You may specify up to 5 query parameters to match on.
  """

  fullPathMatch = _messages.StringField(1)
  headerMatches = _messages.MessageField('HeaderMatch', 2, repeated=True)
  ignoreCase = _messages.BooleanField(3)
  prefixMatch = _messages.StringField(4)
  queryParameterMatches = _messages.MessageField('QueryParameterMatcher', 5, repeated=True)


class MetadataLabelMatcher(_messages.Message):
  r"""The matcher that is based on node metadata presented by xDS clients.

  Enums:
    MetadataLabelMatchCriteriaValueValuesEnum: Specifies how matching should
      be done. Supported values are: MATCH_ANY: At least one of the Labels
      specified in the matcher should match the metadata presented by xDS
      client. MATCH_ALL: The metadata presented by the xDS client should
      contain all of the labels specified here. The selection is determined
      based on the best match. For example, suppose there are three
      EndpointConfigSelector resources P1, P2 and P3 and if P1 has a the
      matcher as MATCH_ANY , P2 has MATCH_ALL , and P3 has MATCH_ALL . If a
      client with label connects, the config from P1 will be selected. If a
      client with label connects, the config from P2 will be selected. If a
      client with label connects, the config from P3 will be selected. If
      there is more than one best match, (for example, if a config P4 with
      selector exists and if a client with label connects), an error will be
      thrown.

  Fields:
    metadataLabelMatchCriteria: Specifies how matching should be done.
      Supported values are: MATCH_ANY: At least one of the Labels specified in
      the matcher should match the metadata presented by xDS client.
      MATCH_ALL: The metadata presented by the xDS client should contain all
      of the labels specified here. The selection is determined based on the
      best match. For example, suppose there are three EndpointConfigSelector
      resources P1, P2 and P3 and if P1 has a the matcher as MATCH_ANY , P2
      has MATCH_ALL , and P3 has MATCH_ALL . If a client with label connects,
      the config from P1 will be selected. If a client with label connects,
      the config from P2 will be selected. If a client with label connects,
      the config from P3 will be selected. If there is more than one best
      match, (for example, if a config P4 with selector exists and if a client
      with label connects), an error will be thrown.
    metadataLabels: The list of label value pairs that must match labels in
      the provided metadata based on filterMatchCriteria This list can have at
      most 64 entries. The list can be empty if the match criteria is
      MATCH_ANY, to specify a wildcard match (i.e this matches any client).
  """

  class MetadataLabelMatchCriteriaValueValuesEnum(_messages.Enum):
    r"""Specifies how matching should be done. Supported values are:
    MATCH_ANY: At least one of the Labels specified in the matcher should
    match the metadata presented by xDS client. MATCH_ALL: The metadata
    presented by the xDS client should contain all of the labels specified
    here. The selection is determined based on the best match. For example,
    suppose there are three EndpointConfigSelector resources P1, P2 and P3 and
    if P1 has a the matcher as MATCH_ANY , P2 has MATCH_ALL , and P3 has
    MATCH_ALL . If a client with label connects, the config from P1 will be
    selected. If a client with label connects, the config from P2 will be
    selected. If a client with label connects, the config from P3 will be
    selected. If there is more than one best match, (for example, if a config
    P4 with selector exists and if a client with label connects), an error
    will be thrown.

    Values:
      METADATA_LABEL_MATCH_CRITERIA_UNSPECIFIED: <no description>
      MATCH_ANY: <no description>
      MATCH_ALL: <no description>
    """
    METADATA_LABEL_MATCH_CRITERIA_UNSPECIFIED = 0
    MATCH_ANY = 1
    MATCH_ALL = 2

  metadataLabelMatchCriteria = _messages.EnumField('MetadataLabelMatchCriteriaValueValuesEnum', 1)
  metadataLabels = _messages.MessageField('MetadataLabels', 2, repeated=True)


class MetadataLabels(_messages.Message):
  r"""Defines a name-pair value for a single label.

  Fields:
    labelName: Required. Label name presented as key in xDS Node Metadata.
    labelValue: Required. Label value presented as value corresponding to the
      above key, in xDS Node Metadata.
  """

  labelName = _messages.StringField(1)
  labelValue = _messages.StringField(2)


class NetworkservicesProjectsLocationsEdgeCacheKeysetsCreateRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheKeysetsCreateRequest object.

  Fields:
    edgeCacheKeyset: A EdgeCacheKeyset resource to be passed as the request
      body.
    edgeCacheKeysetId: Required. Short name of the EdgeCacheKeyset resource to
      be created. E.g. "MyEdgeCacheKeyset".
    parent: Required. The parent resource of the EdgeCacheKeyset. Must be in
      the format `projects/*/locations/global`.
  """

  edgeCacheKeyset = _messages.MessageField('EdgeCacheKeyset', 1)
  edgeCacheKeysetId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsEdgeCacheKeysetsDeleteRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheKeysetsDeleteRequest object.

  Fields:
    name: Required. A name of the EdgeCacheKeyset to delete. Must be in the
      format `projects/*/locations/global/edgeCacheKeysets/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsEdgeCacheKeysetsGetIamPolicyRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheKeysetsGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class NetworkservicesProjectsLocationsEdgeCacheKeysetsGetRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheKeysetsGetRequest object.

  Fields:
    name: Required. A name of the EdgeCacheKeyset to get. Must be in the
      format `projects/*/locations/global/edgeCacheKeysets/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsEdgeCacheKeysetsListRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheKeysetsListRequest object.

  Fields:
    pageSize: Maximum number of EdgeCacheKeysets to return per call.
    pageToken: The value returned by the last `ListEdgeCacheKeysetsResponse`
      Indicates that this is a continuation of a prior `ListEdgeCacheKeysets`
      call, and that the system should return the next page of data.
    parent: Required. The project and location from which the EdgeCacheKeysets
      should be listed, specified in the format `projects/*/locations/global`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsEdgeCacheKeysetsPatchRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheKeysetsPatchRequest object.

  Fields:
    edgeCacheKeyset: A EdgeCacheKeyset resource to be passed as the request
      body.
    name: Required. Name of the resource; provided by the client when the
      resource is created. The name must be 1-64 characters long, and match
      the regular expression a-zA-Z* which means the first character must be a
      letter, and all following characters must be a dash, underscore, letter
      or digit.
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the EdgeCacheKeyset resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  edgeCacheKeyset = _messages.MessageField('EdgeCacheKeyset', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class NetworkservicesProjectsLocationsEdgeCacheKeysetsSetIamPolicyRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheKeysetsSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class NetworkservicesProjectsLocationsEdgeCacheKeysetsTestIamPermissionsRequest(_messages.Message):
  r"""A
  NetworkservicesProjectsLocationsEdgeCacheKeysetsTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class NetworkservicesProjectsLocationsEdgeCacheOriginsCreateRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheOriginsCreateRequest object.

  Fields:
    edgeCacheOrigin: A EdgeCacheOrigin resource to be passed as the request
      body.
    edgeCacheOriginId: Required. Short name of the EdgeCacheOrigin resource to
      be created. E.g. "MyEdgeCacheOrigin".
    parent: Required. The parent resource of the EdgeCacheOrigin. Must be in
      the format `projects/*/locations/global`.
  """

  edgeCacheOrigin = _messages.MessageField('EdgeCacheOrigin', 1)
  edgeCacheOriginId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsEdgeCacheOriginsDeleteRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheOriginsDeleteRequest object.

  Fields:
    name: Required. A name of the EdgeCacheOrigin to delete. Must be in the
      format `projects/*/locations/global/edgeCacheOrigins/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsEdgeCacheOriginsGetIamPolicyRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheOriginsGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class NetworkservicesProjectsLocationsEdgeCacheOriginsGetRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheOriginsGetRequest object.

  Fields:
    name: Required. A name of the EdgeCacheOrigin to get. Must be in the
      format `projects/*/locations/global/edgeCacheOrigins/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsEdgeCacheOriginsListRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheOriginsListRequest object.

  Fields:
    pageSize: Maximum number of EdgeCacheOrigins to return per call.
    pageToken: The value returned by the last `ListEdgeCacheOriginsResponse`
      Indicates that this is a continuation of a prior `ListEdgeCacheOrigins`
      call, and that the system should return the next page of data.
    parent: Required. The project and location from which the EdgeCacheOrigins
      should be listed, specified in the format `projects/*/locations/global`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsEdgeCacheOriginsPatchRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheOriginsPatchRequest object.

  Fields:
    edgeCacheOrigin: A EdgeCacheOrigin resource to be passed as the request
      body.
    name: Required. Name of the resource; provided by the client when the
      resource is created. The name must be 1-64 characters long, and match
      the regular expression a-zA-Z* which means the first character must be a
      letter, and all following characters must be a dash, underscore, letter
      or digit.
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the EdgeCacheOrigin resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  edgeCacheOrigin = _messages.MessageField('EdgeCacheOrigin', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class NetworkservicesProjectsLocationsEdgeCacheOriginsSetIamPolicyRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheOriginsSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class NetworkservicesProjectsLocationsEdgeCacheOriginsTestIamPermissionsRequest(_messages.Message):
  r"""A
  NetworkservicesProjectsLocationsEdgeCacheOriginsTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class NetworkservicesProjectsLocationsEdgeCacheServicesCreateRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheServicesCreateRequest object.

  Fields:
    edgeCacheService: A EdgeCacheService resource to be passed as the request
      body.
    edgeCacheServiceId: Required. Short name of the EdgeCacheService resource
      to be created. E.g. "MyEdgeService".
    parent: Required. The parent resource of the EdgeCacheService. Must be in
      the format `projects/*/locations/global`.
  """

  edgeCacheService = _messages.MessageField('EdgeCacheService', 1)
  edgeCacheServiceId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsEdgeCacheServicesDeleteRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheServicesDeleteRequest object.

  Fields:
    name: Required. A name of the EdgeCacheService to delete. Must be in the
      format `projects/*/locations/global/edgeCacheServices/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsEdgeCacheServicesGetIamPolicyRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheServicesGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class NetworkservicesProjectsLocationsEdgeCacheServicesGetRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheServicesGetRequest object.

  Fields:
    name: Required. A name of the EdgeCacheService to get. Must be in the
      format `projects/*/locations/global/edgeCacheServices/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsEdgeCacheServicesListRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheServicesListRequest object.

  Fields:
    pageSize: Maximum number of EdgeCacheServices to return per call.
    pageToken: The value returned by the last `ListEdgeCacheServicesResponse`
      Indicates that this is a continuation of a prior `ListEdgeCacheServices`
      call, and that the system should return the next page of data.
    parent: Required. The project and location from which the
      EdgeCacheServices should be listed, specified in the format
      `projects/*/locations/global`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsEdgeCacheServicesPatchRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheServicesPatchRequest object.

  Fields:
    edgeCacheService: A EdgeCacheService resource to be passed as the request
      body.
    name: Required. Name of the resource; provided by the client when the
      resource is created. The name must be 1-64 characters long, and match
      the regular expression a-zA-Z* which means the first character must be a
      letter, and all following characters must be a dash, underscore, letter
      or digit.
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the EdgeCacheService resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  edgeCacheService = _messages.MessageField('EdgeCacheService', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class NetworkservicesProjectsLocationsEdgeCacheServicesSetIamPolicyRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEdgeCacheServicesSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class NetworkservicesProjectsLocationsEdgeCacheServicesTestIamPermissionsRequest(_messages.Message):
  r"""A
  NetworkservicesProjectsLocationsEdgeCacheServicesTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class NetworkservicesProjectsLocationsEndpointConfigSelectorsCreateRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEndpointConfigSelectorsCreateRequest
  object.

  Fields:
    endpointConfigSelector: A EndpointConfigSelector resource to be passed as
      the request body.
    endpointConfigSelectorId: Required. Short name of the
      EndpointConfigSelector resource to be created. E.g. "CustomECS".
    parent: Required. The parent resource of the EndpointConfigSelector. Must
      be in the format `projects/*/locations/global`.
  """

  endpointConfigSelector = _messages.MessageField('EndpointConfigSelector', 1)
  endpointConfigSelectorId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsEndpointConfigSelectorsDeleteRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEndpointConfigSelectorsDeleteRequest
  object.

  Fields:
    name: Required. A name of the EndpointConfigSelector to delete. Must be in
      the format `projects/*/locations/global/endpointConfigSelectors/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsEndpointConfigSelectorsGetIamPolicyRequest(_messages.Message):
  r"""A
  NetworkservicesProjectsLocationsEndpointConfigSelectorsGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class NetworkservicesProjectsLocationsEndpointConfigSelectorsGetRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEndpointConfigSelectorsGetRequest
  object.

  Fields:
    name: Required. A name of the EndpointConfigSelector to get. Must be in
      the format `projects/*/locations/global/endpointConfigSelectors/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsEndpointConfigSelectorsListRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEndpointConfigSelectorsListRequest
  object.

  Fields:
    pageSize: Maximum number of EndpointConfigSelectors to return per call.
    pageToken: The value returned by the last
      `ListEndpointConfigSelectorsResponse` Indicates that this is a
      continuation of a prior `ListEndpointConfigSelectors` call, and that the
      system should return the next page of data.
    parent: Required. The project and location from which the
      EndpointConfigSelectors should be listed, specified in the format
      `projects/*/locations/global`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsEndpointConfigSelectorsPatchRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEndpointConfigSelectorsPatchRequest
  object.

  Fields:
    endpointConfigSelector: A EndpointConfigSelector resource to be passed as
      the request body.
    name: Required. Name of the EndpointConfigSelector resource. It matches
      pattern `projects/*/locations/global/endpointConfigSelectors/`.
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the EndpointConfigSelector resource by the update. The
      fields specified in the update_mask are relative to the resource, not
      the full request. A field will be overwritten if it is in the mask. If
      the user does not provide a mask then all fields will be overwritten.
  """

  endpointConfigSelector = _messages.MessageField('EndpointConfigSelector', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class NetworkservicesProjectsLocationsEndpointConfigSelectorsSetIamPolicyRequest(_messages.Message):
  r"""A
  NetworkservicesProjectsLocationsEndpointConfigSelectorsSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class NetworkservicesProjectsLocationsEndpointConfigSelectorsTestIamPermissionsRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsEndpointConfigSelectorsTestIamPermissi
  onsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class NetworkservicesProjectsLocationsGetRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsHttpFiltersCreateRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsHttpFiltersCreateRequest object.

  Fields:
    httpFilter: A HttpFilter resource to be passed as the request body.
    httpFilterId: Required. Short name of the HttpFilter resource to be
      created. E.g. "CustomFilter".
    parent: Required. The parent resource of the HttpFilter. Must be in the
      format `projects/*/locations/global`.
  """

  httpFilter = _messages.MessageField('HttpFilter', 1)
  httpFilterId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsHttpFiltersDeleteRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsHttpFiltersDeleteRequest object.

  Fields:
    name: Required. A name of the HttpFilter to delete. Must be in the format
      `projects/*/locations/global/httpFilters/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsHttpFiltersGetIamPolicyRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsHttpFiltersGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class NetworkservicesProjectsLocationsHttpFiltersGetRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsHttpFiltersGetRequest object.

  Fields:
    name: Required. A name of the HttpFilter to get. Must be in the format
      `projects/*/locations/global/httpFilters/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsHttpFiltersListRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsHttpFiltersListRequest object.

  Fields:
    pageSize: Maximum number of HttpFilters to return per call.
    pageToken: The value returned by the last `ListHttpFiltersResponse`
      Indicates that this is a continuation of a prior `ListHttpFilters` call,
      and that the system should return the next page of data.
    parent: Required. The project and location from which the HttpFilters
      should be listed, specified in the format `projects/*/locations/global`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsHttpFiltersPatchRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsHttpFiltersPatchRequest object.

  Fields:
    httpFilter: A HttpFilter resource to be passed as the request body.
    name: Required. Name of the HttpFilter resource. It matches pattern
      `projects/*/locations/global/httpFilters/`.
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the HttpFilter resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  httpFilter = _messages.MessageField('HttpFilter', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class NetworkservicesProjectsLocationsHttpFiltersSetIamPolicyRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsHttpFiltersSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class NetworkservicesProjectsLocationsHttpFiltersTestIamPermissionsRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsHttpFiltersTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class NetworkservicesProjectsLocationsListRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like "displayName=tokyo", and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      will select a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class NetworkservicesProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class NetworkservicesProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class NetworkservicesProjectsLocationsRoutersCreateRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsRoutersCreateRequest object.

  Fields:
    parent: Required. The parent resource of the Router. Must be in the format
      `projects/*/locations/global`.
    router: A Router resource to be passed as the request body.
    routerId: Required. Short name of the Router resource to be created.
  """

  parent = _messages.StringField(1, required=True)
  router = _messages.MessageField('Router', 2)
  routerId = _messages.StringField(3)


class NetworkservicesProjectsLocationsRoutersDeleteRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsRoutersDeleteRequest object.

  Fields:
    name: Required. A name of the Router to delete. Must be in the format
      `projects/*/locations/global/routers/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsRoutersGetIamPolicyRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsRoutersGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class NetworkservicesProjectsLocationsRoutersGetRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsRoutersGetRequest object.

  Fields:
    name: Required. A name of the Router to get. Must be in the format
      `projects/*/locations/global/routers/*`.
  """

  name = _messages.StringField(1, required=True)


class NetworkservicesProjectsLocationsRoutersListRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsRoutersListRequest object.

  Fields:
    pageSize: Maximum number of Routers to return per call.
    pageToken: The value returned by the last `ListRoutersResponse` Indicates
      that this is a continuation of a prior `ListRouters` call, and that the
      system should return the next page of data.
    parent: Required. The project and location from which the Routers should
      be listed, specified in the format `projects/*/locations/global`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class NetworkservicesProjectsLocationsRoutersPatchRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsRoutersPatchRequest object.

  Fields:
    name: Required. Name of the Router resource. It matches pattern
      `projects/*/locations/global/routers/`.
    router: A Router resource to be passed as the request body.
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the Router resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
  """

  name = _messages.StringField(1, required=True)
  router = _messages.MessageField('Router', 2)
  updateMask = _messages.StringField(3)


class NetworkservicesProjectsLocationsRoutersSetIamPolicyRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsRoutersSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class NetworkservicesProjectsLocationsRoutersTestIamPermissionsRequest(_messages.Message):
  r"""A NetworkservicesProjectsLocationsRoutersTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class PathMatcher(_messages.Message):
  r"""The name of the PathMatcher to use to match the path portion of the URL
  if the hostRule matches the URL's host portion.

  Fields:
    description: Optional. A human-readable description of the resource.
    name: Required. The name to which this PathMatcher is referred by the
      HostRule.
    routeRules: Required. The routeRules to match against. routeRules support
      advanced routing behaviour, and can match on paths, headers and query
      parameters, as well as status codes and HTTP methods. You must specify
      at least one (1) rule, and can specify a maximum of 64 rules.
  """

  description = _messages.StringField(1)
  name = _messages.StringField(2)
  routeRules = _messages.MessageField('RouteRule', 3, repeated=True)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members` to a single `role`.
  Members can be user accounts, service accounts, Google groups, and domains
  (such as G Suite). A `role` is a named list of permissions; each `role` can
  be an IAM predefined role or a user-created custom role. For some types of
  Google Cloud resources, a `binding` can also specify a `condition`, which is
  a logical expression that allows access to a resource only if the expression
  evaluates to `true`. A condition can add constraints based on attributes of
  the request, the resource, or both. To learn which resources support
  conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: - members: -
  user:mike@example.com - group:admins@example.com - domain:google.com -
  serviceAccount:my-project-id@appspot.gserviceaccount.com role:
  roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
  role: roles/resourcemanager.organizationViewer condition: title: expirable
  access description: Does not grant access after Sep 2020 expression:
  request.time < timestamp('2020-10-01T00:00:00.000Z') - etag: BwWWja0YfJA= -
  version: 3 For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. Optionally, may
      specify a `condition` that determines how and when the `bindings` are
      applied. Each of the `bindings` must contain at least one member.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class PublicKey(_messages.Message):
  r"""An Ed25519 public key used for validating signed requests.

  Fields:
    id: Required. The ID of the public key. The ID must be 1-64 characters
      long, and match the regular expression a-zA-Z* which means the first
      character must be a letter, and all following characters must be a dash,
      underscore, letter or digit.
    value: Required. The base64-encoded value of the Ed25519 public key. The
      base64 encoding can be padded (44 bytes) or unpadded (43 bytes).
      Representations or encodings of the public key other than this will be
      rejected with an error.
  """

  id = _messages.StringField(1)
  value = _messages.StringField(2)


class QueryParameterMatcher(_messages.Message):
  r"""QueryParameterMatcher defines the match conditions for URI query
  parameters.

  Fields:
    exactMatch: Optional. The queryParameterMatch matches if the value of the
      parameter exactly matches the contents of exactMatch. Only one of
      presentMatch or exactMatch must be set.
    name: Required. The name of the query parameter to match. The query
      parameter must exist in the request, in the absence of which the request
      match fails.
    presentMatch: Optional. Specifies that the queryParameterMatch matches if
      the request contains the query parameter, irrespective of whether the
      parameter has a value or not. Only one of presentMatch or exactMatch
      must be set.
  """

  exactMatch = _messages.StringField(1)
  name = _messages.StringField(2)
  presentMatch = _messages.BooleanField(3)


class RemoveHeader(_messages.Message):
  r"""Describes a header to remove.

  Fields:
    headerName: Required. The name of the header to remove.
  """

  headerName = _messages.StringField(1)


class RouteAction(_messages.Message):
  r"""RouteAction defines the actions (rewrites, redirects, CORS header
  injection, header modification) to take for a given route match.

  Fields:
    cdnPolicy: Optional. The policy to use for defining caching and signed
      request behaviour for requests that match this route.
    corsPolicy: Optional. The CORS (Cross-Origin Resource Sharing) policy for
      requests that match this route.
    urlRewrite: Optional. The URL rewrite configuration for requests that
      match this route.
  """

  cdnPolicy = _messages.MessageField('CDNPolicy', 1)
  corsPolicy = _messages.MessageField('CORSPolicy', 2)
  urlRewrite = _messages.MessageField('UrlRewrite', 3)


class RouteRule(_messages.Message):
  r"""RouteRule defines the priority of a given "route", including its match
  conditions and the actions to take on a request that matches.

  Fields:
    description: Optional. A human-readable description of the routeRule.
    headerAction: Optional. The header actions, including adding & removing
      headers, for requests that match this route.
    matchRules: Required. The list of criteria for matching attributes of a
      request to this routeRule. This list has OR semantics: the request
      matches this routeRule when any of the matchRules are satisfied. However
      predicates within a given matchRule have AND semantics. All predicates
      within a matchRule must match for the request to match the rule.
    origin: Optional. The Origin resource that requests to this route should
      fetch from when a matching response is not in cache. Origins can be
      defined as short names ("my-origin") or fully-qualified resource URLs -
      e.g. "networkservices.googleapis.com/projects/my-
      project/global/edgecacheorigins/my-origin" Only one of origin or
      urlRedirect can be set.
    priority: Required. The priority of this route rule, where 1 is the
      highest priority. You cannot configure two or more routeRules with the
      same priority. Priority for each rule must be set to a number between 1
      and 999 inclusive. Priority numbers can have gaps, which enable you to
      add or remove rules in the future without affecting the rest of the
      rules. For example, 1, 2, 3, 4, 5, 9, 12, 16 is a valid series of
      priority numbers to which you could add rules numbered from 6 to 8, 10
      to 11, and 13 to 15 in the future without any impact on existing rules.
    routeAction: Optional. In response to a matching path, the routeAction
      performs advanced routing actions like URL rewrites, header
      transformations, etc. prior to forwarding the request to the selected
      origin.
    urlRedirect: Optional. The URL redirect configuration for requests that
      match this route. Only one of origin or urlRedirect can be set.
  """

  description = _messages.StringField(1)
  headerAction = _messages.MessageField('HeaderAction', 2)
  matchRules = _messages.MessageField('MatchRule', 3, repeated=True)
  origin = _messages.StringField(4)
  priority = _messages.IntegerField(5)
  routeAction = _messages.MessageField('RouteAction', 6)
  urlRedirect = _messages.MessageField('UrlRedirect', 7)


class Router(_messages.Message):
  r"""Router is the resource representing infrastructure component that is
  responsible for forwarding traffic and applying policies. For example, it
  could be a load balancer, sidecar proxy or a GRPC client.

  Enums:
    TypeValueValuesEnum: Required. The type of the Router resource.

  Messages:
    LabelsValue: Optional. Set of label tags associated with the Router
      resource.

  Fields:
    createTime: Output only. The timestamp when the resource was created.
    description: Optional. A free-text description of the resource. Max length
      1024 characters.
    labels: Optional. Set of label tags associated with the Router resource.
    name: Required. Name of the Router resource. It matches pattern
      `projects/*/locations/global/routers/`.
    network: Optional. The reference to the VPC network that is using this
      configuration. Currently only the short name (network name) is
      supported, for example "default", and we assume it is under the same
      project as the resource by default.
    routes: Optional. List of references to routes that this Router must be
      able to route traffic for. Example:
      projects/12345/locations/global/grpcRoutes/myGrpcRoute
    type: Required. The type of the Router resource.
    updateTime: Output only. The timestamp when the resource was updated.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of the Router resource.

    Values:
      TYPE_UNSPECIFIED: The type of Router is unspecified.
      PROXYLESS_GRPC: The Router is used in Proxyless gRPC model. Routes being
        referenced must be gRPC routes for this type.
    """
    TYPE_UNSPECIFIED = 0
    PROXYLESS_GRPC = 1

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Set of label tags associated with the Router resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  network = _messages.StringField(5)
  routes = _messages.StringField(6, repeated=True)
  type = _messages.EnumField('TypeValueValuesEnum', 7)
  updateTime = _messages.StringField(8)


class Routing(_messages.Message):
  r"""Defines how requests are routed, modified, cached and/or which origin
  content is filled from.

  Fields:
    hostRules: Required. The list of hostRules to match against. These rules
      define which hostnames the EdgeCacheService will match against, and
      which route configurations apply. You may specify up to 5 host rules.
    pathMatchers: Required. The list of pathMatchers referenced via name by
      hostRules. PathMatcher is used to match the path portion of the URL when
      a HostRule matches the URL's host portion. You may specify up to 10 path
      matchers.
  """

  hostRules = _messages.MessageField('HostRule', 1, repeated=True)
  pathMatchers = _messages.MessageField('PathMatcher', 2, repeated=True)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class Timeout(_messages.Message):
  r"""The timeout configuration for this origin.

  Fields:
    connectTimeout: Optional. The maximum duration to wait for the origin
      connection to be established, including DNS lookup, TLS handshake and
      TCP/QUIC connection establishment. Defaults to 5 seconds. The timeout
      must be a value between 1s and 15s.
    maxAttemptsTimeout: Optional. The maximum time across all connection
      attempts to the origin, including failover origins, before returning an
      error to the client. A HTTP 503 will be returned if the timeout is
      reached before a response is returned. Defaults to 5 seconds. The
      timeout must be a value between 1s and 15s. If a failoverOrigin is
      specified, the maxAttemptsTimeout of the first configured origin takes
      precedence and determines the timeout for all requests.
    responseTimeout: Optional. The maximum duration to wait for data to arrive
      when reading from the HTTP connection/stream. Defaults to 5 seconds. The
      timeout must be a value between 1s and 30s. This also applies to HTTP
      Chunked Transfer Encoding responses, and/or when an open-ended Range
      request is made to the origin. Origins that take longer to write
      additional bytes to the response than the configured responseTimeout
      will result in an error being returned to the client. If the response
      headers have already been written to the connection, the response will
      be truncated and logged.
  """

  connectTimeout = _messages.StringField(1)
  maxAttemptsTimeout = _messages.StringField(2)
  responseTimeout = _messages.StringField(3)


class TrafficPortSelector(_messages.Message):
  r"""Specification of a port-based selector.

  Fields:
    ports: Optional. A list of ports. Can be port numbers or port range
      (example, [80-90] specifies all ports from 80 to 90, including 80 and
      90) or named ports or * to specify all ports. If the list is empty, all
      ports are selected.
  """

  ports = _messages.StringField(1, repeated=True)


class UrlRedirect(_messages.Message):
  r"""UrlRedirect defines HTTP redirect configuration for a given request.

  Enums:
    RedirectResponseCodeValueValuesEnum: Optional. The HTTP Status code to use
      for this RedirectAction. The supported values are: -
      MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to
      301. - FOUND, which corresponds to 302. - SEE_OTHER which corresponds to
      303. - TEMPORARY_REDIRECT, which corresponds to 307. in this case, the
      request method will be retained. - PERMANENT_REDIRECT, which corresponds
      to 308. in this case, the request method will be retained.

  Fields:
    hostRedirect: Optional. The host that will be used in the redirect
      response instead of the one that was supplied in the request. The value
      must be between 1 and 255 characters.
    httpsRedirect: Optional. If set to true, the URL scheme in the redirected
      request is set to https. If set to false, the URL scheme of the
      redirected request will remain the same as that of the request. This can
      only be set if there is at least one (1) edgeSslCertificate set on the
      service.
    pathRedirect: Optional. The path that will be used in the redirect
      response instead of the one that was supplied in the request.
      pathRedirect cannot be supplied together with prefixRedirect. Supply one
      alone or neither. If neither is supplied, the path of the original
      request will be used for the redirect. The path value must be between 1
      and 1024 characters.
    prefixRedirect: Optional. The prefix that replaces the prefixMatch
      specified in the routeRule, retaining the remaining portion of the URL
      before redirecting the request. prefixRedirect cannot be supplied
      together with pathRedirect. Supply one alone or neither. If neither is
      supplied, the path of the original request will be used for the
      redirect. The prefix value must be between 1 and 1024 characters.
    redirectResponseCode: Optional. The HTTP Status code to use for this
      RedirectAction. The supported values are: - MOVED_PERMANENTLY_DEFAULT,
      which is the default value and corresponds to 301. - FOUND, which
      corresponds to 302. - SEE_OTHER which corresponds to 303. -
      TEMPORARY_REDIRECT, which corresponds to 307. in this case, the request
      method will be retained. - PERMANENT_REDIRECT, which corresponds to 308.
      in this case, the request method will be retained.
    stripQuery: Optional. If set to true, any accompanying query portion of
      the original URL is removed prior to redirecting the request. If set to
      false, the query portion of the original URL is retained. The default is
      set to false.
  """

  class RedirectResponseCodeValueValuesEnum(_messages.Enum):
    r"""Optional. The HTTP Status code to use for this RedirectAction. The
    supported values are: - MOVED_PERMANENTLY_DEFAULT, which is the default
    value and corresponds to 301. - FOUND, which corresponds to 302. -
    SEE_OTHER which corresponds to 303. - TEMPORARY_REDIRECT, which
    corresponds to 307. in this case, the request method will be retained. -
    PERMANENT_REDIRECT, which corresponds to 308. in this case, the request
    method will be retained.

    Values:
      MOVED_PERMANENTLY_DEFAULT: HTTP 301 Moved Permanently
      FOUND: HTTP 302 Found
      SEE_OTHER: HTTP 303 See Other
      TEMPORARY_REDIRECT: HTTP 307 Temporary Redirect
      PERMANENT_REDIRECT: HTTP 308 Permanent Redirect
    """
    MOVED_PERMANENTLY_DEFAULT = 0
    FOUND = 1
    SEE_OTHER = 2
    TEMPORARY_REDIRECT = 3
    PERMANENT_REDIRECT = 4

  hostRedirect = _messages.StringField(1)
  httpsRedirect = _messages.BooleanField(2)
  pathRedirect = _messages.StringField(3)
  prefixRedirect = _messages.StringField(4)
  redirectResponseCode = _messages.EnumField('RedirectResponseCodeValueValuesEnum', 5)
  stripQuery = _messages.BooleanField(6)


class UrlRewrite(_messages.Message):
  r"""UrlRewrite defines URL rewrite configuration for a given request.

  Fields:
    hostRewrite: Optional. Prior to forwarding the request to the selected
      origin, the request's host header is replaced with contents of
      hostRewrite. The host value must be between 1 and 255 characters.
    pathPrefixRewrite: Optional. Prior to forwarding the request to the
      selected origin, the matching portion of the request's path is replaced
      by pathPrefixRewrite. The path value must be between 1 and 1024
      characters, and must start with a '/'.
  """

  hostRewrite = _messages.StringField(1)
  pathPrefixRewrite = _messages.StringField(2)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
