// This is an auto-generated file.
// Any changes to this file will be overwritten

// clazy:excludeall=function-args-by-value

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT int version();

class Ancestor;
class PartMetaData;
class CachePolicy;
class CollectionFetchScope;
class TagFetchScope;
class HelloResponse;
class LoginCommand;
class LoginResponse;
class LogoutCommand;
class LogoutResponse;
class TransactionCommand;
class TransactionResponse;
class CreateItemCommand;
class CreateItemResponse;
class CopyItemsCommand;
class CopyItemsResponse;
class DeleteItemsCommand;
class DeleteItemsResponse;
class FetchRelationsCommand;
class FetchRelationsResponse;
class FetchTagsCommand;
class FetchTagsResponse;
class FetchItemsCommand;
class FetchItemsResponse;
class LinkItemsCommand;
class LinkItemsResponse;
class ModifyItemsCommand;
class ModifyItemsResponse;
class MoveItemsCommand;
class MoveItemsResponse;
class CreateCollectionCommand;
class CreateCollectionResponse;
class CopyCollectionCommand;
class CopyCollectionResponse;
class DeleteCollectionCommand;
class DeleteCollectionResponse;
class FetchCollectionStatsCommand;
class FetchCollectionStatsResponse;
class FetchCollectionsCommand;
class FetchCollectionsResponse;
class ModifyCollectionCommand;
class ModifyCollectionResponse;
class MoveCollectionCommand;
class MoveCollectionResponse;
class SearchCommand;
class SearchResponse;
class SearchResultCommand;
class SearchResultResponse;
class StoreSearchCommand;
class StoreSearchResponse;
class CreateTagCommand;
class CreateTagResponse;
class DeleteTagCommand;
class DeleteTagResponse;
class ModifyTagCommand;
class ModifyTagResponse;
class ModifyRelationCommand;
class ModifyRelationResponse;
class RemoveRelationsCommand;
class RemoveRelationsResponse;
class SelectResourceCommand;
class SelectResourceResponse;
class StreamPayloadCommand;
class StreamPayloadResponse;
class ItemChangeNotification;
class CollectionChangeNotification;
class TagChangeNotification;
class RelationChangeNotification;
class CreateSubscriptionCommand;
class CreateSubscriptionResponse;
class ModifySubscriptionCommand;
class ModifySubscriptionResponse;
class SubscriptionChangeNotification;
class DebugChangeNotification;

} // namespace Protocol
} // namespace Akonadi

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const Ancestor &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, Ancestor &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Ancestor &obj);

using AncestorPtr = QSharedPointer<Ancestor>;

class AKONADIPRIVATE_EXPORT Ancestor
{

public:
    enum Depth {
        NoAncestor,
        ParentAncestor,
        AllAncestors,
    };
    explicit Ancestor();
    explicit Ancestor(qint64 id, const QString &remoteId = QString());
    Ancestor(const Ancestor &) = default;
    Ancestor(Ancestor &&) = default;
    ~Ancestor() = default;

    Ancestor &operator=(const Ancestor &) = default;
    Ancestor &operator=(Ancestor &&) = default;
    bool operator==(const Ancestor &other) const;
    inline bool operator!=(const Ancestor &other) const { return !operator==(other); }
    inline qint64 id() const { return mId; }
    inline void setId(qint64 id) { mId = id; }

    inline QString remoteId() const { return mRemoteId; }
    inline void setRemoteId(const QString &remoteId) { mRemoteId = remoteId; }
    inline void setRemoteId(QString &&remoteId) { mRemoteId = std::move(remoteId); }

    inline QString name() const { return mName; }
    inline void setName(const QString &name) { mName = name; }
    inline void setName(QString &&name) { mName = std::move(name); }

    inline Akonadi::Protocol::Attributes attributes() const { return mAttributes; }
    inline void setAttributes(const Akonadi::Protocol::Attributes &attributes) { mAttributes = attributes; }
    inline void setAttributes(Akonadi::Protocol::Attributes &&attributes) { mAttributes = std::move(attributes); }

    void toJson(QJsonObject &stream) const;
protected:
    qint64 mId = -1;
    QString mRemoteId;
    QString mName;
    Akonadi::Protocol::Attributes mAttributes;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::Ancestor &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::Ancestor &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::Ancestor &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::Ancestor)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const PartMetaData &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, PartMetaData &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const PartMetaData &obj);

using PartMetaDataPtr = QSharedPointer<PartMetaData>;

class AKONADIPRIVATE_EXPORT PartMetaData
{

public:
    enum StorageType {
        Internal,
        External,
        Foreign,
    };
    explicit PartMetaData();
    explicit PartMetaData(const QByteArray &name, qint64 size, int version = 0, const PartMetaData::StorageType &storageType = Internal);
    PartMetaData(const PartMetaData &) = default;
    PartMetaData(PartMetaData &&) = default;
    ~PartMetaData() = default;

    PartMetaData &operator=(const PartMetaData &) = default;
    PartMetaData &operator=(PartMetaData &&) = default;
    bool operator==(const PartMetaData &other) const;
    inline bool operator!=(const PartMetaData &other) const { return !operator==(other); }
    inline QByteArray name() const { return mName; }
    inline void setName(const QByteArray &name) { mName = name; }
    inline void setName(QByteArray &&name) { mName = std::move(name); }

    inline qint64 size() const { return mSize; }
    inline void setSize(qint64 size) { mSize = size; }

    inline int version() const { return mVersion; }
    inline void setVersion(int version) { mVersion = version; }

    inline PartMetaData::StorageType storageType() const { return mStorageType; }
    inline void setStorageType(const PartMetaData::StorageType &storageType) { mStorageType = storageType; }
    inline void setStorageType(PartMetaData::StorageType &&storageType) { mStorageType = std::move(storageType); }

    void toJson(QJsonObject &stream) const;
protected:
    QByteArray mName;
    qint64 mSize = 0;
    int mVersion = 0;
    PartMetaData::StorageType mStorageType = Internal;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::PartMetaData &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::PartMetaData &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::PartMetaData &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::PartMetaData)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const CachePolicy &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, CachePolicy &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const CachePolicy &obj);

using CachePolicyPtr = QSharedPointer<CachePolicy>;

class AKONADIPRIVATE_EXPORT CachePolicy
{

public:
    explicit CachePolicy();
    CachePolicy(const CachePolicy &) = default;
    CachePolicy(CachePolicy &&) = default;
    ~CachePolicy() = default;

    CachePolicy &operator=(const CachePolicy &) = default;
    CachePolicy &operator=(CachePolicy &&) = default;
    bool operator==(const CachePolicy &other) const;
    inline bool operator!=(const CachePolicy &other) const { return !operator==(other); }
    inline bool inherit() const { return mInherit; }
    inline void setInherit(bool inherit) { mInherit = inherit; }

    inline int checkInterval() const { return mCheckInterval; }
    inline void setCheckInterval(int checkInterval) { mCheckInterval = checkInterval; }

    inline int cacheTimeout() const { return mCacheTimeout; }
    inline void setCacheTimeout(int cacheTimeout) { mCacheTimeout = cacheTimeout; }

    inline bool syncOnDemand() const { return mSyncOnDemand; }
    inline void setSyncOnDemand(bool syncOnDemand) { mSyncOnDemand = syncOnDemand; }

    inline QStringList localParts() const { return mLocalParts; }
    inline void setLocalParts(const QStringList &localParts) { mLocalParts = localParts; }
    inline void setLocalParts(QStringList &&localParts) { mLocalParts = std::move(localParts); }

    void toJson(QJsonObject &stream) const;
protected:
    QStringList mLocalParts;
    int mCheckInterval = -1;
    int mCacheTimeout = -1;
    bool mInherit = true;
    bool mSyncOnDemand = false;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::CachePolicy &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::CachePolicy &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::CachePolicy &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::CachePolicy)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const CollectionFetchScope &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, CollectionFetchScope &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const CollectionFetchScope &obj);

using CollectionFetchScopePtr = QSharedPointer<CollectionFetchScope>;

class AKONADIPRIVATE_EXPORT CollectionFetchScope
{

public:
    enum ListFilter {
        NoFilter = 0,
        Display,
        Sync,
        Index,
        Enabled,
    };
    enum AncestorRetrieval {
        None,
        Parent,
        All,
    };
    explicit CollectionFetchScope();
    CollectionFetchScope(const CollectionFetchScope &) = default;
    CollectionFetchScope(CollectionFetchScope &&) = default;
    ~CollectionFetchScope() = default;

    CollectionFetchScope &operator=(const CollectionFetchScope &) = default;
    CollectionFetchScope &operator=(CollectionFetchScope &&) = default;
    bool operator==(const CollectionFetchScope &other) const;
    inline bool operator!=(const CollectionFetchScope &other) const { return !operator==(other); }
    inline CollectionFetchScope::ListFilter listFilter() const { return mListFilter; }
    inline void setListFilter(const CollectionFetchScope::ListFilter &listFilter) { mListFilter = listFilter; }
    inline void setListFilter(CollectionFetchScope::ListFilter &&listFilter) { mListFilter = std::move(listFilter); }

    inline bool includeStatistics() const { return mIncludeStatistics; }
    inline void setIncludeStatistics(bool includeStatistics) { mIncludeStatistics = includeStatistics; }

    inline QString resource() const { return mResource; }
    inline void setResource(const QString &resource) { mResource = resource; }
    inline void setResource(QString &&resource) { mResource = std::move(resource); }

    inline QStringList contentMimeTypes() const { return mContentMimeTypes; }
    inline void setContentMimeTypes(const QStringList &contentMimeTypes) { mContentMimeTypes = contentMimeTypes; }
    inline void setContentMimeTypes(QStringList &&contentMimeTypes) { mContentMimeTypes = std::move(contentMimeTypes); }

    inline QSet<QByteArray> attributes() const { return mAttributes; }
    inline void setAttributes(const QSet<QByteArray> &attributes) { mAttributes = attributes; }
    inline void setAttributes(QSet<QByteArray> &&attributes) { mAttributes = std::move(attributes); }

    inline bool fetchIdOnly() const { return mFetchIdOnly; }
    inline void setFetchIdOnly(bool fetchIdOnly) { mFetchIdOnly = fetchIdOnly; }

    inline CollectionFetchScope::AncestorRetrieval ancestorRetrieval() const { return mAncestorRetrieval; }
    inline void setAncestorRetrieval(const CollectionFetchScope::AncestorRetrieval &ancestorRetrieval) { mAncestorRetrieval = ancestorRetrieval; }
    inline void setAncestorRetrieval(CollectionFetchScope::AncestorRetrieval &&ancestorRetrieval) { mAncestorRetrieval = std::move(ancestorRetrieval); }

    inline bool ancestorFetchIdOnly() const { return mAncestorFetchIdOnly; }
    inline void setAncestorFetchIdOnly(bool ancestorFetchIdOnly) { mAncestorFetchIdOnly = ancestorFetchIdOnly; }

    inline QSet<QByteArray> ancestorAttributes() const { return mAncestorAttributes; }
    inline void setAncestorAttributes(const QSet<QByteArray> &ancestorAttributes) { mAncestorAttributes = ancestorAttributes; }
    inline void setAncestorAttributes(QSet<QByteArray> &&ancestorAttributes) { mAncestorAttributes = std::move(ancestorAttributes); }

    inline bool ignoreRetrievalErrors() const { return mIgnoreRetrievalErrors; }
    inline void setIgnoreRetrievalErrors(bool ignoreRetrievalErrors) { mIgnoreRetrievalErrors = ignoreRetrievalErrors; }

    void toJson(QJsonObject &stream) const;
protected:
    QString mResource;
    QStringList mContentMimeTypes;
    QSet<QByteArray> mAttributes;
    QSet<QByteArray> mAncestorAttributes;
    CollectionFetchScope::ListFilter mListFilter = Enabled;
    CollectionFetchScope::AncestorRetrieval mAncestorRetrieval = None;
    bool mIncludeStatistics = false;
    bool mFetchIdOnly = false;
    bool mAncestorFetchIdOnly = false;
    bool mIgnoreRetrievalErrors = false;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::CollectionFetchScope &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::CollectionFetchScope &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::CollectionFetchScope &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::CollectionFetchScope)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const TagFetchScope &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, TagFetchScope &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const TagFetchScope &obj);

using TagFetchScopePtr = QSharedPointer<TagFetchScope>;

class AKONADIPRIVATE_EXPORT TagFetchScope
{

public:
    explicit TagFetchScope();
    TagFetchScope(const TagFetchScope &) = default;
    TagFetchScope(TagFetchScope &&) = default;
    ~TagFetchScope() = default;

    TagFetchScope &operator=(const TagFetchScope &) = default;
    TagFetchScope &operator=(TagFetchScope &&) = default;
    bool operator==(const TagFetchScope &other) const;
    inline bool operator!=(const TagFetchScope &other) const { return !operator==(other); }
    inline bool fetchIdOnly() const { return mFetchIdOnly; }
    inline void setFetchIdOnly(bool fetchIdOnly) { mFetchIdOnly = fetchIdOnly; }

    inline bool fetchRemoteID() const { return mFetchRemoteID; }
    inline void setFetchRemoteID(bool fetchRemoteID) { mFetchRemoteID = fetchRemoteID; }

    inline bool fetchAllAttributes() const { return mFetchAllAttributes; }
    inline void setFetchAllAttributes(bool fetchAllAttributes) { mFetchAllAttributes = fetchAllAttributes; }

    inline QSet<QByteArray> attributes() const { return mAttributes; }
    inline void setAttributes(const QSet<QByteArray> &attributes) { mAttributes = attributes; }
    inline void setAttributes(QSet<QByteArray> &&attributes) { mAttributes = std::move(attributes); }

    void toJson(QJsonObject &stream) const;
protected:
    QSet<QByteArray> mAttributes;
    bool mFetchIdOnly = false;
    bool mFetchRemoteID = false;
    bool mFetchAllAttributes = true;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::TagFetchScope &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::TagFetchScope &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::TagFetchScope &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::TagFetchScope)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const HelloResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, HelloResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const HelloResponse &obj);

using HelloResponsePtr = QSharedPointer<HelloResponse>;

class AKONADIPRIVATE_EXPORT HelloResponse : public Response
{

public:
    explicit HelloResponse();
    HelloResponse(const HelloResponse &) = default;
    HelloResponse(HelloResponse &&) = default;
    ~HelloResponse() = default;

    HelloResponse &operator=(const HelloResponse &) = default;
    HelloResponse &operator=(HelloResponse &&) = default;
    bool operator==(const HelloResponse &other) const;
    inline bool operator!=(const HelloResponse &other) const { return !operator==(other); }
    inline QString serverName() const { return mServerName; }
    inline void setServerName(const QString &serverName) { mServerName = serverName; }
    inline void setServerName(QString &&serverName) { mServerName = std::move(serverName); }

    inline QString message() const { return mMessage; }
    inline void setMessage(const QString &message) { mMessage = message; }
    inline void setMessage(QString &&message) { mMessage = std::move(message); }

    inline int protocolVersion() const { return mProtocolVersion; }
    inline void setProtocolVersion(int protocolVersion) { mProtocolVersion = protocolVersion; }

    inline uint generation() const { return mGeneration; }
    inline void setGeneration(uint generation) { mGeneration = generation; }

    void toJson(QJsonObject &stream) const;
protected:
    QString mServerName;
    QString mMessage;
    int mProtocolVersion = 0;
    uint mGeneration = 0;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::HelloResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::HelloResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::HelloResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::HelloResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::HelloResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const LoginCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, LoginCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const LoginCommand &obj);

using LoginCommandPtr = QSharedPointer<LoginCommand>;

class AKONADIPRIVATE_EXPORT LoginCommand : public Command
{

public:
    explicit LoginCommand();
    explicit LoginCommand(const QByteArray &sessionId);
    LoginCommand(const LoginCommand &) = default;
    LoginCommand(LoginCommand &&) = default;
    ~LoginCommand() = default;

    LoginCommand &operator=(const LoginCommand &) = default;
    LoginCommand &operator=(LoginCommand &&) = default;
    bool operator==(const LoginCommand &other) const;
    inline bool operator!=(const LoginCommand &other) const { return !operator==(other); }
    inline QByteArray sessionId() const { return mSessionId; }
    inline void setSessionId(const QByteArray &sessionId) { mSessionId = sessionId; }
    inline void setSessionId(QByteArray &&sessionId) { mSessionId = std::move(sessionId); }

    void toJson(QJsonObject &stream) const;
protected:
    QByteArray mSessionId;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::LoginCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::LoginCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::LoginCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::LoginCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::LoginCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const LoginResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, LoginResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const LoginResponse &obj);

using LoginResponsePtr = QSharedPointer<LoginResponse>;

class AKONADIPRIVATE_EXPORT LoginResponse : public Response
{

public:
    explicit LoginResponse();
    LoginResponse(const LoginResponse &) = default;
    LoginResponse(LoginResponse &&) = default;
    ~LoginResponse() = default;

    LoginResponse &operator=(const LoginResponse &) = default;
    LoginResponse &operator=(LoginResponse &&) = default;
    bool operator==(const LoginResponse &other) const;
    inline bool operator!=(const LoginResponse &other) const { return !operator==(other); }
    void toJson(QJsonObject &stream) const;
protected:

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::LoginResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::LoginResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::LoginResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::LoginResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::LoginResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const LogoutCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, LogoutCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const LogoutCommand &obj);

using LogoutCommandPtr = QSharedPointer<LogoutCommand>;

class AKONADIPRIVATE_EXPORT LogoutCommand : public Command
{

public:
    explicit LogoutCommand();
    LogoutCommand(const LogoutCommand &) = default;
    LogoutCommand(LogoutCommand &&) = default;
    ~LogoutCommand() = default;

    LogoutCommand &operator=(const LogoutCommand &) = default;
    LogoutCommand &operator=(LogoutCommand &&) = default;
    bool operator==(const LogoutCommand &other) const;
    inline bool operator!=(const LogoutCommand &other) const { return !operator==(other); }
    void toJson(QJsonObject &stream) const;
protected:

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::LogoutCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::LogoutCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::LogoutCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::LogoutCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::LogoutCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const LogoutResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, LogoutResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const LogoutResponse &obj);

using LogoutResponsePtr = QSharedPointer<LogoutResponse>;

class AKONADIPRIVATE_EXPORT LogoutResponse : public Response
{

public:
    explicit LogoutResponse();
    LogoutResponse(const LogoutResponse &) = default;
    LogoutResponse(LogoutResponse &&) = default;
    ~LogoutResponse() = default;

    LogoutResponse &operator=(const LogoutResponse &) = default;
    LogoutResponse &operator=(LogoutResponse &&) = default;
    bool operator==(const LogoutResponse &other) const;
    inline bool operator!=(const LogoutResponse &other) const { return !operator==(other); }
    void toJson(QJsonObject &stream) const;
protected:

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::LogoutResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::LogoutResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::LogoutResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::LogoutResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::LogoutResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const TransactionCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, TransactionCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const TransactionCommand &obj);

using TransactionCommandPtr = QSharedPointer<TransactionCommand>;

class AKONADIPRIVATE_EXPORT TransactionCommand : public Command
{

public:
    enum Mode {
        Invalid = 0,
        Begin,
        Commit,
        Rollback,
    };
    explicit TransactionCommand();
    explicit TransactionCommand(const TransactionCommand::Mode &mode);
    TransactionCommand(const TransactionCommand &) = default;
    TransactionCommand(TransactionCommand &&) = default;
    ~TransactionCommand() = default;

    TransactionCommand &operator=(const TransactionCommand &) = default;
    TransactionCommand &operator=(TransactionCommand &&) = default;
    bool operator==(const TransactionCommand &other) const;
    inline bool operator!=(const TransactionCommand &other) const { return !operator==(other); }
    inline TransactionCommand::Mode mode() const { return mMode; }
    inline void setMode(const TransactionCommand::Mode &mode) { mMode = mode; }
    inline void setMode(TransactionCommand::Mode &&mode) { mMode = std::move(mode); }

    void toJson(QJsonObject &stream) const;
protected:
    TransactionCommand::Mode mMode = Invalid;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::TransactionCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::TransactionCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::TransactionCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::TransactionCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::TransactionCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const TransactionResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, TransactionResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const TransactionResponse &obj);

using TransactionResponsePtr = QSharedPointer<TransactionResponse>;

class AKONADIPRIVATE_EXPORT TransactionResponse : public Response
{

public:
    explicit TransactionResponse();
    TransactionResponse(const TransactionResponse &) = default;
    TransactionResponse(TransactionResponse &&) = default;
    ~TransactionResponse() = default;

    TransactionResponse &operator=(const TransactionResponse &) = default;
    TransactionResponse &operator=(TransactionResponse &&) = default;
    bool operator==(const TransactionResponse &other) const;
    inline bool operator!=(const TransactionResponse &other) const { return !operator==(other); }
    void toJson(QJsonObject &stream) const;
protected:

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::TransactionResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::TransactionResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::TransactionResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::TransactionResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::TransactionResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const CreateItemCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, CreateItemCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const CreateItemCommand &obj);

using CreateItemCommandPtr = QSharedPointer<CreateItemCommand>;

class AKONADIPRIVATE_EXPORT CreateItemCommand : public Command
{

public:
    enum MergeMode {
        None = 0,
        GID = 1,
        RemoteID = 2,
        Silent = 4,
    };
    Q_DECLARE_FLAGS(MergeModes, MergeMode)

    explicit CreateItemCommand();
    CreateItemCommand(const CreateItemCommand &) = default;
    CreateItemCommand(CreateItemCommand &&) = default;
    ~CreateItemCommand() = default;

    CreateItemCommand &operator=(const CreateItemCommand &) = default;
    CreateItemCommand &operator=(CreateItemCommand &&) = default;
    bool operator==(const CreateItemCommand &other) const;
    inline bool operator!=(const CreateItemCommand &other) const { return !operator==(other); }
    inline CreateItemCommand::MergeModes mergeModes() const { return mMergeModes; }
    inline void setMergeModes(const CreateItemCommand::MergeModes &mergeModes) { mMergeModes = mergeModes; }
    inline void setMergeModes(CreateItemCommand::MergeModes &&mergeModes) { mMergeModes = std::move(mergeModes); }

    inline Scope collection() const { return mCollection; }
    inline void setCollection(const Scope &collection) { mCollection = collection; }
    inline void setCollection(Scope &&collection) { mCollection = std::move(collection); }

    inline qint64 itemSize() const { return mItemSize; }
    inline void setItemSize(qint64 itemSize) { mItemSize = itemSize; }

    inline QString mimeType() const { return mMimeType; }
    inline void setMimeType(const QString &mimeType) { mMimeType = mimeType; }
    inline void setMimeType(QString &&mimeType) { mMimeType = std::move(mimeType); }

    inline QString gid() const { return mGid; }
    inline void setGid(const QString &gid) { mGid = gid; }
    inline void setGid(QString &&gid) { mGid = std::move(gid); }

    inline QString remoteId() const { return mRemoteId; }
    inline void setRemoteId(const QString &remoteId) { mRemoteId = remoteId; }
    inline void setRemoteId(QString &&remoteId) { mRemoteId = std::move(remoteId); }

    inline QString remoteRevision() const { return mRemoteRevision; }
    inline void setRemoteRevision(const QString &remoteRevision) { mRemoteRevision = remoteRevision; }
    inline void setRemoteRevision(QString &&remoteRevision) { mRemoteRevision = std::move(remoteRevision); }

    inline QDateTime dateTime() const { return mDateTime; }
    inline void setDateTime(const QDateTime &dateTime) { mDateTime = dateTime; }
    inline void setDateTime(QDateTime &&dateTime) { mDateTime = std::move(dateTime); }

    inline QSet<QByteArray> flags() const { return mFlags; }
    inline void setFlags(const QSet<QByteArray> &flags) { mFlags = flags; }
    inline void setFlags(QSet<QByteArray> &&flags) { mFlags = std::move(flags); }

    inline QSet<QByteArray> addedFlags() const { return mAddedFlags; }
    inline void setAddedFlags(const QSet<QByteArray> &addedFlags) { mAddedFlags = addedFlags; }
    inline void setAddedFlags(QSet<QByteArray> &&addedFlags) { mAddedFlags = std::move(addedFlags); }

    inline QSet<QByteArray> removedFlags() const { return mRemovedFlags; }
    inline void setRemovedFlags(const QSet<QByteArray> &removedFlags) { mRemovedFlags = removedFlags; }
    inline void setRemovedFlags(QSet<QByteArray> &&removedFlags) { mRemovedFlags = std::move(removedFlags); }

    inline Scope tags() const { return mTags; }
    inline void setTags(const Scope &tags) { mTags = tags; }
    inline void setTags(Scope &&tags) { mTags = std::move(tags); }

    inline Scope addedTags() const { return mAddedTags; }
    inline void setAddedTags(const Scope &addedTags) { mAddedTags = addedTags; }
    inline void setAddedTags(Scope &&addedTags) { mAddedTags = std::move(addedTags); }

    inline Scope removedTags() const { return mRemovedTags; }
    inline void setRemovedTags(const Scope &removedTags) { mRemovedTags = removedTags; }
    inline void setRemovedTags(Scope &&removedTags) { mRemovedTags = std::move(removedTags); }

    inline Akonadi::Protocol::Attributes attributes() const { return mAttributes; }
    inline void setAttributes(const Akonadi::Protocol::Attributes &attributes) { mAttributes = attributes; }
    inline void setAttributes(Akonadi::Protocol::Attributes &&attributes) { mAttributes = std::move(attributes); }

    inline QSet<QByteArray> parts() const { return mParts; }
    inline void setParts(const QSet<QByteArray> &parts) { mParts = parts; }
    inline void setParts(QSet<QByteArray> &&parts) { mParts = std::move(parts); }

    inline bool flagsOverwritten() const { return mFlagsOverwritten; }
    inline void setFlagsOverwritten(bool flagsOverwritten) { mFlagsOverwritten = flagsOverwritten; }

    void toJson(QJsonObject &stream) const;
protected:
    Scope mCollection;
    QSet<QByteArray> mParts;
    Akonadi::Protocol::Attributes mAttributes;
    Scope mRemovedTags;
    Scope mAddedTags;
    Scope mTags;
    QSet<QByteArray> mRemovedFlags;
    QSet<QByteArray> mAddedFlags;
    QSet<QByteArray> mFlags;
    QDateTime mDateTime;
    QString mRemoteRevision;
    QString mRemoteId;
    QString mGid;
    QString mMimeType;
    qint64 mItemSize = 0;
    CreateItemCommand::MergeModes mMergeModes = None;
    bool mFlagsOverwritten = false;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::CreateItemCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::CreateItemCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::CreateItemCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::CreateItemCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::CreateItemCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const CreateItemResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, CreateItemResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const CreateItemResponse &obj);

using CreateItemResponsePtr = QSharedPointer<CreateItemResponse>;

class AKONADIPRIVATE_EXPORT CreateItemResponse : public Response
{

public:
    explicit CreateItemResponse();
    CreateItemResponse(const CreateItemResponse &) = default;
    CreateItemResponse(CreateItemResponse &&) = default;
    ~CreateItemResponse() = default;

    CreateItemResponse &operator=(const CreateItemResponse &) = default;
    CreateItemResponse &operator=(CreateItemResponse &&) = default;
    bool operator==(const CreateItemResponse &other) const;
    inline bool operator!=(const CreateItemResponse &other) const { return !operator==(other); }
    void toJson(QJsonObject &stream) const;
protected:

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::CreateItemResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::CreateItemResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::CreateItemResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::CreateItemResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::CreateItemResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const CopyItemsCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, CopyItemsCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const CopyItemsCommand &obj);

using CopyItemsCommandPtr = QSharedPointer<CopyItemsCommand>;

class AKONADIPRIVATE_EXPORT CopyItemsCommand : public Command
{

public:
    explicit CopyItemsCommand();
    explicit CopyItemsCommand(const Scope &items, const Scope &destination);
    CopyItemsCommand(const CopyItemsCommand &) = default;
    CopyItemsCommand(CopyItemsCommand &&) = default;
    ~CopyItemsCommand() = default;

    CopyItemsCommand &operator=(const CopyItemsCommand &) = default;
    CopyItemsCommand &operator=(CopyItemsCommand &&) = default;
    bool operator==(const CopyItemsCommand &other) const;
    inline bool operator!=(const CopyItemsCommand &other) const { return !operator==(other); }
    inline Scope items() const { return mItems; }
    inline void setItems(const Scope &items) { mItems = items; }
    inline void setItems(Scope &&items) { mItems = std::move(items); }

    inline Scope destination() const { return mDestination; }
    inline void setDestination(const Scope &destination) { mDestination = destination; }
    inline void setDestination(Scope &&destination) { mDestination = std::move(destination); }

    void toJson(QJsonObject &stream) const;
protected:
    Scope mItems;
    Scope mDestination;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::CopyItemsCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::CopyItemsCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::CopyItemsCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::CopyItemsCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::CopyItemsCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const CopyItemsResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, CopyItemsResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const CopyItemsResponse &obj);

using CopyItemsResponsePtr = QSharedPointer<CopyItemsResponse>;

class AKONADIPRIVATE_EXPORT CopyItemsResponse : public Response
{

public:
    explicit CopyItemsResponse();
    CopyItemsResponse(const CopyItemsResponse &) = default;
    CopyItemsResponse(CopyItemsResponse &&) = default;
    ~CopyItemsResponse() = default;

    CopyItemsResponse &operator=(const CopyItemsResponse &) = default;
    CopyItemsResponse &operator=(CopyItemsResponse &&) = default;
    bool operator==(const CopyItemsResponse &other) const;
    inline bool operator!=(const CopyItemsResponse &other) const { return !operator==(other); }
    void toJson(QJsonObject &stream) const;
protected:

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::CopyItemsResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::CopyItemsResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::CopyItemsResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::CopyItemsResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::CopyItemsResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const DeleteItemsCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, DeleteItemsCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const DeleteItemsCommand &obj);

using DeleteItemsCommandPtr = QSharedPointer<DeleteItemsCommand>;

class AKONADIPRIVATE_EXPORT DeleteItemsCommand : public Command
{

public:
    explicit DeleteItemsCommand();
    explicit DeleteItemsCommand(const Scope &items, const Akonadi::Protocol::ScopeContext &scopeContext = ScopeContext());
    DeleteItemsCommand(const DeleteItemsCommand &) = default;
    DeleteItemsCommand(DeleteItemsCommand &&) = default;
    ~DeleteItemsCommand() = default;

    DeleteItemsCommand &operator=(const DeleteItemsCommand &) = default;
    DeleteItemsCommand &operator=(DeleteItemsCommand &&) = default;
    bool operator==(const DeleteItemsCommand &other) const;
    inline bool operator!=(const DeleteItemsCommand &other) const { return !operator==(other); }
    inline Scope items() const { return mItems; }
    inline void setItems(const Scope &items) { mItems = items; }
    inline void setItems(Scope &&items) { mItems = std::move(items); }

    inline Akonadi::Protocol::ScopeContext scopeContext() const { return mScopeContext; }
    inline void setScopeContext(const Akonadi::Protocol::ScopeContext &scopeContext) { mScopeContext = scopeContext; }
    inline void setScopeContext(Akonadi::Protocol::ScopeContext &&scopeContext) { mScopeContext = std::move(scopeContext); }

    void toJson(QJsonObject &stream) const;
protected:
    Scope mItems;
    Akonadi::Protocol::ScopeContext mScopeContext;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::DeleteItemsCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::DeleteItemsCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::DeleteItemsCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::DeleteItemsCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::DeleteItemsCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const DeleteItemsResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, DeleteItemsResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const DeleteItemsResponse &obj);

using DeleteItemsResponsePtr = QSharedPointer<DeleteItemsResponse>;

class AKONADIPRIVATE_EXPORT DeleteItemsResponse : public Response
{

public:
    explicit DeleteItemsResponse();
    DeleteItemsResponse(const DeleteItemsResponse &) = default;
    DeleteItemsResponse(DeleteItemsResponse &&) = default;
    ~DeleteItemsResponse() = default;

    DeleteItemsResponse &operator=(const DeleteItemsResponse &) = default;
    DeleteItemsResponse &operator=(DeleteItemsResponse &&) = default;
    bool operator==(const DeleteItemsResponse &other) const;
    inline bool operator!=(const DeleteItemsResponse &other) const { return !operator==(other); }
    void toJson(QJsonObject &stream) const;
protected:

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::DeleteItemsResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::DeleteItemsResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::DeleteItemsResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::DeleteItemsResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::DeleteItemsResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const FetchRelationsCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, FetchRelationsCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const FetchRelationsCommand &obj);

using FetchRelationsCommandPtr = QSharedPointer<FetchRelationsCommand>;

class AKONADIPRIVATE_EXPORT FetchRelationsCommand : public Command
{

public:
    explicit FetchRelationsCommand();
    explicit FetchRelationsCommand(qint64 left, qint64 right, const QVector<QByteArray> &types = QVector<QByteArray>(), const QString &resource = QString());
    explicit FetchRelationsCommand(qint64 side, const QVector<QByteArray> &types = QVector<QByteArray>(), const QString &resource = QString());
    FetchRelationsCommand(const FetchRelationsCommand &) = default;
    FetchRelationsCommand(FetchRelationsCommand &&) = default;
    ~FetchRelationsCommand() = default;

    FetchRelationsCommand &operator=(const FetchRelationsCommand &) = default;
    FetchRelationsCommand &operator=(FetchRelationsCommand &&) = default;
    bool operator==(const FetchRelationsCommand &other) const;
    inline bool operator!=(const FetchRelationsCommand &other) const { return !operator==(other); }
    inline qint64 left() const { return mLeft; }
    inline void setLeft(qint64 left) { mLeft = left; }

    inline qint64 right() const { return mRight; }
    inline void setRight(qint64 right) { mRight = right; }

    inline qint64 side() const { return mSide; }
    inline void setSide(qint64 side) { mSide = side; }

    inline QVector<QByteArray> types() const { return mTypes; }
    inline void setTypes(const QVector<QByteArray> &types) { mTypes = types; }
    inline void setTypes(QVector<QByteArray> &&types) { mTypes = std::move(types); }

    inline QString resource() const { return mResource; }
    inline void setResource(const QString &resource) { mResource = resource; }
    inline void setResource(QString &&resource) { mResource = std::move(resource); }

    void toJson(QJsonObject &stream) const;
protected:
    qint64 mLeft = -1;
    qint64 mRight = -1;
    qint64 mSide = -1;
    QVector<QByteArray> mTypes;
    QString mResource;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::FetchRelationsCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::FetchRelationsCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::FetchRelationsCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::FetchRelationsCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::FetchRelationsCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const FetchRelationsResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, FetchRelationsResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const FetchRelationsResponse &obj);

using FetchRelationsResponsePtr = QSharedPointer<FetchRelationsResponse>;

class AKONADIPRIVATE_EXPORT FetchRelationsResponse : public Response
{

public:
    explicit FetchRelationsResponse();
    explicit FetchRelationsResponse(qint64 left, const QByteArray &leftMimeType, qint64 right, const QByteArray &rightMimeType, const QByteArray &type, const QByteArray &remoteId = QByteArray());
    FetchRelationsResponse(const FetchRelationsResponse &) = default;
    FetchRelationsResponse(FetchRelationsResponse &&) = default;
    ~FetchRelationsResponse() = default;

    FetchRelationsResponse &operator=(const FetchRelationsResponse &) = default;
    FetchRelationsResponse &operator=(FetchRelationsResponse &&) = default;
    bool operator==(const FetchRelationsResponse &other) const;
    inline bool operator!=(const FetchRelationsResponse &other) const { return !operator==(other); }
    inline qint64 left() const { return mLeft; }
    inline void setLeft(qint64 left) { mLeft = left; }

    inline QByteArray leftMimeType() const { return mLeftMimeType; }
    inline void setLeftMimeType(const QByteArray &leftMimeType) { mLeftMimeType = leftMimeType; }
    inline void setLeftMimeType(QByteArray &&leftMimeType) { mLeftMimeType = std::move(leftMimeType); }

    inline qint64 right() const { return mRight; }
    inline void setRight(qint64 right) { mRight = right; }

    inline QByteArray rightMimeType() const { return mRightMimeType; }
    inline void setRightMimeType(const QByteArray &rightMimeType) { mRightMimeType = rightMimeType; }
    inline void setRightMimeType(QByteArray &&rightMimeType) { mRightMimeType = std::move(rightMimeType); }

    inline QByteArray type() const { return mType; }
    inline void setType(const QByteArray &type) { mType = type; }
    inline void setType(QByteArray &&type) { mType = std::move(type); }

    inline QByteArray remoteId() const { return mRemoteId; }
    inline void setRemoteId(const QByteArray &remoteId) { mRemoteId = remoteId; }
    inline void setRemoteId(QByteArray &&remoteId) { mRemoteId = std::move(remoteId); }

    void toJson(QJsonObject &stream) const;
protected:
    qint64 mLeft = -1;
    QByteArray mLeftMimeType;
    qint64 mRight = -1;
    QByteArray mRightMimeType;
    QByteArray mType;
    QByteArray mRemoteId;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::FetchRelationsResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::FetchRelationsResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::FetchRelationsResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::FetchRelationsResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::FetchRelationsResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const FetchTagsCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, FetchTagsCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const FetchTagsCommand &obj);

using FetchTagsCommandPtr = QSharedPointer<FetchTagsCommand>;

class AKONADIPRIVATE_EXPORT FetchTagsCommand : public Command
{

public:
    explicit FetchTagsCommand();
    explicit FetchTagsCommand(const Scope &scope);
    FetchTagsCommand(const FetchTagsCommand &) = default;
    FetchTagsCommand(FetchTagsCommand &&) = default;
    ~FetchTagsCommand() = default;

    FetchTagsCommand &operator=(const FetchTagsCommand &) = default;
    FetchTagsCommand &operator=(FetchTagsCommand &&) = default;
    bool operator==(const FetchTagsCommand &other) const;
    inline bool operator!=(const FetchTagsCommand &other) const { return !operator==(other); }
    inline Scope scope() const { return mScope; }
    inline void setScope(const Scope &scope) { mScope = scope; }
    inline void setScope(Scope &&scope) { mScope = std::move(scope); }

    inline Akonadi::Protocol::TagFetchScope fetchScope() const { return mFetchScope; }
    inline void setFetchScope(const Akonadi::Protocol::TagFetchScope &fetchScope) { mFetchScope = fetchScope; }
    inline void setFetchScope(Akonadi::Protocol::TagFetchScope &&fetchScope) { mFetchScope = std::move(fetchScope); }

    void toJson(QJsonObject &stream) const;
protected:
    Scope mScope;
    Akonadi::Protocol::TagFetchScope mFetchScope;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::FetchTagsCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::FetchTagsCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::FetchTagsCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::FetchTagsCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::FetchTagsCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const FetchTagsResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, FetchTagsResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const FetchTagsResponse &obj);

using FetchTagsResponsePtr = QSharedPointer<FetchTagsResponse>;

class AKONADIPRIVATE_EXPORT FetchTagsResponse : public Response
{

public:
    explicit FetchTagsResponse();
    explicit FetchTagsResponse(qint64 id);
    explicit FetchTagsResponse(qint64 id, const QByteArray &gid, const QByteArray &type, const QByteArray &remoteId = QByteArray(), qint64 parentId = -1, const Akonadi::Protocol::Attributes &attributes = Attributes());
    FetchTagsResponse(const FetchTagsResponse &) = default;
    FetchTagsResponse(FetchTagsResponse &&) = default;
    ~FetchTagsResponse() = default;

    FetchTagsResponse &operator=(const FetchTagsResponse &) = default;
    FetchTagsResponse &operator=(FetchTagsResponse &&) = default;
    bool operator==(const FetchTagsResponse &other) const;
    inline bool operator!=(const FetchTagsResponse &other) const { return !operator==(other); }
    inline qint64 id() const { return mId; }
    inline void setId(qint64 id) { mId = id; }

    inline qint64 parentId() const { return mParentId; }
    inline void setParentId(qint64 parentId) { mParentId = parentId; }

    inline QByteArray gid() const { return mGid; }
    inline void setGid(const QByteArray &gid) { mGid = gid; }
    inline void setGid(QByteArray &&gid) { mGid = std::move(gid); }

    inline QByteArray type() const { return mType; }
    inline void setType(const QByteArray &type) { mType = type; }
    inline void setType(QByteArray &&type) { mType = std::move(type); }

    inline QByteArray remoteId() const { return mRemoteId; }
    inline void setRemoteId(const QByteArray &remoteId) { mRemoteId = remoteId; }
    inline void setRemoteId(QByteArray &&remoteId) { mRemoteId = std::move(remoteId); }

    inline Akonadi::Protocol::Attributes attributes() const { return mAttributes; }
    inline void setAttributes(const Akonadi::Protocol::Attributes &attributes) { mAttributes = attributes; }
    inline void setAttributes(Akonadi::Protocol::Attributes &&attributes) { mAttributes = std::move(attributes); }

    void toJson(QJsonObject &stream) const;
protected:
    qint64 mId = -1;
    qint64 mParentId = -1;
    QByteArray mGid;
    QByteArray mType;
    QByteArray mRemoteId;
    Akonadi::Protocol::Attributes mAttributes;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::FetchTagsResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::FetchTagsResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::FetchTagsResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::FetchTagsResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::FetchTagsResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const FetchItemsCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, FetchItemsCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const FetchItemsCommand &obj);

using FetchItemsCommandPtr = QSharedPointer<FetchItemsCommand>;

class AKONADIPRIVATE_EXPORT FetchItemsCommand : public Command
{

public:
    explicit FetchItemsCommand();
    explicit FetchItemsCommand(const Scope &scope, const Akonadi::Protocol::ScopeContext &scopeContext = ScopeContext(), const Akonadi::Protocol::ItemFetchScope &itemFetchScope = ItemFetchScope(), const Akonadi::Protocol::TagFetchScope &tagFetchScope = TagFetchScope());
    FetchItemsCommand(const FetchItemsCommand &) = default;
    FetchItemsCommand(FetchItemsCommand &&) = default;
    ~FetchItemsCommand() = default;

    FetchItemsCommand &operator=(const FetchItemsCommand &) = default;
    FetchItemsCommand &operator=(FetchItemsCommand &&) = default;
    bool operator==(const FetchItemsCommand &other) const;
    inline bool operator!=(const FetchItemsCommand &other) const { return !operator==(other); }
    inline Scope scope() const { return mScope; }
    inline void setScope(const Scope &scope) { mScope = scope; }
    inline void setScope(Scope &&scope) { mScope = std::move(scope); }

    inline Akonadi::Protocol::ScopeContext scopeContext() const { return mScopeContext; }
    inline void setScopeContext(const Akonadi::Protocol::ScopeContext &scopeContext) { mScopeContext = scopeContext; }
    inline void setScopeContext(Akonadi::Protocol::ScopeContext &&scopeContext) { mScopeContext = std::move(scopeContext); }

    inline Akonadi::Protocol::ItemFetchScope itemFetchScope() const { return mItemFetchScope; }
    inline void setItemFetchScope(const Akonadi::Protocol::ItemFetchScope &itemFetchScope) { mItemFetchScope = itemFetchScope; }
    inline void setItemFetchScope(Akonadi::Protocol::ItemFetchScope &&itemFetchScope) { mItemFetchScope = std::move(itemFetchScope); }

    inline Akonadi::Protocol::TagFetchScope tagFetchScope() const { return mTagFetchScope; }
    inline void setTagFetchScope(const Akonadi::Protocol::TagFetchScope &tagFetchScope) { mTagFetchScope = tagFetchScope; }
    inline void setTagFetchScope(Akonadi::Protocol::TagFetchScope &&tagFetchScope) { mTagFetchScope = std::move(tagFetchScope); }

    void toJson(QJsonObject &stream) const;
protected:
    Scope mScope;
    Akonadi::Protocol::ScopeContext mScopeContext;
    Akonadi::Protocol::ItemFetchScope mItemFetchScope;
    Akonadi::Protocol::TagFetchScope mTagFetchScope;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::FetchItemsCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::FetchItemsCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::FetchItemsCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::FetchItemsCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::FetchItemsCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const FetchItemsResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, FetchItemsResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const FetchItemsResponse &obj);

using FetchItemsResponsePtr = QSharedPointer<FetchItemsResponse>;

class AKONADIPRIVATE_EXPORT FetchItemsResponse : public Response
{

public:
    explicit FetchItemsResponse();
    explicit FetchItemsResponse(qint64 id);
    FetchItemsResponse(const FetchItemsResponse &) = default;
    FetchItemsResponse(FetchItemsResponse &&) = default;
    ~FetchItemsResponse() = default;

    FetchItemsResponse &operator=(const FetchItemsResponse &) = default;
    FetchItemsResponse &operator=(FetchItemsResponse &&) = default;
    bool operator==(const FetchItemsResponse &other) const;
    inline bool operator!=(const FetchItemsResponse &other) const { return !operator==(other); }
    inline qint64 id() const { return mId; }
    inline void setId(qint64 id) { mId = id; }

    inline int revision() const { return mRevision; }
    inline void setRevision(int revision) { mRevision = revision; }

    inline qint64 parentId() const { return mParentId; }
    inline void setParentId(qint64 parentId) { mParentId = parentId; }

    inline QString remoteId() const { return mRemoteId; }
    inline void setRemoteId(const QString &remoteId) { mRemoteId = remoteId; }
    inline void setRemoteId(QString &&remoteId) { mRemoteId = std::move(remoteId); }

    inline QString remoteRevision() const { return mRemoteRevision; }
    inline void setRemoteRevision(const QString &remoteRevision) { mRemoteRevision = remoteRevision; }
    inline void setRemoteRevision(QString &&remoteRevision) { mRemoteRevision = std::move(remoteRevision); }

    inline QString gid() const { return mGid; }
    inline void setGid(const QString &gid) { mGid = gid; }
    inline void setGid(QString &&gid) { mGid = std::move(gid); }

    inline qint64 size() const { return mSize; }
    inline void setSize(qint64 size) { mSize = size; }

    inline QString mimeType() const { return mMimeType; }
    inline void setMimeType(const QString &mimeType) { mMimeType = mimeType; }
    inline void setMimeType(QString &&mimeType) { mMimeType = std::move(mimeType); }

    inline QDateTime mTime() const { return mMTime; }
    inline void setMTime(const QDateTime &mTime) { mMTime = mTime; }
    inline void setMTime(QDateTime &&mTime) { mMTime = std::move(mTime); }

    inline QVector<QByteArray> flags() const { return mFlags; }
    inline void setFlags(const QVector<QByteArray> &flags) { mFlags = flags; }
    inline void setFlags(QVector<QByteArray> &&flags) { mFlags = std::move(flags); }

    inline QVector<Akonadi::Protocol::FetchTagsResponse> tags() const { return mTags; }
    inline void setTags(const QVector<Akonadi::Protocol::FetchTagsResponse> &tags) { mTags = tags; }
    inline void setTags(QVector<Akonadi::Protocol::FetchTagsResponse> &&tags) { mTags = std::move(tags); }

    inline QVector<qint64> virtualReferences() const { return mVirtualReferences; }
    inline void setVirtualReferences(const QVector<qint64> &virtualReferences) { mVirtualReferences = virtualReferences; }
    inline void setVirtualReferences(QVector<qint64> &&virtualReferences) { mVirtualReferences = std::move(virtualReferences); }

    inline QVector<Akonadi::Protocol::FetchRelationsResponse> relations() const { return mRelations; }
    inline void setRelations(const QVector<Akonadi::Protocol::FetchRelationsResponse> &relations) { mRelations = relations; }
    inline void setRelations(QVector<Akonadi::Protocol::FetchRelationsResponse> &&relations) { mRelations = std::move(relations); }

    inline QVector<Akonadi::Protocol::Ancestor> ancestors() const { return mAncestors; }
    inline void setAncestors(const QVector<Akonadi::Protocol::Ancestor> &ancestors) { mAncestors = ancestors; }
    inline void setAncestors(QVector<Akonadi::Protocol::Ancestor> &&ancestors) { mAncestors = std::move(ancestors); }

    inline QVector<Akonadi::Protocol::StreamPayloadResponse> parts() const { return mParts; }
    inline void setParts(const QVector<Akonadi::Protocol::StreamPayloadResponse> &parts) { mParts = parts; }
    inline void setParts(QVector<Akonadi::Protocol::StreamPayloadResponse> &&parts) { mParts = std::move(parts); }

    inline QVector<QByteArray> cachedParts() const { return mCachedParts; }
    inline void setCachedParts(const QVector<QByteArray> &cachedParts) { mCachedParts = cachedParts; }
    inline void setCachedParts(QVector<QByteArray> &&cachedParts) { mCachedParts = std::move(cachedParts); }

    void toJson(QJsonObject &stream) const;
protected:
    qint64 mId = -1;
    qint64 mParentId = -1;
    QString mRemoteId;
    QString mRemoteRevision;
    QString mGid;
    qint64 mSize = 0;
    QString mMimeType;
    QDateTime mMTime;
    QVector<QByteArray> mFlags;
    QVector<Akonadi::Protocol::FetchTagsResponse> mTags;
    QVector<qint64> mVirtualReferences;
    QVector<Akonadi::Protocol::FetchRelationsResponse> mRelations;
    QVector<Akonadi::Protocol::Ancestor> mAncestors;
    QVector<Akonadi::Protocol::StreamPayloadResponse> mParts;
    QVector<QByteArray> mCachedParts;
    int mRevision = -1;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::FetchItemsResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::FetchItemsResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::FetchItemsResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::FetchItemsResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::FetchItemsResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const LinkItemsCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, LinkItemsCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const LinkItemsCommand &obj);

using LinkItemsCommandPtr = QSharedPointer<LinkItemsCommand>;

class AKONADIPRIVATE_EXPORT LinkItemsCommand : public Command
{

public:
    enum Action {
        Link,
        Unlink,
    };
    explicit LinkItemsCommand();
    explicit LinkItemsCommand(const LinkItemsCommand::Action &action, const Scope &items, const Scope &destination);
    LinkItemsCommand(const LinkItemsCommand &) = default;
    LinkItemsCommand(LinkItemsCommand &&) = default;
    ~LinkItemsCommand() = default;

    LinkItemsCommand &operator=(const LinkItemsCommand &) = default;
    LinkItemsCommand &operator=(LinkItemsCommand &&) = default;
    bool operator==(const LinkItemsCommand &other) const;
    inline bool operator!=(const LinkItemsCommand &other) const { return !operator==(other); }
    inline Scope items() const { return mItems; }
    inline void setItems(const Scope &items) { mItems = items; }
    inline void setItems(Scope &&items) { mItems = std::move(items); }

    inline Scope destination() const { return mDestination; }
    inline void setDestination(const Scope &destination) { mDestination = destination; }
    inline void setDestination(Scope &&destination) { mDestination = std::move(destination); }

    inline LinkItemsCommand::Action action() const { return mAction; }
    inline void setAction(const LinkItemsCommand::Action &action) { mAction = action; }
    inline void setAction(LinkItemsCommand::Action &&action) { mAction = std::move(action); }

    void toJson(QJsonObject &stream) const;
protected:
    Scope mItems;
    Scope mDestination;
    LinkItemsCommand::Action mAction = Link;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::LinkItemsCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::LinkItemsCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::LinkItemsCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::LinkItemsCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::LinkItemsCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const LinkItemsResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, LinkItemsResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const LinkItemsResponse &obj);

using LinkItemsResponsePtr = QSharedPointer<LinkItemsResponse>;

class AKONADIPRIVATE_EXPORT LinkItemsResponse : public Response
{

public:
    explicit LinkItemsResponse();
    LinkItemsResponse(const LinkItemsResponse &) = default;
    LinkItemsResponse(LinkItemsResponse &&) = default;
    ~LinkItemsResponse() = default;

    LinkItemsResponse &operator=(const LinkItemsResponse &) = default;
    LinkItemsResponse &operator=(LinkItemsResponse &&) = default;
    bool operator==(const LinkItemsResponse &other) const;
    inline bool operator!=(const LinkItemsResponse &other) const { return !operator==(other); }
    void toJson(QJsonObject &stream) const;
protected:

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::LinkItemsResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::LinkItemsResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::LinkItemsResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::LinkItemsResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::LinkItemsResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const ModifyItemsCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, ModifyItemsCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const ModifyItemsCommand &obj);

using ModifyItemsCommandPtr = QSharedPointer<ModifyItemsCommand>;

class AKONADIPRIVATE_EXPORT ModifyItemsCommand : public Command
{

public:
    enum ModifiedPart {
        None = 0,
        Flags = 1,
        AddedFlags = 2,
        RemovedFlags = 4,
        Tags = 8,
        AddedTags = 16,
        RemovedTags = 32,
        RemoteID = 64,
        RemoteRevision = 128,
        GID = 256,
        Size = 512,
        Parts = 1024,
        RemovedParts = 2048,
        Attributes = 4096,
    };
    Q_DECLARE_FLAGS(ModifiedParts, ModifiedPart)

    explicit ModifyItemsCommand();
    explicit ModifyItemsCommand(const Scope &items);
    ModifyItemsCommand(const ModifyItemsCommand &) = default;
    ModifyItemsCommand(ModifyItemsCommand &&) = default;
    ~ModifyItemsCommand() = default;

    ModifyItemsCommand &operator=(const ModifyItemsCommand &) = default;
    ModifyItemsCommand &operator=(ModifyItemsCommand &&) = default;
    bool operator==(const ModifyItemsCommand &other) const;
    inline bool operator!=(const ModifyItemsCommand &other) const { return !operator==(other); }
    inline ModifyItemsCommand::ModifiedParts modifiedParts() const { return mModifiedParts; }
    inline void setModifiedParts(const ModifyItemsCommand::ModifiedParts &modifiedParts) { mModifiedParts = modifiedParts; }
    inline void setModifiedParts(ModifyItemsCommand::ModifiedParts &&modifiedParts) { mModifiedParts = std::move(modifiedParts); }

    inline Scope items() const { return mItems; }
    inline void setItems(const Scope &items) { mItems = items; }
    inline void setItems(Scope &&items) { mItems = std::move(items); }

    inline int oldRevision() const { return mOldRevision; }
    inline void setOldRevision(int oldRevision) { mOldRevision = oldRevision; }

    inline QSet<QByteArray> flags() const { return mFlags; }
    void setFlags(const QSet<QByteArray> &flags);

    inline QSet<QByteArray> addedFlags() const { return mAddedFlags; }
    void setAddedFlags(const QSet<QByteArray> &addedFlags);

    inline QSet<QByteArray> removedFlags() const { return mRemovedFlags; }
    void setRemovedFlags(const QSet<QByteArray> &removedFlags);

    inline Scope tags() const { return mTags; }
    void setTags(const Scope &tags);

    inline Scope addedTags() const { return mAddedTags; }
    void setAddedTags(const Scope &addedTags);

    inline Scope removedTags() const { return mRemovedTags; }
    void setRemovedTags(const Scope &removedTags);

    inline QString remoteId() const { return mRemoteId; }
    void setRemoteId(const QString &remoteId);

    inline QString gid() const { return mGid; }
    void setGid(const QString &gid);

    inline QString remoteRevision() const { return mRemoteRevision; }
    void setRemoteRevision(const QString &remoteRevision);

    inline bool dirty() const { return mDirty; }
    inline void setDirty(bool dirty) { mDirty = dirty; }

    inline bool invalidateCache() const { return mInvalidateCache; }
    inline void setInvalidateCache(bool invalidateCache) { mInvalidateCache = invalidateCache; }

    inline bool noResponse() const { return mNoResponse; }
    inline void setNoResponse(bool noResponse) { mNoResponse = noResponse; }

    inline bool notify() const { return mNotify; }
    inline void setNotify(bool notify) { mNotify = notify; }

    inline qint64 itemSize() const { return mItemSize; }
    void setItemSize(qint64 itemSize);

    inline QSet<QByteArray> removedParts() const { return mRemovedParts; }
    void setRemovedParts(const QSet<QByteArray> &removedParts);

    inline QSet<QByteArray> parts() const { return mParts; }
    void setParts(const QSet<QByteArray> &parts);

    inline Akonadi::Protocol::Attributes attributes() const { return mAttributes; }
    void setAttributes(const Akonadi::Protocol::Attributes &attributes);

    void toJson(QJsonObject &stream) const;
protected:
    QString mGid;
    Akonadi::Protocol::Attributes mAttributes;
    QSet<QByteArray> mParts;
    QSet<QByteArray> mRemovedParts;
    qint64 mItemSize = 0;
    QString mRemoteRevision;
    QString mRemoteId;
    Scope mRemovedTags;
    Scope mAddedTags;
    Scope mTags;
    QSet<QByteArray> mRemovedFlags;
    QSet<QByteArray> mAddedFlags;
    QSet<QByteArray> mFlags;
    Scope mItems;
    ModifyItemsCommand::ModifiedParts mModifiedParts = None;
    int mOldRevision = -1;
    bool mDirty = true;
    bool mInvalidateCache = false;
    bool mNoResponse = false;
    bool mNotify = true;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::ModifyItemsCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::ModifyItemsCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::ModifyItemsCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::ModifyItemsCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::ModifyItemsCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const ModifyItemsResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, ModifyItemsResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const ModifyItemsResponse &obj);

using ModifyItemsResponsePtr = QSharedPointer<ModifyItemsResponse>;

class AKONADIPRIVATE_EXPORT ModifyItemsResponse : public Response
{

public:
    explicit ModifyItemsResponse();
    explicit ModifyItemsResponse(qint64 id, int newRevision);
    ModifyItemsResponse(const ModifyItemsResponse &) = default;
    ModifyItemsResponse(ModifyItemsResponse &&) = default;
    ~ModifyItemsResponse() = default;

    ModifyItemsResponse &operator=(const ModifyItemsResponse &) = default;
    ModifyItemsResponse &operator=(ModifyItemsResponse &&) = default;
    bool operator==(const ModifyItemsResponse &other) const;
    inline bool operator!=(const ModifyItemsResponse &other) const { return !operator==(other); }
    inline qint64 id() const { return mId; }
    inline void setId(qint64 id) { mId = id; }

    inline int newRevision() const { return mNewRevision; }
    inline void setNewRevision(int newRevision) { mNewRevision = newRevision; }

    inline QDateTime modificationDateTime() const { return mModificationDateTime; }
    inline void setModificationDateTime(const QDateTime &modificationDateTime) { mModificationDateTime = modificationDateTime; }
    inline void setModificationDateTime(QDateTime &&modificationDateTime) { mModificationDateTime = std::move(modificationDateTime); }

    void toJson(QJsonObject &stream) const;
protected:
    qint64 mId = -1;
    QDateTime mModificationDateTime;
    int mNewRevision = 0;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::ModifyItemsResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::ModifyItemsResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::ModifyItemsResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::ModifyItemsResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::ModifyItemsResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const MoveItemsCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, MoveItemsCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const MoveItemsCommand &obj);

using MoveItemsCommandPtr = QSharedPointer<MoveItemsCommand>;

class AKONADIPRIVATE_EXPORT MoveItemsCommand : public Command
{

public:
    explicit MoveItemsCommand();
    explicit MoveItemsCommand(const Scope &items, const Scope &destination);
    explicit MoveItemsCommand(const Scope &items, const Akonadi::Protocol::ScopeContext &itemsContext, const Scope &destination);
    MoveItemsCommand(const MoveItemsCommand &) = default;
    MoveItemsCommand(MoveItemsCommand &&) = default;
    ~MoveItemsCommand() = default;

    MoveItemsCommand &operator=(const MoveItemsCommand &) = default;
    MoveItemsCommand &operator=(MoveItemsCommand &&) = default;
    bool operator==(const MoveItemsCommand &other) const;
    inline bool operator!=(const MoveItemsCommand &other) const { return !operator==(other); }
    inline Scope items() const { return mItems; }
    inline void setItems(const Scope &items) { mItems = items; }
    inline void setItems(Scope &&items) { mItems = std::move(items); }

    inline Akonadi::Protocol::ScopeContext itemsContext() const { return mItemsContext; }
    inline void setItemsContext(const Akonadi::Protocol::ScopeContext &itemsContext) { mItemsContext = itemsContext; }
    inline void setItemsContext(Akonadi::Protocol::ScopeContext &&itemsContext) { mItemsContext = std::move(itemsContext); }

    inline Scope destination() const { return mDestination; }
    inline void setDestination(const Scope &destination) { mDestination = destination; }
    inline void setDestination(Scope &&destination) { mDestination = std::move(destination); }

    void toJson(QJsonObject &stream) const;
protected:
    Scope mItems;
    Scope mDestination;
    Akonadi::Protocol::ScopeContext mItemsContext;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::MoveItemsCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::MoveItemsCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::MoveItemsCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::MoveItemsCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::MoveItemsCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const MoveItemsResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, MoveItemsResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const MoveItemsResponse &obj);

using MoveItemsResponsePtr = QSharedPointer<MoveItemsResponse>;

class AKONADIPRIVATE_EXPORT MoveItemsResponse : public Response
{

public:
    explicit MoveItemsResponse();
    MoveItemsResponse(const MoveItemsResponse &) = default;
    MoveItemsResponse(MoveItemsResponse &&) = default;
    ~MoveItemsResponse() = default;

    MoveItemsResponse &operator=(const MoveItemsResponse &) = default;
    MoveItemsResponse &operator=(MoveItemsResponse &&) = default;
    bool operator==(const MoveItemsResponse &other) const;
    inline bool operator!=(const MoveItemsResponse &other) const { return !operator==(other); }
    void toJson(QJsonObject &stream) const;
protected:

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::MoveItemsResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::MoveItemsResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::MoveItemsResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::MoveItemsResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::MoveItemsResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const CreateCollectionCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, CreateCollectionCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const CreateCollectionCommand &obj);

using CreateCollectionCommandPtr = QSharedPointer<CreateCollectionCommand>;

class AKONADIPRIVATE_EXPORT CreateCollectionCommand : public Command
{

public:
    explicit CreateCollectionCommand();
    CreateCollectionCommand(const CreateCollectionCommand &) = default;
    CreateCollectionCommand(CreateCollectionCommand &&) = default;
    ~CreateCollectionCommand() = default;

    CreateCollectionCommand &operator=(const CreateCollectionCommand &) = default;
    CreateCollectionCommand &operator=(CreateCollectionCommand &&) = default;
    bool operator==(const CreateCollectionCommand &other) const;
    inline bool operator!=(const CreateCollectionCommand &other) const { return !operator==(other); }
    inline Scope parent() const { return mParent; }
    inline void setParent(const Scope &parent) { mParent = parent; }
    inline void setParent(Scope &&parent) { mParent = std::move(parent); }

    inline QString name() const { return mName; }
    inline void setName(const QString &name) { mName = name; }
    inline void setName(QString &&name) { mName = std::move(name); }

    inline QString remoteId() const { return mRemoteId; }
    inline void setRemoteId(const QString &remoteId) { mRemoteId = remoteId; }
    inline void setRemoteId(QString &&remoteId) { mRemoteId = std::move(remoteId); }

    inline QString remoteRevision() const { return mRemoteRevision; }
    inline void setRemoteRevision(const QString &remoteRevision) { mRemoteRevision = remoteRevision; }
    inline void setRemoteRevision(QString &&remoteRevision) { mRemoteRevision = std::move(remoteRevision); }

    inline QStringList mimeTypes() const { return mMimeTypes; }
    inline void setMimeTypes(const QStringList &mimeTypes) { mMimeTypes = mimeTypes; }
    inline void setMimeTypes(QStringList &&mimeTypes) { mMimeTypes = std::move(mimeTypes); }

    inline Akonadi::Protocol::CachePolicy cachePolicy() const { return mCachePolicy; }
    inline void setCachePolicy(const Akonadi::Protocol::CachePolicy &cachePolicy) { mCachePolicy = cachePolicy; }
    inline void setCachePolicy(Akonadi::Protocol::CachePolicy &&cachePolicy) { mCachePolicy = std::move(cachePolicy); }

    inline Akonadi::Protocol::Attributes attributes() const { return mAttributes; }
    inline void setAttributes(const Akonadi::Protocol::Attributes &attributes) { mAttributes = attributes; }
    inline void setAttributes(Akonadi::Protocol::Attributes &&attributes) { mAttributes = std::move(attributes); }

    inline bool isVirtual() const { return mIsVirtual; }
    inline void setIsVirtual(bool isVirtual) { mIsVirtual = isVirtual; }

    inline bool enabled() const { return mEnabled; }
    inline void setEnabled(bool enabled) { mEnabled = enabled; }

    inline Tristate syncPref() const { return mSyncPref; }
    inline void setSyncPref(const Tristate &syncPref) { mSyncPref = syncPref; }
    inline void setSyncPref(Tristate &&syncPref) { mSyncPref = std::move(syncPref); }

    inline Tristate displayPref() const { return mDisplayPref; }
    inline void setDisplayPref(const Tristate &displayPref) { mDisplayPref = displayPref; }
    inline void setDisplayPref(Tristate &&displayPref) { mDisplayPref = std::move(displayPref); }

    inline Tristate indexPref() const { return mIndexPref; }
    inline void setIndexPref(const Tristate &indexPref) { mIndexPref = indexPref; }
    inline void setIndexPref(Tristate &&indexPref) { mIndexPref = std::move(indexPref); }

    void toJson(QJsonObject &stream) const;
protected:
    Scope mParent;
    QString mName;
    QString mRemoteId;
    QString mRemoteRevision;
    QStringList mMimeTypes;
    Akonadi::Protocol::Attributes mAttributes;
    Akonadi::Protocol::CachePolicy mCachePolicy;
    bool mIsVirtual = false;
    bool mEnabled = true;
    Tristate mSyncPref = Tristate::Undefined;
    Tristate mDisplayPref = Tristate::Undefined;
    Tristate mIndexPref = Tristate::Undefined;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::CreateCollectionCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::CreateCollectionCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::CreateCollectionCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::CreateCollectionCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::CreateCollectionCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const CreateCollectionResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, CreateCollectionResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const CreateCollectionResponse &obj);

using CreateCollectionResponsePtr = QSharedPointer<CreateCollectionResponse>;

class AKONADIPRIVATE_EXPORT CreateCollectionResponse : public Response
{

public:
    explicit CreateCollectionResponse();
    CreateCollectionResponse(const CreateCollectionResponse &) = default;
    CreateCollectionResponse(CreateCollectionResponse &&) = default;
    ~CreateCollectionResponse() = default;

    CreateCollectionResponse &operator=(const CreateCollectionResponse &) = default;
    CreateCollectionResponse &operator=(CreateCollectionResponse &&) = default;
    bool operator==(const CreateCollectionResponse &other) const;
    inline bool operator!=(const CreateCollectionResponse &other) const { return !operator==(other); }
    void toJson(QJsonObject &stream) const;
protected:

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::CreateCollectionResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::CreateCollectionResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::CreateCollectionResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::CreateCollectionResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::CreateCollectionResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const CopyCollectionCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, CopyCollectionCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const CopyCollectionCommand &obj);

using CopyCollectionCommandPtr = QSharedPointer<CopyCollectionCommand>;

class AKONADIPRIVATE_EXPORT CopyCollectionCommand : public Command
{

public:
    explicit CopyCollectionCommand();
    explicit CopyCollectionCommand(const Scope &collection, const Scope &destination);
    CopyCollectionCommand(const CopyCollectionCommand &) = default;
    CopyCollectionCommand(CopyCollectionCommand &&) = default;
    ~CopyCollectionCommand() = default;

    CopyCollectionCommand &operator=(const CopyCollectionCommand &) = default;
    CopyCollectionCommand &operator=(CopyCollectionCommand &&) = default;
    bool operator==(const CopyCollectionCommand &other) const;
    inline bool operator!=(const CopyCollectionCommand &other) const { return !operator==(other); }
    inline Scope collection() const { return mCollection; }
    inline void setCollection(const Scope &collection) { mCollection = collection; }
    inline void setCollection(Scope &&collection) { mCollection = std::move(collection); }

    inline Scope destination() const { return mDestination; }
    inline void setDestination(const Scope &destination) { mDestination = destination; }
    inline void setDestination(Scope &&destination) { mDestination = std::move(destination); }

    void toJson(QJsonObject &stream) const;
protected:
    Scope mCollection;
    Scope mDestination;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::CopyCollectionCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::CopyCollectionCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::CopyCollectionCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::CopyCollectionCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::CopyCollectionCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const CopyCollectionResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, CopyCollectionResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const CopyCollectionResponse &obj);

using CopyCollectionResponsePtr = QSharedPointer<CopyCollectionResponse>;

class AKONADIPRIVATE_EXPORT CopyCollectionResponse : public Response
{

public:
    explicit CopyCollectionResponse();
    CopyCollectionResponse(const CopyCollectionResponse &) = default;
    CopyCollectionResponse(CopyCollectionResponse &&) = default;
    ~CopyCollectionResponse() = default;

    CopyCollectionResponse &operator=(const CopyCollectionResponse &) = default;
    CopyCollectionResponse &operator=(CopyCollectionResponse &&) = default;
    bool operator==(const CopyCollectionResponse &other) const;
    inline bool operator!=(const CopyCollectionResponse &other) const { return !operator==(other); }
    void toJson(QJsonObject &stream) const;
protected:

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::CopyCollectionResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::CopyCollectionResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::CopyCollectionResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::CopyCollectionResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::CopyCollectionResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const DeleteCollectionCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, DeleteCollectionCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const DeleteCollectionCommand &obj);

using DeleteCollectionCommandPtr = QSharedPointer<DeleteCollectionCommand>;

class AKONADIPRIVATE_EXPORT DeleteCollectionCommand : public Command
{

public:
    explicit DeleteCollectionCommand();
    explicit DeleteCollectionCommand(const Scope &collection);
    DeleteCollectionCommand(const DeleteCollectionCommand &) = default;
    DeleteCollectionCommand(DeleteCollectionCommand &&) = default;
    ~DeleteCollectionCommand() = default;

    DeleteCollectionCommand &operator=(const DeleteCollectionCommand &) = default;
    DeleteCollectionCommand &operator=(DeleteCollectionCommand &&) = default;
    bool operator==(const DeleteCollectionCommand &other) const;
    inline bool operator!=(const DeleteCollectionCommand &other) const { return !operator==(other); }
    inline Scope collection() const { return mCollection; }
    inline void setCollection(const Scope &collection) { mCollection = collection; }
    inline void setCollection(Scope &&collection) { mCollection = std::move(collection); }

    void toJson(QJsonObject &stream) const;
protected:
    Scope mCollection;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::DeleteCollectionCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::DeleteCollectionCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::DeleteCollectionCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::DeleteCollectionCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::DeleteCollectionCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const DeleteCollectionResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, DeleteCollectionResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const DeleteCollectionResponse &obj);

using DeleteCollectionResponsePtr = QSharedPointer<DeleteCollectionResponse>;

class AKONADIPRIVATE_EXPORT DeleteCollectionResponse : public Response
{

public:
    explicit DeleteCollectionResponse();
    DeleteCollectionResponse(const DeleteCollectionResponse &) = default;
    DeleteCollectionResponse(DeleteCollectionResponse &&) = default;
    ~DeleteCollectionResponse() = default;

    DeleteCollectionResponse &operator=(const DeleteCollectionResponse &) = default;
    DeleteCollectionResponse &operator=(DeleteCollectionResponse &&) = default;
    bool operator==(const DeleteCollectionResponse &other) const;
    inline bool operator!=(const DeleteCollectionResponse &other) const { return !operator==(other); }
    void toJson(QJsonObject &stream) const;
protected:

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::DeleteCollectionResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::DeleteCollectionResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::DeleteCollectionResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::DeleteCollectionResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::DeleteCollectionResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const FetchCollectionStatsCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, FetchCollectionStatsCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const FetchCollectionStatsCommand &obj);

using FetchCollectionStatsCommandPtr = QSharedPointer<FetchCollectionStatsCommand>;

class AKONADIPRIVATE_EXPORT FetchCollectionStatsCommand : public Command
{

public:
    explicit FetchCollectionStatsCommand();
    explicit FetchCollectionStatsCommand(const Scope &collection);
    FetchCollectionStatsCommand(const FetchCollectionStatsCommand &) = default;
    FetchCollectionStatsCommand(FetchCollectionStatsCommand &&) = default;
    ~FetchCollectionStatsCommand() = default;

    FetchCollectionStatsCommand &operator=(const FetchCollectionStatsCommand &) = default;
    FetchCollectionStatsCommand &operator=(FetchCollectionStatsCommand &&) = default;
    bool operator==(const FetchCollectionStatsCommand &other) const;
    inline bool operator!=(const FetchCollectionStatsCommand &other) const { return !operator==(other); }
    inline Scope collection() const { return mCollection; }
    inline void setCollection(const Scope &collection) { mCollection = collection; }
    inline void setCollection(Scope &&collection) { mCollection = std::move(collection); }

    void toJson(QJsonObject &stream) const;
protected:
    Scope mCollection;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::FetchCollectionStatsCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::FetchCollectionStatsCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::FetchCollectionStatsCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::FetchCollectionStatsCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::FetchCollectionStatsCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const FetchCollectionStatsResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, FetchCollectionStatsResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const FetchCollectionStatsResponse &obj);

using FetchCollectionStatsResponsePtr = QSharedPointer<FetchCollectionStatsResponse>;

class AKONADIPRIVATE_EXPORT FetchCollectionStatsResponse : public Response
{

public:
    explicit FetchCollectionStatsResponse();
    explicit FetchCollectionStatsResponse(qint64 count, qint64 unseen, qint64 size);
    FetchCollectionStatsResponse(const FetchCollectionStatsResponse &) = default;
    FetchCollectionStatsResponse(FetchCollectionStatsResponse &&) = default;
    ~FetchCollectionStatsResponse() = default;

    FetchCollectionStatsResponse &operator=(const FetchCollectionStatsResponse &) = default;
    FetchCollectionStatsResponse &operator=(FetchCollectionStatsResponse &&) = default;
    bool operator==(const FetchCollectionStatsResponse &other) const;
    inline bool operator!=(const FetchCollectionStatsResponse &other) const { return !operator==(other); }
    inline qint64 count() const { return mCount; }
    inline void setCount(qint64 count) { mCount = count; }

    inline qint64 unseen() const { return mUnseen; }
    inline void setUnseen(qint64 unseen) { mUnseen = unseen; }

    inline qint64 size() const { return mSize; }
    inline void setSize(qint64 size) { mSize = size; }

    void toJson(QJsonObject &stream) const;
protected:
    qint64 mCount = 0;
    qint64 mUnseen = 0;
    qint64 mSize = 0;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::FetchCollectionStatsResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::FetchCollectionStatsResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::FetchCollectionStatsResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::FetchCollectionStatsResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::FetchCollectionStatsResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const FetchCollectionsCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, FetchCollectionsCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const FetchCollectionsCommand &obj);

using FetchCollectionsCommandPtr = QSharedPointer<FetchCollectionsCommand>;

class AKONADIPRIVATE_EXPORT FetchCollectionsCommand : public Command
{

public:
    enum Depth {
        BaseCollection,
        ParentCollection,
        AllCollections,
    };
    explicit FetchCollectionsCommand();
    explicit FetchCollectionsCommand(const Scope &collections);
    FetchCollectionsCommand(const FetchCollectionsCommand &) = default;
    FetchCollectionsCommand(FetchCollectionsCommand &&) = default;
    ~FetchCollectionsCommand() = default;

    FetchCollectionsCommand &operator=(const FetchCollectionsCommand &) = default;
    FetchCollectionsCommand &operator=(FetchCollectionsCommand &&) = default;
    bool operator==(const FetchCollectionsCommand &other) const;
    inline bool operator!=(const FetchCollectionsCommand &other) const { return !operator==(other); }
    inline Scope collections() const { return mCollections; }
    inline void setCollections(const Scope &collections) { mCollections = collections; }
    inline void setCollections(Scope &&collections) { mCollections = std::move(collections); }

    inline FetchCollectionsCommand::Depth depth() const { return mDepth; }
    inline void setDepth(const FetchCollectionsCommand::Depth &depth) { mDepth = depth; }
    inline void setDepth(FetchCollectionsCommand::Depth &&depth) { mDepth = std::move(depth); }

    inline QString resource() const { return mResource; }
    inline void setResource(const QString &resource) { mResource = resource; }
    inline void setResource(QString &&resource) { mResource = std::move(resource); }

    inline QStringList mimeTypes() const { return mMimeTypes; }
    inline void setMimeTypes(const QStringList &mimeTypes) { mMimeTypes = mimeTypes; }
    inline void setMimeTypes(QStringList &&mimeTypes) { mMimeTypes = std::move(mimeTypes); }

    inline Akonadi::Protocol::Ancestor::Depth ancestorsDepth() const { return mAncestorsDepth; }
    inline void setAncestorsDepth(const Akonadi::Protocol::Ancestor::Depth &ancestorsDepth) { mAncestorsDepth = ancestorsDepth; }
    inline void setAncestorsDepth(Akonadi::Protocol::Ancestor::Depth &&ancestorsDepth) { mAncestorsDepth = std::move(ancestorsDepth); }

    inline QSet<QByteArray> ancestorsAttributes() const { return mAncestorsAttributes; }
    inline void setAncestorsAttributes(const QSet<QByteArray> &ancestorsAttributes) { mAncestorsAttributes = ancestorsAttributes; }
    inline void setAncestorsAttributes(QSet<QByteArray> &&ancestorsAttributes) { mAncestorsAttributes = std::move(ancestorsAttributes); }

    inline bool enabled() const { return mEnabled; }
    inline void setEnabled(bool enabled) { mEnabled = enabled; }

    inline bool syncPref() const { return mSyncPref; }
    inline void setSyncPref(bool syncPref) { mSyncPref = syncPref; }

    inline bool displayPref() const { return mDisplayPref; }
    inline void setDisplayPref(bool displayPref) { mDisplayPref = displayPref; }

    inline bool indexPref() const { return mIndexPref; }
    inline void setIndexPref(bool indexPref) { mIndexPref = indexPref; }

    inline bool fetchStats() const { return mFetchStats; }
    inline void setFetchStats(bool fetchStats) { mFetchStats = fetchStats; }

    void toJson(QJsonObject &stream) const;
protected:
    Scope mCollections;
    QString mResource;
    QStringList mMimeTypes;
    QSet<QByteArray> mAncestorsAttributes;
    FetchCollectionsCommand::Depth mDepth = BaseCollection;
    Akonadi::Protocol::Ancestor::Depth mAncestorsDepth;
    bool mEnabled = false;
    bool mSyncPref = false;
    bool mDisplayPref = false;
    bool mIndexPref = false;
    bool mFetchStats = false;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::FetchCollectionsCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::FetchCollectionsCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::FetchCollectionsCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::FetchCollectionsCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::FetchCollectionsCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const FetchCollectionsResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, FetchCollectionsResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const FetchCollectionsResponse &obj);

using FetchCollectionsResponsePtr = QSharedPointer<FetchCollectionsResponse>;

class AKONADIPRIVATE_EXPORT FetchCollectionsResponse : public Response
{

public:
    explicit FetchCollectionsResponse();
    explicit FetchCollectionsResponse(qint64 id);
    FetchCollectionsResponse(const FetchCollectionsResponse &) = default;
    FetchCollectionsResponse(FetchCollectionsResponse &&) = default;
    ~FetchCollectionsResponse() = default;

    FetchCollectionsResponse &operator=(const FetchCollectionsResponse &) = default;
    FetchCollectionsResponse &operator=(FetchCollectionsResponse &&) = default;
    bool operator==(const FetchCollectionsResponse &other) const;
    inline bool operator!=(const FetchCollectionsResponse &other) const { return !operator==(other); }
    inline qint64 id() const { return mId; }
    inline void setId(qint64 id) { mId = id; }

    inline qint64 parentId() const { return mParentId; }
    inline void setParentId(qint64 parentId) { mParentId = parentId; }

    inline QString name() const { return mName; }
    inline void setName(const QString &name) { mName = name; }
    inline void setName(QString &&name) { mName = std::move(name); }

    inline QStringList mimeTypes() const { return mMimeTypes; }
    inline void setMimeTypes(const QStringList &mimeTypes) { mMimeTypes = mimeTypes; }
    inline void setMimeTypes(QStringList &&mimeTypes) { mMimeTypes = std::move(mimeTypes); }

    inline QString remoteId() const { return mRemoteId; }
    inline void setRemoteId(const QString &remoteId) { mRemoteId = remoteId; }
    inline void setRemoteId(QString &&remoteId) { mRemoteId = std::move(remoteId); }

    inline QString remoteRevision() const { return mRemoteRevision; }
    inline void setRemoteRevision(const QString &remoteRevision) { mRemoteRevision = remoteRevision; }
    inline void setRemoteRevision(QString &&remoteRevision) { mRemoteRevision = std::move(remoteRevision); }

    inline QString resource() const { return mResource; }
    inline void setResource(const QString &resource) { mResource = resource; }
    inline void setResource(QString &&resource) { mResource = std::move(resource); }

    inline Akonadi::Protocol::FetchCollectionStatsResponse statistics() const { return mStatistics; }
    inline void setStatistics(const Akonadi::Protocol::FetchCollectionStatsResponse &statistics) { mStatistics = statistics; }
    inline void setStatistics(Akonadi::Protocol::FetchCollectionStatsResponse &&statistics) { mStatistics = std::move(statistics); }

    inline QString searchQuery() const { return mSearchQuery; }
    inline void setSearchQuery(const QString &searchQuery) { mSearchQuery = searchQuery; }
    inline void setSearchQuery(QString &&searchQuery) { mSearchQuery = std::move(searchQuery); }

    inline QVector<qint64> searchCollections() const { return mSearchCollections; }
    inline void setSearchCollections(const QVector<qint64> &searchCollections) { mSearchCollections = searchCollections; }
    inline void setSearchCollections(QVector<qint64> &&searchCollections) { mSearchCollections = std::move(searchCollections); }

    inline QVector<Akonadi::Protocol::Ancestor> ancestors() const { return mAncestors; }
    inline void setAncestors(const QVector<Akonadi::Protocol::Ancestor> &ancestors) { mAncestors = ancestors; }
    inline void setAncestors(QVector<Akonadi::Protocol::Ancestor> &&ancestors) { mAncestors = std::move(ancestors); }

    inline Akonadi::Protocol::CachePolicy cachePolicy() const { return mCachePolicy; }
    inline void setCachePolicy(const Akonadi::Protocol::CachePolicy &cachePolicy) { mCachePolicy = cachePolicy; }
    inline void setCachePolicy(Akonadi::Protocol::CachePolicy &&cachePolicy) { mCachePolicy = std::move(cachePolicy); }

    inline Akonadi::Protocol::Attributes attributes() const { return mAttributes; }
    inline void setAttributes(const Akonadi::Protocol::Attributes &attributes) { mAttributes = attributes; }
    inline void setAttributes(Akonadi::Protocol::Attributes &&attributes) { mAttributes = std::move(attributes); }

    inline bool enabled() const { return mEnabled; }
    inline void setEnabled(bool enabled) { mEnabled = enabled; }

    inline Tristate displayPref() const { return mDisplayPref; }
    inline void setDisplayPref(const Tristate &displayPref) { mDisplayPref = displayPref; }
    inline void setDisplayPref(Tristate &&displayPref) { mDisplayPref = std::move(displayPref); }

    inline Tristate syncPref() const { return mSyncPref; }
    inline void setSyncPref(const Tristate &syncPref) { mSyncPref = syncPref; }
    inline void setSyncPref(Tristate &&syncPref) { mSyncPref = std::move(syncPref); }

    inline Tristate indexPref() const { return mIndexPref; }
    inline void setIndexPref(const Tristate &indexPref) { mIndexPref = indexPref; }
    inline void setIndexPref(Tristate &&indexPref) { mIndexPref = std::move(indexPref); }

    inline bool isVirtual() const { return mIsVirtual; }
    inline void setIsVirtual(bool isVirtual) { mIsVirtual = isVirtual; }

    void toJson(QJsonObject &stream) const;
protected:
    qint64 mParentId = -1;
    Akonadi::Protocol::Attributes mAttributes;
    QVector<Akonadi::Protocol::Ancestor> mAncestors;
    QVector<qint64> mSearchCollections;
    QString mSearchQuery;
    QString mResource;
    QString mRemoteRevision;
    QString mRemoteId;
    QStringList mMimeTypes;
    QString mName;
    qint64 mId = -1;
    Akonadi::Protocol::FetchCollectionStatsResponse mStatistics;
    Akonadi::Protocol::CachePolicy mCachePolicy;
    bool mEnabled = true;
    Tristate mDisplayPref = Tristate::Undefined;
    Tristate mSyncPref = Tristate::Undefined;
    Tristate mIndexPref = Tristate::Undefined;
    bool mIsVirtual = false;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::FetchCollectionsResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::FetchCollectionsResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::FetchCollectionsResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::FetchCollectionsResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::FetchCollectionsResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const ModifyCollectionCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, ModifyCollectionCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const ModifyCollectionCommand &obj);

using ModifyCollectionCommandPtr = QSharedPointer<ModifyCollectionCommand>;

class AKONADIPRIVATE_EXPORT ModifyCollectionCommand : public Command
{

public:
    enum ModifiedPart {
        None = 0,
        Name = 1,
        RemoteID = 2,
        RemoteRevision = 4,
        ParentID = 8,
        MimeTypes = 16,
        CachePolicy = 32,
        PersistentSearch = 64,
        RemovedAttributes = 128,
        Attributes = 256,
        ListPreferences = 512,
    };
    Q_DECLARE_FLAGS(ModifiedParts, ModifiedPart)

    explicit ModifyCollectionCommand();
    explicit ModifyCollectionCommand(const Scope &collection);
    ModifyCollectionCommand(const ModifyCollectionCommand &) = default;
    ModifyCollectionCommand(ModifyCollectionCommand &&) = default;
    ~ModifyCollectionCommand() = default;

    ModifyCollectionCommand &operator=(const ModifyCollectionCommand &) = default;
    ModifyCollectionCommand &operator=(ModifyCollectionCommand &&) = default;
    bool operator==(const ModifyCollectionCommand &other) const;
    inline bool operator!=(const ModifyCollectionCommand &other) const { return !operator==(other); }
    inline ModifyCollectionCommand::ModifiedParts modifiedParts() const { return mModifiedParts; }
    inline void setModifiedParts(const ModifyCollectionCommand::ModifiedParts &modifiedParts) { mModifiedParts = modifiedParts; }
    inline void setModifiedParts(ModifyCollectionCommand::ModifiedParts &&modifiedParts) { mModifiedParts = std::move(modifiedParts); }

    inline Scope collection() const { return mCollection; }
    inline void setCollection(const Scope &collection) { mCollection = collection; }
    inline void setCollection(Scope &&collection) { mCollection = std::move(collection); }

    inline qint64 parentId() const { return mParentId; }
    void setParentId(qint64 parentId);

    inline QStringList mimeTypes() const { return mMimeTypes; }
    void setMimeTypes(const QStringList &mimeTypes);

    inline Akonadi::Protocol::CachePolicy cachePolicy() const { return mCachePolicy; }
    void setCachePolicy(const Akonadi::Protocol::CachePolicy &cachePolicy);

    inline QString name() const { return mName; }
    void setName(const QString &name);

    inline QString remoteId() const { return mRemoteId; }
    void setRemoteId(const QString &remoteId);

    inline QString remoteRevision() const { return mRemoteRevision; }
    void setRemoteRevision(const QString &remoteRevision);

    inline QString persistentSearchQuery() const { return mPersistentSearchQuery; }
    void setPersistentSearchQuery(const QString &persistentSearchQuery);

    inline QVector<qint64> persistentSearchCollections() const { return mPersistentSearchCollections; }
    void setPersistentSearchCollections(const QVector<qint64> &persistentSearchCollections);

    inline bool persistentSearchRecursive() const { return mPersistentSearchRecursive; }
    void setPersistentSearchRecursive(bool persistentSearchRecursive);

    inline bool persistentSearchRemote() const { return mPersistentSearchRemote; }
    void setPersistentSearchRemote(bool persistentSearchRemote);

    inline QSet<QByteArray> removedAttributes() const { return mRemovedAttributes; }
    void setRemovedAttributes(const QSet<QByteArray> &removedAttributes);

    inline Akonadi::Protocol::Attributes attributes() const { return mAttributes; }
    void setAttributes(const Akonadi::Protocol::Attributes &attributes);

    inline bool enabled() const { return mEnabled; }
    void setEnabled(bool enabled);

    inline Tristate syncPref() const { return mSyncPref; }
    void setSyncPref(const Tristate &syncPref);

    inline Tristate displayPref() const { return mDisplayPref; }
    void setDisplayPref(const Tristate &displayPref);

    inline Tristate indexPref() const { return mIndexPref; }
    void setIndexPref(const Tristate &indexPref);

    void toJson(QJsonObject &stream) const;
protected:
    Scope mCollection;
    Akonadi::Protocol::Attributes mAttributes;
    QSet<QByteArray> mRemovedAttributes;
    QVector<qint64> mPersistentSearchCollections;
    QString mPersistentSearchQuery;
    QString mRemoteRevision;
    QString mRemoteId;
    QString mName;
    QStringList mMimeTypes;
    qint64 mParentId = -1;
    Akonadi::Protocol::CachePolicy mCachePolicy;
    ModifyCollectionCommand::ModifiedParts mModifiedParts = None;
    bool mPersistentSearchRecursive = false;
    bool mPersistentSearchRemote = false;
    bool mEnabled = true;
    Tristate mSyncPref = Tristate::Undefined;
    Tristate mDisplayPref = Tristate::Undefined;
    Tristate mIndexPref = Tristate::Undefined;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::ModifyCollectionCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::ModifyCollectionCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::ModifyCollectionCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::ModifyCollectionCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::ModifyCollectionCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const ModifyCollectionResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, ModifyCollectionResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const ModifyCollectionResponse &obj);

using ModifyCollectionResponsePtr = QSharedPointer<ModifyCollectionResponse>;

class AKONADIPRIVATE_EXPORT ModifyCollectionResponse : public Response
{

public:
    explicit ModifyCollectionResponse();
    ModifyCollectionResponse(const ModifyCollectionResponse &) = default;
    ModifyCollectionResponse(ModifyCollectionResponse &&) = default;
    ~ModifyCollectionResponse() = default;

    ModifyCollectionResponse &operator=(const ModifyCollectionResponse &) = default;
    ModifyCollectionResponse &operator=(ModifyCollectionResponse &&) = default;
    bool operator==(const ModifyCollectionResponse &other) const;
    inline bool operator!=(const ModifyCollectionResponse &other) const { return !operator==(other); }
    void toJson(QJsonObject &stream) const;
protected:

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::ModifyCollectionResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::ModifyCollectionResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::ModifyCollectionResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::ModifyCollectionResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::ModifyCollectionResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const MoveCollectionCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, MoveCollectionCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const MoveCollectionCommand &obj);

using MoveCollectionCommandPtr = QSharedPointer<MoveCollectionCommand>;

class AKONADIPRIVATE_EXPORT MoveCollectionCommand : public Command
{

public:
    explicit MoveCollectionCommand();
    explicit MoveCollectionCommand(const Scope &collection, const Scope &destination);
    MoveCollectionCommand(const MoveCollectionCommand &) = default;
    MoveCollectionCommand(MoveCollectionCommand &&) = default;
    ~MoveCollectionCommand() = default;

    MoveCollectionCommand &operator=(const MoveCollectionCommand &) = default;
    MoveCollectionCommand &operator=(MoveCollectionCommand &&) = default;
    bool operator==(const MoveCollectionCommand &other) const;
    inline bool operator!=(const MoveCollectionCommand &other) const { return !operator==(other); }
    inline Scope collection() const { return mCollection; }
    inline void setCollection(const Scope &collection) { mCollection = collection; }
    inline void setCollection(Scope &&collection) { mCollection = std::move(collection); }

    inline Scope destination() const { return mDestination; }
    inline void setDestination(const Scope &destination) { mDestination = destination; }
    inline void setDestination(Scope &&destination) { mDestination = std::move(destination); }

    void toJson(QJsonObject &stream) const;
protected:
    Scope mCollection;
    Scope mDestination;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::MoveCollectionCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::MoveCollectionCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::MoveCollectionCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::MoveCollectionCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::MoveCollectionCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const MoveCollectionResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, MoveCollectionResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const MoveCollectionResponse &obj);

using MoveCollectionResponsePtr = QSharedPointer<MoveCollectionResponse>;

class AKONADIPRIVATE_EXPORT MoveCollectionResponse : public Response
{

public:
    explicit MoveCollectionResponse();
    MoveCollectionResponse(const MoveCollectionResponse &) = default;
    MoveCollectionResponse(MoveCollectionResponse &&) = default;
    ~MoveCollectionResponse() = default;

    MoveCollectionResponse &operator=(const MoveCollectionResponse &) = default;
    MoveCollectionResponse &operator=(MoveCollectionResponse &&) = default;
    bool operator==(const MoveCollectionResponse &other) const;
    inline bool operator!=(const MoveCollectionResponse &other) const { return !operator==(other); }
    void toJson(QJsonObject &stream) const;
protected:

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::MoveCollectionResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::MoveCollectionResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::MoveCollectionResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::MoveCollectionResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::MoveCollectionResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const SearchCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, SearchCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const SearchCommand &obj);

using SearchCommandPtr = QSharedPointer<SearchCommand>;

class AKONADIPRIVATE_EXPORT SearchCommand : public Command
{

public:
    explicit SearchCommand();
    explicit SearchCommand(const QString &query);
    SearchCommand(const SearchCommand &) = default;
    SearchCommand(SearchCommand &&) = default;
    ~SearchCommand() = default;

    SearchCommand &operator=(const SearchCommand &) = default;
    SearchCommand &operator=(SearchCommand &&) = default;
    bool operator==(const SearchCommand &other) const;
    inline bool operator!=(const SearchCommand &other) const { return !operator==(other); }
    inline QStringList mimeTypes() const { return mMimeTypes; }
    inline void setMimeTypes(const QStringList &mimeTypes) { mMimeTypes = mimeTypes; }
    inline void setMimeTypes(QStringList &&mimeTypes) { mMimeTypes = std::move(mimeTypes); }

    inline QVector<qint64> collections() const { return mCollections; }
    inline void setCollections(const QVector<qint64> &collections) { mCollections = collections; }
    inline void setCollections(QVector<qint64> &&collections) { mCollections = std::move(collections); }

    inline QString query() const { return mQuery; }
    inline void setQuery(const QString &query) { mQuery = query; }
    inline void setQuery(QString &&query) { mQuery = std::move(query); }

    inline Akonadi::Protocol::ItemFetchScope itemFetchScope() const { return mItemFetchScope; }
    inline void setItemFetchScope(const Akonadi::Protocol::ItemFetchScope &itemFetchScope) { mItemFetchScope = itemFetchScope; }
    inline void setItemFetchScope(Akonadi::Protocol::ItemFetchScope &&itemFetchScope) { mItemFetchScope = std::move(itemFetchScope); }

    inline Akonadi::Protocol::TagFetchScope tagFetchScope() const { return mTagFetchScope; }
    inline void setTagFetchScope(const Akonadi::Protocol::TagFetchScope &tagFetchScope) { mTagFetchScope = tagFetchScope; }
    inline void setTagFetchScope(Akonadi::Protocol::TagFetchScope &&tagFetchScope) { mTagFetchScope = std::move(tagFetchScope); }

    inline bool recursive() const { return mRecursive; }
    inline void setRecursive(bool recursive) { mRecursive = recursive; }

    inline bool remote() const { return mRemote; }
    inline void setRemote(bool remote) { mRemote = remote; }

    void toJson(QJsonObject &stream) const;
protected:
    QStringList mMimeTypes;
    QVector<qint64> mCollections;
    QString mQuery;
    Akonadi::Protocol::ItemFetchScope mItemFetchScope;
    Akonadi::Protocol::TagFetchScope mTagFetchScope;
    bool mRecursive = false;
    bool mRemote = false;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::SearchCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::SearchCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::SearchCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::SearchCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::SearchCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const SearchResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, SearchResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const SearchResponse &obj);

using SearchResponsePtr = QSharedPointer<SearchResponse>;

class AKONADIPRIVATE_EXPORT SearchResponse : public Response
{

public:
    explicit SearchResponse();
    SearchResponse(const SearchResponse &) = default;
    SearchResponse(SearchResponse &&) = default;
    ~SearchResponse() = default;

    SearchResponse &operator=(const SearchResponse &) = default;
    SearchResponse &operator=(SearchResponse &&) = default;
    bool operator==(const SearchResponse &other) const;
    inline bool operator!=(const SearchResponse &other) const { return !operator==(other); }
    void toJson(QJsonObject &stream) const;
protected:

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::SearchResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::SearchResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::SearchResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::SearchResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::SearchResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const SearchResultCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, SearchResultCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const SearchResultCommand &obj);

using SearchResultCommandPtr = QSharedPointer<SearchResultCommand>;

class AKONADIPRIVATE_EXPORT SearchResultCommand : public Command
{

public:
    explicit SearchResultCommand();
    explicit SearchResultCommand(const QByteArray &searchId, qint64 collectionId, const Scope &result);
    SearchResultCommand(const SearchResultCommand &) = default;
    SearchResultCommand(SearchResultCommand &&) = default;
    ~SearchResultCommand() = default;

    SearchResultCommand &operator=(const SearchResultCommand &) = default;
    SearchResultCommand &operator=(SearchResultCommand &&) = default;
    bool operator==(const SearchResultCommand &other) const;
    inline bool operator!=(const SearchResultCommand &other) const { return !operator==(other); }
    inline QByteArray searchId() const { return mSearchId; }
    inline void setSearchId(const QByteArray &searchId) { mSearchId = searchId; }
    inline void setSearchId(QByteArray &&searchId) { mSearchId = std::move(searchId); }

    inline qint64 collectionId() const { return mCollectionId; }
    inline void setCollectionId(qint64 collectionId) { mCollectionId = collectionId; }

    inline Scope result() const { return mResult; }
    inline void setResult(const Scope &result) { mResult = result; }
    inline void setResult(Scope &&result) { mResult = std::move(result); }

    void toJson(QJsonObject &stream) const;
protected:
    QByteArray mSearchId;
    qint64 mCollectionId = -1;
    Scope mResult;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::SearchResultCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::SearchResultCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::SearchResultCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::SearchResultCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::SearchResultCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const SearchResultResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, SearchResultResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const SearchResultResponse &obj);

using SearchResultResponsePtr = QSharedPointer<SearchResultResponse>;

class AKONADIPRIVATE_EXPORT SearchResultResponse : public Response
{

public:
    explicit SearchResultResponse();
    SearchResultResponse(const SearchResultResponse &) = default;
    SearchResultResponse(SearchResultResponse &&) = default;
    ~SearchResultResponse() = default;

    SearchResultResponse &operator=(const SearchResultResponse &) = default;
    SearchResultResponse &operator=(SearchResultResponse &&) = default;
    bool operator==(const SearchResultResponse &other) const;
    inline bool operator!=(const SearchResultResponse &other) const { return !operator==(other); }
    void toJson(QJsonObject &stream) const;
protected:

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::SearchResultResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::SearchResultResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::SearchResultResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::SearchResultResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::SearchResultResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const StoreSearchCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, StoreSearchCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const StoreSearchCommand &obj);

using StoreSearchCommandPtr = QSharedPointer<StoreSearchCommand>;

class AKONADIPRIVATE_EXPORT StoreSearchCommand : public Command
{

public:
    explicit StoreSearchCommand();
    StoreSearchCommand(const StoreSearchCommand &) = default;
    StoreSearchCommand(StoreSearchCommand &&) = default;
    ~StoreSearchCommand() = default;

    StoreSearchCommand &operator=(const StoreSearchCommand &) = default;
    StoreSearchCommand &operator=(StoreSearchCommand &&) = default;
    bool operator==(const StoreSearchCommand &other) const;
    inline bool operator!=(const StoreSearchCommand &other) const { return !operator==(other); }
    inline QString name() const { return mName; }
    inline void setName(const QString &name) { mName = name; }
    inline void setName(QString &&name) { mName = std::move(name); }

    inline QString query() const { return mQuery; }
    inline void setQuery(const QString &query) { mQuery = query; }
    inline void setQuery(QString &&query) { mQuery = std::move(query); }

    inline QStringList mimeTypes() const { return mMimeTypes; }
    inline void setMimeTypes(const QStringList &mimeTypes) { mMimeTypes = mimeTypes; }
    inline void setMimeTypes(QStringList &&mimeTypes) { mMimeTypes = std::move(mimeTypes); }

    inline QVector<qint64> queryCollections() const { return mQueryCollections; }
    inline void setQueryCollections(const QVector<qint64> &queryCollections) { mQueryCollections = queryCollections; }
    inline void setQueryCollections(QVector<qint64> &&queryCollections) { mQueryCollections = std::move(queryCollections); }

    inline bool remote() const { return mRemote; }
    inline void setRemote(bool remote) { mRemote = remote; }

    inline bool recursive() const { return mRecursive; }
    inline void setRecursive(bool recursive) { mRecursive = recursive; }

    void toJson(QJsonObject &stream) const;
protected:
    QString mName;
    QString mQuery;
    QStringList mMimeTypes;
    QVector<qint64> mQueryCollections;
    bool mRemote = false;
    bool mRecursive = false;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::StoreSearchCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::StoreSearchCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::StoreSearchCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::StoreSearchCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::StoreSearchCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const StoreSearchResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, StoreSearchResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const StoreSearchResponse &obj);

using StoreSearchResponsePtr = QSharedPointer<StoreSearchResponse>;

class AKONADIPRIVATE_EXPORT StoreSearchResponse : public Response
{

public:
    explicit StoreSearchResponse();
    StoreSearchResponse(const StoreSearchResponse &) = default;
    StoreSearchResponse(StoreSearchResponse &&) = default;
    ~StoreSearchResponse() = default;

    StoreSearchResponse &operator=(const StoreSearchResponse &) = default;
    StoreSearchResponse &operator=(StoreSearchResponse &&) = default;
    bool operator==(const StoreSearchResponse &other) const;
    inline bool operator!=(const StoreSearchResponse &other) const { return !operator==(other); }
    void toJson(QJsonObject &stream) const;
protected:

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::StoreSearchResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::StoreSearchResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::StoreSearchResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::StoreSearchResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::StoreSearchResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const CreateTagCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, CreateTagCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const CreateTagCommand &obj);

using CreateTagCommandPtr = QSharedPointer<CreateTagCommand>;

class AKONADIPRIVATE_EXPORT CreateTagCommand : public Command
{

public:
    explicit CreateTagCommand();
    CreateTagCommand(const CreateTagCommand &) = default;
    CreateTagCommand(CreateTagCommand &&) = default;
    ~CreateTagCommand() = default;

    CreateTagCommand &operator=(const CreateTagCommand &) = default;
    CreateTagCommand &operator=(CreateTagCommand &&) = default;
    bool operator==(const CreateTagCommand &other) const;
    inline bool operator!=(const CreateTagCommand &other) const { return !operator==(other); }
    inline QByteArray gid() const { return mGid; }
    inline void setGid(const QByteArray &gid) { mGid = gid; }
    inline void setGid(QByteArray &&gid) { mGid = std::move(gid); }

    inline QByteArray remoteId() const { return mRemoteId; }
    inline void setRemoteId(const QByteArray &remoteId) { mRemoteId = remoteId; }
    inline void setRemoteId(QByteArray &&remoteId) { mRemoteId = std::move(remoteId); }

    inline QByteArray type() const { return mType; }
    inline void setType(const QByteArray &type) { mType = type; }
    inline void setType(QByteArray &&type) { mType = std::move(type); }

    inline Akonadi::Protocol::Attributes attributes() const { return mAttributes; }
    inline void setAttributes(const Akonadi::Protocol::Attributes &attributes) { mAttributes = attributes; }
    inline void setAttributes(Akonadi::Protocol::Attributes &&attributes) { mAttributes = std::move(attributes); }

    inline qint64 parentId() const { return mParentId; }
    inline void setParentId(qint64 parentId) { mParentId = parentId; }

    inline bool merge() const { return mMerge; }
    inline void setMerge(bool merge) { mMerge = merge; }

    void toJson(QJsonObject &stream) const;
protected:
    QByteArray mGid;
    QByteArray mRemoteId;
    QByteArray mType;
    Akonadi::Protocol::Attributes mAttributes;
    qint64 mParentId = -1;
    bool mMerge = false;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::CreateTagCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::CreateTagCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::CreateTagCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::CreateTagCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::CreateTagCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const CreateTagResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, CreateTagResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const CreateTagResponse &obj);

using CreateTagResponsePtr = QSharedPointer<CreateTagResponse>;

class AKONADIPRIVATE_EXPORT CreateTagResponse : public Response
{

public:
    explicit CreateTagResponse();
    CreateTagResponse(const CreateTagResponse &) = default;
    CreateTagResponse(CreateTagResponse &&) = default;
    ~CreateTagResponse() = default;

    CreateTagResponse &operator=(const CreateTagResponse &) = default;
    CreateTagResponse &operator=(CreateTagResponse &&) = default;
    bool operator==(const CreateTagResponse &other) const;
    inline bool operator!=(const CreateTagResponse &other) const { return !operator==(other); }
    void toJson(QJsonObject &stream) const;
protected:

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::CreateTagResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::CreateTagResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::CreateTagResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::CreateTagResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::CreateTagResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const DeleteTagCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, DeleteTagCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const DeleteTagCommand &obj);

using DeleteTagCommandPtr = QSharedPointer<DeleteTagCommand>;

class AKONADIPRIVATE_EXPORT DeleteTagCommand : public Command
{

public:
    explicit DeleteTagCommand();
    explicit DeleteTagCommand(const Scope &tag);
    DeleteTagCommand(const DeleteTagCommand &) = default;
    DeleteTagCommand(DeleteTagCommand &&) = default;
    ~DeleteTagCommand() = default;

    DeleteTagCommand &operator=(const DeleteTagCommand &) = default;
    DeleteTagCommand &operator=(DeleteTagCommand &&) = default;
    bool operator==(const DeleteTagCommand &other) const;
    inline bool operator!=(const DeleteTagCommand &other) const { return !operator==(other); }
    inline Scope tag() const { return mTag; }
    inline void setTag(const Scope &tag) { mTag = tag; }
    inline void setTag(Scope &&tag) { mTag = std::move(tag); }

    void toJson(QJsonObject &stream) const;
protected:
    Scope mTag;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::DeleteTagCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::DeleteTagCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::DeleteTagCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::DeleteTagCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::DeleteTagCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const DeleteTagResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, DeleteTagResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const DeleteTagResponse &obj);

using DeleteTagResponsePtr = QSharedPointer<DeleteTagResponse>;

class AKONADIPRIVATE_EXPORT DeleteTagResponse : public Response
{

public:
    explicit DeleteTagResponse();
    DeleteTagResponse(const DeleteTagResponse &) = default;
    DeleteTagResponse(DeleteTagResponse &&) = default;
    ~DeleteTagResponse() = default;

    DeleteTagResponse &operator=(const DeleteTagResponse &) = default;
    DeleteTagResponse &operator=(DeleteTagResponse &&) = default;
    bool operator==(const DeleteTagResponse &other) const;
    inline bool operator!=(const DeleteTagResponse &other) const { return !operator==(other); }
    void toJson(QJsonObject &stream) const;
protected:

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::DeleteTagResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::DeleteTagResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::DeleteTagResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::DeleteTagResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::DeleteTagResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const ModifyTagCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, ModifyTagCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const ModifyTagCommand &obj);

using ModifyTagCommandPtr = QSharedPointer<ModifyTagCommand>;

class AKONADIPRIVATE_EXPORT ModifyTagCommand : public Command
{

public:
    enum ModifiedPart {
        None = 0,
        ParentId = 1,
        Type = 2,
        RemoteId = 4,
        RemovedAttributes = 8,
        Attributes = 16,
    };
    Q_DECLARE_FLAGS(ModifiedParts, ModifiedPart)

    explicit ModifyTagCommand();
    explicit ModifyTagCommand(qint64 tagId);
    ModifyTagCommand(const ModifyTagCommand &) = default;
    ModifyTagCommand(ModifyTagCommand &&) = default;
    ~ModifyTagCommand() = default;

    ModifyTagCommand &operator=(const ModifyTagCommand &) = default;
    ModifyTagCommand &operator=(ModifyTagCommand &&) = default;
    bool operator==(const ModifyTagCommand &other) const;
    inline bool operator!=(const ModifyTagCommand &other) const { return !operator==(other); }
    inline ModifyTagCommand::ModifiedParts modifiedParts() const { return mModifiedParts; }
    inline void setModifiedParts(const ModifyTagCommand::ModifiedParts &modifiedParts) { mModifiedParts = modifiedParts; }
    inline void setModifiedParts(ModifyTagCommand::ModifiedParts &&modifiedParts) { mModifiedParts = std::move(modifiedParts); }

    inline qint64 tagId() const { return mTagId; }
    inline void setTagId(qint64 tagId) { mTagId = tagId; }

    inline qint64 parentId() const { return mParentId; }
    void setParentId(qint64 parentId);

    inline QByteArray type() const { return mType; }
    void setType(const QByteArray &type);

    inline QByteArray remoteId() const { return mRemoteId; }
    void setRemoteId(const QByteArray &remoteId);

    inline QSet<QByteArray> removedAttributes() const { return mRemovedAttributes; }
    void setRemovedAttributes(const QSet<QByteArray> &removedAttributes);

    inline Akonadi::Protocol::Attributes attributes() const { return mAttributes; }
    void setAttributes(const Akonadi::Protocol::Attributes &attributes);

    void toJson(QJsonObject &stream) const;
protected:
    qint64 mTagId = -1;
    qint64 mParentId = -1;
    QByteArray mType;
    QByteArray mRemoteId;
    QSet<QByteArray> mRemovedAttributes;
    Akonadi::Protocol::Attributes mAttributes;
    ModifyTagCommand::ModifiedParts mModifiedParts = None;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::ModifyTagCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::ModifyTagCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::ModifyTagCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::ModifyTagCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::ModifyTagCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const ModifyTagResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, ModifyTagResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const ModifyTagResponse &obj);

using ModifyTagResponsePtr = QSharedPointer<ModifyTagResponse>;

class AKONADIPRIVATE_EXPORT ModifyTagResponse : public Response
{

public:
    explicit ModifyTagResponse();
    ModifyTagResponse(const ModifyTagResponse &) = default;
    ModifyTagResponse(ModifyTagResponse &&) = default;
    ~ModifyTagResponse() = default;

    ModifyTagResponse &operator=(const ModifyTagResponse &) = default;
    ModifyTagResponse &operator=(ModifyTagResponse &&) = default;
    bool operator==(const ModifyTagResponse &other) const;
    inline bool operator!=(const ModifyTagResponse &other) const { return !operator==(other); }
    void toJson(QJsonObject &stream) const;
protected:

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::ModifyTagResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::ModifyTagResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::ModifyTagResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::ModifyTagResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::ModifyTagResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const ModifyRelationCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, ModifyRelationCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const ModifyRelationCommand &obj);

using ModifyRelationCommandPtr = QSharedPointer<ModifyRelationCommand>;

class AKONADIPRIVATE_EXPORT ModifyRelationCommand : public Command
{

public:
    explicit ModifyRelationCommand();
    explicit ModifyRelationCommand(qint64 left, qint64 right, const QByteArray &type, const QByteArray &remoteId = QByteArray());
    ModifyRelationCommand(const ModifyRelationCommand &) = default;
    ModifyRelationCommand(ModifyRelationCommand &&) = default;
    ~ModifyRelationCommand() = default;

    ModifyRelationCommand &operator=(const ModifyRelationCommand &) = default;
    ModifyRelationCommand &operator=(ModifyRelationCommand &&) = default;
    bool operator==(const ModifyRelationCommand &other) const;
    inline bool operator!=(const ModifyRelationCommand &other) const { return !operator==(other); }
    inline qint64 left() const { return mLeft; }
    inline void setLeft(qint64 left) { mLeft = left; }

    inline qint64 right() const { return mRight; }
    inline void setRight(qint64 right) { mRight = right; }

    inline QByteArray type() const { return mType; }
    inline void setType(const QByteArray &type) { mType = type; }
    inline void setType(QByteArray &&type) { mType = std::move(type); }

    inline QByteArray remoteId() const { return mRemoteId; }
    inline void setRemoteId(const QByteArray &remoteId) { mRemoteId = remoteId; }
    inline void setRemoteId(QByteArray &&remoteId) { mRemoteId = std::move(remoteId); }

    void toJson(QJsonObject &stream) const;
protected:
    qint64 mLeft = -1;
    qint64 mRight = -1;
    QByteArray mType;
    QByteArray mRemoteId;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::ModifyRelationCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::ModifyRelationCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::ModifyRelationCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::ModifyRelationCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::ModifyRelationCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const ModifyRelationResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, ModifyRelationResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const ModifyRelationResponse &obj);

using ModifyRelationResponsePtr = QSharedPointer<ModifyRelationResponse>;

class AKONADIPRIVATE_EXPORT ModifyRelationResponse : public Response
{

public:
    explicit ModifyRelationResponse();
    ModifyRelationResponse(const ModifyRelationResponse &) = default;
    ModifyRelationResponse(ModifyRelationResponse &&) = default;
    ~ModifyRelationResponse() = default;

    ModifyRelationResponse &operator=(const ModifyRelationResponse &) = default;
    ModifyRelationResponse &operator=(ModifyRelationResponse &&) = default;
    bool operator==(const ModifyRelationResponse &other) const;
    inline bool operator!=(const ModifyRelationResponse &other) const { return !operator==(other); }
    void toJson(QJsonObject &stream) const;
protected:

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::ModifyRelationResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::ModifyRelationResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::ModifyRelationResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::ModifyRelationResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::ModifyRelationResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const RemoveRelationsCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, RemoveRelationsCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const RemoveRelationsCommand &obj);

using RemoveRelationsCommandPtr = QSharedPointer<RemoveRelationsCommand>;

class AKONADIPRIVATE_EXPORT RemoveRelationsCommand : public Command
{

public:
    explicit RemoveRelationsCommand();
    explicit RemoveRelationsCommand(qint64 left, qint64 right, const QByteArray &type = QByteArray());
    RemoveRelationsCommand(const RemoveRelationsCommand &) = default;
    RemoveRelationsCommand(RemoveRelationsCommand &&) = default;
    ~RemoveRelationsCommand() = default;

    RemoveRelationsCommand &operator=(const RemoveRelationsCommand &) = default;
    RemoveRelationsCommand &operator=(RemoveRelationsCommand &&) = default;
    bool operator==(const RemoveRelationsCommand &other) const;
    inline bool operator!=(const RemoveRelationsCommand &other) const { return !operator==(other); }
    inline qint64 left() const { return mLeft; }
    inline void setLeft(qint64 left) { mLeft = left; }

    inline qint64 right() const { return mRight; }
    inline void setRight(qint64 right) { mRight = right; }

    inline QByteArray type() const { return mType; }
    inline void setType(const QByteArray &type) { mType = type; }
    inline void setType(QByteArray &&type) { mType = std::move(type); }

    void toJson(QJsonObject &stream) const;
protected:
    qint64 mLeft = -1;
    qint64 mRight = -1;
    QByteArray mType;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::RemoveRelationsCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::RemoveRelationsCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::RemoveRelationsCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::RemoveRelationsCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::RemoveRelationsCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const RemoveRelationsResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, RemoveRelationsResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const RemoveRelationsResponse &obj);

using RemoveRelationsResponsePtr = QSharedPointer<RemoveRelationsResponse>;

class AKONADIPRIVATE_EXPORT RemoveRelationsResponse : public Response
{

public:
    explicit RemoveRelationsResponse();
    RemoveRelationsResponse(const RemoveRelationsResponse &) = default;
    RemoveRelationsResponse(RemoveRelationsResponse &&) = default;
    ~RemoveRelationsResponse() = default;

    RemoveRelationsResponse &operator=(const RemoveRelationsResponse &) = default;
    RemoveRelationsResponse &operator=(RemoveRelationsResponse &&) = default;
    bool operator==(const RemoveRelationsResponse &other) const;
    inline bool operator!=(const RemoveRelationsResponse &other) const { return !operator==(other); }
    void toJson(QJsonObject &stream) const;
protected:

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::RemoveRelationsResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::RemoveRelationsResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::RemoveRelationsResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::RemoveRelationsResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::RemoveRelationsResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const SelectResourceCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, SelectResourceCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const SelectResourceCommand &obj);

using SelectResourceCommandPtr = QSharedPointer<SelectResourceCommand>;

class AKONADIPRIVATE_EXPORT SelectResourceCommand : public Command
{

public:
    explicit SelectResourceCommand();
    explicit SelectResourceCommand(const QString &resourceId);
    SelectResourceCommand(const SelectResourceCommand &) = default;
    SelectResourceCommand(SelectResourceCommand &&) = default;
    ~SelectResourceCommand() = default;

    SelectResourceCommand &operator=(const SelectResourceCommand &) = default;
    SelectResourceCommand &operator=(SelectResourceCommand &&) = default;
    bool operator==(const SelectResourceCommand &other) const;
    inline bool operator!=(const SelectResourceCommand &other) const { return !operator==(other); }
    inline QString resourceId() const { return mResourceId; }
    inline void setResourceId(const QString &resourceId) { mResourceId = resourceId; }
    inline void setResourceId(QString &&resourceId) { mResourceId = std::move(resourceId); }

    void toJson(QJsonObject &stream) const;
protected:
    QString mResourceId;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::SelectResourceCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::SelectResourceCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::SelectResourceCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::SelectResourceCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::SelectResourceCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const SelectResourceResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, SelectResourceResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const SelectResourceResponse &obj);

using SelectResourceResponsePtr = QSharedPointer<SelectResourceResponse>;

class AKONADIPRIVATE_EXPORT SelectResourceResponse : public Response
{

public:
    explicit SelectResourceResponse();
    SelectResourceResponse(const SelectResourceResponse &) = default;
    SelectResourceResponse(SelectResourceResponse &&) = default;
    ~SelectResourceResponse() = default;

    SelectResourceResponse &operator=(const SelectResourceResponse &) = default;
    SelectResourceResponse &operator=(SelectResourceResponse &&) = default;
    bool operator==(const SelectResourceResponse &other) const;
    inline bool operator!=(const SelectResourceResponse &other) const { return !operator==(other); }
    void toJson(QJsonObject &stream) const;
protected:

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::SelectResourceResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::SelectResourceResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::SelectResourceResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::SelectResourceResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::SelectResourceResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const StreamPayloadCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, StreamPayloadCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const StreamPayloadCommand &obj);

using StreamPayloadCommandPtr = QSharedPointer<StreamPayloadCommand>;

class AKONADIPRIVATE_EXPORT StreamPayloadCommand : public Command
{

public:
    enum Request {
        MetaData,
        Data,
    };
    explicit StreamPayloadCommand();
    explicit StreamPayloadCommand(const QByteArray &payloadName, const StreamPayloadCommand::Request &request, const QString &destination = QString());
    StreamPayloadCommand(const StreamPayloadCommand &) = default;
    StreamPayloadCommand(StreamPayloadCommand &&) = default;
    ~StreamPayloadCommand() = default;

    StreamPayloadCommand &operator=(const StreamPayloadCommand &) = default;
    StreamPayloadCommand &operator=(StreamPayloadCommand &&) = default;
    bool operator==(const StreamPayloadCommand &other) const;
    inline bool operator!=(const StreamPayloadCommand &other) const { return !operator==(other); }
    inline QByteArray payloadName() const { return mPayloadName; }
    inline void setPayloadName(const QByteArray &payloadName) { mPayloadName = payloadName; }
    inline void setPayloadName(QByteArray &&payloadName) { mPayloadName = std::move(payloadName); }

    inline QString destination() const { return mDestination; }
    inline void setDestination(const QString &destination) { mDestination = destination; }
    inline void setDestination(QString &&destination) { mDestination = std::move(destination); }

    inline StreamPayloadCommand::Request request() const { return mRequest; }
    inline void setRequest(const StreamPayloadCommand::Request &request) { mRequest = request; }
    inline void setRequest(StreamPayloadCommand::Request &&request) { mRequest = std::move(request); }

    void toJson(QJsonObject &stream) const;
protected:
    QByteArray mPayloadName;
    QString mDestination;
    StreamPayloadCommand::Request mRequest = MetaData;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::StreamPayloadCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::StreamPayloadCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::StreamPayloadCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::StreamPayloadCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::StreamPayloadCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const StreamPayloadResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, StreamPayloadResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const StreamPayloadResponse &obj);

using StreamPayloadResponsePtr = QSharedPointer<StreamPayloadResponse>;

class AKONADIPRIVATE_EXPORT StreamPayloadResponse : public Response
{

public:
    explicit StreamPayloadResponse();
    explicit StreamPayloadResponse(const QByteArray &payloadName, const Akonadi::Protocol::PartMetaData &metaData = PartMetaData());
    explicit StreamPayloadResponse(const QByteArray &payloadName, const QByteArray &data);
    explicit StreamPayloadResponse(const QByteArray &payloadName, const Akonadi::Protocol::PartMetaData &metaData, const QByteArray &data);
    StreamPayloadResponse(const StreamPayloadResponse &) = default;
    StreamPayloadResponse(StreamPayloadResponse &&) = default;
    ~StreamPayloadResponse() = default;

    StreamPayloadResponse &operator=(const StreamPayloadResponse &) = default;
    StreamPayloadResponse &operator=(StreamPayloadResponse &&) = default;
    bool operator==(const StreamPayloadResponse &other) const;
    inline bool operator!=(const StreamPayloadResponse &other) const { return !operator==(other); }
    inline QByteArray payloadName() const { return mPayloadName; }
    inline void setPayloadName(const QByteArray &payloadName) { mPayloadName = payloadName; }
    inline void setPayloadName(QByteArray &&payloadName) { mPayloadName = std::move(payloadName); }

    inline Akonadi::Protocol::PartMetaData metaData() const { return mMetaData; }
    inline void setMetaData(const Akonadi::Protocol::PartMetaData &metaData) { mMetaData = metaData; }
    inline void setMetaData(Akonadi::Protocol::PartMetaData &&metaData) { mMetaData = std::move(metaData); }

    inline QByteArray data() const { return mData; }
    inline void setData(const QByteArray &data) { mData = data; }
    inline void setData(QByteArray &&data) { mData = std::move(data); }

    void toJson(QJsonObject &stream) const;
protected:
    QByteArray mPayloadName;
    QByteArray mData;
    Akonadi::Protocol::PartMetaData mMetaData;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::StreamPayloadResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::StreamPayloadResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::StreamPayloadResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::StreamPayloadResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::StreamPayloadResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const ItemChangeNotification &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, ItemChangeNotification &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const ItemChangeNotification &obj);

using ItemChangeNotificationPtr = QSharedPointer<ItemChangeNotification>;

class AKONADIPRIVATE_EXPORT ItemChangeNotification : public ChangeNotification
{

public:
    enum Operation {
        InvalidOp = 0,
        Add,
        Modify,
        Move,
        Remove,
        Link,
        Unlink,
        ModifyFlags,
        ModifyTags,
        ModifyRelations,
    };
    explicit ItemChangeNotification();
    ItemChangeNotification(const ItemChangeNotification &) = default;
    ItemChangeNotification(ItemChangeNotification &&) = default;
    ~ItemChangeNotification() = default;

    ItemChangeNotification &operator=(const ItemChangeNotification &) = default;
    ItemChangeNotification &operator=(ItemChangeNotification &&) = default;
    bool operator==(const ItemChangeNotification &other) const;
    inline bool operator!=(const ItemChangeNotification &other) const { return !operator==(other); }
    inline ItemChangeNotification::Operation operation() const { return mOperation; }
    inline void setOperation(const ItemChangeNotification::Operation &operation) { mOperation = operation; }
    inline void setOperation(ItemChangeNotification::Operation &&operation) { mOperation = std::move(operation); }

    inline QByteArray resource() const { return mResource; }
    inline void setResource(const QByteArray &resource) { mResource = resource; }
    inline void setResource(QByteArray &&resource) { mResource = std::move(resource); }

    inline qint64 parentCollection() const { return mParentCollection; }
    inline void setParentCollection(qint64 parentCollection) { mParentCollection = parentCollection; }

    inline qint64 parentDestCollection() const { return mParentDestCollection; }
    inline void setParentDestCollection(qint64 parentDestCollection) { mParentDestCollection = parentDestCollection; }

    inline QByteArray destinationResource() const { return mDestinationResource; }
    inline void setDestinationResource(const QByteArray &destinationResource) { mDestinationResource = destinationResource; }
    inline void setDestinationResource(QByteArray &&destinationResource) { mDestinationResource = std::move(destinationResource); }

    inline QSet<QByteArray> itemParts() const { return mItemParts; }
    inline void setItemParts(const QSet<QByteArray> &itemParts) { mItemParts = itemParts; }
    inline void setItemParts(QSet<QByteArray> &&itemParts) { mItemParts = std::move(itemParts); }

    inline QSet<QByteArray> addedFlags() const { return mAddedFlags; }
    inline void setAddedFlags(const QSet<QByteArray> &addedFlags) { mAddedFlags = addedFlags; }
    inline void setAddedFlags(QSet<QByteArray> &&addedFlags) { mAddedFlags = std::move(addedFlags); }

    inline QSet<QByteArray> removedFlags() const { return mRemovedFlags; }
    inline void setRemovedFlags(const QSet<QByteArray> &removedFlags) { mRemovedFlags = removedFlags; }
    inline void setRemovedFlags(QSet<QByteArray> &&removedFlags) { mRemovedFlags = std::move(removedFlags); }

    inline QSet<qint64> addedTags() const { return mAddedTags; }
    inline void setAddedTags(const QSet<qint64> &addedTags) { mAddedTags = addedTags; }
    inline void setAddedTags(QSet<qint64> &&addedTags) { mAddedTags = std::move(addedTags); }

    inline QSet<qint64> removedTags() const { return mRemovedTags; }
    inline void setRemovedTags(const QSet<qint64> &removedTags) { mRemovedTags = removedTags; }
    inline void setRemovedTags(QSet<qint64> &&removedTags) { mRemovedTags = std::move(removedTags); }

    inline QSet<Akonadi::Protocol::ChangeNotification::Relation> addedRelations() const { return mAddedRelations; }
    inline void setAddedRelations(const QSet<Akonadi::Protocol::ChangeNotification::Relation> &addedRelations) { mAddedRelations = addedRelations; }
    inline void setAddedRelations(QSet<Akonadi::Protocol::ChangeNotification::Relation> &&addedRelations) { mAddedRelations = std::move(addedRelations); }

    inline QSet<Akonadi::Protocol::ChangeNotification::Relation> removedRelations() const { return mRemovedRelations; }
    inline void setRemovedRelations(const QSet<Akonadi::Protocol::ChangeNotification::Relation> &removedRelations) { mRemovedRelations = removedRelations; }
    inline void setRemovedRelations(QSet<Akonadi::Protocol::ChangeNotification::Relation> &&removedRelations) { mRemovedRelations = std::move(removedRelations); }

    inline bool mustRetrieve() const { return mMustRetrieve; }
    inline void setMustRetrieve(bool mustRetrieve) { mMustRetrieve = mustRetrieve; }

    inline const QVector<Akonadi::Protocol::FetchItemsResponse> &items() const { return mItems; }
    inline QVector<Akonadi::Protocol::FetchItemsResponse> &items() { return mItems; }
    inline void setItems(const QVector<Akonadi::Protocol::FetchItemsResponse> &items) { mItems = items; }
    inline void setItems(QVector<Akonadi::Protocol::FetchItemsResponse> &&items) { mItems = std::move(items); }

    void toJson(QJsonObject &stream) const;
protected:
    QByteArray mResource;
    qint64 mParentCollection = -1;
    qint64 mParentDestCollection = -1;
    QByteArray mDestinationResource;
    QSet<QByteArray> mItemParts;
    QSet<QByteArray> mAddedFlags;
    QSet<QByteArray> mRemovedFlags;
    QSet<qint64> mAddedTags;
    QSet<qint64> mRemovedTags;
    QSet<Akonadi::Protocol::ChangeNotification::Relation> mAddedRelations;
    QSet<Akonadi::Protocol::ChangeNotification::Relation> mRemovedRelations;
    QVector<Akonadi::Protocol::FetchItemsResponse> mItems;
    ItemChangeNotification::Operation mOperation = InvalidOp;
    bool mMustRetrieve = false;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::ItemChangeNotification &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::ItemChangeNotification &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::ItemChangeNotification &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::ItemChangeNotification)

Q_DECLARE_METATYPE(Akonadi::Protocol::ItemChangeNotificationPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const CollectionChangeNotification &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, CollectionChangeNotification &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const CollectionChangeNotification &obj);

using CollectionChangeNotificationPtr = QSharedPointer<CollectionChangeNotification>;

class AKONADIPRIVATE_EXPORT CollectionChangeNotification : public ChangeNotification
{

public:
    enum Operation {
        InvalidOp,
        Add,
        Modify,
        Move,
        Remove,
        Subscribe,
        Unsubscribe,
    };
    explicit CollectionChangeNotification();
    CollectionChangeNotification(const CollectionChangeNotification &) = default;
    CollectionChangeNotification(CollectionChangeNotification &&) = default;
    ~CollectionChangeNotification() = default;

    CollectionChangeNotification &operator=(const CollectionChangeNotification &) = default;
    CollectionChangeNotification &operator=(CollectionChangeNotification &&) = default;
    bool operator==(const CollectionChangeNotification &other) const;
    inline bool operator!=(const CollectionChangeNotification &other) const { return !operator==(other); }
    inline CollectionChangeNotification::Operation operation() const { return mOperation; }
    inline void setOperation(const CollectionChangeNotification::Operation &operation) { mOperation = operation; }
    inline void setOperation(CollectionChangeNotification::Operation &&operation) { mOperation = std::move(operation); }

    inline QByteArray resource() const { return mResource; }
    inline void setResource(const QByteArray &resource) { mResource = resource; }
    inline void setResource(QByteArray &&resource) { mResource = std::move(resource); }

    inline qint64 parentCollection() const { return mParentCollection; }
    inline void setParentCollection(qint64 parentCollection) { mParentCollection = parentCollection; }

    inline qint64 parentDestCollection() const { return mParentDestCollection; }
    inline void setParentDestCollection(qint64 parentDestCollection) { mParentDestCollection = parentDestCollection; }

    inline QByteArray destinationResource() const { return mDestinationResource; }
    inline void setDestinationResource(const QByteArray &destinationResource) { mDestinationResource = destinationResource; }
    inline void setDestinationResource(QByteArray &&destinationResource) { mDestinationResource = std::move(destinationResource); }

    inline QSet<QByteArray> changedParts() const { return mChangedParts; }
    inline void setChangedParts(const QSet<QByteArray> &changedParts) { mChangedParts = changedParts; }
    inline void setChangedParts(QSet<QByteArray> &&changedParts) { mChangedParts = std::move(changedParts); }

    inline const Akonadi::Protocol::FetchCollectionsResponse &collection() const { return mCollection; }
    inline Akonadi::Protocol::FetchCollectionsResponse &collection() { return mCollection; }
    inline void setCollection(const Akonadi::Protocol::FetchCollectionsResponse &collection) { mCollection = collection; }
    inline void setCollection(Akonadi::Protocol::FetchCollectionsResponse &&collection) { mCollection = std::move(collection); }

    void toJson(QJsonObject &stream) const;
protected:
    QByteArray mResource;
    qint64 mParentCollection = -1;
    qint64 mParentDestCollection = -1;
    QByteArray mDestinationResource;
    QSet<QByteArray> mChangedParts;
    CollectionChangeNotification::Operation mOperation = InvalidOp;
    Akonadi::Protocol::FetchCollectionsResponse mCollection;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::CollectionChangeNotification &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::CollectionChangeNotification &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::CollectionChangeNotification &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::CollectionChangeNotification)

Q_DECLARE_METATYPE(Akonadi::Protocol::CollectionChangeNotificationPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const TagChangeNotification &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, TagChangeNotification &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const TagChangeNotification &obj);

using TagChangeNotificationPtr = QSharedPointer<TagChangeNotification>;

class AKONADIPRIVATE_EXPORT TagChangeNotification : public ChangeNotification
{

public:
    enum Operation {
        InvalidOp,
        Add,
        Modify,
        Remove,
    };
    explicit TagChangeNotification();
    TagChangeNotification(const TagChangeNotification &) = default;
    TagChangeNotification(TagChangeNotification &&) = default;
    ~TagChangeNotification() = default;

    TagChangeNotification &operator=(const TagChangeNotification &) = default;
    TagChangeNotification &operator=(TagChangeNotification &&) = default;
    bool operator==(const TagChangeNotification &other) const;
    inline bool operator!=(const TagChangeNotification &other) const { return !operator==(other); }
    inline TagChangeNotification::Operation operation() const { return mOperation; }
    inline void setOperation(const TagChangeNotification::Operation &operation) { mOperation = operation; }
    inline void setOperation(TagChangeNotification::Operation &&operation) { mOperation = std::move(operation); }

    inline QByteArray resource() const { return mResource; }
    inline void setResource(const QByteArray &resource) { mResource = resource; }
    inline void setResource(QByteArray &&resource) { mResource = std::move(resource); }

    inline const Akonadi::Protocol::FetchTagsResponse &tag() const { return mTag; }
    inline Akonadi::Protocol::FetchTagsResponse &tag() { return mTag; }
    inline void setTag(const Akonadi::Protocol::FetchTagsResponse &tag) { mTag = tag; }
    inline void setTag(Akonadi::Protocol::FetchTagsResponse &&tag) { mTag = std::move(tag); }

    void toJson(QJsonObject &stream) const;
protected:
    QByteArray mResource;
    TagChangeNotification::Operation mOperation = InvalidOp;
    Akonadi::Protocol::FetchTagsResponse mTag;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::TagChangeNotification &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::TagChangeNotification &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::TagChangeNotification &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::TagChangeNotification)

Q_DECLARE_METATYPE(Akonadi::Protocol::TagChangeNotificationPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const RelationChangeNotification &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, RelationChangeNotification &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const RelationChangeNotification &obj);

using RelationChangeNotificationPtr = QSharedPointer<RelationChangeNotification>;

class AKONADIPRIVATE_EXPORT RelationChangeNotification : public ChangeNotification
{

public:
    enum Operation {
        InvalidOp,
        Add,
        Remove,
    };
    explicit RelationChangeNotification();
    RelationChangeNotification(const RelationChangeNotification &) = default;
    RelationChangeNotification(RelationChangeNotification &&) = default;
    ~RelationChangeNotification() = default;

    RelationChangeNotification &operator=(const RelationChangeNotification &) = default;
    RelationChangeNotification &operator=(RelationChangeNotification &&) = default;
    bool operator==(const RelationChangeNotification &other) const;
    inline bool operator!=(const RelationChangeNotification &other) const { return !operator==(other); }
    inline RelationChangeNotification::Operation operation() const { return mOperation; }
    inline void setOperation(const RelationChangeNotification::Operation &operation) { mOperation = operation; }
    inline void setOperation(RelationChangeNotification::Operation &&operation) { mOperation = std::move(operation); }

    inline const Akonadi::Protocol::FetchRelationsResponse &relation() const { return mRelation; }
    inline Akonadi::Protocol::FetchRelationsResponse &relation() { return mRelation; }
    inline void setRelation(const Akonadi::Protocol::FetchRelationsResponse &relation) { mRelation = relation; }
    inline void setRelation(Akonadi::Protocol::FetchRelationsResponse &&relation) { mRelation = std::move(relation); }

    void toJson(QJsonObject &stream) const;
protected:
    RelationChangeNotification::Operation mOperation = InvalidOp;
    Akonadi::Protocol::FetchRelationsResponse mRelation;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::RelationChangeNotification &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::RelationChangeNotification &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::RelationChangeNotification &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::RelationChangeNotification)

Q_DECLARE_METATYPE(Akonadi::Protocol::RelationChangeNotificationPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const CreateSubscriptionCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, CreateSubscriptionCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const CreateSubscriptionCommand &obj);

using CreateSubscriptionCommandPtr = QSharedPointer<CreateSubscriptionCommand>;

class AKONADIPRIVATE_EXPORT CreateSubscriptionCommand : public Command
{

public:
    explicit CreateSubscriptionCommand();
    explicit CreateSubscriptionCommand(const QByteArray &subscriberName, const QByteArray &session = QByteArray());
    CreateSubscriptionCommand(const CreateSubscriptionCommand &) = default;
    CreateSubscriptionCommand(CreateSubscriptionCommand &&) = default;
    ~CreateSubscriptionCommand() = default;

    CreateSubscriptionCommand &operator=(const CreateSubscriptionCommand &) = default;
    CreateSubscriptionCommand &operator=(CreateSubscriptionCommand &&) = default;
    bool operator==(const CreateSubscriptionCommand &other) const;
    inline bool operator!=(const CreateSubscriptionCommand &other) const { return !operator==(other); }
    inline QByteArray subscriberName() const { return mSubscriberName; }
    inline void setSubscriberName(const QByteArray &subscriberName) { mSubscriberName = subscriberName; }
    inline void setSubscriberName(QByteArray &&subscriberName) { mSubscriberName = std::move(subscriberName); }

    inline QByteArray session() const { return mSession; }
    inline void setSession(const QByteArray &session) { mSession = session; }
    inline void setSession(QByteArray &&session) { mSession = std::move(session); }

    void toJson(QJsonObject &stream) const;
protected:
    QByteArray mSubscriberName;
    QByteArray mSession;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::CreateSubscriptionCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::CreateSubscriptionCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::CreateSubscriptionCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::CreateSubscriptionCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::CreateSubscriptionCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const CreateSubscriptionResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, CreateSubscriptionResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const CreateSubscriptionResponse &obj);

using CreateSubscriptionResponsePtr = QSharedPointer<CreateSubscriptionResponse>;

class AKONADIPRIVATE_EXPORT CreateSubscriptionResponse : public Response
{

public:
    explicit CreateSubscriptionResponse();
    CreateSubscriptionResponse(const CreateSubscriptionResponse &) = default;
    CreateSubscriptionResponse(CreateSubscriptionResponse &&) = default;
    ~CreateSubscriptionResponse() = default;

    CreateSubscriptionResponse &operator=(const CreateSubscriptionResponse &) = default;
    CreateSubscriptionResponse &operator=(CreateSubscriptionResponse &&) = default;
    bool operator==(const CreateSubscriptionResponse &other) const;
    inline bool operator!=(const CreateSubscriptionResponse &other) const { return !operator==(other); }
    void toJson(QJsonObject &stream) const;
protected:

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::CreateSubscriptionResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::CreateSubscriptionResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::CreateSubscriptionResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::CreateSubscriptionResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::CreateSubscriptionResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const ModifySubscriptionCommand &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, ModifySubscriptionCommand &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const ModifySubscriptionCommand &obj);

using ModifySubscriptionCommandPtr = QSharedPointer<ModifySubscriptionCommand>;

class AKONADIPRIVATE_EXPORT ModifySubscriptionCommand : public Command
{

public:
    enum ModifiedPart {
        None = 0,
        Collections = 1 << 0,
        Items = 1 << 1,
        Tags = 1 << 2,
        Types = 1 << 3,
        Resources = 1 << 4,
        MimeTypes = 1 << 5,
        AllFlag = 1 << 6,
        ExclusiveFlag = 1 << 7,
        Sessions = 1 << 8,
        Add = 1 << 9,
        Remove = 1 << 10,
        ItemFetchScope = 1 << 11,
        CollectionFetchScope = 1 << 12,
        TagFetchScope = 1 << 13,
    };
    Q_DECLARE_FLAGS(ModifiedParts, ModifiedPart)

    enum ChangeType {
        NoType,
        ItemChanges,
        CollectionChanges,
        TagChanges,
        RelationChanges,
        SubscriptionChanges,
        ChangeNotifications,
    };
    explicit ModifySubscriptionCommand();
    ModifySubscriptionCommand(const ModifySubscriptionCommand &) = default;
    ModifySubscriptionCommand(ModifySubscriptionCommand &&) = default;
    ~ModifySubscriptionCommand() = default;

    ModifySubscriptionCommand &operator=(const ModifySubscriptionCommand &) = default;
    ModifySubscriptionCommand &operator=(ModifySubscriptionCommand &&) = default;
    bool operator==(const ModifySubscriptionCommand &other) const;
    inline bool operator!=(const ModifySubscriptionCommand &other) const { return !operator==(other); }
    inline ModifySubscriptionCommand::ModifiedParts modifiedParts() const { return mModifiedParts; }
    inline void setModifiedParts(const ModifySubscriptionCommand::ModifiedParts &modifiedParts) { mModifiedParts = modifiedParts; }
    inline void setModifiedParts(ModifySubscriptionCommand::ModifiedParts &&modifiedParts) { mModifiedParts = std::move(modifiedParts); }

    inline QByteArray subscriberName() const { return mSubscriberName; }
    inline void setSubscriberName(const QByteArray &subscriberName) { mSubscriberName = subscriberName; }
    inline void setSubscriberName(QByteArray &&subscriberName) { mSubscriberName = std::move(subscriberName); }

    inline QVector<qint64> startMonitoringCollections() const { return mStartMonitoringCollections; }
    void startMonitoringCollection(const qint64 &startMonitoringCollections);

    inline QVector<qint64> stopMonitoringCollections() const { return mStopMonitoringCollections; }
    void stopMonitoringCollection(const qint64 &stopMonitoringCollections);

    inline QVector<qint64> startMonitoringItems() const { return mStartMonitoringItems; }
    void startMonitoringItem(const qint64 &startMonitoringItems);

    inline QVector<qint64> stopMonitoringItems() const { return mStopMonitoringItems; }
    void stopMonitoringItem(const qint64 &stopMonitoringItems);

    inline QVector<qint64> startMonitoringTags() const { return mStartMonitoringTags; }
    void startMonitoringTag(const qint64 &startMonitoringTags);

    inline QVector<qint64> stopMonitoringTags() const { return mStopMonitoringTags; }
    void stopMonitoringTag(const qint64 &stopMonitoringTags);

    inline QVector<ModifySubscriptionCommand::ChangeType> startMonitoringTypes() const { return mStartMonitoringTypes; }
    void startMonitoringType(const ModifySubscriptionCommand::ChangeType &startMonitoringTypes);

    inline QVector<ModifySubscriptionCommand::ChangeType> stopMonitoringTypes() const { return mStopMonitoringTypes; }
    void stopMonitoringType(const ModifySubscriptionCommand::ChangeType &stopMonitoringTypes);

    inline QVector<QByteArray> startMonitoringResources() const { return mStartMonitoringResources; }
    void startMonitoringResource(const QByteArray &startMonitoringResources);

    inline QVector<QByteArray> stopMonitoringResources() const { return mStopMonitoringResources; }
    void stopMonitoringResource(const QByteArray &stopMonitoringResources);

    inline QStringList startMonitoringMimeTypes() const { return mStartMonitoringMimeTypes; }
    void startMonitoringMimeType(const QString &startMonitoringMimeTypes);

    inline QStringList stopMonitoringMimeTypes() const { return mStopMonitoringMimeTypes; }
    void stopMonitoringMimeType(const QString &stopMonitoringMimeTypes);

    inline bool allMonitored() const { return mAllMonitored; }
    void setAllMonitored(bool allMonitored);

    inline bool isExclusive() const { return mIsExclusive; }
    void setIsExclusive(bool isExclusive);

    inline QVector<QByteArray> startIgnoringSessions() const { return mStartIgnoringSessions; }
    void startIgnoringSession(const QByteArray &startIgnoringSessions);

    inline QVector<QByteArray> stopIgnoringSessions() const { return mStopIgnoringSessions; }
    void stopIgnoringSession(const QByteArray &stopIgnoringSessions);

    inline Akonadi::Protocol::ItemFetchScope itemFetchScope() const { return mItemFetchScope; }
    void setItemFetchScope(const Akonadi::Protocol::ItemFetchScope &itemFetchScope);

    inline Akonadi::Protocol::CollectionFetchScope collectionFetchScope() const { return mCollectionFetchScope; }
    void setCollectionFetchScope(const Akonadi::Protocol::CollectionFetchScope &collectionFetchScope);

    inline Akonadi::Protocol::TagFetchScope tagFetchScope() const { return mTagFetchScope; }
    void setTagFetchScope(const Akonadi::Protocol::TagFetchScope &tagFetchScope);

    void toJson(QJsonObject &stream) const;
protected:
    QByteArray mSubscriberName;
    QVector<QByteArray> mStopIgnoringSessions;
    QVector<QByteArray> mStartIgnoringSessions;
    QStringList mStopMonitoringMimeTypes;
    QStringList mStartMonitoringMimeTypes;
    QVector<QByteArray> mStopMonitoringResources;
    QVector<QByteArray> mStartMonitoringResources;
    QVector<ModifySubscriptionCommand::ChangeType> mStopMonitoringTypes;
    QVector<ModifySubscriptionCommand::ChangeType> mStartMonitoringTypes;
    QVector<qint64> mStopMonitoringTags;
    QVector<qint64> mStartMonitoringTags;
    QVector<qint64> mStopMonitoringItems;
    QVector<qint64> mStartMonitoringItems;
    QVector<qint64> mStopMonitoringCollections;
    QVector<qint64> mStartMonitoringCollections;
    ModifySubscriptionCommand::ModifiedParts mModifiedParts = None;
    Akonadi::Protocol::ItemFetchScope mItemFetchScope;
    Akonadi::Protocol::CollectionFetchScope mCollectionFetchScope;
    Akonadi::Protocol::TagFetchScope mTagFetchScope;
    bool mAllMonitored = false;
    bool mIsExclusive = false;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::ModifySubscriptionCommand &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::ModifySubscriptionCommand &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::ModifySubscriptionCommand &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::ModifySubscriptionCommand)

Q_DECLARE_METATYPE(Akonadi::Protocol::ModifySubscriptionCommandPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const ModifySubscriptionResponse &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, ModifySubscriptionResponse &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const ModifySubscriptionResponse &obj);

using ModifySubscriptionResponsePtr = QSharedPointer<ModifySubscriptionResponse>;

class AKONADIPRIVATE_EXPORT ModifySubscriptionResponse : public Response
{

public:
    explicit ModifySubscriptionResponse();
    ModifySubscriptionResponse(const ModifySubscriptionResponse &) = default;
    ModifySubscriptionResponse(ModifySubscriptionResponse &&) = default;
    ~ModifySubscriptionResponse() = default;

    ModifySubscriptionResponse &operator=(const ModifySubscriptionResponse &) = default;
    ModifySubscriptionResponse &operator=(ModifySubscriptionResponse &&) = default;
    bool operator==(const ModifySubscriptionResponse &other) const;
    inline bool operator!=(const ModifySubscriptionResponse &other) const { return !operator==(other); }
    void toJson(QJsonObject &stream) const;
protected:

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::ModifySubscriptionResponse &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::ModifySubscriptionResponse &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::ModifySubscriptionResponse &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::ModifySubscriptionResponse)

Q_DECLARE_METATYPE(Akonadi::Protocol::ModifySubscriptionResponsePtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const SubscriptionChangeNotification &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, SubscriptionChangeNotification &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const SubscriptionChangeNotification &obj);

using SubscriptionChangeNotificationPtr = QSharedPointer<SubscriptionChangeNotification>;

class AKONADIPRIVATE_EXPORT SubscriptionChangeNotification : public ChangeNotification
{

public:
    enum Operation {
        InvalidOp,
        Add,
        Modify,
        Remove,
    };
    explicit SubscriptionChangeNotification();
    SubscriptionChangeNotification(const SubscriptionChangeNotification &) = default;
    SubscriptionChangeNotification(SubscriptionChangeNotification &&) = default;
    ~SubscriptionChangeNotification() = default;

    SubscriptionChangeNotification &operator=(const SubscriptionChangeNotification &) = default;
    SubscriptionChangeNotification &operator=(SubscriptionChangeNotification &&) = default;
    bool operator==(const SubscriptionChangeNotification &other) const;
    inline bool operator!=(const SubscriptionChangeNotification &other) const { return !operator==(other); }
    inline SubscriptionChangeNotification::Operation operation() const { return mOperation; }
    inline void setOperation(const SubscriptionChangeNotification::Operation &operation) { mOperation = operation; }
    inline void setOperation(SubscriptionChangeNotification::Operation &&operation) { mOperation = std::move(operation); }

    inline QByteArray subscriber() const { return mSubscriber; }
    inline void setSubscriber(const QByteArray &subscriber) { mSubscriber = subscriber; }
    inline void setSubscriber(QByteArray &&subscriber) { mSubscriber = std::move(subscriber); }

    inline QSet<qint64> collections() const { return mCollections; }
    inline void setCollections(const QSet<qint64> &collections) { mCollections = collections; }
    inline void setCollections(QSet<qint64> &&collections) { mCollections = std::move(collections); }

    inline QSet<qint64> items() const { return mItems; }
    inline void setItems(const QSet<qint64> &items) { mItems = items; }
    inline void setItems(QSet<qint64> &&items) { mItems = std::move(items); }

    inline QSet<qint64> tags() const { return mTags; }
    inline void setTags(const QSet<qint64> &tags) { mTags = tags; }
    inline void setTags(QSet<qint64> &&tags) { mTags = std::move(tags); }

    inline QSet<ModifySubscriptionCommand::ChangeType> types() const { return mTypes; }
    inline void setTypes(const QSet<ModifySubscriptionCommand::ChangeType> &types) { mTypes = types; }
    inline void setTypes(QSet<ModifySubscriptionCommand::ChangeType> &&types) { mTypes = std::move(types); }

    inline QSet<QString> mimeTypes() const { return mMimeTypes; }
    inline void setMimeTypes(const QSet<QString> &mimeTypes) { mMimeTypes = mimeTypes; }
    inline void setMimeTypes(QSet<QString> &&mimeTypes) { mMimeTypes = std::move(mimeTypes); }

    inline QSet<QByteArray> resources() const { return mResources; }
    inline void setResources(const QSet<QByteArray> &resources) { mResources = resources; }
    inline void setResources(QSet<QByteArray> &&resources) { mResources = std::move(resources); }

    inline QSet<QByteArray> ignoredSessions() const { return mIgnoredSessions; }
    inline void setIgnoredSessions(const QSet<QByteArray> &ignoredSessions) { mIgnoredSessions = ignoredSessions; }
    inline void setIgnoredSessions(QSet<QByteArray> &&ignoredSessions) { mIgnoredSessions = std::move(ignoredSessions); }

    inline bool allMonitored() const { return mAllMonitored; }
    inline void setAllMonitored(bool allMonitored) { mAllMonitored = allMonitored; }

    inline bool exclusive() const { return mExclusive; }
    inline void setExclusive(bool exclusive) { mExclusive = exclusive; }

    inline Akonadi::Protocol::ItemFetchScope itemFetchScope() const { return mItemFetchScope; }
    inline void setItemFetchScope(const Akonadi::Protocol::ItemFetchScope &itemFetchScope) { mItemFetchScope = itemFetchScope; }
    inline void setItemFetchScope(Akonadi::Protocol::ItemFetchScope &&itemFetchScope) { mItemFetchScope = std::move(itemFetchScope); }

    inline Akonadi::Protocol::TagFetchScope tagFetchScope() const { return mTagFetchScope; }
    inline void setTagFetchScope(const Akonadi::Protocol::TagFetchScope &tagFetchScope) { mTagFetchScope = tagFetchScope; }
    inline void setTagFetchScope(Akonadi::Protocol::TagFetchScope &&tagFetchScope) { mTagFetchScope = std::move(tagFetchScope); }

    inline Akonadi::Protocol::CollectionFetchScope collectionFetchScope() const { return mCollectionFetchScope; }
    inline void setCollectionFetchScope(const Akonadi::Protocol::CollectionFetchScope &collectionFetchScope) { mCollectionFetchScope = collectionFetchScope; }
    inline void setCollectionFetchScope(Akonadi::Protocol::CollectionFetchScope &&collectionFetchScope) { mCollectionFetchScope = std::move(collectionFetchScope); }

    void toJson(QJsonObject &stream) const;
protected:
    QByteArray mSubscriber;
    QSet<qint64> mCollections;
    QSet<qint64> mItems;
    QSet<qint64> mTags;
    QSet<ModifySubscriptionCommand::ChangeType> mTypes;
    QSet<QString> mMimeTypes;
    QSet<QByteArray> mResources;
    QSet<QByteArray> mIgnoredSessions;
    SubscriptionChangeNotification::Operation mOperation = InvalidOp;
    Akonadi::Protocol::ItemFetchScope mItemFetchScope;
    Akonadi::Protocol::TagFetchScope mTagFetchScope;
    Akonadi::Protocol::CollectionFetchScope mCollectionFetchScope;
    bool mAllMonitored = false;
    bool mExclusive = false;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::SubscriptionChangeNotification &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::SubscriptionChangeNotification &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::SubscriptionChangeNotification &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::SubscriptionChangeNotification)

Q_DECLARE_METATYPE(Akonadi::Protocol::SubscriptionChangeNotificationPtr)

namespace Akonadi {
namespace Protocol {

AKONADIPRIVATE_EXPORT DataStream &operator<<(DataStream &stream, const DebugChangeNotification &obj);
AKONADIPRIVATE_EXPORT DataStream &operator>>(DataStream &stream, DebugChangeNotification &obj);
AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const DebugChangeNotification &obj);

using DebugChangeNotificationPtr = QSharedPointer<DebugChangeNotification>;

class AKONADIPRIVATE_EXPORT DebugChangeNotification : public ChangeNotification
{

public:
    explicit DebugChangeNotification();
    DebugChangeNotification(const DebugChangeNotification &) = default;
    DebugChangeNotification(DebugChangeNotification &&) = default;
    ~DebugChangeNotification() = default;

    DebugChangeNotification &operator=(const DebugChangeNotification &) = default;
    DebugChangeNotification &operator=(DebugChangeNotification &&) = default;
    bool operator==(const DebugChangeNotification &other) const;
    inline bool operator!=(const DebugChangeNotification &other) const { return !operator==(other); }
    inline Akonadi::Protocol::ChangeNotificationPtr notification() const { return mNotification; }
    inline void setNotification(const Akonadi::Protocol::ChangeNotificationPtr &notification) { mNotification = notification; }
    inline void setNotification(Akonadi::Protocol::ChangeNotificationPtr &&notification) { mNotification = std::move(notification); }

    inline QVector<QByteArray> listeners() const { return mListeners; }
    inline void setListeners(const QVector<QByteArray> &listeners) { mListeners = listeners; }
    inline void setListeners(QVector<QByteArray> &&listeners) { mListeners = std::move(listeners); }

    inline qint64 timestamp() const { return mTimestamp; }
    inline void setTimestamp(qint64 timestamp) { mTimestamp = timestamp; }

    void toJson(QJsonObject &stream) const;
protected:
    Akonadi::Protocol::ChangeNotificationPtr mNotification;
    QVector<QByteArray> mListeners;
    qint64 mTimestamp = 0;

private:
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator<<(Akonadi::Protocol::DataStream &stream, const Akonadi::Protocol::DebugChangeNotification &obj);
    friend AKONADIPRIVATE_EXPORT Akonadi::Protocol::DataStream &operator>>(Akonadi::Protocol::DataStream &stream, Akonadi::Protocol::DebugChangeNotification &obj);
    friend AKONADIPRIVATE_EXPORT QDebug operator<<(QDebug dbg, const Akonadi::Protocol::DebugChangeNotification &obj);
};

} // namespace Protocol
} // namespace Akonadi

Q_DECLARE_METATYPE(Akonadi::Protocol::DebugChangeNotification)

Q_DECLARE_METATYPE(Akonadi::Protocol::DebugChangeNotificationPtr)

