/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.langdetect;

import java.util.ArrayList;
import opennlp.tools.langdetect.LanguageDetectorContextGenerator;
import opennlp.tools.ngram.NGramModel;
import opennlp.tools.util.StringList;
import opennlp.tools.util.normalizer.AggregateCharSequenceNormalizer;
import opennlp.tools.util.normalizer.CharSequenceNormalizer;

public class DefaultLanguageDetectorContextGenerator
implements LanguageDetectorContextGenerator {
    protected final int minLength;
    protected final int maxLength;
    protected final CharSequenceNormalizer normalizer;

    public DefaultLanguageDetectorContextGenerator(int minLength, int maxLength, CharSequenceNormalizer ... normalizers) {
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.normalizer = new AggregateCharSequenceNormalizer(normalizers);
    }

    @Override
    public String[] getContext(CharSequence document) {
        ArrayList<String> context = new ArrayList<String>();
        NGramModel model = new NGramModel();
        model.add(this.normalizer.normalize(document), this.minLength, this.maxLength);
        for (StringList tokenList : model) {
            if (tokenList.size() <= 0) continue;
            context.add(tokenList.getToken(0));
        }
        return context.toArray(new String[context.size()]);
    }
}

