/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.sql;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.solr.handler.sql.SolrRel;
import org.apache.solr.handler.sql.SolrRules;
import org.apache.solr.handler.sql.SolrTable;
import org.apache.solr.handler.sql.SolrToEnumerableConverterRule;

class SolrTableScan
extends TableScan
implements SolrRel {
    private final SolrTable solrTable;
    private final RelDataType projectRowType;

    SolrTableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, SolrTable solrTable, RelDataType projectRowType) {
        super(cluster, traitSet, table);
        this.solrTable = solrTable;
        this.projectRowType = projectRowType;
        assert (solrTable != null);
        assert (this.getConvention() == SolrRel.CONVENTION);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        float f = this.projectRowType == null ? 1.0f : (float)this.projectRowType.getFieldCount() / 100.0f;
        return super.computeSelfCost(planner, mq).multiplyBy(0.1 * (double)f);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return this;
    }

    public RelDataType deriveRowType() {
        return this.projectRowType != null ? this.projectRowType : super.deriveRowType();
    }

    public void register(RelOptPlanner planner) {
        planner.addRule((RelOptRule)SolrToEnumerableConverterRule.INSTANCE);
        for (RelOptRule rule : SolrRules.RULES) {
            planner.addRule(rule);
        }
        planner.removeRule((RelOptRule)CoreRules.FILTER_REDUCE_EXPRESSIONS);
    }

    @Override
    public void implement(SolrRel.Implementor implementor) {
        implementor.solrTable = this.solrTable;
        implementor.table = this.table;
    }
}

