/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.rest.BaseSolrResource;
import org.apache.solr.rest.ManagedResource;
import org.apache.solr.rest.ManagedResourceObserver;
import org.apache.solr.rest.ManagedResourceStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestManager {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String SCHEMA_BASE_PATH = "/schema";
    public static final String MANAGED_ENDPOINT = "/managed";
    private static final Pattern resourceIdRegex = Pattern.compile("(/config|/schema)(/.*)");
    private static final boolean DECODE = true;
    protected ManagedResourceStorage.StorageIO storageIO;
    protected Registry registry;
    protected Map<String, ManagedResource> managed = new TreeMap<String, ManagedResource>();
    protected RestManagerManagedResource endpoint;
    protected SolrResourceLoader loader;

    public void init(SolrResourceLoader loader, NamedList<String> initArgs, ManagedResourceStorage.StorageIO storageIO) throws SolrException {
        log.debug("Initializing RestManager with initArgs: {}", initArgs);
        if (storageIO == null) {
            throw new IllegalArgumentException("Must provide a valid StorageIO implementation to the RestManager!");
        }
        this.storageIO = storageIO;
        this.loader = loader;
        this.registry = loader.getManagedResourceRegistry();
        this.endpoint = new RestManagerManagedResource(this);
        this.endpoint.loadManagedDataAndNotify(null);
        this.managed.put("/schema/managed", this.endpoint);
        if (log.isDebugEnabled()) {
            log.debug("Initializing {} registered ManagedResources", (Object)this.registry.registered.size());
        }
        for (ManagedResourceRegistration reg : this.registry.registered.values()) {
            this.managed.put(reg.resourceId, this.createManagedResource(reg));
        }
        this.registry.initializedRestManager = this;
    }

    public synchronized ManagedResource addManagedResource(String resourceId, Class<? extends ManagedResource> clazz) {
        ManagedResource res;
        ManagedResourceRegistration existingReg = (ManagedResourceRegistration)this.registry.registered.get(resourceId);
        if (existingReg == null) {
            this.registry.registerManagedResource(resourceId, clazz, null);
            res = this.addRegisteredResource((ManagedResourceRegistration)this.registry.registered.get(resourceId));
        } else {
            res = this.getManagedResource(resourceId);
        }
        return res;
    }

    private synchronized ManagedResource addRegisteredResource(ManagedResourceRegistration reg) {
        String resourceId = reg.resourceId;
        ManagedResource res = this.createManagedResource(reg);
        this.managed.put(resourceId, res);
        log.info("Registered new managed resource {}", (Object)resourceId);
        return res;
    }

    protected ManagedResource createManagedResource(ManagedResourceRegistration reg) throws SolrException {
        ManagedResource res = null;
        try {
            Constructor<? extends ManagedResource> ctor = reg.implClass.getConstructor(String.class, SolrResourceLoader.class, ManagedResourceStorage.StorageIO.class);
            res = ctor.newInstance(reg.resourceId, this.loader, this.storageIO);
            res.loadManagedDataAndNotify(reg.observers);
        }
        catch (Exception e) {
            String errMsg = String.format(Locale.ROOT, "Failed to create new ManagedResource %s of type %s due to: %s", reg.resourceId, reg.implClass.getName(), e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, errMsg, (Throwable)e);
        }
        return res;
    }

    public ManagedResource getManagedResource(String resourceId) {
        ManagedResource res = this.getManagedResourceOrNull(resourceId);
        if (res == null) {
            throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "No ManagedResource registered for path: " + resourceId);
        }
        return res;
    }

    public synchronized ManagedResource getManagedResourceOrNull(String resourceId) {
        return this.managed.get(resourceId);
    }

    public synchronized void deleteManagedResource(ManagedResource res) {
        String resourceId = res.getResourceId();
        ManagedResourceRegistration existingReg = (ManagedResourceRegistration)this.registry.registered.get(resourceId);
        int numObservers = existingReg.observers.size();
        if (numObservers > 0) {
            String errMsg = String.format(Locale.ROOT, "Cannot delete managed resource %s as it is being used by %d Solr components", resourceId, numObservers);
            throw new SolrException(SolrException.ErrorCode.FORBIDDEN, errMsg);
        }
        this.registry.registered.remove(resourceId);
        this.managed.remove(resourceId);
        try {
            res.onResourceDeleted();
        }
        catch (IOException e) {
            log.error("Error when trying to clean-up after deleting {}", (Object)resourceId, (Object)e);
        }
    }

    private static class RestManagerManagedResource
    extends ManagedResource {
        private static final String REST_MANAGER_STORAGE_ID = "/rest/managed";
        private final RestManager restManager;

        public RestManagerManagedResource(RestManager restManager) throws SolrException {
            super(REST_MANAGER_STORAGE_ID, restManager.loader, restManager.storageIO);
            this.restManager = restManager;
        }

        @Override
        protected synchronized void reloadFromStorage() throws SolrException {
            String resourceId = this.getResourceId();
            Object data = null;
            try {
                data = this.storage.load(resourceId);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException ioExc) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to load stored data for " + resourceId + " due to: " + ioExc, (Throwable)ioExc);
            }
            Object managedData = this.processStoredData(data);
            if (this.managedInitArgs == null) {
                this.managedInitArgs = new NamedList();
            }
            if (managedData != null) {
                this.onManagedDataLoadedFromStorage(this.managedInitArgs, managedData);
            }
        }

        @Override
        protected void onManagedDataLoadedFromStorage(NamedList<?> managedInitArgs, Object managedData) throws SolrException {
            if (managedData == null) {
                return;
            }
            List managedList = (List)managedData;
            for (Object next : managedList) {
                Map info = (Map)next;
                String implClass = (String)info.get("class");
                String resourceId = (String)info.get("resourceId");
                Class<ManagedResource> clazz = this.solrResourceLoader.findClass(implClass, ManagedResource.class);
                ManagedResourceRegistration existingReg = (ManagedResourceRegistration)this.restManager.registry.registered.get(resourceId);
                if (existingReg != null) continue;
                this.restManager.registry.registerManagedResource(resourceId, clazz, null);
            }
        }

        @Override
        public synchronized void doPut(BaseSolrResource endpoint, Object json) {
            if (!(json instanceof Map)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Expected Map to create a new ManagedResource but received a " + json.getClass().getName());
            }
            String resourceId = ManagedEndpoint.resolveResourceId(endpoint.getSolrRequest().getPath());
            Map info = (Map)json;
            info.put("resourceId", resourceId);
            this.storeManagedData(this.applyUpdatesToManagedData(json));
        }

        @Override
        protected Object applyUpdatesToManagedData(Object updates) {
            Map info = (Map)updates;
            String implClass = (String)info.get("class");
            String resourceId = (String)info.get("resourceId");
            log.info("Creating a new ManagedResource of type {} at path {}", (Object)implClass, (Object)resourceId);
            Class<ManagedResource> clazz = this.solrResourceLoader.findClass(implClass, ManagedResource.class);
            this.restManager.addManagedResource(resourceId, clazz);
            ArrayList<Map<String, String>> managedList = new ArrayList<Map<String, String>>();
            for (ManagedResourceRegistration reg : this.restManager.registry.getRegistered()) {
                if (!reg.observers.isEmpty()) continue;
                managedList.add(reg.getInfo());
            }
            return managedList;
        }

        @Override
        public void doDeleteChild(BaseSolrResource endpoint, String childId) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Delete child resource not supported!");
        }

        @Override
        public void doGet(BaseSolrResource endpoint, String childId) {
            String path = ManagedEndpoint.resolveResourceId(endpoint.getSolrRequest().getPath());
            Matcher resourceIdMatcher = resourceIdRegex.matcher(path);
            if (!resourceIdMatcher.matches()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Requests to path " + path + " not supported!");
            }
            String filter = resourceIdMatcher.group(1);
            ArrayList<Map<String, String>> regList = new ArrayList<Map<String, String>>();
            for (ManagedResourceRegistration reg : this.restManager.registry.getRegistered()) {
                if (!reg.resourceId.startsWith(filter) || RestManagerManagedResource.class.isAssignableFrom(reg.implClass)) continue;
                regList.add(reg.getInfo());
            }
            endpoint.getSolrResponse().add("managedResources", regList);
        }
    }

    public static class ManagedEndpoint
    extends BaseSolrResource {
        final RestManager restManager;
        protected ManagedResource managedResource;
        protected String childId;

        public ManagedEndpoint(RestManager restManager) {
            this.restManager = restManager;
        }

        public static String resolveResourceId(String path) {
            String resourceId;
            try {
                resourceId = URLDecoder.decode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            int at = resourceId.indexOf(RestManager.SCHEMA_BASE_PATH);
            if (at == -1) {
                at = resourceId.indexOf("/config");
            }
            if (at > 0) {
                resourceId = resourceId.substring(at);
            }
            if (!resourceId.startsWith("/")) {
                resourceId = "/" + resourceId;
            }
            return resourceId;
        }

        @Override
        public void doInit(SolrQueryRequest solrRequest, SolrQueryResponse solrResponse) {
            int lastSlashAt;
            super.doInit(solrRequest, solrResponse);
            String resourceId = ManagedEndpoint.resolveResourceId(solrRequest.getPath());
            this.managedResource = this.restManager.getManagedResourceOrNull(resourceId);
            if (this.managedResource == null && (lastSlashAt = resourceId.lastIndexOf(47)) != -1) {
                String parentResourceId = resourceId.substring(0, lastSlashAt);
                log.info("Resource not found for {}, looking for parent: {}", (Object)resourceId, (Object)parentResourceId);
                this.managedResource = this.restManager.getManagedResourceOrNull(parentResourceId);
                if (this.managedResource != null) {
                    if (!(this.managedResource instanceof ManagedResource.ChildResourceSupport)) {
                        String errMsg = String.format(Locale.ROOT, "%s does not support child resources!", this.managedResource.getResourceId());
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, errMsg);
                    }
                    this.childId = resourceId.substring(lastSlashAt + 1);
                    log.info("Found parent resource {} for child: {}", (Object)parentResourceId, (Object)this.childId);
                }
            }
            if (this.managedResource == null) {
                String method = this.getSolrRequest().getHttpMethod();
                if ("PUT".equals(method) || "POST".equals(method)) {
                    this.managedResource = this.restManager.endpoint;
                } else {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No REST managed resource registered for path " + resourceId);
                }
            }
            log.info("Found ManagedResource [{}] for {}", (Object)this.managedResource, (Object)resourceId);
        }

        public void delegateRequestToManagedResource() {
            SolrQueryRequest req = this.getSolrRequest();
            String method = req.getHttpMethod();
            try {
                switch (method) {
                    case "GET": {
                        this.managedResource.doGet(this, this.childId);
                        break;
                    }
                    case "PUT": {
                        this.managedResource.doPut(this, this.parseJsonFromRequestBody(req));
                        break;
                    }
                    case "POST": {
                        this.managedResource.doPost(this, this.parseJsonFromRequestBody(req));
                        break;
                    }
                    case "DELETE": {
                        this.doDelete();
                    }
                }
            }
            catch (Exception e) {
                this.getSolrResponse().setException(e);
            }
            this.handlePostExecution(log);
        }

        protected void doDelete() {
            if (this.childId != null) {
                try {
                    this.managedResource.doDeleteChild(this, this.childId);
                }
                catch (Exception e) {
                    this.getSolrResponse().setException(e);
                }
            } else {
                try {
                    this.restManager.deleteManagedResource(this.managedResource);
                }
                catch (Exception e) {
                    this.getSolrResponse().setException(e);
                }
            }
            this.handlePostExecution(log);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Object parseJsonFromRequestBody(SolrQueryRequest req) {
            Iterator<ContentStream> iter = req.getContentStreams().iterator();
            if (!iter.hasNext()) throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No JSON body found in request!");
            try (Reader reader = iter.next().getReader();){
                Object object = Utils.fromJSON((Reader)reader);
                return object;
            }
            catch (IOException ioExc) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)ioExc);
            }
        }

        @Override
        protected void addDeprecatedWarning() {
        }
    }

    public static class Registry {
        private Map<String, ManagedResourceRegistration> registered = new TreeMap<String, ManagedResourceRegistration>();
        private RestManager initializedRestManager = null;
        private final Set<String> reservedEndpoints = new HashSet<String>();
        private final Pattern reservedEndpointsPattern;

        public Registry() {
            this.reservedEndpoints.add("/schema/managed");
            this.reservedEndpointsPattern = this.getReservedEndpointsPattern();
        }

        public Set<String> getReservedEndpoints() {
            return Collections.unmodifiableSet(this.reservedEndpoints);
        }

        private Pattern getReservedEndpointsPattern() {
            StringBuilder builder = new StringBuilder();
            builder.append("(");
            boolean notFirst = false;
            for (String reservedEndpoint : this.reservedEndpoints) {
                if (notFirst) {
                    builder.append("|");
                } else {
                    notFirst = true;
                }
                builder.append(reservedEndpoint);
            }
            builder.append(")(?:|/.*)");
            return Pattern.compile(builder.toString());
        }

        public Collection<ManagedResourceRegistration> getRegistered() {
            return Collections.unmodifiableCollection(this.registered.values());
        }

        public synchronized void registerManagedResource(String resourceId, Class<? extends ManagedResource> implClass, ManagedResourceObserver observer) {
            if (resourceId == null) {
                throw new IllegalArgumentException("Must provide a non-null resourceId to register a ManagedResource!");
            }
            Matcher resourceIdValidator = resourceIdRegex.matcher(resourceId);
            if (!resourceIdValidator.matches()) {
                String errMsg = String.format(Locale.ROOT, "Invalid resourceId '%s'; must start with  %s.", resourceId, RestManager.SCHEMA_BASE_PATH);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, errMsg);
            }
            Matcher reservedEndpointsMatcher = this.reservedEndpointsPattern.matcher(resourceId);
            if (reservedEndpointsMatcher.matches()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, reservedEndpointsMatcher.group(1) + " is a reserved endpoint used by the Solr REST API!");
            }
            ManagedResourceRegistration reg = this.registered.get(resourceId);
            if (reg != null) {
                if (!implClass.equals(reg.implClass)) {
                    String errMsg = String.format(Locale.ROOT, "REST API path %s already registered to instances of %s", resourceId, reg.implClass.getName());
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, errMsg);
                }
                if (observer != null) {
                    reg.observers.add(observer);
                    if (log.isInfoEnabled()) {
                        log.info("Added observer of type {} to existing ManagedResource {}", (Object)observer.getClass().getName(), (Object)resourceId);
                    }
                }
            } else {
                this.registered.put(resourceId, new ManagedResourceRegistration(resourceId, implClass, observer));
                if (log.isInfoEnabled()) {
                    log.info("Registered ManagedResource impl {} for path {}", (Object)implClass.getName(), (Object)resourceId);
                }
            }
            if (this.initializedRestManager != null && this.initializedRestManager.getManagedResourceOrNull(resourceId) == null) {
                this.initializedRestManager.addRegisteredResource(this.registered.get(resourceId));
            }
        }
    }

    private static class ManagedResourceRegistration {
        String resourceId;
        Class<? extends ManagedResource> implClass;
        Set<ManagedResourceObserver> observers = new LinkedHashSet<ManagedResourceObserver>();

        private ManagedResourceRegistration(String resourceId, Class<? extends ManagedResource> implClass, ManagedResourceObserver observer) {
            this.resourceId = resourceId;
            this.implClass = implClass;
            if (observer != null) {
                this.observers.add(observer);
            }
        }

        public Map<String, String> getInfo() {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("resourceId", this.resourceId);
            info.put("class", this.implClass.getName());
            info.put("numObservers", String.valueOf(this.observers.size()));
            return info;
        }
    }
}

