/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sevenzipjbinding;

import net.sf.sevenzipjbinding.IOutArchive;
import net.sf.sevenzipjbinding.IOutCreateArchive;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.impl.OutArchive7zImpl;
import net.sf.sevenzipjbinding.impl.OutArchiveBZip2Impl;
import net.sf.sevenzipjbinding.impl.OutArchiveGZipImpl;
import net.sf.sevenzipjbinding.impl.OutArchiveImpl;
import net.sf.sevenzipjbinding.impl.OutArchiveTarImpl;
import net.sf.sevenzipjbinding.impl.OutArchiveZipImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ArchiveFormat {
    ZIP("Zip", OutArchiveZipImpl.class, true),
    TAR("Tar", OutArchiveTarImpl.class, true),
    SPLIT("Split", true),
    RAR("Rar", true),
    LZMA("Lzma", false),
    ISO("Iso", true),
    HFS("HFS", true),
    GZIP("GZip", OutArchiveGZipImpl.class, false),
    CPIO("Cpio", true),
    BZIP2("BZip2", OutArchiveBZip2Impl.class, false),
    SEVEN_ZIP("7z", OutArchive7zImpl.class, true),
    Z("Z", false),
    ARJ("Arj", true),
    CAB("Cab", true),
    LZH("Lzh", true),
    CHM("Chm", true),
    NSIS("Nsis", true),
    DEB("Deb", true),
    RPM("Rpm", true),
    UDF("Udf", true),
    WIM("Wim", true),
    XAR("Xar", true);

    private String methodName;
    private int codecIndex = -2;
    Class<? extends OutArchiveImpl<?>> outArchiveImplementation;
    private boolean supportMultipleFiles;

    private ArchiveFormat(String string2, boolean bl) {
        this(string2, null, bl);
    }

    private ArchiveFormat(String string2, Class<? extends OutArchiveImpl<?>> clazz, boolean bl) {
        this.methodName = string2;
        this.outArchiveImplementation = clazz;
        this.supportMultipleFiles = bl;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isOutArchiveSupported() {
        return this.outArchiveImplementation != null;
    }

    public Class<? extends OutArchiveImpl<?>> getOutArchiveImplementation() {
        return this.outArchiveImplementation;
    }

    public boolean supportMultipleFiles() {
        return this.supportMultipleFiles;
    }

    public String toString() {
        return this.methodName;
    }

    static ArchiveFormat findOutArchiveImplementationToInterface(Class<? extends IOutCreateArchive<?>> clazz) throws SevenZipException {
        for (ArchiveFormat archiveFormat : ArchiveFormat.values()) {
            Class<? extends OutArchiveImpl<?>> clazz2 = archiveFormat.getOutArchiveImplementation();
            if (clazz2 == null || !clazz.isAssignableFrom(clazz2)) continue;
            return archiveFormat;
        }
        throw new SevenZipException("Can't determine corresponding archive format to the interface " + IOutArchive.class.getSimpleName() + ".");
    }
}

