/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.io;

import org.catacombae.io.BasicRandomAccessStream;
import org.catacombae.io.RandomAccessStream;
import org.catacombae.io.ReadableConcatenatedStream;

public class ConcatenatedStream
extends BasicRandomAccessStream {
    private ReadableConcatenatedStream backingFile;

    public ConcatenatedStream(RandomAccessStream firstPart, long startOffset, long length) {
        this.backingFile = new ReadableConcatenatedStream(firstPart, startOffset, length);
    }

    public void addPart(RandomAccessStream newFile, long off, long len) {
        ReadableConcatenatedStream.Part newPart = new ReadableConcatenatedStream.Part(newFile, off, len);
        this.backingFile.parts.add(newPart);
    }

    public void seek(long pos) {
        this.backingFile.seek(pos);
    }

    public int read() {
        return this.backingFile.read();
    }

    public int read(byte[] data) {
        return this.backingFile.read(data);
    }

    public int read(byte[] data, int pos, int len) {
        return this.backingFile.read(data, pos, len);
    }

    public void readFully(byte[] data) {
        this.backingFile.readFully(data);
    }

    public void readFully(byte[] data, int offset, int length) {
        this.backingFile.readFully(data, offset, length);
    }

    public void write(byte[] data, int off, int len) {
        int bytesWritten = 0;
        RandomAccessStream currentWritableFile = (RandomAccessStream)this.backingFile.currentPart.file;
        while (true) {
            int bytesLeftToWrite;
            long bytesLeftInFile;
            int bytesToWrite = (int)((bytesLeftInFile = this.backingFile.currentPart.length - (currentWritableFile.getFilePointer() - this.backingFile.currentPart.startOffset)) < (long)(bytesLeftToWrite = len - bytesWritten) ? bytesLeftInFile : (long)bytesLeftToWrite);
            currentWritableFile.write(data, off + bytesWritten, bytesToWrite);
            if ((bytesWritten += bytesToWrite) >= len) break;
            ++this.backingFile.currentPartIndex;
            this.backingFile.currentPart = this.backingFile.parts.get(this.backingFile.currentPartIndex);
            currentWritableFile = (RandomAccessStream)this.backingFile.currentPart.file;
            currentWritableFile.seek(this.backingFile.currentPart.startOffset);
        }
        if (bytesWritten == len) {
            return;
        }
        throw new RuntimeException("Wrote more than I was supposed to! This can't happen.");
    }

    public long length() {
        return this.backingFile.length();
    }

    public long getFilePointer() {
        return this.backingFile.getFilePointer();
    }

    public void close() {
        this.backingFile.close();
    }
}

