/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.label;

import docking.DialogComponentProvider;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.label.LabelMgrPlugin;
import ghidra.app.plugin.core.symboltree.EditExternalLocationDialog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class EditExternalLabelAction
extends ListingContextAction {
    private static ImageIcon EDIT_ICON = null;
    private static final KeyStroke KEYBINDING = KeyStroke.getKeyStroke(76, 0);
    private LabelMgrPlugin plugin;

    public EditExternalLabelAction(LabelMgrPlugin plugin) {
        super("Edit External Location", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Edit External Location"}, (Icon)EDIT_ICON, "0External"));
        this.setKeyBindingData(new KeyBindingData(KEYBINDING));
        this.setEnabled(true);
    }

    private Symbol getExternalSymbol(ListingActionContext context) {
        Symbol s = null;
        ProgramLocation location = context.getLocation();
        if (location instanceof OperandFieldLocation) {
            OperandFieldLocation opLoc = (OperandFieldLocation)location;
            Address address = opLoc.getAddress();
            int opIndex = opLoc.getOperandIndex();
            Program program = context.getProgram();
            ReferenceManager refMgr = program.getReferenceManager();
            Reference ref = refMgr.getPrimaryReferenceFrom(address, opIndex);
            if (ref != null) {
                s = program.getSymbolTable().getSymbol(ref);
            }
        }
        if (s == null || !s.isExternal()) {
            return null;
        }
        if (s.getSymbolType() == SymbolType.LABEL || s.getSymbolType() == SymbolType.FUNCTION) {
            return s;
        }
        return null;
    }

    @Override
    public boolean isEnabledForContext(ListingActionContext context) {
        return this.getExternalSymbol(context) != null;
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        Symbol symbol = this.getExternalSymbol(context);
        if (symbol == null) {
            return;
        }
        ExternalManager externalManager = context.getProgram().getExternalManager();
        ExternalLocation externalLocation = externalManager.getExternalLocation(symbol);
        if (externalLocation == null) {
            return;
        }
        EditExternalLocationDialog dialog = new EditExternalLocationDialog(externalLocation);
        dialog.setHelpLocation(new HelpLocation("LabelMgrPlugin", "EditExternalLocation"));
        this.plugin.getTool().showDialog((DialogComponentProvider)dialog);
    }
}

