/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBHandle;
import db.Field;
import db.LongField;
import db.Record;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.symbol.OldVariableStorageDBAdapter;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class OldVariableStorageDBAdapterV1
extends OldVariableStorageDBAdapter {
    private static final int TABLE_VERSION = 1;
    private Table variableStorageTable;

    OldVariableStorageDBAdapterV1(DBHandle handle, boolean create) throws VersionException, IOException {
        if (create) {
            this.variableStorageTable = handle.createTable("VariableStorage", VARIABLE_STORAGE_SCHEMA, new int[]{1});
        } else {
            this.variableStorageTable = handle.getTable("VariableStorage");
            if (this.variableStorageTable == null) {
                throw new VersionException(1, true);
            }
            int version = this.variableStorageTable.getSchema().getVersion();
            if (version < 1) {
                throw new VersionException(1, true);
            }
            if (version > 1) {
                throw new VersionException(2, false);
            }
        }
    }

    @Override
    long getNextStorageID() {
        long nextKey = this.variableStorageTable.getMaxKey() + 1L;
        if (nextKey <= 0L) {
            nextKey = 1L;
        }
        return nextKey;
    }

    @Override
    void deleteRecord(long key) throws IOException {
        this.variableStorageTable.deleteRecord(key);
    }

    @Override
    Record getRecord(long key) throws IOException {
        return this.variableStorageTable.getRecord(key);
    }

    @Override
    Record[] getRecordsForNamespace(long namespaceID) throws IOException {
        long[] keys = this.variableStorageTable.findRecords((Field)new LongField(namespaceID), 1);
        Record[] records = new Record[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            records[i] = this.variableStorageTable.getRecord(keys[i]);
        }
        return records;
    }

    @Override
    void updateRecord(Record record) throws IOException {
        this.variableStorageTable.putRecord(record);
    }

    @Override
    RecordIterator getRecords() throws IOException {
        return this.variableStorageTable.iterator();
    }

    @Override
    int getRecordCount() {
        return this.variableStorageTable.getRecordCount();
    }

    public static OldVariableStorageDBAdapter upgrade(DBHandle dbHandle, OldVariableStorageDBAdapter oldAdapter, TaskMonitor monitor) throws IOException, CancelledException {
        DBHandle tmpHandle = dbHandle.getScratchPad();
        try {
            monitor.setMessage("Upgrading Variable Storage Table...");
            monitor.setMaximum((long)(oldAdapter.getRecordCount() * 2));
            int count = 0;
            OldVariableStorageDBAdapterV1 tmpAdapter = new OldVariableStorageDBAdapterV1(tmpHandle, true);
            RecordIterator iter = oldAdapter.getRecords();
            while (iter.hasNext()) {
                monitor.checkCanceled();
                Record rec = iter.next();
                Record newRec = VARIABLE_STORAGE_SCHEMA.createRecord(rec.getKey());
                newRec.setLongValue(0, rec.getLongValue(0));
                newRec.setLongValue(1, rec.getLongValue(1));
                newRec.setIntValue(2, rec.getIntValue(2));
                tmpAdapter.updateRecord(newRec);
                monitor.setProgress((long)(++count));
            }
            dbHandle.deleteTable("VariableStorage");
            OldVariableStorageDBAdapterV1 newAdapter = new OldVariableStorageDBAdapterV1(dbHandle, true);
            iter = tmpAdapter.getRecords();
            while (iter.hasNext()) {
                monitor.checkCanceled();
                newAdapter.updateRecord(iter.next());
                monitor.setProgress((long)(++count));
            }
            OldVariableStorageDBAdapterV1 oldVariableStorageDBAdapterV1 = newAdapter;
            return oldVariableStorageDBAdapterV1;
        }
        catch (VersionException e) {
            throw new AssertException();
        }
        finally {
            tmpHandle.deleteTable("VariableStorage");
        }
    }
}

