/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class DynamicSymbol
extends HighSymbol {
    private Entry[] refs;

    public DynamicSymbol() {
        this.refs = new Entry[0];
    }

    public DynamicSymbol(String nm, DataType tp, int size, HighFunction func, Address addr, long hash, int format) {
        super(nm, tp, size, addr, func);
        this.refs = new Entry[1];
        this.refs[0] = new Entry(addr, hash, format);
    }

    public long getHash() {
        return this.refs[0].hash;
    }

    public void addReference(Address addr, long hash, int format) {
        Entry[] newrefs = new Entry[this.refs.length + 1];
        for (int i = 0; i < this.refs.length; ++i) {
            newrefs[i] = this.refs[i];
        }
        newrefs[this.refs.length] = new Entry(addr, hash, format);
        this.refs = newrefs;
        if (this.refs.length == 1) {
            this.pcaddr = addr;
        }
    }

    protected void buildHashXML(StringBuilder buf) {
        for (int i = 0; i < this.refs.length; ++i) {
            buf.append("<hash val=\"0x").append(Long.toHexString(this.refs[i].hash)).append("\"/>");
            DynamicSymbol.buildRangelistXML(buf, this.refs[i].pcaddr);
        }
    }

    @Override
    public String buildXML() {
        String sym = DynamicSymbol.buildSymbolXML(this.function.getDataTypeManager(), this.name, this.type, this.size, this.isTypeLocked(), this.isNameLocked(), this.isReadOnly(), false, 0);
        StringBuilder res = new StringBuilder();
        res.append("<mapsym type=\"dynamic\">\n");
        res.append(sym);
        this.buildHashXML(res);
        res.append("</mapsym>\n");
        return res.toString();
    }

    @Override
    public int restoreXML(XmlPullParser parser, HighFunction func) throws PcodeXMLException {
        XmlElement symel = parser.start(new String[]{"symbol"});
        int symbolId = this.restoreSymbolXML(symel, func);
        this.type = func.getDataTypeManager().readXMLDataType(parser);
        this.size = this.type.getLength();
        parser.end(symel);
        if (this.size == 0) {
            throw new PcodeXMLException("Invalid symbol 0-sized data-type: " + this.type.getName());
        }
        while (parser.peek().isStart()) {
            long hash = 0L;
            int format = 0;
            XmlElement addrel = parser.start(new String[]{"hash"});
            hash = SpecXmlUtils.decodeLong((String)addrel.getAttribute("val"));
            format = SpecXmlUtils.decodeInt((String)symel.getAttribute("format"));
            parser.end(addrel);
            Address addr = this.parseRangeList(parser);
            this.addReference(addr, hash, format);
        }
        return symbolId;
    }

    public static String buildSymbolXML(PcodeDataTypeManager dtmanage, String nm, DataType dt, int length, boolean tl, boolean nl, boolean ro, boolean isVolatile, int format) {
        StringBuilder res = new StringBuilder();
        res.append("<symbol");
        if (nm != null) {
            SpecXmlUtils.xmlEscapeAttribute((StringBuilder)res, (String)"name", (String)nm);
        }
        SpecXmlUtils.encodeBooleanAttribute((StringBuilder)res, (String)"typelock", (boolean)tl);
        SpecXmlUtils.encodeBooleanAttribute((StringBuilder)res, (String)"namelock", (boolean)nl);
        SpecXmlUtils.encodeBooleanAttribute((StringBuilder)res, (String)"readonly", (boolean)ro);
        if (isVolatile) {
            SpecXmlUtils.encodeBooleanAttribute((StringBuilder)res, (String)"volatile", (boolean)true);
        }
        res.append(">\n");
        res.append((CharSequence)dtmanage.buildTypeRef(dt, length));
        res.append("</symbol>\n");
        return res.toString();
    }

    public static class Entry {
        public final Address pcaddr;
        public final long hash;
        public final int format;

        public Entry(Address addr, long h, int f) {
            this.pcaddr = addr;
            this.hash = h;
            this.format = f;
        }
    }
}

