/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.analyzer;

import ghidra.app.plugin.core.analysis.AnalysisState;
import ghidra.app.plugin.core.analysis.AnalysisStateInfo;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.file.formats.android.dex.format.ClassDataItem;
import ghidra.file.formats.android.dex.format.ClassDefItem;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.dex.format.EncodedMethod;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import java.io.IOException;
import java.util.List;
import java.util.TreeMap;

public final class DexAnalysisState
implements AnalysisState {
    private Program program;
    private DexHeader header;
    private TreeMap<Address, EncodedMethod> methodMap;

    public DexAnalysisState(Program program, DexHeader header) {
        this.program = program;
        this.header = header;
    }

    private void installMethodList(AddressSpace defaultAddressSpace, List<EncodedMethod> methodList) {
        for (EncodedMethod encodedMethod : methodList) {
            Address methodAddress = defaultAddressSpace.getAddress(0x50000000L + (long)encodedMethod.getCodeOffset());
            this.methodMap.put(methodAddress, encodedMethod);
        }
    }

    private void buildMethodMap() {
        this.methodMap = new TreeMap();
        AddressSpace defaultAddressSpace = this.program.getAddressFactory().getDefaultAddressSpace();
        for (ClassDefItem item : this.header.getClassDefs()) {
            ClassDataItem classDataItem = item.getClassDataItem();
            if (classDataItem == null) continue;
            this.installMethodList(defaultAddressSpace, classDataItem.getDirectMethods());
            this.installMethodList(defaultAddressSpace, classDataItem.getVirtualMethods());
        }
    }

    public DexHeader getHeader() {
        return this.header;
    }

    public EncodedMethod getEncodedMethod(Address addr) {
        if (this.methodMap == null) {
            this.buildMethodMap();
        }
        return this.methodMap.get(addr);
    }

    public static DexAnalysisState getState(Program program) throws IOException {
        DexAnalysisState analysisState = (DexAnalysisState)AnalysisStateInfo.getAnalysisState((Program)program, DexAnalysisState.class);
        if (analysisState == null) {
            MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), program.getMinAddress());
            BinaryReader reader = new BinaryReader((ByteProvider)provider, true);
            DexHeader dexHeader = new DexHeader(reader);
            analysisState = new DexAnalysisState(program, dexHeader);
            AnalysisStateInfo.putAnalysisState((Program)program, (AnalysisState)analysisState);
        }
        return analysisState;
    }
}

