/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.Border;

public class SmallBorderButton
extends JButton {
    public static final Border RAISED_BORDER;
    public static final Border NO_BORDER;
    public static final Border LOWERED_BORDER;
    private Border overrideBorder;

    public SmallBorderButton() {
        this.initBorder();
    }

    public SmallBorderButton(String text) {
        super(text);
        this.initBorder();
    }

    public SmallBorderButton(Action a) {
        super(a);
        this.initBorder();
    }

    public SmallBorderButton(Icon icon) {
        super(icon);
        this.initBorder();
    }

    public SmallBorderButton(String text, Icon icon) {
        super(text, icon);
        this.initBorder();
    }

    private void initBorder() {
        this.clearBorder();
        this.addMouseListener(new ButtonMouseListener());
    }

    public void clearBorder() {
        this.setBorder(NO_BORDER);
    }

    public void setOverrideBorder(Border overrideBorder) {
        this.overrideBorder = overrideBorder;
    }

    static {
        NO_BORDER = RAISED_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(1, 1, 1, 1));
        LOWERED_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(1, 1, 1, 1));
    }

    private class ButtonMouseListener
    extends MouseAdapter {
        private boolean inside = false;

        private ButtonMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent me) {
            if (SmallBorderButton.this.isEnabled()) {
                SmallBorderButton.this.setBorder(RAISED_BORDER);
                this.inside = true;
            }
        }

        @Override
        public void mouseExited(MouseEvent me) {
            this.inside = false;
            SmallBorderButton.this.setBorder(NO_BORDER);
            if (SmallBorderButton.this.overrideBorder != null) {
                SmallBorderButton.this.setBorder(SmallBorderButton.this.overrideBorder);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SmallBorderButton.this.isEnabled()) {
                SmallBorderButton.this.setBorder(LOWERED_BORDER);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.inside) {
                SmallBorderButton.this.setBorder(RAISED_BORDER);
            } else {
                SmallBorderButton.this.setBorder(NO_BORDER);
            }
            if (SmallBorderButton.this.overrideBorder != null) {
                SmallBorderButton.this.setBorder(SmallBorderButton.this.overrideBorder);
            }
        }
    }
}

