/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.partitioning;

import java.io.PrintStream;
import java.util.Hashtable;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.partitioning.Partition;
import org.catacombae.jparted.lib.ps.PartitionType;
import org.catacombae.jparted.lib.ps.mbr.MBRPartitionType;

public class MBRPartition
implements Partition {
    protected static final byte PARTITION_NOT_BOOTABLE = 0;
    protected static final byte PARTITION_BOOTABLE = -128;
    private static final Hashtable<Byte, MBRPartitionType> byteMap = new Hashtable();
    protected final byte[] status = new byte[1];
    protected final byte[] firstSector = new byte[3];
    protected final byte[] partitionType = new byte[1];
    protected final byte[] lastSector = new byte[3];
    protected final byte[] lbaFirstSector = new byte[4];
    protected final byte[] lbaPartitionLength = new byte[4];
    private final int sectorSize;

    public MBRPartition(byte[] data, int offset, int sectorSize) {
        this(sectorSize);
        System.arraycopy(data, offset + 0, this.status, 0, 1);
        System.arraycopy(data, offset + 1, this.firstSector, 0, 3);
        System.arraycopy(data, offset + 4, this.partitionType, 0, 1);
        System.arraycopy(data, offset + 5, this.lastSector, 0, 3);
        System.arraycopy(data, offset + 8, this.lbaFirstSector, 0, 4);
        System.arraycopy(data, offset + 12, this.lbaPartitionLength, 0, 4);
    }

    protected MBRPartition(int sectorSize) {
        this.sectorSize = sectorSize;
    }

    public MBRPartition(MBRPartition source) {
        this(source, source.sectorSize);
    }

    public MBRPartition(MBRPartition source, int sectorSize) {
        this(sectorSize);
        System.arraycopy(source.status, 0, this.status, 0, 1);
        System.arraycopy(source.firstSector, 0, this.firstSector, 0, 3);
        System.arraycopy(source.partitionType, 0, this.partitionType, 0, 1);
        System.arraycopy(source.lastSector, 0, this.lastSector, 0, 3);
        System.arraycopy(source.lbaFirstSector, 0, this.lbaFirstSector, 0, 4);
        System.arraycopy(source.lbaPartitionLength, 0, this.lbaPartitionLength, 0, 4);
    }

    public long getStartOffset() {
        return Util.unsign((int)this.getLBAFirstSector()) * (long)this.sectorSize;
    }

    public long getLength() {
        return Util.unsign((int)this.getLBAPartitionLength()) * (long)this.sectorSize;
    }

    public PartitionType getType() {
        return this.getPartitionTypeAsEnum().getGeneralType();
    }

    public byte getStatus() {
        return Util.readByteLE((byte[])this.status);
    }

    public byte[] getFirstSector() {
        return Util.createCopy((byte[])this.firstSector);
    }

    public byte getPartitionType() {
        return Util.readByteLE((byte[])this.partitionType);
    }

    public byte[] getLastSector() {
        return Util.createCopy((byte[])this.lastSector);
    }

    public int getLBAFirstSector() {
        return Util.readIntLE((byte[])this.lbaFirstSector);
    }

    public int getLBAPartitionLength() {
        return Util.readIntLE((byte[])this.lbaPartitionLength);
    }

    public MBRPartitionType getPartitionTypeAsEnum() {
        return MBRPartitionType.fromMBRType(this.getPartitionType());
    }

    public boolean isBootable() {
        return this.getStatus() == -128;
    }

    public boolean isValid() {
        int beginLBA = this.getLBAFirstSector();
        byte[] beginCHS = this.getFirstSector();
        int beginS = beginCHS[1] & 0x3F;
        byte beginH = beginCHS[0];
        int beginC = ((beginCHS[1] & 0xC0) >> 6) * 255 + beginCHS[2];
        int endLBA = beginLBA + this.getLBAPartitionLength() - 1;
        byte[] endCHS = this.getLastSector();
        int endS = endCHS[1] & 0x3F;
        byte endH = endCHS[0];
        int endC = ((endCHS[1] & 0xC0) >> 6) * 255 + endCHS[2];
        byte statusByte = this.getStatus();
        return statusByte == 0 || statusByte == -128;
    }

    public boolean isUsed() {
        return this.isValid() && this.getPartitionTypeAsEnum() != MBRPartitionType.UNUSED;
    }

    public String toString() {
        MBRPartitionType mpt = this.getPartitionTypeAsEnum();
        return (this.isBootable() ? "Bootable " : "") + "MBR Partition (" + (Object)((Object)mpt) + (mpt == null ? " [0x" + Util.toHexStringBE((byte)this.getPartitionType()) + "]" : "") + ")";
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " status: 0x" + Util.toHexStringBE((byte)this.getStatus()));
        ps.println(prefix + " firstSector: 0x" + Util.byteArrayToHexString((byte[])this.getFirstSector()));
        ps.println(prefix + " partitionType: 0x" + Util.toHexStringBE((byte)this.getPartitionType()) + " (" + this.getPartitionTypeAsEnum().toString() + ")");
        ps.println(prefix + " lastSector: 0x" + Util.byteArrayToHexString((byte[])this.getLastSector()));
        ps.println(prefix + " lbaFirstSector: " + Util.unsign((int)this.getLBAFirstSector()));
        ps.println(prefix + " lbaPartitionLength: " + Util.unsign((int)this.getLBAPartitionLength()));
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + this.getClass().getSimpleName() + ":");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[16];
        int i = 0;
        System.arraycopy(this.status, 0, result, i, this.status.length);
        System.arraycopy(this.firstSector, 0, result, i += this.status.length, this.firstSector.length);
        System.arraycopy(this.partitionType, 0, result, i += this.firstSector.length, this.partitionType.length);
        System.arraycopy(this.lastSector, 0, result, i += this.partitionType.length, this.lastSector.length);
        System.arraycopy(this.lbaFirstSector, 0, result, i += this.lastSector.length, this.lbaFirstSector.length);
        System.arraycopy(this.lbaPartitionLength, 0, result, i += this.lbaFirstSector.length, this.lbaPartitionLength.length);
        if ((i += this.lbaPartitionLength.length) != result.length) {
            throw new RuntimeException("Internal error!");
        }
        return result;
    }
}

