/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.persist.DataSpaceManager;
import org.hsqldb.persist.TableSpaceManager;

public class TableSpaceManagerBlocks
implements TableSpaceManager {
    DataSpaceManager spaceManager;
    private final int scale;
    final int mainBlockSize;
    final int spaceID;
    final int minReuse;
    private DoubleIntIndex lookup;
    private final int capacity;
    private long requestGetCount;
    private long releaseCount;
    private long requestCount;
    private long requestSize;
    boolean isModified;
    long freshBlockFreePos = 0L;
    long freshBlockLimit = 0L;
    int fileBlockIndex = -1;

    public TableSpaceManagerBlocks(DataSpaceManager dataSpaceManager, int n, int n2, int n3, int n4, int n5) {
        this.spaceManager = dataSpaceManager;
        this.scale = n4;
        this.spaceID = n;
        this.mainBlockSize = n2;
        this.minReuse = n5;
        this.lookup = new DoubleIntIndex(n3, true);
        this.lookup.setValuesSearchTarget();
        this.capacity = n3;
    }

    @Override
    public boolean hasFileRoom(long l) {
        return this.freshBlockLimit - this.freshBlockFreePos > l;
    }

    @Override
    public void addFileBlock(long l, long l2) {
        int n = (int)(this.freshBlockLimit - this.freshBlockFreePos);
        if (n > 0) {
            this.release(this.freshBlockFreePos / (long)this.scale, n);
        }
        this.initialiseFileBlock(null, l, l2);
    }

    @Override
    public void initialiseFileBlock(DoubleIntIndex doubleIntIndex, long l, long l2) {
        this.freshBlockFreePos = l;
        this.freshBlockLimit = l2;
        if (doubleIntIndex != null) {
            doubleIntIndex.copyTo(this.lookup);
        }
    }

    boolean getNewMainBlock(long l) {
        long l2 = ((long)this.mainBlockSize + l) / (long)this.mainBlockSize;
        long l3 = l2 * (long)this.mainBlockSize;
        long l4 = this.spaceManager.getFileBlocks(this.spaceID, (int)l2);
        if (l4 < 0L) {
            return false;
        }
        if (l4 != this.freshBlockLimit) {
            long l5 = this.freshBlockLimit - this.freshBlockFreePos;
            if (l5 > 0L) {
                this.release(this.freshBlockFreePos / (long)this.scale, (int)l5);
            }
            this.freshBlockFreePos = l4;
            this.freshBlockLimit = l4;
        }
        this.freshBlockLimit += l3;
        return true;
    }

    long getNewBlock(long l, boolean bl) {
        long l2;
        boolean bl2;
        if (bl) {
            l = (int)ArrayUtil.getBinaryMultipleCeiling(l, 4096L);
        }
        if (this.freshBlockFreePos + l > this.freshBlockLimit && !(bl2 = this.getNewMainBlock(l))) {
            throw Error.error(468);
        }
        long l3 = this.freshBlockFreePos;
        if (bl && (l2 = (l3 = ArrayUtil.getBinaryMultipleCeiling(l3, 4096L)) - this.freshBlockFreePos) > 0L) {
            this.release(this.freshBlockFreePos / (long)this.scale, (int)l2);
            this.freshBlockFreePos = l3;
        }
        this.freshBlockFreePos += l;
        return l3 / (long)this.scale;
    }

    @Override
    public int getSpaceID() {
        return this.spaceID;
    }

    @Override
    public synchronized void release(long l, int n) {
        int n2 = n / this.scale;
        this.isModified = true;
        ++this.releaseCount;
        if (this.lookup.size() == this.capacity) {
            this.resetList();
        }
        if (l + (long)n2 >= Integer.MAX_VALUE) {
            return;
        }
        this.lookup.add(l, (long)n2);
    }

    @Override
    public synchronized long getFilePosition(int n, boolean bl) {
        ++this.requestGetCount;
        if (this.capacity == 0) {
            return this.getNewBlock(n, bl);
        }
        if (bl) {
            n = (int)ArrayUtil.getBinaryMultipleCeiling(n, 4096L);
        }
        int n2 = -1;
        int n3 = n / this.scale;
        if (n >= this.minReuse && this.lookup.size() > 0) {
            n2 = this.lookup.getValue(0) >= n3 ? 0 : (n > Integer.MAX_VALUE ? -1 : this.lookup.findFirstGreaterEqualKeyIndex(n3));
        }
        if (n2 == -1) {
            return this.getNewBlock(n, bl);
        }
        if (bl) {
            long l;
            while (n2 < this.lookup.size() && (l = (long)this.lookup.getKey(n2)) % (long)(4096 / this.scale) != 0L) {
                ++n2;
            }
            if (n2 == this.lookup.size()) {
                return this.getNewBlock(n, bl);
            }
        }
        ++this.requestCount;
        this.requestSize += (long)n;
        int n4 = this.lookup.getKey(n2);
        int n5 = this.lookup.getValue(n2);
        int n6 = n5 - n3;
        this.lookup.remove(n2);
        if (n6 > 0) {
            int n7 = n4 + n3;
            this.lookup.add(n7, n6);
        }
        return n4;
    }

    @Override
    public void reset() {
        this.fileBlockIndex = this.freshBlockFreePos == 0L ? -1 : (int)(this.freshBlockFreePos / (long)this.mainBlockSize);
        this.spaceManager.freeTableSpace(this.spaceID, this.lookup, this.freshBlockFreePos, this.freshBlockLimit, true);
        this.freshBlockFreePos = 0L;
        this.freshBlockLimit = 0L;
    }

    @Override
    public long getLostBlocksSize() {
        long l = this.freshBlockLimit - this.freshBlockFreePos + this.lookup.getTotalValues() * (long)this.scale;
        return l;
    }

    @Override
    public boolean isDefaultSpace() {
        return this.spaceID == 7;
    }

    public int getFileBlockIndex() {
        return this.fileBlockIndex;
    }

    private void resetList() {
        this.spaceManager.freeTableSpace(this.spaceID, this.lookup, 0L, 0L, false);
    }
}

