/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.designer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.solr.api.EndPoint;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkMaintenanceUtils;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.designer.DefaultSampleDocumentsLoader;
import org.apache.solr.handler.designer.DefaultSchemaSuggester;
import org.apache.solr.handler.designer.ManagedSchemaDiff;
import org.apache.solr.handler.designer.SampleDocuments;
import org.apache.solr.handler.designer.SampleDocumentsLoader;
import org.apache.solr.handler.designer.SchemaDesignerConfigSetHelper;
import org.apache.solr.handler.designer.SchemaDesignerConstants;
import org.apache.solr.handler.designer.SchemaDesignerSettings;
import org.apache.solr.handler.designer.SchemaDesignerSettingsDAO;
import org.apache.solr.handler.designer.SchemaSuggester;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.ManagedIndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.RTimer;
import org.apache.zookeeper.KeeperException;
import org.noggit.JSONParser;
import org.noggit.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaDesignerAPI
implements SchemaDesignerConstants {
    private static final Set<String> excludeConfigSetNames = new HashSet<String>(Arrays.asList("_default", ".system"));
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CoreContainer coreContainer;
    private final SchemaSuggester schemaSuggester;
    private final SampleDocumentsLoader sampleDocLoader;
    private final SchemaDesignerSettingsDAO settingsDAO;
    private final SchemaDesignerConfigSetHelper configSetHelper;
    private final Map<String, Integer> indexedVersion = new ConcurrentHashMap<String, Integer>();

    public SchemaDesignerAPI(CoreContainer coreContainer) {
        this(coreContainer, SchemaDesignerAPI.newSchemaSuggester(coreContainer), SchemaDesignerAPI.newSampleDocumentsLoader(coreContainer));
    }

    SchemaDesignerAPI(CoreContainer coreContainer, SchemaSuggester schemaSuggester, SampleDocumentsLoader sampleDocLoader) {
        this.coreContainer = coreContainer;
        this.schemaSuggester = schemaSuggester;
        this.sampleDocLoader = sampleDocLoader;
        this.settingsDAO = new SchemaDesignerSettingsDAO(coreContainer);
        this.configSetHelper = new SchemaDesignerConfigSetHelper(this.coreContainer, this.schemaSuggester);
    }

    public static SchemaSuggester newSchemaSuggester(CoreContainer coreContainer) {
        DefaultSchemaSuggester suggester = new DefaultSchemaSuggester();
        suggester.init(new NamedList());
        return suggester;
    }

    public static SampleDocumentsLoader newSampleDocumentsLoader(CoreContainer coreContainer) {
        DefaultSampleDocumentsLoader loader = new DefaultSampleDocumentsLoader();
        loader.init(new NamedList());
        return loader;
    }

    static String getConfigSetZkPath(String configSet) {
        return SchemaDesignerAPI.getConfigSetZkPath(configSet, null);
    }

    static String getConfigSetZkPath(String configSet, String childNode) {
        String path = "/configs/" + configSet;
        if (childNode != null) {
            path = path + "/" + childNode;
        }
        return path;
    }

    static String getMutableId(String configSet) {
        return "._designer_" + configSet;
    }

    @EndPoint(method={SolrRequest.METHOD.GET}, path={"/schema-designer/info"}, permission=PermissionNameProvider.Name.CONFIG_READ_PERM)
    public void getInfo(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        String configSet = this.getRequiredParam("configSet", req);
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("configSet", configSet);
        boolean exists = this.configExists(configSet);
        responseMap.put("published", exists);
        String mutableId = SchemaDesignerAPI.getMutableId(configSet);
        SolrConfig srcConfig = exists ? this.configSetHelper.loadSolrConfig(configSet) : null;
        SolrConfig solrConfig = this.configExists(mutableId) ? this.configSetHelper.loadSolrConfig(mutableId) : srcConfig;
        this.addSettingsToResponse(this.settingsDAO.getSettings(solrConfig), responseMap);
        responseMap.put("schemaVersion", this.configSetHelper.getCurrentSchemaVersion(mutableId));
        responseMap.put("collections", exists ? this.configSetHelper.listCollectionsForConfig(configSet) : Collections.emptyList());
        try {
            responseMap.put("numDocs", this.configSetHelper.getStoredSampleDocs(configSet).size());
        }
        catch (Exception exc) {
            log.warn("Failed to load sample docs from blob store for {}", (Object)configSet, (Object)exc);
        }
        rsp.getValues().addAll(responseMap);
    }

    @EndPoint(method={SolrRequest.METHOD.POST}, path={"/schema-designer/prep"}, permission=PermissionNameProvider.Name.CONFIG_EDIT_PERM)
    public void prepNewSchema(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException, SolrServerException {
        String configSet = this.getRequiredParam("configSet", req);
        this.validateNewConfigSetName(configSet);
        String copyFrom = req.getParams().get("copyFrom", "_default");
        SchemaDesignerSettings settings = this.getMutableSchemaForConfigSet(configSet, -1, copyFrom);
        ManagedIndexSchema schema = settings.getSchema();
        String mutableId = SchemaDesignerAPI.getMutableId(configSet);
        if (!this.zkStateReader().getClusterState().hasCollection(mutableId)) {
            this.indexedVersion.remove(mutableId);
            this.configSetHelper.createCollection(mutableId, mutableId);
        }
        this.settingsDAO.persistIfChanged(mutableId, settings);
        rsp.getValues().addAll(this.buildResponse(configSet, schema, settings, null));
    }

    @EndPoint(method={SolrRequest.METHOD.PUT}, path={"/schema-designer/cleanup"}, permission=PermissionNameProvider.Name.CONFIG_EDIT_PERM)
    public void cleanupTemp(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException, SolrServerException {
        this.cleanupTemp(this.getRequiredParam("configSet", req));
    }

    @EndPoint(method={SolrRequest.METHOD.GET}, path={"/schema-designer/file"}, permission=PermissionNameProvider.Name.CONFIG_READ_PERM)
    public void getFileContents(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        byte[] data;
        String configSet = this.getRequiredParam("configSet", req);
        String file = this.getRequiredParam("file", req);
        String filePath = SchemaDesignerAPI.getConfigSetZkPath(SchemaDesignerAPI.getMutableId(configSet), file);
        try {
            data = this.zkStateReader().getZkClient().getData(filePath, null, null, true);
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error reading file: " + filePath, SolrZkClient.checkInterrupted((Throwable)e));
        }
        String stringData = data != null && data.length > 0 ? new String(data, StandardCharsets.UTF_8) : "";
        rsp.getValues().addAll(Collections.singletonMap(file, stringData));
    }

    @EndPoint(method={SolrRequest.METHOD.POST}, path={"/schema-designer/file"}, permission=PermissionNameProvider.Name.CONFIG_EDIT_PERM)
    public void updateFileContents(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException, SolrServerException {
        String configSet = this.getRequiredParam("configSet", req);
        String file = this.getRequiredParam("file", req);
        String mutableId = SchemaDesignerAPI.getMutableId(configSet);
        String zkPath = SchemaDesignerAPI.getConfigSetZkPath(mutableId, file);
        if (!this.pathExistsInZk(zkPath)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "File '" + file + "' not found in configSet: " + configSet);
        }
        byte[] data = DefaultSampleDocumentsLoader.streamAsBytes(this.extractSingleContentStream(req, true).getStream());
        Exception updateFileError = null;
        if ("solrconfig.xml".equals(file)) {
            try {
                InMemoryResourceLoader loader = new InMemoryResourceLoader(this.coreContainer, mutableId, "solrconfig.xml", data);
                SolrConfig.readFromResourceLoader(loader, "solrconfig.xml", true, null);
            }
            catch (Exception exc) {
                updateFileError = exc;
            }
        }
        if (updateFileError != null) {
            Throwable causedBy = SolrException.getRootCause(updateFileError);
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("updateFileError", causedBy.getMessage());
            response.put(file, new String(data, StandardCharsets.UTF_8));
            rsp.getValues().addAll(response);
            return;
        }
        SolrZkClient zkClient = this.zkStateReader().getZkClient();
        try {
            zkClient.setData(zkPath, data, true);
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Failed to save data in ZK at path: " + zkPath, SolrZkClient.checkInterrupted((Throwable)e));
        }
        this.configSetHelper.reloadTempCollection(mutableId, false);
        ManagedIndexSchema schema = this.loadLatestSchema(mutableId);
        Map<Object, Throwable> errorsDuringIndexing = null;
        SolrException solrExc = null;
        List<SolrInputDocument> docs = this.configSetHelper.getStoredSampleDocs(configSet);
        String[] analysisErrorHolder = new String[1];
        if (!docs.isEmpty()) {
            String idField = schema.getUniqueKeyField().getName();
            try {
                errorsDuringIndexing = this.indexSampleDocsWithRebuildOnAnalysisError(idField, docs, mutableId, true, analysisErrorHolder);
            }
            catch (SolrException exc) {
                solrExc = exc;
            }
        }
        Map<String, Object> response = this.buildResponse(configSet, schema, null, docs);
        if (analysisErrorHolder[0] != null) {
            response.put("analysisError", analysisErrorHolder[0]);
        }
        this.addErrorToResponse(mutableId, solrExc, errorsDuringIndexing, response, "Failed to re-index sample documents after update to the " + file + " file");
        rsp.getValues().addAll(response);
    }

    @EndPoint(method={SolrRequest.METHOD.GET}, path={"/schema-designer/sample"}, permission=PermissionNameProvider.Name.CONFIG_READ_PERM)
    public void getSampleValue(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        String configSet = this.getRequiredParam("configSet", req);
        String fieldName = this.getRequiredParam("field", req);
        String idField = this.getRequiredParam("uniqueKeyField", req);
        String docId = req.getParams().get("docId");
        List<SolrInputDocument> docs = this.configSetHelper.getStoredSampleDocs(configSet);
        String textValue = null;
        if (StringUtils.isEmpty((String)docId)) {
            Optional<SolrInputDocument> doc = docs.stream().filter(d -> d.getField(fieldName) != null && d.getField(fieldName).getFirstValue() != null && !d.getField(fieldName).getFirstValue().toString().isEmpty()).findFirst();
            if (doc.isPresent()) {
                docId = doc.get().getFieldValue(idField).toString();
                textValue = doc.get().getField(fieldName).getFirstValue().toString();
            }
        } else {
            String idFilter = docId;
            Optional<SolrInputDocument> doc = docs.stream().filter(d -> idFilter.equals(d.getFieldValue(idField))).findFirst();
            if (doc.isPresent()) {
                SolrInputField field = doc.get().getField(fieldName);
                String string = textValue = field != null && field.getFirstValue() != null ? field.getFirstValue().toString() : "";
            }
        }
        if (textValue != null) {
            Map<String, Object> analysis = this.configSetHelper.analyzeField(configSet, fieldName, textValue);
            rsp.getValues().addAll(Utils.makeMap((Object[])new Object[]{idField, docId, fieldName, textValue, "analysis", analysis}));
        }
    }

    @EndPoint(method={SolrRequest.METHOD.GET}, path={"/schema-designer/collectionsForConfig"}, permission=PermissionNameProvider.Name.CONFIG_READ_PERM)
    public void listCollectionsForConfig(SolrQueryRequest req, SolrQueryResponse rsp) {
        String configSet = this.getRequiredParam("configSet", req);
        rsp.getValues().addAll(Collections.singletonMap("collections", this.configSetHelper.listCollectionsForConfig(configSet)));
    }

    @EndPoint(method={SolrRequest.METHOD.GET}, path={"/schema-designer/configs"}, permission=PermissionNameProvider.Name.CONFIG_EDIT_PERM)
    public void listConfigs(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        rsp.getValues().addAll(Collections.singletonMap("configSets", this.listEnabledConfigs()));
    }

    protected Map<String, Integer> listEnabledConfigs() throws IOException {
        List<String> configsInZk = this.configSetHelper.listConfigsInZk();
        Map<String, Integer> configs = configsInZk.stream().filter(c -> !excludeConfigSetNames.contains(c) && !c.startsWith("._designer_")).collect(Collectors.toMap(c -> c, c -> this.settingsDAO.isDesignerDisabled((String)c) ? 1 : 2));
        configsInZk.stream().filter(c -> c.startsWith("._designer_")).map(c -> c.substring("._designer_".length())).forEach(c -> configs.putIfAbsent((String)c, 0));
        return configs;
    }

    @EndPoint(method={SolrRequest.METHOD.GET}, path={"/schema-designer/download/*"}, permission=PermissionNameProvider.Name.CONFIG_READ_PERM)
    public void downloadConfig(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        String configId;
        String configSet;
        block3: {
            configSet = this.getRequiredParam("configSet", req);
            String mutableId = SchemaDesignerAPI.getMutableId(configSet);
            SolrZkClient zkClient = this.zkStateReader().getZkClient();
            configId = mutableId;
            try {
                if (zkClient.exists(SchemaDesignerAPI.getConfigSetZkPath(mutableId, null), true).booleanValue()) break block3;
                if (zkClient.exists(SchemaDesignerAPI.getConfigSetZkPath(configSet, null), true).booleanValue()) {
                    configId = configSet;
                    break block3;
                }
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "ConfigSet " + configSet + " not found!");
            }
            catch (InterruptedException | KeeperException e) {
                throw new IOException("Error reading config from ZK", SolrZkClient.checkInterrupted((Throwable)e));
            }
        }
        ContentStreamBase.ByteArrayStream content = new ContentStreamBase.ByteArrayStream(this.configSetHelper.downloadAndZipConfigSet(configId), configSet + ".zip", "application/zip");
        rsp.add("content", content);
    }

    @EndPoint(method={SolrRequest.METHOD.POST}, path={"/schema-designer/add"}, permission=PermissionNameProvider.Name.CONFIG_EDIT_PERM)
    public void addSchemaObject(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException, SolrServerException {
        String configSet = this.getRequiredParam("configSet", req);
        String mutableId = this.checkMutable(configSet, req);
        Map<String, Object> addJson = this.readJsonFromRequest(req);
        log.info("Adding new schema object from JSON: {}", addJson);
        String objectName = this.configSetHelper.addSchemaObject(configSet, addJson);
        String action = addJson.keySet().iterator().next();
        ManagedIndexSchema schema = this.loadLatestSchema(mutableId);
        Map<String, Object> response = this.buildResponse(configSet, schema, null, this.configSetHelper.getStoredSampleDocs(configSet));
        response.put(action, objectName);
        rsp.getValues().addAll(response);
    }

    @EndPoint(method={SolrRequest.METHOD.PUT}, path={"/schema-designer/update"}, permission=PermissionNameProvider.Name.CONFIG_EDIT_PERM)
    public void updateSchemaObject(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException, SolrServerException {
        String configSet = this.getRequiredParam("configSet", req);
        String mutableId = this.checkMutable(configSet, req);
        Map<String, Object> updateField = this.readJsonFromRequest(req);
        String name = (String)updateField.get("name");
        if (StringUtils.isEmpty((String)name)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid update request! JSON payload is missing the required name property: " + updateField);
        }
        log.info("Updating schema object: configSet={}, mutableId={}, name={}, JSON={}", new Object[]{configSet, mutableId, name, updateField});
        SchemaDesignerSettings settings = this.getMutableSchemaForConfigSet(configSet, -1, null);
        ManagedIndexSchema schemaBeforeUpdate = settings.getSchema();
        Map<String, Object> updateResult = this.configSetHelper.updateSchemaObject(configSet, updateField, schemaBeforeUpdate);
        SolrException solrExc = (SolrException)((Object)updateResult.get("solrExc"));
        String updateError = (String)updateResult.get("updateError");
        String updateType = (String)updateResult.get("updateType");
        boolean needsRebuild = (Boolean)updateResult.get("rebuild");
        ManagedIndexSchema schema = this.loadLatestSchema(mutableId);
        List<SolrInputDocument> docs = this.configSetHelper.getStoredSampleDocs(configSet);
        Map<Object, Throwable> errorsDuringIndexing = null;
        String[] analysisErrorHolder = new String[1];
        if (solrExc == null && !docs.isEmpty()) {
            try {
                errorsDuringIndexing = this.indexSampleDocsWithRebuildOnAnalysisError(schema.getUniqueKeyField().getName(), docs, mutableId, false, analysisErrorHolder);
            }
            catch (SolrException exc) {
                solrExc = exc;
                updateError = "Failed to re-index sample documents after update to the " + name + " " + updateType + " due to: " + solrExc.getMessage();
            }
        }
        Map<String, Object> response = this.buildResponse(configSet, schema, settings, docs);
        response.put("updateType", updateType);
        if ("field".equals(updateType)) {
            response.put(updateType, this.fieldToMap(schema.getField(name), schema));
        } else if ("type".equals(updateType)) {
            response.put(updateType, schema.getFieldTypeByName(name).getNamedPropertyValues(true));
        }
        if (analysisErrorHolder[0] != null) {
            response.put("analysisError", analysisErrorHolder[0]);
        }
        this.addErrorToResponse(mutableId, solrExc, errorsDuringIndexing, response, updateError);
        response.put("rebuild", needsRebuild);
        rsp.getValues().addAll(response);
    }

    @EndPoint(method={SolrRequest.METHOD.PUT}, path={"/schema-designer/publish"}, permission=PermissionNameProvider.Name.CONFIG_EDIT_PERM)
    public void publish(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException, SolrServerException {
        String newCollection;
        String configSet = this.getRequiredParam("configSet", req);
        String mutableId = this.checkMutable(configSet, req);
        SchemaDesignerSettings settings = this.settingsDAO.getSettings(mutableId);
        Optional<Integer> publishedVersion = settings.getPublishedVersion();
        if (publishedVersion.isPresent()) {
            int currentVersionOfSrc = this.configSetHelper.getCurrentSchemaVersion(configSet);
            if (publishedVersion.get() != currentVersionOfSrc) {
                throw new SolrException(SolrException.ErrorCode.CONFLICT, "Version mismatch for " + configSet + "! Expected version " + publishedVersion.get() + " but current is " + currentVersionOfSrc + "; another user may have changed the published schema while you were making edits. Publishing your changes would result in losing the edits from the other user.");
            }
        }
        if (!StringUtils.isEmpty((String)(newCollection = req.getParams().get("newCollection"))) && this.zkStateReader().getClusterState().hasCollection(newCollection)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection '" + newCollection + "' already exists!");
        }
        if (this.configExists(configSet)) {
            SolrZkClient zkClient = this.coreContainer.getZkController().getZkClient();
            try {
                zkClient.zkTransfer(SchemaDesignerAPI.getConfigSetZkPath(mutableId), Boolean.valueOf(true), SchemaDesignerAPI.getConfigSetZkPath(configSet), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (InterruptedException | KeeperException e) {
                throw new IOException("Failed to copy config set: " + mutableId, SolrZkClient.checkInterrupted((Throwable)e));
            }
        } else {
            this.copyConfig(mutableId, configSet);
        }
        boolean reloadCollections = req.getParams().getBool("reloadCollections", false);
        if (reloadCollections) {
            log.debug("Reloading collections after update to configSet: {}", (Object)configSet);
            List<String> collectionsForConfig = this.configSetHelper.listCollectionsForConfig(configSet);
            CloudSolrClient csc = this.cloudClient();
            for (String next : collectionsForConfig) {
                CollectionAdminRequest.reloadCollection((String)next).processAsync((SolrClient)csc);
            }
        }
        Map<Object, Throwable> errorsDuringIndexing = null;
        if (!StringUtils.isEmpty((String)newCollection)) {
            List<SolrInputDocument> docs;
            int numShards = req.getParams().getInt("numShards", 1);
            int rf = req.getParams().getInt("replicationFactor", 1);
            this.configSetHelper.createCollection(newCollection, configSet, numShards, rf);
            if (req.getParams().getBool("indexToCollection", false) && !(docs = this.configSetHelper.getStoredSampleDocs(configSet)).isEmpty()) {
                ManagedIndexSchema schema = this.loadLatestSchema(mutableId);
                errorsDuringIndexing = this.indexSampleDocs(schema.getUniqueKeyField().getName(), docs, newCollection, true);
            }
        }
        if (req.getParams().getBool("cleanupTemp", true)) {
            this.cleanupTemp(configSet);
        }
        settings.setDisabled(req.getParams().getBool("disableDesigner", false));
        this.settingsDAO.persistIfChanged(configSet, settings);
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("configSet", configSet);
        response.put("schemaVersion", this.configSetHelper.getCurrentSchemaVersion(configSet));
        if (!StringUtils.isEmpty((String)newCollection)) {
            response.put("newCollection", newCollection);
        }
        this.addErrorToResponse(newCollection, null, errorsDuringIndexing, response, null);
        rsp.getValues().addAll(response);
    }

    @EndPoint(method={SolrRequest.METHOD.POST}, path={"/schema-designer/analyze"}, permission=PermissionNameProvider.Name.CONFIG_EDIT_PERM)
    public void analyze(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException, SolrServerException {
        List<SolrInputDocument> docs;
        List<String> langs;
        int schemaVersion = req.getParams().getInt("schemaVersion", -1);
        String configSet = this.getRequiredParam("configSet", req);
        if ("_default".equals(configSet)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'_default' is a reserved configSet name! Please choose a different name.");
        }
        this.validateNewConfigSetName(configSet);
        SampleDocuments sampleDocuments = this.loadSampleDocuments(req, configSet);
        String copyFrom = this.configExists(configSet) ? configSet : req.getParams().get("copyFrom", "_default");
        String mutableId = SchemaDesignerAPI.getMutableId(configSet);
        SchemaDesignerSettings settings = this.getMutableSchemaForConfigSet(configSet, schemaVersion, copyFrom);
        ManagedIndexSchema schema = settings.getSchema();
        String uniqueKeyFieldParam = req.getParams().get("uniqueKeyField");
        if (!StringUtils.isEmpty((String)uniqueKeyFieldParam)) {
            String uniqueKeyField;
            String string = uniqueKeyField = schema.getUniqueKeyField() != null ? schema.getUniqueKeyField().getName() : null;
            if (!uniqueKeyFieldParam.equals(uniqueKeyField)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Changing the unique key field not supported yet!");
            }
        }
        boolean langsUpdated = false;
        String[] languages = req.getParams().getParams("languages");
        if (languages != null) {
            List<Object> list = langs = languages.length == 0 || languages.length == 1 && "*".equals(languages[0]) ? Collections.emptyList() : Arrays.asList(languages);
            if (!langs.equals(settings.getLanguages())) {
                settings.setLanguages(langs);
                langsUpdated = true;
            }
        } else {
            langs = settings.getLanguages();
        }
        boolean dynamicUpdated = false;
        Boolean enableDynamicFields = req.getParams().getBool("enableDynamicFields");
        if (enableDynamicFields != null && enableDynamicFields.booleanValue() != settings.dynamicFieldsEnabled()) {
            settings.setDynamicFieldsEnabled(enableDynamicFields);
            dynamicUpdated = true;
        }
        if (langsUpdated) {
            schema = this.configSetHelper.syncLanguageSpecificObjectsAndFiles(mutableId, schema, langs, settings.dynamicFieldsEnabled(), copyFrom);
        }
        if (dynamicUpdated) {
            schema = enableDynamicFields == false ? this.configSetHelper.removeDynamicFields(schema) : this.configSetHelper.restoreDynamicFields(schema, langs, copyFrom);
        }
        if (!(docs = sampleDocuments.parsed).isEmpty()) {
            if (this.sampleDocLoader.ensureUniqueKey(schema.getUniqueKeyField(), docs)) {
                this.configSetHelper.storeSampleDocs(configSet, docs);
            }
            schema = this.analyzeInputDocs(this.schemaSuggester.transposeDocs(docs), schema, langs);
        }
        schema.persistManagedSchema(false);
        Boolean enableFieldGuessing = req.getParams().getBool("enableFieldGuessing");
        if (enableFieldGuessing != null && enableFieldGuessing.booleanValue() != settings.fieldGuessingEnabled()) {
            settings.setFieldGuessingEnabled(enableFieldGuessing);
        }
        if (!this.zkStateReader().getClusterState().hasCollection(mutableId)) {
            this.configSetHelper.createCollection(mutableId, mutableId);
            this.indexedVersion.remove(mutableId);
        } else {
            CollectionAdminRequest.reloadCollection((String)mutableId).process((SolrClient)this.cloudClient());
        }
        Boolean enableNestedDocs = req.getParams().getBool("enableNestedDocs");
        if (enableNestedDocs != null && enableNestedDocs.booleanValue() != settings.nestedDocsEnabled()) {
            settings.setNestedDocsEnabled(enableNestedDocs);
            this.configSetHelper.toggleNestedDocsFields(schema, enableNestedDocs);
        }
        String[] analysisErrorHolder = new String[1];
        Map<Object, Throwable> errorsDuringIndexing = null;
        if (!docs.isEmpty()) {
            String idField = schema.getUniqueKeyField().getName();
            errorsDuringIndexing = this.indexSampleDocsWithRebuildOnAnalysisError(idField, docs, mutableId, false, analysisErrorHolder);
        }
        if (this.settingsDAO.persistIfChanged(mutableId, settings)) {
            CollectionAdminRequest.reloadCollection((String)mutableId).process((SolrClient)this.cloudClient());
        }
        Map<String, Object> response = this.buildResponse(configSet, this.loadLatestSchema(mutableId), settings, docs);
        response.put("sampleSource", sampleDocuments.getSource());
        if (analysisErrorHolder[0] != null) {
            response.put("analysisError", analysisErrorHolder[0]);
        }
        this.addErrorToResponse(mutableId, null, errorsDuringIndexing, response, null);
        rsp.getValues().addAll(response);
    }

    @EndPoint(method={SolrRequest.METHOD.GET}, path={"/schema-designer/query"}, permission=PermissionNameProvider.Name.CONFIG_READ_PERM)
    public void query(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException, SolrServerException {
        String configSet = this.getRequiredParam("configSet", req);
        String mutableId = SchemaDesignerAPI.getMutableId(configSet);
        if (!this.configExists(mutableId)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, mutableId + " configSet not found! Are you sure " + configSet + " was being edited by the schema designer?");
        }
        if (!this.zkStateReader().getClusterState().hasCollection(mutableId)) {
            this.indexedVersion.remove(mutableId);
            this.configSetHelper.createCollection(mutableId, mutableId);
        }
        int currentVersion = this.configSetHelper.getCurrentSchemaVersion(mutableId);
        Integer version = this.indexedVersion.get(mutableId);
        Map<Object, Throwable> errorsDuringIndexing = null;
        if (version == null || version != currentVersion) {
            log.debug("Schema for collection {} is stale ({} != {}), need to re-index sample docs", new Object[]{mutableId, version, currentVersion});
            List<SolrInputDocument> docs = this.configSetHelper.getStoredSampleDocs(configSet);
            ManagedIndexSchema schema = this.loadLatestSchema(mutableId);
            errorsDuringIndexing = this.indexSampleDocsWithRebuildOnAnalysisError(schema.getUniqueKeyField().getName(), docs, mutableId, true, null);
            currentVersion = this.configSetHelper.getCurrentSchemaVersion(mutableId);
            this.indexedVersion.put(mutableId, currentVersion);
        }
        if (errorsDuringIndexing != null) {
            HashMap<String, Map<Object, Throwable>> response = new HashMap<String, Map<Object, Throwable>>();
            rsp.setException((Exception)((Object)new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Failed to re-index sample documents after schema updated.")));
            response.put("errorDetails", errorsDuringIndexing);
            rsp.getValues().addAll(response);
            return;
        }
        QueryResponse qr = this.cloudClient().query(mutableId, req.getParams());
        rsp.getValues().addAll(qr.getResponse());
    }

    @EndPoint(method={SolrRequest.METHOD.GET}, path={"/schema-designer/diff"}, permission=PermissionNameProvider.Name.CONFIG_READ_PERM)
    public void getSchemaDiff(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        String configSet = this.getRequiredParam("configSet", req);
        SchemaDesignerSettings settings = this.getMutableSchemaForConfigSet(configSet, -1, null);
        String sourceSchema = this.configExists(configSet) ? configSet : settings.getCopyFrom();
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("diff", ManagedSchemaDiff.diff(this.loadLatestSchema(sourceSchema), settings.getSchema()));
        response.put("diff-source", sourceSchema);
        this.addSettingsToResponse(settings, response);
        rsp.getValues().addAll(response);
    }

    protected SampleDocuments loadSampleDocuments(SolrQueryRequest req, String configSet) throws IOException {
        List<SolrInputDocument> docs = null;
        ContentStream stream = this.extractSingleContentStream(req, false);
        SampleDocuments sampleDocs = null;
        if (stream != null && stream.getContentType() != null) {
            sampleDocs = this.sampleDocLoader.parseDocsFromStream(req.getParams(), stream, 1000);
            docs = sampleDocs.parsed;
            if (!docs.isEmpty()) {
                List<SolrInputDocument> stored = this.configSetHelper.getStoredSampleDocs(configSet);
                if (!stored.isEmpty()) {
                    ManagedIndexSchema latestSchema = this.loadLatestSchema(SchemaDesignerAPI.getMutableId(configSet));
                    docs = sampleDocs.appendDocs(latestSchema.getUniqueKeyField().getName(), stored, 1000);
                }
                this.configSetHelper.storeSampleDocs(configSet, docs);
            }
        }
        if (docs == null || docs.isEmpty()) {
            docs = this.configSetHelper.getStoredSampleDocs(configSet);
            if (docs.isEmpty() && !this.configExists(configSet)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No sample documents provided for analyzing schema! Only CSV/TSV, XML, JSON, and JSON lines supported.");
            }
            sampleDocs = new SampleDocuments(docs, "", "blob");
        }
        return sampleDocs;
    }

    protected ManagedIndexSchema analyzeInputDocs(Map<String, List<Object>> docs, ManagedIndexSchema schema, List<String> langs) {
        LinkedList<SchemaField> fieldsToAdd = new LinkedList<SchemaField>();
        for (String field : docs.keySet()) {
            List<Object> sampleValues = docs.getOrDefault(field, Collections.emptyList());
            String normalizedField = field.trim().replaceAll("\\s+", "_");
            if (schema.hasExplicitField(normalizedField)) {
                SchemaField existing = schema.getField(normalizedField);
                schema = this.schemaSuggester.adaptExistingFieldToData(existing, sampleValues, schema);
                continue;
            }
            Optional<SchemaField> maybeSchemaField = this.schemaSuggester.suggestField(normalizedField, sampleValues, schema, langs);
            maybeSchemaField.ifPresent(fieldsToAdd::add);
        }
        if (!fieldsToAdd.isEmpty()) {
            schema = (ManagedIndexSchema)schema.addFields(fieldsToAdd);
        }
        return schema;
    }

    protected String getManagedSchemaZkPath(String configSet) {
        return SchemaDesignerAPI.getConfigSetZkPath(configSet, "managed-schema");
    }

    protected SchemaDesignerSettings getMutableSchemaForConfigSet(String configSet, int schemaVersion, String copyFrom) throws IOException {
        String mutableId = SchemaDesignerAPI.getMutableId(configSet);
        int publishedVersion = -1;
        boolean isNew = false;
        if (!this.configExists(mutableId)) {
            if (this.configExists(configSet)) {
                if (this.settingsDAO.isDesignerDisabled(configSet)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Schema '" + configSet + "' is locked for edits by the schema designer!");
                }
                publishedVersion = this.configSetHelper.getCurrentSchemaVersion(configSet);
                this.copyConfig(configSet, mutableId);
                copyFrom = null;
            } else {
                this.copyConfig(copyFrom, mutableId);
            }
            isNew = true;
        }
        SolrConfig solrConfig = this.configSetHelper.loadSolrConfig(mutableId);
        ManagedIndexSchema schema = this.configSetHelper.loadLatestSchema(solrConfig);
        if (!isNew) {
            this.configSetHelper.checkSchemaVersion(mutableId, schemaVersion, schema.getSchemaZkVersion());
        }
        SchemaDesignerSettings settings = this.settingsDAO.getSettings(solrConfig);
        if (isNew) {
            if (!configSet.equals(copyFrom)) {
                settings.setDisabled(false);
            }
            if (copyFrom != null) {
                settings.setCopyFrom(copyFrom);
            }
            if (publishedVersion != -1) {
                settings.setPublishedVersion(publishedVersion);
            }
            if (!settings.nestedDocsEnabled()) {
                schema = this.configSetHelper.deleteNestedDocsFieldsIfNeeded(schema, false);
            }
            if (!settings.dynamicFieldsEnabled()) {
                schema = this.configSetHelper.removeDynamicFields(schema);
            }
            schema.persistManagedSchema(false);
        }
        settings.setSchema(schema);
        return settings;
    }

    ManagedIndexSchema loadLatestSchema(String configSet) {
        return this.configSetHelper.loadLatestSchema(configSet);
    }

    protected ContentStream extractSingleContentStream(SolrQueryRequest req, boolean required) {
        ContentStream stream;
        Iterable<ContentStream> streams = req.getContentStreams();
        Iterator<ContentStream> iter = streams != null ? streams.iterator() : null;
        ContentStream contentStream = stream = iter != null && iter.hasNext() ? iter.next() : null;
        if (required && stream == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No JSON content found in the request body!");
        }
        return stream;
    }

    protected CloudSolrClient cloudClient() {
        return this.coreContainer.getSolrClientCache().getCloudSolrClient(this.coreContainer.getZkController().getZkServerAddress());
    }

    protected ZkStateReader zkStateReader() {
        return this.coreContainer.getZkController().getZkStateReader();
    }

    protected Map<Object, Throwable> indexSampleDocsWithRebuildOnAnalysisError(String idField, List<SolrInputDocument> docs, String collectionName, boolean asBatch, String[] analysisErrorHolder) throws IOException, SolrServerException {
        Map<Object, Throwable> results;
        try {
            results = this.indexSampleDocs(idField, docs, collectionName, asBatch);
        }
        catch (IllegalArgumentException analysisExc) {
            String errMsg = SolrException.getRootCause((Throwable)analysisExc).getMessage();
            if (analysisErrorHolder != null) {
                analysisErrorHolder[0] = errMsg;
            }
            log.warn("Rebuilding temp collection {} after low-level Lucene indexing issue: {}", (Object)collectionName, (Object)errMsg);
            this.configSetHelper.reloadTempCollection(collectionName, true);
            results = this.indexSampleDocs(idField, docs, collectionName, asBatch);
            log.info("Re-index sample docs into {} after rebuild due to {} succeeded; results: {}", new Object[]{collectionName, errMsg, results});
        }
        return results;
    }

    protected Map<Object, Throwable> indexSampleDocs(String idField, List<SolrInputDocument> docs, String collectionName, boolean asBatch) throws IOException, SolrServerException {
        LinkedHashMap<Object, Throwable> errorsDuringIndexing = new LinkedHashMap<Object, Throwable>();
        RTimer timer = new RTimer();
        CloudSolrClient cloudSolrClient = this.cloudClient();
        cloudSolrClient.deleteByQuery(collectionName, "*:*", 1);
        cloudSolrClient.optimize(collectionName, true, true, 1);
        int commitWithin = 100;
        int numDocs = docs.size();
        int numAdded = 0;
        if (asBatch) {
            cloudSolrClient.add(collectionName, docs, 100);
            numAdded = docs.size();
        } else {
            int maxErrors = Math.min(100, Math.round((float)numDocs / 2.0f));
            for (SolrInputDocument next : docs) {
                try {
                    cloudSolrClient.add(collectionName, next, 100);
                    ++numAdded;
                }
                catch (Exception exc) {
                    Throwable rootCause = SolrException.getRootCause((Throwable)exc);
                    if (String.valueOf(rootCause.getMessage()).contains("possible analysis error")) {
                        throw new IllegalArgumentException(rootCause);
                    }
                    Object docId = next.getFieldValue(idField);
                    if (docId == null) {
                        throw exc;
                    }
                    errorsDuringIndexing.put(docId, rootCause);
                    if (errorsDuringIndexing.size() <= 20 || errorsDuringIndexing.size() < maxErrors) continue;
                    break;
                }
            }
        }
        cloudSolrClient.commit(collectionName, true, true, true);
        if (!errorsDuringIndexing.isEmpty()) {
            return errorsDuringIndexing;
        }
        long numFound = this.waitToSeeSampleDocs(collectionName, numAdded);
        double tookMs = timer.getTime();
        log.debug("Indexed {} docs into collection {}, took {} ms", new Object[]{numFound, collectionName, tookMs});
        return !errorsDuringIndexing.isEmpty() ? errorsDuringIndexing : null;
    }

    protected long waitToSeeSampleDocs(String collectionName, long numAdded) throws IOException, SolrServerException {
        CloudSolrClient cloudSolrClient = this.cloudClient();
        SolrQuery query = new SolrQuery("*:*");
        query.setRows(Integer.valueOf(0));
        QueryResponse queryResponse = cloudSolrClient.query(collectionName, (SolrParams)query);
        long numFound = queryResponse.getResults().getNumFound();
        if (numFound < numAdded) {
            long deadline = System.nanoTime() + TimeUnit.SECONDS.toNanos(5L);
            do {
                cloudSolrClient.commit(collectionName, true, true, true);
                queryResponse = cloudSolrClient.query(collectionName, (SolrParams)query);
                numFound = queryResponse.getResults().getNumFound();
                if (numFound >= numAdded) break;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            } while (System.nanoTime() < deadline);
            if (numFound < numAdded) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to index " + numAdded + " sample docs into temp collection: " + collectionName);
            }
        }
        return numFound;
    }

    protected Map<String, Object> buildResponse(String configSet, ManagedIndexSchema schema, SchemaDesignerSettings settings, List<SolrInputDocument> docs) throws IOException {
        String mutableId = SchemaDesignerAPI.getMutableId(configSet);
        int currentVersion = this.configSetHelper.getCurrentSchemaVersion(mutableId);
        this.indexedVersion.put(mutableId, currentVersion);
        HashMap<String, Object> response = new HashMap<String, Object>();
        DocCollection coll = this.zkStateReader().getCollection(mutableId);
        if (coll.getActiveSlicesArr().length > 0) {
            String coreName = coll.getActiveSlicesArr()[0].getLeader().getCoreName();
            response.put("core", coreName);
        }
        response.put("uniqueKeyField", schema.getUniqueKeyField().getName());
        response.put("configSet", configSet);
        response.put("schemaVersion", currentVersion);
        response.put("tempCollection", mutableId);
        response.put("collectionsForConfig", this.configSetHelper.listCollectionsForConfig(configSet));
        response.put("fields", schema.getFields().values().stream().map(f -> this.fieldToMap((SchemaField)f, schema)).sorted(Comparator.comparing(map -> (String)map.get("name"))).collect(Collectors.toList()));
        if (settings == null) {
            settings = this.settingsDAO.getSettings(mutableId);
        }
        this.addSettingsToResponse(settings, response);
        response.put("dynamicFields", Arrays.stream(schema.getDynamicFieldPrototypes()).map(e -> e.getNamedPropertyValues(true)).sorted(Comparator.comparing(map -> (String)map.get("name"))).collect(Collectors.toList()));
        response.put("fieldTypes", schema.getFieldTypes().values().stream().map(fieldType -> fieldType.getNamedPropertyValues(true)).sorted(Comparator.comparing(map -> (String)map.get("name"))).collect(Collectors.toList()));
        SolrZkClient zkClient = this.zkStateReader().getZkClient();
        String configPathInZk = SchemaDesignerAPI.getConfigSetZkPath(mutableId);
        HashSet files = new HashSet();
        try {
            ZkMaintenanceUtils.traverseZkTree((SolrZkClient)zkClient, (String)configPathInZk, (ZkMaintenanceUtils.VISIT_ORDER)ZkMaintenanceUtils.VISIT_ORDER.VISIT_POST, files::add);
        }
        catch (InterruptedException | KeeperException e2) {
            throw new IOException("Failed to traverse files under: " + configPathInZk, SolrZkClient.checkInterrupted((Throwable)e2));
        }
        files.remove(configPathInZk);
        String prefix = configPathInZk + "/";
        int prefixLen = prefix.length();
        Set stripPrefix = files.stream().map(f -> f.startsWith(prefix) ? f.substring(prefixLen) : f).collect(Collectors.toSet());
        stripPrefix.remove("managed-schema");
        stripPrefix.remove("lang");
        stripPrefix.remove("configoverlay.json");
        ArrayList sortedFiles = new ArrayList(stripPrefix);
        Collections.sort(sortedFiles);
        response.put("files", sortedFiles);
        if (docs != null) {
            String uniqueKeyField = schema.getUniqueKeyField().getName();
            response.put("docIds", docs.stream().map(d -> (String)d.getFieldValue(uniqueKeyField)).filter(Objects::nonNull).limit(100L).collect(Collectors.toList()));
        }
        response.put("numDocs", docs != null ? docs.size() : -1);
        return response;
    }

    protected void addErrorToResponse(String collection, SolrException solrExc, Map<Object, Throwable> errorsDuringIndexing, Map<String, Object> response, String updateError) {
        if (solrExc == null && (errorsDuringIndexing == null || errorsDuringIndexing.isEmpty())) {
            return;
        }
        if (updateError != null) {
            response.put("updateError", updateError);
        }
        if (solrExc != null) {
            response.put("updateErrorCode", solrExc.code());
            response.putIfAbsent("updateError", solrExc.getMessage());
        }
        response.putIfAbsent("updateError", "Index sample documents into " + collection + " failed!");
        response.putIfAbsent("updateErrorCode", 400);
        if (errorsDuringIndexing != null) {
            response.put("errorDetails", errorsDuringIndexing);
        }
    }

    protected SimpleOrderedMap<Object> fieldToMap(SchemaField f, ManagedIndexSchema schema) {
        SimpleOrderedMap<Object> map = f.getNamedPropertyValues(true);
        List copyFieldNames = schema.getCopyFieldsList((String)map.get("name")).stream().map(c -> c.getDestination().getName()).collect(Collectors.toList());
        map.add("copyDest", (Object)String.join((CharSequence)",", copyFieldNames));
        return map;
    }

    protected Map<String, Object> readJsonFromRequest(SolrQueryRequest req) throws IOException {
        Object json;
        ContentStream stream = this.extractSingleContentStream(req, true);
        String contentType = stream.getContentType();
        if (StringUtils.isEmpty((String)contentType) || !contentType.toLowerCase(Locale.ROOT).contains("application/json")) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Expected JSON in request!");
        }
        try (Reader reader = stream.getReader();){
            json = ObjectBuilder.getVal((JSONParser)new JSONParser(reader));
        }
        return (Map)json;
    }

    protected void addSettingsToResponse(SchemaDesignerSettings settings, Map<String, Object> response) {
        response.put("languages", settings.getLanguages());
        response.put("enableFieldGuessing", settings.fieldGuessingEnabled());
        response.put("enableDynamicFields", settings.dynamicFieldsEnabled());
        response.put("enableNestedDocs", settings.nestedDocsEnabled());
        response.put("disabled", settings.isDisabled());
        Optional<Integer> publishedVersion = settings.getPublishedVersion();
        publishedVersion.ifPresent(version -> response.put("publishedVersion", version));
        String copyFrom = settings.getCopyFrom();
        if (copyFrom != null) {
            response.put("copyFrom", copyFrom);
        }
    }

    protected String checkMutable(String configSet, SolrQueryRequest req) throws IOException {
        String mutableId = SchemaDesignerAPI.getMutableId(configSet);
        if (!this.configExists(mutableId)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, mutableId + " configSet not found! Are you sure " + configSet + " was being edited by the schema designer?");
        }
        this.configSetHelper.checkSchemaVersion(mutableId, this.requireSchemaVersionFromClient(req), -1);
        return mutableId;
    }

    protected int requireSchemaVersionFromClient(SolrQueryRequest req) {
        int schemaVersion = req.getParams().getInt("schemaVersion", -1);
        if (schemaVersion == -1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "schemaVersion is a required parameter for the " + req.getPath() + " endpoint");
        }
        return schemaVersion;
    }

    protected String getRequiredParam(String param, SolrQueryRequest req) {
        String paramValue = req.getParams().get(param);
        if (StringUtils.isEmpty((String)paramValue)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, param + " is a required parameter for the " + req.getPath() + " endpoint!");
        }
        return paramValue;
    }

    protected void cleanupTemp(String configSet) throws IOException, SolrServerException {
        String mutableId = SchemaDesignerAPI.getMutableId(configSet);
        this.indexedVersion.remove(mutableId);
        CollectionAdminRequest.deleteCollection((String)mutableId).process((SolrClient)this.cloudClient());
        this.configSetHelper.deleteStoredSampleDocs(configSet);
        this.deleteConfig(mutableId);
    }

    private boolean configExists(String configSet) throws IOException {
        return this.configSetHelper.checkConfigExists(configSet);
    }

    private void deleteConfig(String configSet) throws IOException {
        this.configSetHelper.deleteConfig(configSet);
    }

    private void copyConfig(String from, String to) throws IOException {
        this.configSetHelper.copyConfig(from, to);
    }

    private void validateNewConfigSetName(String configSet) {
        if (configSet.length() > 50) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Schema name should be 50 characters or less");
        }
        if (configSet.contains(" ") || configSet.contains("/")) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Schema name should not contain spaces or forward slash");
        }
    }

    private boolean pathExistsInZk(String zkPath) throws IOException {
        SolrZkClient zkClient = this.zkStateReader().getZkClient();
        try {
            return zkClient.exists(zkPath, true);
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Failed to check if path exists: " + zkPath, SolrZkClient.checkInterrupted((Throwable)e));
        }
    }

    private static class InMemoryResourceLoader
    extends SolrResourceLoader {
        String resource;
        byte[] data;
        ZkSolrResourceLoader delegate;

        public InMemoryResourceLoader(CoreContainer cc, String configSet, String resource, byte[] data) {
            super(cc.getResourceLoader().getInstancePath(), cc.getResourceLoader().getClassLoader());
            SolrResourceLoader resourceLoader = cc.getResourceLoader();
            this.delegate = new ZkSolrResourceLoader(resourceLoader.getInstancePath(), configSet, resourceLoader.getClassLoader(), new Properties(), cc.getZkController());
            this.resource = resource;
            this.data = data;
        }

        @Override
        public InputStream openResource(String res) throws IOException {
            return this.resource.equals(res) ? new ByteArrayInputStream(this.data) : this.delegate.openResource(res);
        }
    }
}

