/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ParserDQL;
import org.hsqldb.Session;
import org.hsqldb.StatementDMQL;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.map.BaseHashMap;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.result.Result;

public class StatementExpression
extends StatementDMQL {
    Expression expression;

    StatementExpression(Session session, ParserDQL.CompileContext compileContext, int n, Expression expression) {
        super(n, 2007, null);
        switch (n) {
            case 62: 
            case 1211: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "");
            }
        }
        this.isTransactionStatement = false;
        this.expression = expression;
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
    }

    @Override
    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case 62: {
                return this.sql;
            }
            case 1211: {
                stringBuffer.append(this.expression.getSQL());
            }
        }
        return stringBuffer.toString();
    }

    @Override
    TableDerived[] getSubqueries(Session session) {
        BaseHashMap baseHashMap = null;
        if (this.expression != null) {
            baseHashMap = this.expression.collectAllSubqueries((OrderedHashSet)baseHashMap);
        }
        if (baseHashMap == null || baseHashMap.size() == 0) {
            return TableDerived.emptyArray;
        }
        Object[] objectArray = new TableDerived[baseHashMap.size()];
        ((OrderedHashSet)baseHashMap).toArray(objectArray);
        for (int i = 0; i < this.subqueries.length; ++i) {
            ((TableDerived)objectArray[i]).prepareTable(session);
        }
        return objectArray;
    }

    protected String describe(Session session, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append("STATEMENT");
        return stringBuffer.toString();
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            if (this.subqueries.length > 0) {
                this.materializeSubQueries(session);
            }
            result = this.getResult(session);
        }
        catch (Throwable throwable) {
            result = Result.newErrorResult(throwable);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    @Override
    Result getResult(Session session) {
        switch (this.type) {
            case 62: 
            case 1211: {
                Result result = this.expression.getResult(session);
                if (result.isData()) {
                    RowSetNavigatorData rowSetNavigatorData = new RowSetNavigatorData(session, result.getNavigator());
                    result.setNavigator(rowSetNavigatorData);
                }
                return result;
            }
        }
        throw Error.runtimeError(201, "");
    }

    @Override
    public void resolve(Session session) {
    }

    @Override
    String describeImpl(Session session) throws Exception {
        return this.getSQL();
    }

    @Override
    void collectTableNamesForRead(OrderedHashSet orderedHashSet) {
        int n;
        for (n = 0; n < this.subqueries.length; ++n) {
            if (this.subqueries[n].queryExpression == null) continue;
            this.subqueries[n].queryExpression.getBaseTableNames(orderedHashSet);
        }
        for (n = 0; n < this.routines.length; ++n) {
            orderedHashSet.addAll(this.routines[n].getTableNamesForRead());
        }
    }

    @Override
    void collectTableNamesForWrite(OrderedHashSet orderedHashSet) {
    }
}

