/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

class OneNoteDirectFileResource
implements Closeable {
    private static final int TRANSFER_SIZE = 8192;
    private RandomAccessFile raf;

    public OneNoteDirectFileResource(File f) throws IOException {
        this.raf = new RandomAccessFile(f, "r");
    }

    public int read() throws IOException {
        return this.raf.read();
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        int bytesToRead;
        int totalRead;
        int len = byteBuffer.remaining();
        int bytesRead = 0;
        byte[] buf = new byte[8192];
        for (totalRead = 0; totalRead < len && (bytesRead = this.raf.read(buf, 0, bytesToRead = Math.min(len - totalRead, 8192))) >= 0; totalRead += bytesRead) {
            byteBuffer.put(buf, 0, bytesRead);
        }
        if (bytesRead < 0 && this.position() == this.size() && byteBuffer.hasRemaining()) {
            throw new IOException("End of stream reached earlier than expected");
        }
        return bytesRead < 0 && totalRead == 0 ? -1 : totalRead;
    }

    public long size() throws IOException {
        return this.raf.length();
    }

    public long position() throws IOException {
        return this.raf.getFilePointer();
    }

    public void position(long nuPos) throws IOException {
        if (nuPos > this.raf.length()) {
            throw new IOException("requesting seek past end of stream");
        }
        this.raf.seek(nuPos);
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }
}

