/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.stats;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.TermStatistics;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.stats.StatsCache;
import org.apache.solr.search.stats.StatsSource;

public final class LocalStatsSource
extends StatsSource {
    private final StatsCache.StatsCacheMetrics metrics;

    public LocalStatsSource(StatsCache.StatsCacheMetrics metrics) {
        this.metrics = metrics;
    }

    @Override
    public TermStatistics termStatistics(SolrIndexSearcher localSearcher, Term term, int docFreq, long totalTermFreq) throws IOException {
        this.metrics.missingGlobalTermStats.increment();
        return localSearcher.localTermStatistics(term, docFreq, totalTermFreq);
    }

    @Override
    public CollectionStatistics collectionStatistics(SolrIndexSearcher localSearcher, String field) throws IOException {
        this.metrics.missingGlobalFieldStats.increment();
        return localSearcher.localCollectionStatistics(field);
    }
}

