/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.mockfile;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemException;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.mockfile.HandleTrackingFS;

public class HandleLimitFS
extends HandleTrackingFS {
    final int limit;
    final AtomicInteger count = new AtomicInteger();

    public HandleLimitFS(FileSystem delegate, int limit) {
        super("handlelimit://", delegate);
        this.limit = limit;
    }

    @Override
    protected void onOpen(Path path, Object stream) throws IOException {
        if (this.count.incrementAndGet() > this.limit) {
            this.count.decrementAndGet();
            throw new FileSystemException(path.toString(), null, "Too many open files");
        }
    }

    @Override
    protected void onClose(Path path, Object stream) throws IOException {
        this.count.decrementAndGet();
    }
}

