/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.velocity.tools.ConversionUtils;
import org.apache.velocity.tools.config.DefaultKey;
import org.apache.velocity.tools.config.InvalidScope;
import org.apache.velocity.tools.config.SkipSetters;
import org.apache.velocity.tools.generic.FormatConfig;

@DefaultKey(value="parser")
@InvalidScope(value={"session"})
@SkipSetters
public class ValueParser
extends FormatConfig
implements Map<String, Object> {
    public static final String STRINGS_DELIMITER_FORMAT_KEY = "stringsDelimiter";
    public static final String DEFAULT_STRINGS_DELIMITER = ",";
    private String stringsDelimiter = ",";
    private Map<String, Object> source = null;
    private boolean allowSubkeys = true;
    private Boolean hasSubkeys = null;
    private boolean readOnly = true;
    public static final String ALLOWSUBKEYS_KEY = "allowSubkeys";
    public static final String READONLY_KEY = "readOnly";

    public ValueParser() {
    }

    public ValueParser(Map<String, Object> source) {
        this.setSource(source);
    }

    protected void setSource(Map<String, Object> source) {
        this.source = source;
    }

    protected Map<String, Object> getSource(boolean create) {
        if (this.source == null && create) {
            this.source = new HashMap<String, Object>();
        }
        return this.source;
    }

    protected Map<String, Object> getSource() {
        return this.getSource(true);
    }

    protected boolean getAllowSubkeys() {
        return this.allowSubkeys;
    }

    protected void setAllowSubkeys(boolean allow) {
        this.allowSubkeys = allow;
    }

    protected boolean getReadOnly() {
        return this.readOnly;
    }

    protected void setReadOnly(boolean ro) {
        this.readOnly = ro;
    }

    protected final void setStringsDelimiter(String stringsDelimiter) {
        this.stringsDelimiter = stringsDelimiter;
    }

    @Override
    protected void configure(ValueParser values) {
        Boolean ro;
        Boolean allow;
        super.configure(values);
        String delimiter = values.getString(STRINGS_DELIMITER_FORMAT_KEY);
        if (delimiter != null) {
            this.setStringsDelimiter(delimiter);
        }
        if ((allow = values.getBoolean(ALLOWSUBKEYS_KEY)) != null) {
            this.setAllowSubkeys(allow);
        }
        if ((ro = values.getBoolean(READONLY_KEY)) != null) {
            this.setReadOnly(ro);
        }
    }

    public boolean exists(String key) {
        return this.getValue(key) != null;
    }

    public Object get(String key) {
        Object value = this.getValue(key);
        if (value == null && this.getSource() != null && this.getAllowSubkeys()) {
            value = this.getSubkey(key);
        }
        return value;
    }

    public Object getValue(String key) {
        if (this.getSource() == null) {
            return null;
        }
        return this.getSource().get(key);
    }

    public Object getValue(String key, Object alternate) {
        Object value = this.getValue(key);
        if (value == null) {
            return alternate;
        }
        return value;
    }

    protected String[] parseStringList(String value) {
        String[] values = this.stringsDelimiter.length() == 0 || value.indexOf(this.stringsDelimiter) < 0 ? new String[]{value} : value.split(this.stringsDelimiter);
        return values;
    }

    public Object[] getValues(String key) {
        Object value = this.getValue(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.parseStringList((String)value);
        }
        if (value instanceof Object[]) {
            return (Object[])value;
        }
        return new Object[]{value};
    }

    public String getString(String key) {
        return ConversionUtils.toString(this.getValue(key));
    }

    public String getString(String key, String alternate) {
        String s = this.getString(key);
        return s != null ? s : alternate;
    }

    public Boolean getBoolean(String key) {
        return ConversionUtils.toBoolean(this.getValue(key));
    }

    public boolean getBoolean(String key, boolean alternate) {
        Boolean bool = this.getBoolean(key);
        return bool != null ? bool : alternate;
    }

    public Boolean getBoolean(String key, Boolean alternate) {
        Boolean bool = this.getBoolean(key);
        return bool != null ? bool : alternate;
    }

    public Integer getInteger(String key) {
        Object value = this.getValue(key);
        if (value == null) {
            return null;
        }
        Number number = ConversionUtils.toNumber(value, this.getFormat(), this.getLocale());
        return number == null ? null : Integer.valueOf(number.intValue());
    }

    public Integer getInteger(String key, Integer alternate) {
        Integer num = this.getInteger(key);
        if (num == null) {
            return alternate;
        }
        return num;
    }

    public Double getDouble(String key) {
        Object value = this.getValue(key);
        if (value == null) {
            return null;
        }
        Number number = ConversionUtils.toNumber(value, this.getFormat(), this.getLocale());
        return number == null ? null : Double.valueOf(number.doubleValue());
    }

    public Double getDouble(String key, Double alternate) {
        Double num = this.getDouble(key);
        if (num == null) {
            return alternate;
        }
        return num;
    }

    public Number getNumber(String key) {
        return ConversionUtils.toNumber(this.getValue(key), this.getFormat(), this.getLocale());
    }

    public Locale getLocale(String key) {
        return this.toLocale(this.getValue(key));
    }

    public Number getNumber(String key, Number alternate) {
        Number n = this.getNumber(key);
        return n != null ? (Number)n : (Number)alternate;
    }

    public int getInt(String key, int alternate) {
        Number n = this.getNumber(key);
        return n != null ? n.intValue() : alternate;
    }

    public double getDouble(String key, double alternate) {
        Number n = this.getNumber(key);
        return n != null ? n.doubleValue() : alternate;
    }

    public Locale getLocale(String key, Locale alternate) {
        Locale l = this.getLocale(key);
        return l != null ? l : alternate;
    }

    public String[] getStrings(String key) {
        Object[] array = this.getValues(key);
        if (array == null || String.class.isAssignableFrom(array.getClass().getComponentType())) {
            return (String[])array;
        }
        String[] ret = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            ret[i] = ConversionUtils.toString(array[i]);
        }
        return ret;
    }

    public Boolean[] getBooleans(String key) {
        Object[] array = this.getValues(key);
        if (array == null || Boolean.class.isAssignableFrom(array.getClass().getComponentType())) {
            return (Boolean[])array;
        }
        Boolean[] ret = new Boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            ret[i] = ConversionUtils.toBoolean(array[i]);
        }
        return ret;
    }

    public Number[] getNumbers(String key) {
        Object[] array = this.getValues(key);
        if (array == null || Number.class.isAssignableFrom(array.getClass().getComponentType())) {
            return (Number[])array;
        }
        Number[] ret = new Number[array.length];
        for (int i = 0; i < array.length; ++i) {
            ret[i] = ConversionUtils.toNumber(array[i], this.getFormat(), this.getLocale());
        }
        return ret;
    }

    public int[] getInts(String key) {
        Object[] array = this.getValues(key);
        if (array == null) {
            return null;
        }
        int[] ret = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            ret[i] = ConversionUtils.toNumber(array[i], this.getFormat(), this.getLocale()).intValue();
        }
        return ret;
    }

    public double[] getDoubles(String key) {
        Object[] array = this.getValues(key);
        if (array == null) {
            return null;
        }
        double[] ret = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            ret[i] = ConversionUtils.toNumber(array[i], this.getFormat(), this.getLocale()).doubleValue();
        }
        return ret;
    }

    public Locale[] getLocales(String key) {
        Object[] array = this.getValues(key);
        if (array == null || Locale.class.isAssignableFrom(array.getClass().getComponentType())) {
            return (Locale[])array;
        }
        Locale[] ret = new Locale[array.length];
        for (int i = 0; i < array.length; ++i) {
            ret[i] = ConversionUtils.toLocale(String.valueOf(array[i]));
        }
        return ret;
    }

    public boolean hasSubkeys() {
        if (this.getSource() == null || !this.getAllowSubkeys()) {
            return false;
        }
        if (this.hasSubkeys == null) {
            for (String key : this.getSource().keySet()) {
                int dot = key.indexOf(46);
                if (dot <= 0 || dot >= key.length()) continue;
                this.hasSubkeys = Boolean.TRUE;
                break;
            }
            if (this.hasSubkeys == null) {
                this.hasSubkeys = Boolean.FALSE;
            }
        }
        return this.hasSubkeys;
    }

    public Set<String> getSubkeys() {
        Set<String> keys = this.keySet();
        if (this.getSource() == null || !this.getAllowSubkeys()) {
            return keys;
        }
        TreeSet<String> result = new TreeSet<String>();
        for (String key : keys) {
            int dot = key.indexOf(46);
            if (dot <= 0 || dot >= key.length()) continue;
            result.add(key.substring(0, dot));
        }
        return result;
    }

    protected ValueParser getSubkey(String subkey) {
        if (!this.hasSubkeys() || subkey == null || subkey.length() == 0) {
            return null;
        }
        HashMap<String, Object> values = null;
        subkey = subkey.concat(".");
        for (Map.Entry<String, Object> entry : this.getSource().entrySet()) {
            if (!entry.getKey().startsWith(subkey) || entry.getKey().length() <= subkey.length()) continue;
            if (values == null) {
                values = new HashMap<String, Object>();
            }
            values.put(entry.getKey().substring(subkey.length()), entry.getValue());
        }
        if (values == null) {
            return null;
        }
        ValueParser ret = new ValueParser(values);
        ret.setReadOnly(this.getReadOnly());
        return ret;
    }

    @Override
    public int size() {
        return this.getSource() == null ? 0 : this.getSource().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getSource() == null || this.getSource().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getSource() == null ? false : this.getSource().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getSource() == null ? false : this.getSource().containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.get(String.valueOf(key));
    }

    @Override
    public Object put(String key, Object value) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Cannot put(" + key + DEFAULT_STRINGS_DELIMITER + value + "); " + this.getClass().getName() + " is read-only");
        }
        if (this.hasSubkeys != null && this.hasSubkeys.equals(Boolean.FALSE) && key.indexOf(46) != -1) {
            this.hasSubkeys = Boolean.TRUE;
        }
        return this.getSource().put(key, value);
    }

    @Override
    public Object remove(Object key) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Cannot remove(" + key + "); " + this.getClass().getName() + " is read-only");
        }
        if (this.hasSubkeys != null && this.hasSubkeys.equals(Boolean.TRUE) && ((String)key).indexOf(46) != -1) {
            this.hasSubkeys = null;
        }
        return this.getSource().remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Cannot putAll(" + m + "); " + this.getClass().getName() + " is read-only");
        }
        this.hasSubkeys = null;
        this.getSource().putAll(m);
    }

    @Override
    public void clear() {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Cannot clear(); " + this.getClass().getName() + " is read-only");
        }
        this.hasSubkeys = Boolean.FALSE;
        this.getSource().clear();
    }

    @Override
    public Set<String> keySet() {
        return this.getSource() == null ? null : this.getSource().keySet();
    }

    @Override
    public Collection values() {
        return this.getSource() == null ? null : this.getSource().values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.getSource().entrySet();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        boolean empty = true;
        for (Map.Entry<String, Object> entry : this.entrySet()) {
            if (!empty) {
                builder.append(", ");
            }
            empty = false;
            builder.append(entry.getKey());
            builder.append('=');
            builder.append(String.valueOf(entry.getValue()));
        }
        builder.append('}');
        return builder.toString();
    }
}

