/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.gax.httpjson.ApiMessage;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.List;

public class FieldMaskedSerializer
implements JsonSerializer<ApiMessage> {
    private final List<String> fieldMask;

    public FieldMaskedSerializer(List<String> fieldMask) {
        this.fieldMask = fieldMask;
    }

    public JsonElement serialize(ApiMessage requestBody, Type typeOfSrc, JsonSerializationContext context) {
        Gson gson = new GsonBuilder().serializeNulls().create();
        if (this.fieldMask == null) {
            return gson.toJsonTree((Object)requestBody, typeOfSrc);
        }
        JsonObject jsonObject = new JsonObject();
        for (String fieldName : this.fieldMask) {
            Object fieldValue = requestBody.getFieldValue(fieldName);
            if (fieldValue != null) {
                jsonObject.add(fieldName, gson.toJsonTree(fieldValue, fieldValue.getClass()));
                continue;
            }
            jsonObject.add(fieldName, (JsonElement)JsonNull.INSTANCE);
        }
        return jsonObject;
    }
}

