/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.aggregaterows;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.aggregaterows.AggregateRows;
import org.pentaho.di.trans.steps.aggregaterows.AggregateRowsData;
import org.pentaho.di.trans.steps.aggregaterows.Messages;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateRowsMeta
extends BaseStepMeta
implements StepMetaInterface {
    public static final int TYPE_AGGREGATE_NONE = 0;
    public static final int TYPE_AGGREGATE_SUM = 1;
    public static final int TYPE_AGGREGATE_AVERAGE = 2;
    public static final int TYPE_AGGREGATE_COUNT = 3;
    public static final int TYPE_AGGREGATE_MIN = 4;
    public static final int TYPE_AGGREGATE_MAX = 5;
    public static final int TYPE_AGGREGATE_FIRST = 6;
    public static final int TYPE_AGGREGATE_LAST = 7;
    public static final int TYPE_AGGREGATE_FIRST_NULL = 8;
    public static final int TYPE_AGGREGATE_LAST_NULL = 9;
    public static final String[] aggregateTypeDesc = new String[]{Messages.getString("AggregateRowsMeta.AggregateTypeDesc.NONE"), Messages.getString("AggregateRowsMeta.AggregateTypeDesc.SUM"), Messages.getString("AggregateRowsMeta.AggregateTypeDesc.AVERAGE"), Messages.getString("AggregateRowsMeta.AggregateTypeDesc.COUNT"), Messages.getString("AggregateRowsMeta.AggregateTypeDesc.MIN"), Messages.getString("AggregateRowsMeta.AggregateTypeDesc.MAX"), Messages.getString("AggregateRowsMeta.AggregateTypeDesc.FIRST"), Messages.getString("AggregateRowsMeta.AggregateTypeDesc.LAST"), Messages.getString("AggregateRowsMeta.AggregateTypeDesc.FIRST_NULL"), Messages.getString("AggregateRowsMeta.AggregateTypeDesc.LAST_NULL")};
    private String[] fieldName;
    private String[] fieldNewName;
    private int[] aggregateType;

    public int[] getAggregateType() {
        return this.aggregateType;
    }

    public void setAggregateType(int[] aggregateType) {
        this.aggregateType = aggregateType;
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public String[] getFieldNewName() {
        return this.fieldNewName;
    }

    public void setFieldNewName(String[] fieldNewName) {
        this.fieldNewName = fieldNewName;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields) {
        this.fieldName = new String[nrfields];
        this.fieldNewName = new String[nrfields];
        this.aggregateType = new int[nrfields];
    }

    public static final String getTypeDesc(int t) {
        if (t < 0 || t >= aggregateTypeDesc.length) {
            return null;
        }
        return aggregateTypeDesc[t];
    }

    public static final int getType(String at) {
        for (int i = 0; i < aggregateTypeDesc.length; ++i) {
            if (!aggregateTypeDesc[i].equalsIgnoreCase(at)) continue;
            return i;
        }
        return 0;
    }

    @Override
    public Object clone() {
        AggregateRowsMeta retval = (AggregateRowsMeta)super.clone();
        int nrfields = this.fieldName.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.fieldName[i] = this.fieldName[i];
            retval.fieldNewName[i] = this.fieldNewName[i];
            retval.aggregateType[i] = this.aggregateType[i];
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.fieldNewName[i] = XMLHandler.getTagValue((Node)fnode, (String)"rename");
                String type = XMLHandler.getTagValue((Node)fnode, (String)"type");
                this.aggregateType[i] = AggregateRowsMeta.getType(type);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("AggregateRowsMeta.Exception.UnableToLoadStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.fieldName[i] = Messages.getString("AggregateRowsMeta.Fieldname.Label");
            this.fieldNewName[i] = Messages.getString("AggregateRowsMeta.NewName.Label");
            this.aggregateType[i] = 1;
        }
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        ValueMetaInterface v;
        int i;
        int[] fieldnrs = new int[this.fieldName.length];
        ValueMetaInterface[] values = new ValueMetaInterface[this.fieldName.length];
        for (i = 0; i < this.fieldName.length; ++i) {
            fieldnrs[i] = row.indexOfValue(this.fieldName[i]);
            v = row.getValueMeta(fieldnrs[i]);
            values[i] = v.clone();
            switch (this.aggregateType[i]) {
                case 1: 
                case 2: 
                case 3: {
                    values[i].setType(1);
                    values[i].setLength(-1, -1);
                }
            }
        }
        row.clear();
        for (i = 0; i < this.fieldName.length; ++i) {
            v = values[i];
            v.setName(this.fieldNewName[i]);
            v.setOrigin(name);
            row.addValueMeta(v);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"rename", (String)this.fieldNewName[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)AggregateRowsMeta.getTypeDesc(this.aggregateType[i])));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.fieldNewName[i] = rep.getStepAttributeString(id_step, i, "field_rename");
                this.aggregateType[i] = AggregateRowsMeta.getType(rep.getStepAttributeString(id_step, i, "field_type"));
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("AggregateRowsMeta.Exception.UnexpectedErrorWhileReadingStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            for (int i = 0; i < this.fieldName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", this.fieldName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_rename", this.fieldNewName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_type", AggregateRowsMeta.getTypeDesc(this.aggregateType[i]));
            }
        }
        catch (KettleException e) {
            throw new KettleException(Messages.getString("AggregateRowsMeta.Exception.UnableToSaveStepInfo") + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        String message = "";
        if (this.fieldName.length > 0) {
            int i;
            boolean error_found = false;
            message = Messages.getString("AggregateRowsMeta.CheckResult.FieldsNotFound.DialogMessage") + Const.CR;
            for (i = 0; i < this.fieldName.length; ++i) {
                if (prev.indexOfValue(this.fieldName[i]) >= 0) continue;
                message = message + "  " + this.fieldName[i] + Const.CR;
                error_found = true;
            }
            if (error_found) {
                cr = new CheckResult(4, message, (CheckResultSourceInterface)stepMeta);
            } else {
                message = Messages.getString("AggregateRowsMeta.CheckResult.AllFieldsOK.DialogMessage");
                cr = new CheckResult(1, message, (CheckResultSourceInterface)stepMeta);
            }
            remarks.add((CheckResultInterface)cr);
            message = Messages.getString("AggregateRowsMeta.CheckResult.IgnoredFields.DialogMessage") + Const.CR;
            error_found = false;
            for (i = 0; i < prev.size(); ++i) {
                ValueMetaInterface v = prev.getValueMeta(i);
                boolean value_found = false;
                for (int j = 0; j < this.fieldName.length && !value_found; ++j) {
                    if (!v.getName().equalsIgnoreCase(this.fieldName[j])) continue;
                    value_found = true;
                }
                if (value_found) continue;
                message = message + "  " + v.getName() + " (" + v.toStringMeta() + ")" + Const.CR;
                error_found = true;
            }
            if (error_found) {
                cr = new CheckResult(2, message, (CheckResultSourceInterface)stepMeta);
            } else {
                message = Messages.getString("AggregateRowsMeta.CheckResult.AllFieldsUsed.DialogMessage");
                cr = new CheckResult(1, message, (CheckResultSourceInterface)stepMeta);
            }
            remarks.add((CheckResultInterface)cr);
        } else {
            message = Messages.getString("AggregateRowsMeta.CheckResult.NothingSpecified.DialogMessage");
            cr = new CheckResult(3, message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, Messages.getString("AggregateRowsMeta.CheckResult.StepReceiveInfo.DialogMessage"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("AggregateRowsMeta.CheckResult.NoInputReceived.DialogMessage"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new AggregateRows(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new AggregateRowsData();
    }
}

