/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.filemonitoring;

import com.almworks.tracklink.TrackLinkPlugin;
import com.almworks.tracklink.codelinks.CodeLinkType;
import com.almworks.tracklink.filemonitoring.FileMapper;
import com.almworks.tracklink.util.StringBundle;
import com.intellij.openapi.localVcs.LocalVcs;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.almworks.util.detach.Detach;
import org.almworks.util.detach.Lifespan;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileMapperImpl
implements FileMapper {
    private static final String FILE_ELEM = "fileAssociations";
    private static final String FILE_URL_ATTR = "fileURL";
    private static final String URL_ELEM = "URL";
    private static final String URL_VALUE_ATTR = "urlValue";
    private static final String ACTIVE_URL_ELEM = "activeURL";
    private final Set<String> myActiveUrls = new HashSet<String>();
    private final Map<String, Set<String>> myFileMap = new HashMap<String, Set<String>>();
    private final List<Runnable> myListeners = new ArrayList<Runnable>();
    private final List<FileMapper.Listener> myAssociationChangeListeners = new ArrayList<FileMapper.Listener>(4);
    private final String myProjectUrl;

    public FileMapperImpl(String projectUrl) {
        this.myProjectUrl = projectUrl;
    }

    public FileMapperImpl() {
        this.myProjectUrl = null;
    }

    @Override
    public boolean isURLActive(String url) {
        return this.myActiveUrls.contains(url);
    }

    @Override
    public void activateURLs(Collection<String> urls) {
        if (this.myActiveUrls.addAll(urls)) {
            for (Runnable runnable : this.myListeners) {
                runnable.run();
            }
        }
    }

    @Override
    public void deactivateURLs(Collection<String> urls) {
        if (this.myActiveUrls.removeAll(urls)) {
            for (Runnable runnable : this.myListeners) {
                runnable.run();
            }
        }
    }

    @Override
    public void forgetFiles(@NotNull VirtualFile[] files) {
        if (files == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/filemonitoring/FileMapperImpl.forgetFiles must not be null");
        }
        for (VirtualFile file : files) {
            this.myFileMap.remove(file.getUrl());
        }
        this.fireAssociationsChanged(Arrays.asList(files));
    }

    @Override
    public Collection<String> getActiveUrls() {
        return new ArrayList<String>(this.myActiveUrls);
    }

    @Override
    @Nullable
    public Collection<String> getURLs(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/filemonitoring/FileMapperImpl.getURLs must not be null");
        }
        return this.myFileMap.get(file.getUrl());
    }

    @Override
    public boolean hasNoAssociations() {
        return this.myFileMap.isEmpty();
    }

    @Override
    public boolean hasNoData() {
        return this.myFileMap.isEmpty() && this.myActiveUrls.isEmpty();
    }

    @Override
    public void addActivityChangeListener(final Runnable runnable, Lifespan lifespan) {
        this.myListeners.add(runnable);
        lifespan.add(new Detach(){

            protected void doDetach() {
                FileMapperImpl.this.myListeners.remove(runnable);
            }
        });
    }

    @Override
    public void addAssociationsChangeListener(Lifespan life, final FileMapper.Listener listener) {
        this.myAssociationChangeListeners.add(listener);
        life.add(new Detach(){

            protected void doDetach() {
                FileMapperImpl.this.myAssociationChangeListeners.remove(listener);
            }
        });
    }

    private void fireAssociationsChanged(Collection<VirtualFile> files) {
        FileMapper.Listener[] listeners;
        ArrayList<VirtualFile> fixedList = null;
        for (VirtualFile file : files) {
            if (file.isValid()) continue;
            fixedList = new ArrayList<VirtualFile>(files.size());
            for (VirtualFile fileCopied : files) {
                if (!fileCopied.isValid()) continue;
                fixedList.add(fileCopied);
            }
        }
        if (fixedList != null) {
            files = fixedList;
        }
        for (FileMapper.Listener listener : listeners = this.myAssociationChangeListeners.toArray(new FileMapper.Listener[this.myAssociationChangeListeners.size()])) {
            listener.onAssociationsChanged(files);
        }
    }

    private void fireAssociationChanged(VirtualFile file) {
        this.fireAssociationsChanged(Collections.singleton(file));
    }

    @Override
    public void forgetURLs(Collection<String> urls) {
        Set<String> fileURLs = this.myFileMap.keySet();
        Collection<VirtualFile> files = this.findVirtualFiles(fileURLs);
        this.myFileMap.clear();
        this.fireAssociationsChanged(files);
    }

    private Collection<VirtualFile> findVirtualFiles(Collection<String> fileURLs) {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (String fileURL : fileURLs) {
            VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(fileURL);
            if (file == null || !file.isValid()) continue;
            files.add(file);
        }
        return files;
    }

    @Override
    public void fileChanged(@NotNull VirtualFile file) {
        boolean changed;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/filemonitoring/FileMapperImpl.fileChanged must not be null");
        }
        if (this.myActiveUrls.isEmpty()) {
            return;
        }
        String fileURL = file.getUrl();
        Set<String> urls = this.myFileMap.get(fileURL);
        if (urls == null) {
            changed = !this.myActiveUrls.isEmpty();
            urls = new HashSet<String>(this.myActiveUrls);
            this.myFileMap.put(fileURL, urls);
            Project project = this.getProject();
            if (!urls.isEmpty() && project != null) {
                TrackLinkPlugin linkPlugin = (TrackLinkPlugin)project.getComponent(TrackLinkPlugin.class);
                List<CodeLinkType> codeLinkTypes = linkPlugin.getIssueModel().getReferenceTypes();
                StringBuffer label = new StringBuffer();
                int typedCount = 0;
                block0: for (String url : urls) {
                    for (CodeLinkType codeLinkType : codeLinkTypes) {
                        String visualID = codeLinkType.getVisualID(url);
                        if (visualID == null) continue;
                        label.append(visualID).append(", ");
                        ++typedCount;
                        continue block0;
                    }
                }
                int pos = label.lastIndexOf(", ");
                if (pos == label.length() - 2) {
                    label.delete(pos, pos + 2);
                }
                LocalVcs.getInstance((Project)project).startAction(StringBundle.get("working.on", typedCount, label.toString()), file.getPath(), false).finish();
            }
        } else {
            changed = !urls.containsAll(this.myActiveUrls);
            urls.addAll(this.myActiveUrls);
        }
        if (changed) {
            this.fireAssociationChanged(file);
        }
    }

    @Override
    public void associate(VirtualFile file, Collection<String> newUrls) {
        String fileUrl = file.getUrl();
        Set<String> urls = this.myFileMap.get(fileUrl);
        if (urls == null) {
            urls = new HashSet<String>();
            this.myFileMap.put(fileUrl, urls);
        }
        urls.addAll(newUrls);
        this.fireAssociationChanged(file);
    }

    @Override
    public Collection<String> chooseNotAssociated(VirtualFile file, Collection<String> urls) {
        Set<String> associations = this.myFileMap.get(file.getUrl());
        if (associations == null) {
            return urls;
        }
        Collection result = null;
        for (String url : urls) {
            if (associations.contains(url)) continue;
            if (result == null) {
                result = new ArrayList();
            }
            result.add(url);
        }
        return result != null ? result : Collections.EMPTY_SET;
    }

    @Override
    public Collection<String> chooseAssociated(VirtualFile file, Collection<String> urls) {
        Set<String> associations = this.myFileMap.get(file.getUrl());
        if (associations == null) {
            return Collections.EMPTY_SET;
        }
        Collection result = null;
        for (String url : urls) {
            if (!associations.contains(url)) continue;
            if (result == null) {
                result = new ArrayList();
            }
            result.add(url);
        }
        return result != null ? result : Collections.EMPTY_SET;
    }

    @Override
    public void deassociate(VirtualFile file, Collection<String> removeUrls) {
        String fileUrl = file.getUrl();
        Set<String> urls = this.myFileMap.get(fileUrl);
        if (urls != null) {
            urls.removeAll(removeUrls);
        }
        this.fireAssociationChanged(file);
    }

    @Nullable
    private Project getProject() {
        Project[] projects;
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            String projectUrl;
            VirtualFile baseDir = project.getBaseDir();
            if (baseDir == null || (projectUrl = baseDir.getUrl()) == null || !Comparing.strEqual((String)projectUrl, (String)this.myProjectUrl)) continue;
            return project;
        }
        return null;
    }

    @Override
    public Collection<VirtualFile> getModifiedFiles(String url) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        Set<String> files = this.myFileMap.keySet();
        for (String fileURL : files) {
            VirtualFile vFile;
            if (!this.myFileMap.get(fileURL).contains(url) || (vFile = VirtualFileManager.getInstance().findFileByUrl(fileURL)) == null) continue;
            result.add(vFile);
        }
        return result;
    }

    public void readExternal(Element element) throws InvalidDataException {
        List fileElements = element.getChildren(FILE_ELEM);
        for (Element fileElement : fileElements) {
            HashSet<String> urls = new HashSet<String>();
            String fileURL = fileElement.getAttributeValue(FILE_URL_ATTR);
            List urlElements = fileElement.getChildren(URL_ELEM);
            for (Element urlElement : urlElements) {
                String url = urlElement.getAttributeValue(URL_VALUE_ATTR);
                if (url == null) continue;
                urls.add(url);
            }
            this.myFileMap.put(fileURL, urls);
        }
        List activeURLs = element.getChildren(ACTIVE_URL_ELEM);
        for (Element el : activeURLs) {
            String url = el.getAttributeValue(URL_VALUE_ATTR);
            if (url == null) continue;
            this.myActiveUrls.add(url);
        }
        this.fireAssociationsChanged(this.findVirtualFiles(this.myFileMap.keySet()));
    }

    public void writeExternal(Element element) throws WriteExternalException {
        Set<String> fileURLs = this.myFileMap.keySet();
        for (String fileURL : fileURLs) {
            Element fileElement = new Element(FILE_ELEM);
            fileElement.setAttribute(FILE_URL_ATTR, fileURL);
            Set<String> urls = this.myFileMap.get(fileURL);
            for (String url : urls) {
                Element urlElement = new Element(URL_ELEM);
                urlElement.setAttribute(URL_VALUE_ATTR, url);
                fileElement.addContent(urlElement);
            }
            element.addContent(fileElement);
        }
        for (String activeURL : this.myActiveUrls) {
            Element urlElement = new Element(ACTIVE_URL_ELEM);
            urlElement.setAttribute(URL_VALUE_ATTR, activeURL);
            element.addContent(urlElement);
        }
    }
}

