<elements>
  <summary>
    <attribution license="cc4" from="Microsoft" modified="false" />
    <para>The System.Xml.Xsl namespace provides support for Extensible Stylesheet Transformation (XSLT) transforms. It supports the W3C XSL Transformations (XSLT) Version 1.0 Recommendation (www.w3.org/TR/xslt).</para>
  </summary>
  <remarks />
  <class name="IXsltContextFunction" fullname="System.Xml.Xsl.IXsltContextFunction" assembly="System.Xml">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Provides an interface to a given function defined in the Extensible Stylesheet Language for Transformations (XSLT) style sheet during runtime execution.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>For more information on using <see cref="T:System.Xml.Xsl.IXsltContextFunction" />, see article Q324899, "HOW TO: Implement and Use Custom Functions When You Execute XPath Queries in Visual Basic .NET" in the Microsoft Knowledge Base at http://support.microsoft.com.</para>
    </remarks>
  </class>
  <class name="IXsltContextVariable" fullname="System.Xml.Xsl.IXsltContextVariable" assembly="System.Xml">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Provides an interface to a given variable that is defined in the style sheet during runtime execution.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>For more information on using <see cref="T:System.Xml.Xsl.IXsltContextVariable" /> , see article Q324899, "HOW TO: Implement and Use Custom Functions When You Execute XPath Queries in Visual Basic .NET" in the Microsoft Knowledge Base at http://support.microsoft.com.</para>
    </remarks>
  </class>
  <class name="XslCompiledTransform" fullname="System.Xml.Xsl.XslCompiledTransform" assembly="System.Xml">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Transforms XML data using an XSLT style sheet.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The <see cref="T:System.Xml.Xsl.XslCompiledTransform" /> class is an XSLT processor that supports the XSLT 1.0 syntax. It is a new implementation and includes performance gains when compared to the obsolete <see cref="T:System.Xml.Xsl.XslTransform" /> class. The structure of the <see cref="T:System.Xml.Xsl.XslCompiledTransform" /> class is very similar to the <see cref="T:System.Xml.Xsl.XslTransform" /> class. The <see cref="Overload:System.Xml.Xsl.XslCompiledTransform.Load" /> method loads and compiles the style sheet, while the <see cref="Overload:System.Xml.Xsl.XslCompiledTransform.Transform" /> method executes the XSLT transform.</para>
      <para>Support for the XSLT document() function and embedded script blocks are disabled by default. These features can be enabled by creating an <see cref="T:System.Xml.Xsl.XsltSettings" /> object and passing it to the <see cref="Overload:System.Xml.Xsl.XslCompiledTransform.Load" /> method.</para>
      <para>For more information, see <format type="text/html"><a href="f9b074f6-d6f4-49dd-a093-df510bf0cf7b">Using the XsltCompiledTransform Class</a></format> and <format type="text/html"><a href="9404d758-679f-4ffb-995d-3d07d817659e">Migrating From the XslTransform Class</a></format>.</para>
      <format type="text/html">
        <h2>Security Considerations</h2>
      </format>
      <para>When creating an application that uses the <see cref="T:System.Xml.Xsl.XslCompiledTransform" /> class, you should be aware of the following items and their implications:</para>
      <list type="bullet">
        <item>
          <para>XSLT scripting is disabled by default. XSLT scripting should be enabled only if you require script support and you are working in a fully trusted environment. </para>
        </item>
        <item>
          <para>The XSLT document() function is disabled by default. If you enable the document() function, restrict the resources that can be accessed by passing an <see cref="T:System.Xml.XmlSecureResolver" /> object to the <see cref="Overload:System.Xml.Xsl.XslCompiledTransform.Transform" /> method.</para>
        </item>
        <item>
          <para>Extension objects are enabled by default. If an <see cref="T:System.Xml.Xsl.XsltArgumentList" /> object containing extension objects is passed to the <see cref="Overload:System.Xml.Xsl.XslCompiledTransform.Transform" /> method, they are utilized.</para>
        </item>
        <item>
          <para>XSLT style sheets can include references to other files and embedded script blocks. A malicious user can exploit this by supplying you with data or style sheets that when executed can cause your system to process until the computer runs low on resources.</para>
        </item>
        <item>
          <para>XSLT applications that run in a mixed trust environment can result in style sheet spoofing. For example, a malicious user can load an object with a harmful style sheet and hand it off to another user who subsequently calls the <see cref="Overload:System.Xml.Xsl.XslCompiledTransform.Transform" /> method and executes the transformation.</para>
        </item>
      </list>
      <para>These security issues can be mitigated by not enabling scripting or the document() function unless the style sheet comes from a trusted source, and by not accepting <see cref="T:System.Xml.Xsl.XslCompiledTransform" /> objects, XSLT style sheets, or XML source data from an untrusted source.</para>
    </remarks>
  </class>
  <class name="XsltArgumentList" fullname="System.Xml.Xsl.XsltArgumentList" assembly="System.Xml">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Contains a variable number of arguments which are either XSLT parameters or extension objects.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>This class is used by the <see cref="Overload:System.Xml.Xsl.XslCompiledTransform.Transform" /> method. It allows parameters and extension objects to be invoked from within the style sheet.</para>
      <para>When the parameters and objects are added to the <see cref="T:System.Xml.Xsl.XsltArgumentList" />, they are associated with a namespace qualified name and a namespace URI, respectively.</para>
      <para>The following are advantages to passing an object rather than using an embedded script such as &lt;msxsl:script&gt;: </para>
      <list type="bullet">
        <item>
          <para>Provides better encapsulation and reuse of classes.</para>
        </item>
        <item>
          <para>Allows style sheets to be smaller and more easily maintained.</para>
        </item>
        <item>
          <para>Supports passing node fragments (through the <see cref="T:System.Xml.XPath.XPathNavigator" />) to the style sheet.</para>
        </item>
      </list>
      <para>For more information about using the <see cref="T:System.Xml.Xsl.XsltArgumentList" />, see <format type="text/html"><a href="a4ebdbad-087c-4cfe-acc0-17c48142f81a">XSLT Extension Objects</a></format> and <format type="text/html"><a href="fe60aaa0-ae43-4b1c-9be1-426af66ba757">XSLT Parameters</a></format>.</para>
    </remarks>
  </class>
  <class name="XsltCompileException" fullname="System.Xml.Xsl.XsltCompileException" assembly="System.Xml">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The exception that is thrown by the Load method when an error is found in the XSLT style sheet.</para>
    </summary>
    <remarks>An instance of this class will be created to be thrown on an XSLT stylesheet compilation error. An input stylesheet in <see cref="M:System.Xml.Xsl.XslTransform.Load" /> method is compiled into internal compiled stylesheet (that contains, for example, all compiled XPath expressions in the stylesheet, via <see cref="M:System.Xml.XPath.XPathNavigator.Compile" /> method).</remarks>
  </class>
  <class name="XsltContext" fullname="System.Xml.Xsl.XsltContext" assembly="System.Xml">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Encapsulates the current execution context of the Extensible Stylesheet Language for Transformations (XSLT) processor allowing XML Path Language (XPath) to resolve functions, parameters, and namespaces within XPath expressions.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>For more information on using <see cref="T:System.Xml.Xsl.XsltContext" />, see article Q324899, "HOW TO: Implement and Use Custom Functions When You Execute XPath Queries in Visual Basic .NET" in the Microsoft Knowledge Base at http://support.microsoft.com.</para>
    </remarks>
  </class>
  <class name="XsltException" fullname="System.Xml.Xsl.XsltException" assembly="System.Xml">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The exception that is thrown when an error occurs while processing an XSLT transformation.</para>
    </summary>
    <remarks>An instance of this class will be created to be thrown on an XSLT dynamic (that is, evaluation, transformation) error.</remarks>
  </class>
  <class name="XsltMessageEncounteredEventArgs" fullname="System.Xml.Xsl.XsltMessageEncounteredEventArgs" assembly="System.Xml">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Provides data for the <see cref="E:System.Xml.Xsl.XsltArgumentList.XsltMessageEncountered" /> event.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The <see cref="E:System.Xml.Xsl.XsltArgumentList.XsltMessageEncountered" /> event occurs during XSLT processing when an xsl:message is specified in the style sheet.</para>
      <block subset="none" type="note">
        <para>If the terminate attribute is set to "yes", the XSLT processor stops executing the style sheet stops after the message is processed.</para>
      </block>
    </remarks>
  </class>
  <class name="XsltMessageEncounteredEventHandler" fullname="System.Xml.Xsl.XsltMessageEncounteredEventHandler" assembly="System.Xml">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents the method that will handle the <see cref="E:System.Xml.Xsl.XsltArgumentList.XsltMessageEncountered" /> event.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The <see cref="E:System.Xml.Xsl.XsltArgumentList.XsltMessageEncountered" /> event occurs during XSLT processing when an xsl:message is specified in the style sheet.</para>
      <para>For more information about event handler delegates, see <format type="text/html"><a href="d98fd58b-fa4f-4598-8378-addf4355a115">Events and Delegates</a></format>.</para>
    </remarks>
  </class>
  <class name="XslTransform" fullname="System.Xml.Xsl.XslTransform" assembly="System.Xml">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Transforms XML data using an Extensible Stylesheet Language for Transformations (XSLT) style sheet.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <block subset="none" type="note">
        <para>The <see cref="T:System.Xml.Xsl.XslTransform" /> class is obsolete in the Microsoft .NET Framework version 2.0. The <see cref="T:System.Xml.Xsl.XslCompiledTransform" /> class is the new XSLT processor. For more information, see <format type="text/html"><a href="f9b074f6-d6f4-49dd-a093-df510bf0cf7b">Using the XslCompiledTransform Class</a></format> and <format type="text/html"><a href="9404d758-679f-4ffb-995d-3d07d817659e">Migrating From the XslTransform Class</a></format>.</para>
      </block>
      <para>
        <see cref="T:System.Xml.Xsl.XslTransform" /> supports the XSLT 1.0 syntax. The XSLT style sheet must use the namespace http://www.w3.org/1999/XSL/Transform.</para>
      <para>Additional arguments can also be added to the style sheet using the <see cref="T:System.Xml.Xsl.XsltArgumentList" /> class. This class contains input parameters for the style sheet and extension objects which can be called from the style sheet.</para>
      <para>To transform XML data: </para>
      <list type="ordered">
        <item>
          <para>Create an <see cref="T:System.Xml.Xsl.XslTransform" /> object.</para>
        </item>
        <item>
          <para>Use the <see cref="Overload:System.Xml.Xsl.XslTransform.Load" /> method to load the style sheet for the transformation. This method has several overloads and can load a style sheet using an <see cref="T:System.Xml.XmlReader" />, <see cref="T:System.Xml.XPath.XPathNavigator" />, <see cref="T:System.Xml.XPath.IXPathNavigable" />, or a URL with the location of the file.</para>
        </item>
        <item>
          <para>Use the <see cref="Overload:System.Xml.Xsl.XslTransform.Transform" /> method to transform the XML data. This method has several overloads and can handle different types of input and output. You can also specify an <see cref="T:System.Xml.Xsl.XsltArgumentList" /> containing additional arguments to use as input during the transformation.</para>
        </item>
      </list>
      <para>Security Considerations</para>
      <para>When creating an application that uses the <see cref="T:System.Xml.Xsl.XslTransform" /> class, you should be aware of the following items and their implications:</para>
      <list type="bullet">
        <item>
          <para>Extension objects are enabled by default. If an <see cref="T:System.Xml.Xsl.XsltArgumentList" /> object containing extension objects is passed to the <see cref="Overload:System.Xml.Xsl.XslTransform.Transform" /> method, they are utilized.</para>
        </item>
        <item>
          <para>XSLT style sheets can include references to other files and embedded script blocks. A malicious user can exploit this by supplying you with data or style sheets that when executed will cause your system to process until the computer runs low on resources.</para>
        </item>
        <item>
          <para>XSLT applications that run in a mixed trust environment can result in style sheet spoofing. For example, a malicious user can load an object with a harmful style sheet and hand it off to another user who subsequently calls the <see cref="Overload:System.Xml.Xsl.XslTransform.Transform" /> method and executes the transformation.</para>
        </item>
      </list>
      <para>These security issues can be mitigated by not accepting <see cref="T:System.Xml.Xsl.XslTransform" /> objects, XSLT style sheets, or XML source data from untrusted sources.</para>
      <para>Scripting Support</para>
      <para>This class supports embedded scripting using the msxsl:script element.</para>
      <para>In version 1.1 of the .NET Framework, the evidence of the style sheet determines what permissions are given to embedded scripts.</para>
      <list type="bullet">
        <item>
          <para>If the style sheet was loaded from a Uniform Resource Identifier (URI), the URI is used to create the evidence. This evidence includes the URI along with its site and zone.</para>
        </item>
        <item>
          <para>If the style sheet was loaded using another source, you can provide evidence by passing a <see cref="T:System.Security.Policy.Evidence" /> object to the <see cref="Overload:System.Xml.Xsl.XslTransform.Load" /> method. Otherwise, the script assembly has full trust.</para>
        </item>
      </list>
      <para>Semi-trusted callers: UnmanagedCode permission is required to compile the embedded script. ControlEvidence permission is required to provide <see cref="T:System.Security.Policy.Evidence" /> to the <see cref="Overload:System.Xml.Xsl.XslTransform.Load" /> method. A <see cref="T:System.Security.SecurityException" /> is thrown if the caller does not have the necessary permissions. See <see cref="T:System.Security.Permissions.SecurityPermission" /> and <see cref="T:System.Security.Permissions.SecurityPermissionFlag" /> for more information.</para>
      <para>The msxsl:script element has the following requirements: </para>
      <list type="bullet">
        <item>
          <para>The msxsl:script element belongs to the urn:schemas-microsoft-com:xslt namespace. The style sheet must include the namespace declaration xmlns:msxsl=urn:schemas-microsoft-com:xslt.</para>
        </item>
        <item>
          <para>The msxsl:script element can include a language attribute that specifies the scripting language to use. The value of the language attribute must be one of the following: C#, CSharp, VB, VisualBasic, JScript, or JavaScript. Because the language name is not case-sensitive, JavaScript and javascript are both valid. If a language attribute is not specified, it defaults to JScript.</para>
        </item>
        <item>
          <para>The msxsl:script element must include an implements-prefix attribute that contains the prefix representing the namespace associated with the script block. This namespace must be defined within the style sheet. A style sheet can include multiple script blocks which are grouped by namespace. You cannot have script blocks with multiple languages within the same namespace. Script blocks can call a function defined in another script block, provided the script blocks reside within the same namespace. The contents of a script block are parsed according to the rules and syntax of the scripting language (supplied by the language attribute). For example, if you had a C# script block, comments would be prefixed by the // characters. The comments must be valid XML content.</para>
        </item>
      </list>
      <para>Note It is recommended that you wrap script blocks in a CDATA section.</para>
      <code> &lt;msxsl:script implements-prefix='xy' language='C#'&gt;
   &lt;![CDATA[
   // Add code here.
   ]]&gt;
 &lt;/msxsl:script&gt;</code>
      <para>Functions can be declared within the msxsl:script element. The following table shows the namespaces that are supported by default.</para>
      <list type="table">
        <listheader>
          <item>
            <term>
              <para>Supported Namespaces </para>
            </term>
            <description>
              <para>Description </para>
            </description>
          </item>
        </listheader>
        <item>
          <term>
            <para>System </para>
          </term>
          <description>
            <para>System classes. </para>
          </description>
        </item>
        <item>
          <term>
            <para>System.Collection </para>
          </term>
          <description>
            <para>Collection classes. </para>
          </description>
        </item>
        <item>
          <term>
            <para>System.Text </para>
          </term>
          <description>
            <para>Text handling classes. </para>
          </description>
        </item>
        <item>
          <term>
            <para>System.Xml </para>
          </term>
          <description>
            <para>Core XML classes. </para>
          </description>
        </item>
        <item>
          <term>
            <para>System.Xml.Xsl </para>
          </term>
          <description>
            <para>XSLT classes. </para>
          </description>
        </item>
        <item>
          <term>
            <para>System.Xml.XPath </para>
          </term>
          <description>
            <para>XML Path Language (XPath) classes. </para>
          </description>
        </item>
      </list>
      <para>The supplied arguments and return values defined by the script functions must be one of the World Wide Web Consortium (W3C) types listed below. The following table details the mapping between the W3C types, either XPath or XSLT, and the corresponding .NET Framework classes.</para>
      <list type="table">
        <listheader>
          <item>
            <term>
              <para>W3C Type </para>
            </term>
            <description>
              <para>Equivalent .NET class </para>
            </description>
          </item>
        </listheader>
        <item>
          <term>
            <para>String (XPath) </para>
          </term>
          <description>
            <para>System.String </para>
          </description>
        </item>
        <item>
          <term>
            <para>Boolean (XPath) </para>
          </term>
          <description>
            <para>System.Boolean </para>
          </description>
        </item>
        <item>
          <term>
            <para>Number (XPath) </para>
          </term>
          <description>
            <para>System.Double </para>
          </description>
        </item>
        <item>
          <term>
            <para>Result Tree Fragment (XSLT) </para>
          </term>
          <description>
            <para>System.Xml.XPath.XPathNavigator </para>
          </description>
        </item>
        <item>
          <term>
            <para>Node Set (XPath) </para>
          </term>
          <description>
            <para>System.Xml.XPath.XPathNodeIterator </para>
          </description>
        </item>
      </list>
      <para>If the script function utilizes one of the following numeric types: Int16, UInt16, Int32, UInt32, Int64, UInt64, Single, or Decimal, these types are coerced to Double, which maps to the W3C XPath type number.</para>
      <para>An exception is thrown when a function is called that cannot convert the argument result to one of the required types.</para>
      <block subset="none" type="note">
        <para>msxsl:script and msxsl:node-list are the only functions from the urn:schemas-microsoft-com:xslt namespace that are supported by the <see cref="T:System.Xml.Xsl.XslTransform" /> class.</para>
      </block>
      <para>
        <see cref="T:System.Xml.Xsl.XslTransform" /> has the ability to utilize common language runtime (CLR) code as an extension mechanism. This is accomplished by passing an instance of a class to the <see cref="T:System.Xml.Xsl.XslTransform" /> class and calling its public methods within an XSLT style sheet. Methods that are defined with the params keyword, which allows an unspecified number of parameters to be passed, do not work correctly in this scenario. See <format type="text/html"><a href="1690815e-b52b-4967-8380-5780aff08012">params (C# Programmers Reference)</a></format> for more details.</para>
      <para>For more information see <format type="text/html"><a href="500335af-f9b5-413b-968a-e6d9a824478c">XSLT Transformations with the XslTransform Class</a></format>.</para>
    </remarks>
  </class>
  <class name="XsltSettings" fullname="System.Xml.Xsl.XsltSettings" assembly="System.Xml">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Specifies the XSLT features to support during execution of the XSLT style sheet.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Embedded script blocks and the XSLT document() function are optional features on the <see cref="T:System.Xml.Xsl.XslCompiledTransform" /> class. These features are disabled by default. The <see cref="T:System.Xml.Xsl.XsltSettings" /> class specifies which of these optional features to support. Features are enabled or disabled using the class properties. The <see cref="T:System.Xml.Xsl.XsltSettings" /> object is then passed to the <see cref="Overload:System.Xml.Xsl.XslCompiledTransform.Load" /> method.</para>
      <block subset="none" type="note">
        <para>XSLT style sheets can include references to other files and embedded script blocks. A malicious user can exploit this by supplying you with data or style sheets that when executed can cause your system to process until the computer runs low on resources. Do not enable scripting or the document() function unless the style sheet comes from a trusted source. If you cannot verify the source of the style sheet, or if the style sheet does not come from a trusted source, use the default XSLT settings.</para>
      </block>
    </remarks>
  </class>
</elements>