/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.dialog;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.projectlibre1.configuration.Configuration;
import com.projectlibre1.configuration.FieldDictionary;
import com.projectlibre1.dialog.FieldDialog;
import com.projectlibre1.dialog.util.FieldComponentMap;
import com.projectlibre1.field.HasExtraFields;
import com.projectlibre1.field.HasExtraFieldsImpl;
import com.projectlibre1.help.HelpUtil;
import com.projectlibre1.options.CalendarOption;
import com.projectlibre1.pm.resource.ResourcePool;
import com.projectlibre1.pm.resource.ResourcePoolFactory;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.util.Alert;
import com.projectlibre1.util.DateTime;
import com.projectlibre1.util.Environment;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import net.sf.nachocalendar.CalendarFactory;
import net.sf.nachocalendar.components.DateField;

public final class ProjectDialog
extends FieldDialog {
    private static final long serialVersionUID = 1L;
    private Form form;
    JTextPane notes;
    DateField startDateChooser;
    JTextField manager;
    JTextField name;
    JComboBox resourcePool;
    JCheckBox forward;
    JCheckBox remote;
    JLabel dateLabel;
    JComboBox projectType;
    JComboBox projectStatus;
    JComboBox expenseType;
    JTextField group;
    JTextField division;
    JComboBox accessControl;

    public static ProjectDialog getInstance(Frame frame, Form form) {
        return new ProjectDialog(frame, form);
    }

    private ProjectDialog(Frame frame, Form form) {
        super(frame, Messages.getString("ProjectDialog.NewProject"), true, false);
        this.addDocHelp("Creating_a_Project");
        this.form = form != null ? form : new Form();
        this.setObjectClass(HasExtraFieldsImpl.class);
        this.setObject(this.form.extra);
    }

    protected void initControls() {
        this.notes = new JTextPane();
        this.notes.setAutoscrolls(true);
        this.startDateChooser = CalendarFactory.createDateField();
        this.manager = new JTextField();
        this.name = new JTextField();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(new String());
        arrayList.addAll(ResourcePoolFactory.getInstance().getResourcePools());
        this.resourcePool = new JComboBox<Object>(arrayList.toArray());
        this.forward = new JCheckBox(Messages.getString("Field.forward"));
        this.dateLabel = new JLabel();
        this.forward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectDialog.this.setDateLabel();
            }
        });
        if (!Environment.getStandAlone()) {
            this.accessControl = new JComboBox<Object>(new Object[]{Messages.getString("ProjectDialog.AllResourcesExceptCustomerPartner"), Messages.getString("ProjectDialog.BasedOnProjectRole")});
            HelpUtil.addDocHelp(this.accessControl, "Project_Team");
        }
        this.projectType = new JComboBox<Object>(Configuration.getFieldFromId("Field.projectType").getOptions(null));
        this.projectStatus = new JComboBox<Object>(Configuration.getFieldFromId("Field.projectStatus").getOptions(null));
        this.expenseType = new JComboBox<Object>(Configuration.getFieldFromId("Field.expenseType").getOptions(null));
        this.group = new JTextField();
        this.division = new JTextField();
        this.bind(true);
    }

    private void setDateLabel() {
        if (this.forward.isSelected()) {
            this.dateLabel.setText(Messages.getString("ProjectDialog.StartDate"));
        } else {
            this.dateLabel.setText(Messages.getString("ProjectDialog.FinishDate"));
        }
    }

    @Override
    protected boolean bind(boolean bl) {
        if (this.form == null) {
            return false;
        }
        if (bl) {
            this.notes.setText(this.form.getNotes());
            this.manager.setText(this.form.getManager());
            this.name.setText(this.form.getName());
            Date date = new Date(this.form.getStartDate());
            Date date2 = DateTime.gmtDate(date);
            this.startDateChooser.setValue(date);
            this.forward.setSelected(this.form.isForward());
            this.projectType.setSelectedItem(new Integer(this.form.getProjectType()));
            this.projectStatus.setSelectedItem(new Integer(this.form.getProjectStatus()));
            this.expenseType.setSelectedItem(new Integer(this.form.getExpenseType()));
            this.group.setText(this.form.getGroup());
            this.division.setText(this.form.getDivision());
            this.setDateLabel();
            if (!Environment.getStandAlone()) {
                this.accessControl.setSelectedIndex(0);
            }
        } else {
            this.form.setNotes(this.notes.getText());
            this.form.setManager(this.manager.getText());
            if (this.name.getText().length() == 0) {
                Alert.error(Messages.getString("Message.projectMustHaveName"), this);
                return false;
            }
            this.form.setName(this.name.getText());
            long l = DateTime.gmt((Date)this.startDateChooser.getValue());
            l = this.forward.isSelected() ? CalendarOption.getInstance().makeValidStart(l, true) : CalendarOption.getInstance().makeValidEnd(l, true);
            this.form.setStartDate(l);
            this.form.setForward(this.forward.isSelected());
            this.form.setProjectType(this.projectType.getSelectedIndex());
            this.form.setProjectStatus(this.projectStatus.getSelectedIndex());
            this.form.setExpenseType(this.expenseType.getSelectedIndex());
            this.form.setGroup(this.group.getText());
            this.form.setDivision(this.division.getText());
            if (!Environment.getStandAlone()) {
                this.form.setAccessControlType(this.accessControl.getSelectedIndex());
            }
        }
        return true;
    }

    @Override
    public JComponent createContentPanel() {
        this.initControls();
        FormLayout formLayout = new FormLayout("default, 3dlu, 220dlu, 3dlu, default:grow", "p, 3dlu,p, 3dlu,p, 3dlu, p, 3dlu, p, 3dlu,p, 3dlu, fill:50dlu:grow");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.append(Messages.getString("ProjectDialog.ProjectName"), (Component)this.name, 3);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(Messages.getString("ProjectDialog.Manager"), (Component)this.manager, 3);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(this.dateLabel);
        defaultFormBuilder.append(this.startDateChooser);
        defaultFormBuilder.append(this.forward);
        defaultFormBuilder.nextLine(2);
        if (!Environment.getStandAlone()) {
            defaultFormBuilder.append(Messages.getString("ProjectDialog.ProjectTeam"));
            defaultFormBuilder.add((Component)this.accessControl, cellConstraints.xy(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), "left,default"));
        }
        HelpUtil.addDocHelp(this.accessControl, "Project_Team");
        defaultFormBuilder.nextLine(2);
        FieldComponentMap fieldComponentMap = this.createMap();
        LinkedList linkedList = FieldDictionary.extractExtraFields(FieldDictionary.getInstance().getProjectFields(), true);
        JComponent jComponent = this.createFieldsPanel(fieldComponentMap, linkedList);
        if (jComponent != null) {
            defaultFormBuilder.add((Component)jComponent, cellConstraints.xyw(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), 3));
        }
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(Messages.getString("ProjectDialog.Notes"));
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.add((Component)new JScrollPane(this.notes), cellConstraints.xyw(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), 5));
        return defaultFormBuilder.getPanel();
    }

    public Form getForm() {
        return this.form;
    }

    @Override
    public Object getBean() {
        return this.form;
    }

    @Override
    protected void onCancel() {
        this.setVisible(false);
    }

    public static class Form {
        String notes;
        String manager;
        String name;
        long startDate = CalendarOption.getInstance().makeValidStart(DateTime.gmt(new Date()), true);
        ResourcePool resourcePool = null;
        boolean forward = true;
        boolean local = Environment.getStandAlone();
        int projectType;
        int projectStatus;
        int expenseType;
        String group;
        String division;
        HasExtraFields extra = new HasExtraFieldsImpl();
        int accessControlType;

        public String getManager() {
            return this.manager;
        }

        public void setManager(String string) {
            this.manager = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getNotes() {
            return this.notes;
        }

        public void setNotes(String string) {
            this.notes = string;
        }

        public long getStartDate() {
            return this.startDate;
        }

        public void setStartDate(long l) {
            this.startDate = l;
        }

        public ResourcePool getResourcePool() {
            return this.resourcePool;
        }

        public void setResourcePool(ResourcePool resourcePool) {
            this.resourcePool = resourcePool;
        }

        public final boolean isForward() {
            return this.forward;
        }

        public final void setForward(boolean bl) {
            this.forward = bl;
        }

        public boolean isLocal() {
            return this.local;
        }

        public void setLocal(boolean bl) {
            this.local = bl;
        }

        public final HasExtraFields getExtra() {
            return this.extra;
        }

        public int getExpenseType() {
            return this.expenseType;
        }

        public void setExpenseType(int n) {
            this.expenseType = n;
        }

        public int getProjectType() {
            return this.projectType;
        }

        public void setProjectType(int n) {
            this.projectType = n;
        }

        public String getDivision() {
            return this.division;
        }

        public void setDivision(String string) {
            this.division = string;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String string) {
            this.group = string;
        }

        public int getProjectStatus() {
            return this.projectStatus;
        }

        public void setProjectStatus(int n) {
            this.projectStatus = n;
        }

        public int getAccessControlType() {
            return this.accessControlType;
        }

        public void setAccessControlType(int n) {
            this.accessControlType = n;
        }
    }
}

