/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.AddBlockFlag;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSStripedOutputStream;
import org.apache.hadoop.hdfs.DataStreamer;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.util.ByteArrayManager;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.Private
public class StripedDataStreamer
extends DataStreamer {
    private final DFSStripedOutputStream.Coordinator coordinator;
    private final int index;

    StripedDataStreamer(HdfsFileStatus stat, DFSClient dfsClient, String src, Progressable progress, DataChecksum checksum, AtomicReference<CachingStrategy> cachingStrategy, ByteArrayManager byteArrayManage, String[] favoredNodes, short index, DFSStripedOutputStream.Coordinator coordinator, EnumSet<AddBlockFlag> flags) {
        super(stat, null, dfsClient, src, progress, checksum, cachingStrategy, byteArrayManage, favoredNodes, flags);
        this.index = index;
        this.coordinator = coordinator;
    }

    int getIndex() {
        return this.index;
    }

    boolean isHealthy() {
        return !this.streamerClosed() && !this.getErrorState().hasInternalError();
    }

    @Override
    protected void endBlock() {
        this.coordinator.offerEndBlock(this.index, this.block.getCurrentBlock());
        super.endBlock();
    }

    private LocatedBlock getFollowingBlock() throws IOException {
        if (!this.isHealthy()) {
            this.getLastException().check(false);
        }
        return this.coordinator.getFollowingBlocks().poll(this.index);
    }

    @Override
    protected LocatedBlock nextBlockOutputStream() throws IOException {
        LocatedBlock lb = this.getFollowingBlock();
        this.block.setCurrentBlock(lb.getBlock());
        this.block.setNumBytes(0L);
        this.bytesSent = 0L;
        this.accessToken = lb.getBlockToken();
        DatanodeInfo[] nodes = lb.getLocations();
        StorageType[] storageTypes = lb.getStorageTypes();
        String[] storageIDs = lb.getStorageIDs();
        boolean success = this.createBlockOutputStream(nodes, storageTypes, storageIDs, 0L, false);
        if (!success) {
            this.block.setCurrentBlock(null);
            DatanodeInfo badNode = nodes[this.getErrorState().getBadNodeIndex()];
            LOG.warn("Excluding datanode " + badNode);
            this.excludedNodes.put((Object)badNode, (Object)badNode);
            throw new IOException("Unable to create new block." + (Object)((Object)this));
        }
        return lb;
    }

    @VisibleForTesting
    LocatedBlock peekFollowingBlock() {
        return this.coordinator.getFollowingBlocks().peek(this.index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setupPipelineInternal(DatanodeInfo[] nodes, StorageType[] nodeStorageTypes, String[] nodeStorageIDs) throws IOException {
        boolean success = false;
        while (!success && !this.streamerClosed() && this.dfsClient.clientRunning) {
            if (!this.handleRestartingDatanode()) {
                return;
            }
            if (!this.handleBadDatanode()) {
                return;
            }
            LocatedBlock lb = this.coordinator.getNewBlocks().take(this.index);
            long newGS = lb.getBlock().getGenerationStamp();
            this.setAccessToken(lb.getBlockToken());
            assert (this.getErrorState().hasExternalError());
            success = this.createBlockOutputStream(nodes, nodeStorageTypes, nodeStorageIDs, newGS, true);
            this.failPacket4Testing();
            this.getErrorState().checkRestartingNodeDeadline(nodes);
            DFSStripedOutputStream.Coordinator coordinator = this.coordinator;
            synchronized (coordinator) {
                if (!this.streamerClosed()) {
                    this.coordinator.updateStreamer(this, success);
                    this.coordinator.notify();
                } else {
                    success = false;
                }
            }
            if (success) {
                success = this.coordinator.takeStreamerUpdateResult(this.index);
                if (success) {
                    this.updateBlockGS(newGS);
                    continue;
                }
                this.closeStream();
                continue;
            }
            this.closeStream();
            this.setStreamerAsClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setExternalError() {
        this.getErrorState().setExternalError();
        LinkedList linkedList = this.dataQueue;
        synchronized (linkedList) {
            this.dataQueue.notifyAll();
        }
    }

    @Override
    public String toString() {
        return "#" + this.index + ": " + (!this.isHealthy() ? "failed, " : "") + super.toString();
    }
}

