/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssTextTransform
extends org.w3c.css.properties.css.CssTextTransform {
    private static CssIdent[] allowed_action_values;
    private static CssIdent fullWidth;
    private static CssIdent fullSizeKana;

    public static CssIdent getMatchingActionIdent(CssIdent ident) {
        for (CssIdent id : allowed_action_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssTextTransform() {
        this.value = initial;
    }

    public CssTextTransform(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        this.setByUser();
        CssValue val = expression.getValue();
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        boolean got_action = false;
        boolean got_full_width = false;
        boolean got_full_size_kana = false;
        if (check && expression.getCount() > 3) {
            throw new InvalidParamException("unrecognize", ac);
        }
        while (!expression.end()) {
            val = expression.getValue();
            char op = expression.getOperator();
            if (val.getType() != 0) {
                throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
            }
            if (inherit.equals(val)) {
                if (expression.getCount() > 1) {
                    throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
                }
                values.add(inherit);
            } else if (none.equals(val)) {
                if (expression.getCount() > 1) {
                    throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
                }
                values.add(none);
            } else if (fullWidth.equals(val) && !got_full_width) {
                got_full_width = true;
                values.add(fullWidth);
            } else if (fullSizeKana.equals(val) && !got_full_size_kana) {
                got_full_size_kana = true;
                values.add(fullSizeKana);
            } else if (!got_action) {
                got_action = true;
                if ((val = CssTextTransform.getMatchingActionIdent((CssIdent)val)) == null) {
                    throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
                }
                got_action = true;
                values.add(val);
            } else {
                throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.valueOf(op), this.getPropertyName(), ac);
            }
            expression.next();
        }
        this.value = values.size() == 1 ? (CssValue)values.get(0) : new CssValueList(values);
    }

    public CssTextTransform(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        fullWidth = CssIdent.getIdent("full-width");
        fullSizeKana = CssIdent.getIdent("full-size-kana");
        String[] id_values = new String[]{"capitalize", "uppercase", "lowercase"};
        allowed_action_values = new CssIdent[id_values.length];
        int i = 0;
        for (String s : id_values) {
            CssTextTransform.allowed_action_values[i++] = CssIdent.getIdent(s);
        }
    }
}

