/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.extension.ExtensionLoader;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnLoader;
import org.zaproxy.zap.control.CoreFunctionality;
import org.zaproxy.zap.extension.ext.ExtensionParam;
import org.zaproxy.zap.utils.ZapResourceBundleControl;

public class ExtensionFactory {
    private static Logger log = Logger.getLogger(ExtensionFactory.class);
    private static Vector<Extension> listAllExtension = new Vector();
    private static TreeMap<String, Extension> mapAllExtension = new TreeMap();
    private static Map<Class<? extends Extension>, Extension> mapClassExtension = new HashMap<Class<? extends Extension>, Extension>();
    private static TreeMap<Integer, Extension> mapOrderToExtension = new TreeMap();
    private static List<Extension> unorderedExtensions = new ArrayList<Extension>();
    private static Map<Extension, Boolean> extensionsWithMessages = new HashMap<Extension, Boolean>();
    private static AddOnLoader addOnLoader = null;

    private static AddOnLoader getAddOnLoader(List<File> extraDirs) {
        if (addOnLoader == null) {
            File[] dirs = new File[extraDirs.size() + 2];
            dirs[0] = new File(Constant.getZapInstall(), "plugin");
            dirs[1] = new File(Constant.getZapHome(), "plugin");
            for (int i = 0; i < extraDirs.size(); ++i) {
                dirs[2 + i] = extraDirs.get(i);
            }
            addOnLoader = new AddOnLoader(dirs);
            ArrayList<AddOn> sortedAddOns = new ArrayList<AddOn>(addOnLoader.getAddOnCollection().getInstalledAddOns());
            Collections.sort(sortedAddOns, new Comparator<AddOn>(){

                @Override
                public int compare(AddOn addOn, AddOn otherAddOn) {
                    return addOn.getId().compareTo(otherAddOn.getId());
                }
            });
            log.info((Object)("Installed add-ons: " + sortedAddOns));
        } else {
            log.error((Object)"AddOnLoader initialised without additional directories");
        }
        return addOnLoader;
    }

    public static AddOnLoader getAddOnLoader() {
        if (addOnLoader == null) {
            addOnLoader = new AddOnLoader(new File[]{new File(Constant.getZapInstall(), "plugin"), new File(Constant.getZapHome(), "plugin")});
            log.info((Object)("Installed add-ons: " + addOnLoader.getAddOnCollection().getInstalledAddOns()));
        }
        return addOnLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void loadAllExtension(ExtensionLoader extensionLoader, OptionsParam optionsParam) {
        log.info((Object)"Loading extensions");
        ArrayList<Extension> listExts = new ArrayList<Extension>(CoreFunctionality.getBuiltInExtensions());
        listExts.addAll(ExtensionFactory.getAddOnLoader(optionsParam.getCheckForUpdatesParam().getAddonDirectories()).getExtensions());
        ExtensionParam extParam = optionsParam.getExtensionParam();
        TreeMap<String, Extension> treeMap = mapAllExtension;
        synchronized (treeMap) {
            mapAllExtension.clear();
            mapClassExtension.clear();
            for (int i = 0; i < listExts.size(); ++i) {
                ExtensionFactory.addExtensionImpl((Extension)listExts.get(i), extParam);
            }
            for (Integer order : mapOrderToExtension.keySet()) {
                Extension ext = mapOrderToExtension.get(order);
                if (ext.isEnabled()) {
                    log.debug((Object)("Ordered extension " + order + " " + ext.getName()));
                }
                ExtensionFactory.loadMessagesAndAddExtension(extensionLoader, ext);
            }
            for (Extension ext : unorderedExtensions) {
                if (ext.isEnabled()) {
                    log.debug((Object)("Unordered extension " + ext.getName()));
                }
                ExtensionFactory.loadMessagesAndAddExtension(extensionLoader, ext);
            }
        }
        log.info((Object)"Extensions loaded");
    }

    private static void loadMessagesAndAddExtension(ExtensionLoader extensionLoader, Extension extension) {
        ExtensionFactory.loadMessages(extension);
        if (!extension.isEnabled()) {
            return;
        }
        if (!ExtensionFactory.canBeLoaded(mapClassExtension, extension)) {
            return;
        }
        if (extension.supportsDb(Model.getSingleton().getDb().getType()) && (extension.supportsLowMemory() || !Constant.isLowMemoryOptionSet())) {
            extensionLoader.addExtension(extension);
        } else if (!extension.supportsDb(Model.getSingleton().getDb().getType())) {
            log.debug((Object)("Not loading extension " + extension.getName() + ": doesn't support " + Model.getSingleton().getDb().getType()));
            extension.setEnabled(false);
        } else if (extension.supportsLowMemory() || !Constant.isLowMemoryOptionSet()) {
            log.debug((Object)("Not loading extension " + extension.getName() + ": doesn't support low memory option"));
            extension.setEnabled(false);
        }
    }

    static boolean canBeLoaded(Map<Class<? extends Extension>, Extension> extensions, Extension extension) {
        return ExtensionFactory.canBeLoaded(extensions, extension, new ArrayList<Extension>());
    }

    private static boolean canBeLoaded(Map<Class<? extends Extension>, Extension> extensions, Extension extension, List<Extension> extsBeingProcessed) {
        if (extsBeingProcessed.contains(extension)) {
            log.error((Object)("Dependency loop with \"" + extension + "\" and " + extsBeingProcessed));
            return false;
        }
        List<Class<? extends Extension>> dependencies = extension.getDependencies();
        if (dependencies == null || dependencies.isEmpty()) {
            return true;
        }
        extsBeingProcessed.add(extension);
        for (Class<? extends Extension> dependency : dependencies) {
            Extension extDep = extensions.get(dependency);
            if (extDep == null) {
                ExtensionFactory.logUnableToLoadExt(extension, "missing dependency", dependency);
                extension.setEnabled(false);
                return false;
            }
            if (!extDep.isEnabled()) {
                ExtensionFactory.logUnableToLoadExt(extension, "dependency not enabled", dependency);
                extension.setEnabled(false);
                return false;
            }
            if (ExtensionFactory.canBeLoaded(extensions, extDep, extsBeingProcessed)) continue;
            ExtensionFactory.logUnableToLoadExt(extension, "can not load dependency", dependency);
            extension.setEnabled(false);
            return false;
        }
        extsBeingProcessed.remove(extension);
        return true;
    }

    private static void logUnableToLoadExt(Extension extension, String reason, Class<? extends Extension> dependency) {
        log.warn((Object)("Unable to load \"" + extension + "\", " + reason + ": " + dependency.getCanonicalName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void addAddOnExtension(ExtensionLoader extensionLoader, Configuration config, Extension extension) {
        TreeMap<String, Extension> treeMap = mapAllExtension;
        synchronized (treeMap) {
            ExtensionFactory.addExtensionImpl(extension, Model.getSingleton().getOptionsParam().getExtensionParam());
            if (extension.isEnabled()) {
                log.debug((Object)("Adding new extension " + extension.getName()));
            }
            ExtensionFactory.loadMessagesAndAddExtension(extensionLoader, extension);
        }
    }

    private static void addExtensionImpl(Extension extension, ExtensionParam extensionParam) {
        if (mapAllExtension.containsKey(extension.getName())) {
            if (mapAllExtension.get(extension.getName()).getClass().equals(extension.getClass())) {
                log.error((Object)("Duplicate extension: " + extension.getName() + " " + extension.getClass().getCanonicalName()));
                extension.setEnabled(false);
                return;
            }
            log.error((Object)("Duplicate extension name: " + extension.getName() + " " + extension.getClass().getCanonicalName() + " " + mapAllExtension.get(extension.getName()).getClass().getCanonicalName()));
        }
        if (extension.isDepreciated()) {
            log.debug((Object)("Depreciated extension " + extension.getName()));
            extension.setEnabled(false);
            return;
        }
        extension.setEnabled(extensionParam.isExtensionEnabled(extension.getName()));
        listAllExtension.add(extension);
        mapAllExtension.put(extension.getName(), extension);
        mapClassExtension.put(extension.getClass(), extension);
        int order = extension.getOrder();
        if (order == 0) {
            unorderedExtensions.add(extension);
        } else if (mapOrderToExtension.containsKey(order)) {
            log.error((Object)("Duplicate order " + order + " " + mapOrderToExtension.get(order).getName() + "/" + mapOrderToExtension.get(order).getClass().getCanonicalName() + " already registered, " + extension.getName() + "/" + extension.getClass().getCanonicalName() + " will be added as an unordered extension"));
            unorderedExtensions.add(extension);
        } else {
            mapOrderToExtension.put(order, extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List<Extension> loadAddOnExtensions(ExtensionLoader extensionLoader, Configuration config, AddOn addOn) {
        List<Extension> listExts = ExtensionFactory.getAddOnLoader().getExtensions(addOn);
        TreeMap<String, Extension> treeMap = mapAllExtension;
        synchronized (treeMap) {
            ExtensionParam extParam = Model.getSingleton().getOptionsParam().getExtensionParam();
            for (Extension extension : listExts) {
                ExtensionFactory.addExtensionImpl(extension, extParam);
            }
            for (Extension ext : listExts) {
                if (ext.isEnabled()) {
                    log.debug((Object)("Adding new extension " + ext.getName()));
                }
                ExtensionFactory.loadMessagesAndAddExtension(extensionLoader, ext);
            }
        }
        return listExts;
    }

    private static void loadMessages(Extension ext) {
        AddOn addOn = ext.getAddOn();
        if (addOn == null) {
            ext.setMessages(Constant.messages.getCoreResourceBundle());
            return;
        }
        ResourceBundle msg = ExtensionFactory.getExtensionResourceBundle(ext);
        if (msg != null) {
            ext.setMessages(msg);
            extensionsWithMessages.put(ext, Boolean.TRUE);
            Constant.messages.addMessageBundle(ext.getI18nPrefix(), ext.getMessages());
        } else if (addOn.getResourceBundle() != null) {
            ext.setMessages(addOn.getResourceBundle());
        } else {
            ext.setMessages(Constant.messages.getCoreResourceBundle());
        }
    }

    private static ResourceBundle getExtensionResourceBundle(Extension ext) {
        String extensionPackage = ext.getClass().getPackage().getName();
        ClassLoader classLoader = ext.getClass().getClassLoader();
        try {
            String name = extensionPackage + ".resources." + "Messages";
            return ExtensionFactory.getPropertiesResourceBundle(name, classLoader);
        }
        catch (MissingResourceException ignore) {
            String oldLocation = extensionPackage + "." + "Messages";
            try {
                return ExtensionFactory.getPropertiesResourceBundle(oldLocation, classLoader);
            }
            catch (MissingResourceException missingResourceException) {
                return null;
            }
        }
    }

    private static ResourceBundle getPropertiesResourceBundle(String name, ClassLoader classLoader) throws MissingResourceException {
        return ResourceBundle.getBundle(name, Constant.getLocale(), classLoader, new ZapResourceBundleControl());
    }

    public static List<Extension> getAllExtensions() {
        return listAllExtension;
    }

    public static Extension getExtension(String name) {
        return mapAllExtension.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unloadAddOnExtension(Extension extension) {
        TreeMap<String, Extension> treeMap = mapAllExtension;
        synchronized (treeMap) {
            ExtensionFactory.unloadMessages(extension);
            mapAllExtension.remove(extension.getName());
            mapClassExtension.remove(extension.getClass());
            listAllExtension.remove(extension);
            boolean isUnordered = true;
            Iterator<Extension> it = mapOrderToExtension.values().iterator();
            while (it.hasNext()) {
                if (it.next() != extension) continue;
                it.remove();
                isUnordered = false;
                break;
            }
            if (isUnordered) {
                unorderedExtensions.remove(extension);
            }
        }
    }

    private static void unloadMessages(Extension extension) {
        if (extensionsWithMessages.remove(extension) == null) {
            return;
        }
        ResourceBundle msg = extension.getMessages();
        if (msg != null) {
            Constant.messages.removeMessageBundle(extension.getI18nPrefix());
        }
    }
}

