/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.BitFieldPacking;
import ghidra.program.model.data.CompositeAlignmentHelper;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataOrganizationImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.InternalDataTypeComponent;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.util.exception.AssertException;

class AlignedComponentPacker {
    private final DataOrganization dataOrganization;
    private final BitFieldPacking bitFieldPacking;
    private final int packValue;
    private int nextOrdinal;
    private int zeroAlignment;
    private int lastAlignment;
    private int groupOffset = -1;
    private InternalDataTypeComponent lastComponent;
    private int externalAlignment = 1;
    private boolean componentsChanged;

    AlignedComponentPacker(int packValue, DataOrganization dataOrganization) {
        this.dataOrganization = dataOrganization;
        this.bitFieldPacking = dataOrganization.getBitFieldPacking();
        this.packValue = packValue;
    }

    void addComponent(InternalDataTypeComponent dtc, boolean isLastComponent) {
        if (dtc.getDataType() == DataType.DEFAULT || dtc.isFlexibleArrayComponent()) {
            throw new IllegalArgumentException("unsupported component");
        }
        if (!this.packComponent(dtc)) {
            this.initGroup(dtc, isLastComponent);
        }
        this.lastComponent = dtc;
        ++this.nextOrdinal;
        this.externalAlignment = this.getComponentAlignmentLCM(this.externalAlignment);
    }

    boolean componentsChanged() {
        return this.componentsChanged;
    }

    int getExternalAlignment() {
        return this.externalAlignment;
    }

    int getLength() {
        if (this.lastComponent == null) {
            return 0;
        }
        int offset = 0;
        if (this.groupOffset >= 0 && this.lastComponent.isBitFieldComponent() && this.bitFieldPacking.useMSConvention()) {
            BitFieldDataType lastBitFieldDt = (BitFieldDataType)this.lastComponent.getDataType();
            offset = this.groupOffset + lastBitFieldDt.getBaseTypeSize();
        } else {
            offset = this.lastComponent.getOffset() + this.lastComponent.getLength();
            if (!this.bitFieldPacking.useMSConvention() && this.lastComponent.isZeroBitFieldComponent()) {
                BitFieldDataType bitfieldDt = (BitFieldDataType)this.lastComponent.getDataType();
                int sizeAlignment = CompositeAlignmentHelper.getPackedAlignment(this.dataOrganization, 0, bitfieldDt.getBaseDataType(), bitfieldDt.getBaseTypeSize());
                this.getBitFieldAlignment((BitFieldDataType)this.lastComponent.getDataType());
                offset += DataOrganizationImpl.getPaddingSize(sizeAlignment, offset);
            }
        }
        return offset;
    }

    private int getBitFieldTypeSize(InternalDataTypeComponent dataTypeComponent) {
        DataType componentDt = dataTypeComponent.getDataType();
        if (componentDt instanceof BitFieldDataType) {
            return ((BitFieldDataType)componentDt).getBaseTypeSize();
        }
        throw new AssertException("expected bitfield component only");
    }

    private int getBitFieldAlignment(BitFieldDataType bitfieldDt) {
        if (!this.bitFieldPacking.useMSConvention() && this.packValue != 0) {
            return 1;
        }
        return CompositeAlignmentHelper.getPackedAlignment(this.dataOrganization, this.packValue, bitfieldDt.getBaseDataType(), bitfieldDt.getBaseTypeSize());
    }

    private boolean isIgnoredZeroBitField(BitFieldDataType zeroBitFieldDt) {
        if (!zeroBitFieldDt.isZeroLengthField()) {
            return false;
        }
        if (this.bitFieldPacking.useMSConvention()) {
            return this.lastComponent == null || !this.lastComponent.isBitFieldComponent();
        }
        return false;
    }

    private int getZeroBitFieldAlignment(BitFieldDataType zeroBitFieldDt, boolean isLastComponent) {
        if (this.isIgnoredZeroBitField(zeroBitFieldDt)) {
            return -1;
        }
        if (!this.bitFieldPacking.isTypeAlignmentEnabled()) {
            int zeroLengthBitFieldBoundary = this.bitFieldPacking.getZeroLengthBoundary();
            if (zeroLengthBitFieldBoundary > 0) {
                return zeroLengthBitFieldBoundary;
            }
            return 1;
        }
        int pack = this.packValue;
        if (!this.bitFieldPacking.useMSConvention() && !isLastComponent) {
            pack = 0;
        }
        return CompositeAlignmentHelper.getPackedAlignment(this.dataOrganization, pack, zeroBitFieldDt.getBaseDataType(), zeroBitFieldDt.getBaseTypeSize());
    }

    private void initGroup(InternalDataTypeComponent dataTypeComponent, boolean isLastComponent) {
        this.groupOffset = this.getLength();
        this.lastAlignment = 1;
        if (dataTypeComponent.isBitFieldComponent()) {
            BitFieldDataType zeroBitFieldDt = (BitFieldDataType)dataTypeComponent.getDataType();
            if (dataTypeComponent.isZeroBitFieldComponent()) {
                int zeroBitOffset;
                int alignment = this.getZeroBitFieldAlignment(zeroBitFieldDt, isLastComponent);
                int n = zeroBitOffset = this.dataOrganization.isBigEndian() ? 7 : 0;
                if (zeroBitFieldDt.getBitOffset() != zeroBitOffset || zeroBitFieldDt.getStorageSize() != 1) {
                    try {
                        BitFieldDataType packedBitFieldDt = new BitFieldDataType(zeroBitFieldDt.getBaseDataType(), 0, zeroBitOffset);
                        dataTypeComponent.setDataType(packedBitFieldDt);
                    }
                    catch (InvalidDataTypeException e) {
                        throw new AssertException("unexpected", (Throwable)((Object)e));
                    }
                    this.componentsChanged = true;
                }
                if (isLastComponent) {
                    int offset = this.groupOffset;
                    int length = 1;
                    if (this.lastComponent != null) {
                        offset = this.groupOffset - 1;
                    }
                    this.updateComponent(dataTypeComponent, this.nextOrdinal, offset, length, alignment > 0 ? alignment : 1);
                    this.groupOffset = -1;
                } else {
                    this.zeroAlignment = alignment;
                    if (this.bitFieldPacking.useMSConvention()) {
                        this.lastAlignment = alignment;
                    }
                }
            } else {
                this.lastComponent = null;
                this.alignAndPackBitField(dataTypeComponent);
            }
        } else {
            this.lastComponent = null;
            this.alignAndPackNonBitfieldComponent(dataTypeComponent, this.groupOffset);
        }
    }

    private void adjustZeroLengthBitField(int ordinal, int minimumAlignment) {
        int zeroAlignmentOffset;
        int minOffset = DataOrganizationImpl.getOffset(minimumAlignment, this.groupOffset);
        this.groupOffset = minOffset >= (zeroAlignmentOffset = DataOrganizationImpl.getOffset(this.zeroAlignment, this.groupOffset)) ? minOffset : zeroAlignmentOffset;
        this.updateComponent(this.lastComponent, ordinal, this.groupOffset, 1, minimumAlignment);
    }

    private boolean packComponent(InternalDataTypeComponent dataTypeComponent) {
        if (this.lastComponent == null || dataTypeComponent.isZeroBitFieldComponent()) {
            return false;
        }
        if (dataTypeComponent.isBitFieldComponent()) {
            if (!this.lastComponent.isZeroBitFieldComponent() && this.bitFieldPacking.useMSConvention()) {
                if (!this.lastComponent.isBitFieldComponent()) {
                    return false;
                }
                if (this.getBitFieldTypeSize(dataTypeComponent) != this.getBitFieldTypeSize(this.lastComponent)) {
                    return false;
                }
            }
            this.alignAndPackBitField(dataTypeComponent);
            return true;
        }
        if (!this.lastComponent.isZeroBitFieldComponent() && this.bitFieldPacking.useMSConvention()) {
            return false;
        }
        int offset = this.lastComponent.isZeroBitFieldComponent() ? this.groupOffset : this.lastComponent.getOffset() + this.lastComponent.getLength();
        this.alignAndPackNonBitfieldComponent(dataTypeComponent, offset);
        return true;
    }

    private void alignAndPackNonBitfieldComponent(InternalDataTypeComponent dataTypeComponent, int minOffset) {
        int offset;
        DataType componentDt = dataTypeComponent.getDataType();
        int dtSize = componentDt.getLength();
        if (dtSize <= 0) {
            dtSize = dataTypeComponent.getLength();
        }
        int alignment = CompositeAlignmentHelper.getPackedAlignment(this.dataOrganization, this.packValue, componentDt, dtSize);
        if (this.lastComponent != null && this.lastComponent.isZeroBitFieldComponent()) {
            this.adjustZeroLengthBitField(this.nextOrdinal - 1, alignment);
            offset = this.groupOffset;
        } else {
            offset = DataOrganizationImpl.getOffset(alignment, minOffset);
            if (this.lastComponent == null) {
                this.groupOffset = offset;
            }
        }
        this.updateComponent(dataTypeComponent, this.nextOrdinal, offset, dtSize, alignment);
    }

    private void alignAndPackBitField(InternalDataTypeComponent dataTypeComponent) {
        int bitsConsumed;
        int offset;
        BitFieldDataType bitfieldDt = (BitFieldDataType)dataTypeComponent.getDataType();
        if (this.lastComponent != null && this.lastComponent.isZeroBitFieldComponent()) {
            int alignment = this.bitFieldPacking.useMSConvention() ? this.getBitFieldAlignment(bitfieldDt) : this.zeroAlignment;
            this.adjustZeroLengthBitField(this.nextOrdinal - 1, alignment);
        }
        int alignment = CompositeAlignmentHelper.getPackedAlignment(this.dataOrganization, this.packValue, bitfieldDt.getPrimitiveBaseDataType(), bitfieldDt.getBaseTypeSize());
        this.lastAlignment = Math.max(alignment, this.lastAlignment);
        if (this.lastComponent == null) {
            offset = DataOrganizationImpl.getOffset(alignment, this.groupOffset);
            bitsConsumed = 0;
            this.groupOffset = offset;
        } else if (this.lastComponent.isZeroBitFieldComponent()) {
            offset = this.groupOffset;
            bitsConsumed = 0;
        } else {
            int alignedBaseOffset;
            alignment = this.getBitFieldAlignment(bitfieldDt);
            BitFieldDataType lastBitfieldDt = null;
            if (this.lastComponent.isBitFieldComponent()) {
                lastBitfieldDt = (BitFieldDataType)this.lastComponent.getDataType();
                offset = this.lastComponent.getEndOffset();
                bitsConsumed = this.dataOrganization.isBigEndian() ? 8 - lastBitfieldDt.getBitOffset() : (lastBitfieldDt.getBitSize() + lastBitfieldDt.getBitOffset()) % 8;
                if (bitsConsumed == 8 || bitsConsumed == 0) {
                    bitsConsumed = 0;
                    ++offset;
                }
            } else {
                offset = this.lastComponent.getOffset() + this.lastComponent.getLength();
                bitsConsumed = 0;
            }
            int byteSize = (bitfieldDt.getBitSize() + bitsConsumed + 7) / 8;
            int endOffset = offset + byteSize - 1;
            if ((offset % alignment != 0 || byteSize > bitfieldDt.getBaseTypeSize()) && endOffset >= (alignedBaseOffset = DataOrganizationImpl.getOffset(alignment, offset) - alignment) + bitfieldDt.getBaseTypeSize()) {
                offset = DataOrganizationImpl.getOffset(alignment, offset + 1);
                endOffset = offset + byteSize - 1;
                bitsConsumed = 0;
            }
            if (this.groupOffset >= 0 && lastBitfieldDt != null && endOffset >= this.groupOffset + lastBitfieldDt.getBaseTypeSize()) {
                this.groupOffset = this.bitFieldPacking.useMSConvention() ? offset : -1;
            }
        }
        int byteSize = this.setBitFieldDataType(dataTypeComponent, bitfieldDt, bitsConsumed);
        this.updateComponent(dataTypeComponent, this.nextOrdinal, offset, byteSize, alignment);
    }

    private int setBitFieldDataType(InternalDataTypeComponent dataTypeComponent, BitFieldDataType currentBitFieldDt, int bitsConsumed) {
        int byteSize = (currentBitFieldDt.getBitSize() + bitsConsumed + 7) / 8;
        int bitOffset = this.dataOrganization.isBigEndian() ? byteSize * 8 - currentBitFieldDt.getBitSize() - bitsConsumed : bitsConsumed;
        if (bitOffset != currentBitFieldDt.getBitOffset()) {
            try {
                BitFieldDataType packedBitFieldDt = new BitFieldDataType(currentBitFieldDt.getBaseDataType(), currentBitFieldDt.getDeclaredBitSize(), bitOffset);
                dataTypeComponent.setDataType(packedBitFieldDt);
            }
            catch (InvalidDataTypeException e) {
                throw new AssertException("unexpected", (Throwable)((Object)e));
            }
            this.componentsChanged = true;
        }
        return byteSize;
    }

    private void updateComponent(InternalDataTypeComponent dataTypeComponent, int ordinal, int offset, int length, int alignment) {
        if (ordinal != dataTypeComponent.getOrdinal() || offset != dataTypeComponent.getOffset() || length != dataTypeComponent.getLength()) {
            dataTypeComponent.update(ordinal, offset, length);
            this.componentsChanged = true;
        }
        this.lastAlignment = Math.max(this.lastAlignment, alignment);
    }

    private int getComponentAlignmentLCM(int allComponentsLCM) {
        if (this.lastAlignment == 0) {
            return this.lastAlignment;
        }
        int alignment = this.lastAlignment;
        if (this.packValue > 0 && alignment > this.packValue) {
            alignment = this.packValue;
        }
        return DataOrganizationImpl.getLeastCommonMultiple(allComponentsLCM, alignment);
    }
}

