/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.docking.settings.Settings;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.BitGroup;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.EnumValuePartitioner;
import ghidra.program.model.data.GenericDataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.UniversalID;
import ghidra.util.datastruct.LongObjectHashtable;
import ghidra.util.datastruct.ObjectLongHashtable;
import ghidra.util.exception.NoValueException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;

public class EnumDataType
extends GenericDataType
implements Enum {
    private ObjectLongHashtable<String> defs = new ObjectLongHashtable();
    private int length;
    private String description;
    private List<BitGroup> bitGroups;

    public EnumDataType(String name, int length) {
        this(CategoryPath.ROOT, name, length, null);
    }

    public EnumDataType(CategoryPath path, String name, int length) {
        this(path, name, length, null);
    }

    public EnumDataType(CategoryPath path, String name, int length, DataTypeManager dtm) {
        super(path, name, dtm);
        this.length = length;
    }

    public EnumDataType(CategoryPath path, String name, int length, UniversalID universalID, SourceArchive sourceArchive, long lastChangeTime, long lastChangeTimeInSourceArchive, DataTypeManager dtm) {
        super(path, name, universalID, sourceArchive, lastChangeTime, lastChangeTimeInSourceArchive, dtm);
        this.length = length;
    }

    @Override
    public boolean isDynamicallySized() {
        return false;
    }

    @Override
    public long getValue(String valueName) throws NoSuchElementException {
        try {
            return this.defs.get((Object)valueName);
        }
        catch (NoValueException e) {
            throw new NoSuchElementException("No value for " + valueName);
        }
    }

    @Override
    public String getName(long value) {
        String[] names;
        for (String name1 : names = (String[])this.defs.getKeys((Object[])new String[this.defs.size()])) {
            try {
                long nameValue = this.defs.get((Object)name1);
                if (nameValue != value) continue;
                return name1;
            }
            catch (NoValueException noValueException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public long[] getValues() {
        String[] names = (String[])this.defs.getKeys((Object[])new String[this.defs.size()]);
        LongObjectHashtable keyTable = new LongObjectHashtable();
        for (String name1 : names) {
            try {
                long value = this.defs.get((Object)name1);
                keyTable.put(value, (Object)name1);
            }
            catch (NoValueException noValueException) {
                // empty catch block
            }
        }
        long[] values = keyTable.getKeys();
        Arrays.sort(values);
        return values;
    }

    @Override
    public String[] getNames() {
        Object[] names = (String[])this.defs.getKeys((Object[])new String[this.defs.size()]);
        Arrays.sort(names);
        return names;
    }

    @Override
    public int getCount() {
        return this.defs.size();
    }

    @Override
    public void add(String valueName, long value) {
        this.bitGroups = null;
        this.checkValue(value);
        if (this.defs.contains((Object)valueName)) {
            try {
                if (this.defs.get((Object)valueName) == value) {
                    return;
                }
            }
            catch (NoValueException noValueException) {
                // empty catch block
            }
            throw new IllegalArgumentException(this.name + " enum value " + value + " already assigned");
        }
        this.defs.put((Object)valueName, value);
    }

    private void checkValue(long value) {
        long max = (1L << this.length * 8) - 1L;
        if (max > 0L && value > max) {
            throw new IllegalArgumentException(this.name + " enum value 0x" + Long.toHexString(value) + " is outside the range of 0x0 to 0x" + Long.toHexString(max));
        }
    }

    @Override
    public void remove(String valueName) {
        this.bitGroups = null;
        this.defs.remove((Object)valueName);
    }

    @Override
    public DataType copy(DataTypeManager dtm) {
        EnumDataType enumDataType = new EnumDataType(this.getCategoryPath(), this.getName(), this.getLength(), dtm);
        enumDataType.setDescription(this.getDescription());
        enumDataType.replaceWith(this);
        return enumDataType;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (this.getDataTypeManager() == dtm) {
            return this;
        }
        EnumDataType enumDataType = new EnumDataType(this.getCategoryPath(), this.getName(), this.getLength(), this.getUniversalID(), this.getSourceArchive(), this.getLastChangeTime(), this.getLastChangeTimeInSourceArchive(), dtm);
        enumDataType.setDescription(this.description);
        enumDataType.replaceWith(this);
        return enumDataType;
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.name;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        String[] names;
        for (String enumName : names = this.getNames()) {
            long value = this.getValue(enumName);
            if (!this.isTooBig(length, value)) continue;
            throw new IllegalArgumentException("Setting the length of this Enum to a size that cannot contain the current value for \"" + enumName + "\" of " + Long.toHexString(value));
        }
        this.length = length;
    }

    private boolean isTooBig(int testLength, long value) {
        long max = (1L << testLength * 8) - 1L;
        return max > 0L && value > max;
    }

    @Override
    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
        this.stateChanged(null);
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int valueLength) {
        try {
            long value = 0L;
            switch (valueLength) {
                case 1: {
                    value = buf.getByte(0);
                    break;
                }
                case 2: {
                    value = buf.getShort(0);
                    break;
                }
                case 4: {
                    value = buf.getInt(0);
                    break;
                }
                case 8: {
                    value = buf.getLong(0);
                }
            }
            return new Scalar(valueLength * 8, value);
        }
        catch (MemoryAccessException e) {
            return null;
        }
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return Scalar.class;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int valueLength) {
        try {
            long value = 0L;
            switch (this.length) {
                case 1: {
                    value = (long)buf.getByte(0) & 0xFFL;
                    break;
                }
                case 2: {
                    value = (long)buf.getShort(0) & 0xFFFFL;
                    break;
                }
                case 4: {
                    value = (long)buf.getInt(0) & 0xFFFFFFFFL;
                    break;
                }
                case 8: {
                    value = buf.getLong(0);
                }
            }
            return this.getRepresentation(value);
        }
        catch (MemoryAccessException e) {
            return "??";
        }
    }

    @Override
    public String getRepresentation(BigInteger bigInt, Settings settings, int bitLength) {
        return this.getRepresentation(bigInt.longValue());
    }

    private String getRepresentation(long value) {
        String valueName = this.getName(value);
        if (valueName == null) {
            valueName = this.getCompoundValue(value);
        }
        return valueName;
    }

    private String getCompoundValue(long value) {
        if (value == 0L) {
            return "0";
        }
        List<BitGroup> list = this.getBitGroups();
        StringBuffer buf = new StringBuffer();
        for (BitGroup bitGroup : list) {
            long subValue = bitGroup.getMask() & value;
            if (subValue == 0L) continue;
            String part = this.getName(subValue);
            if (part == null) {
                part = this.getStringForNoMatchingValue(subValue);
            }
            if (buf.length() != 0) {
                buf.append(" | ");
            }
            buf.append(part);
        }
        return buf.toString();
    }

    private List<BitGroup> getBitGroups() {
        if (this.bitGroups == null) {
            this.bitGroups = EnumValuePartitioner.partition(this.getValues());
        }
        return this.bitGroups;
    }

    private String getStringForNoMatchingValue(long value) {
        Object valueStr = value < 0L || value >= 32L ? "0x" + Long.toHexString(value) : Long.toString(value);
        String valueName = (String)valueStr;
        return valueName;
    }

    @Override
    public boolean isEquivalent(DataType dt) {
        if (dt == this) {
            return true;
        }
        if (dt == null || !(dt instanceof Enum)) {
            return false;
        }
        Enum enumm = (Enum)dt;
        if (!DataTypeUtilities.equalsIgnoreConflict(this.name, enumm.getName()) || this.length != enumm.getLength() || this.getCount() != enumm.getCount()) {
            return false;
        }
        String[] names = this.getNames();
        String[] otherNames = enumm.getNames();
        try {
            for (int i = 0; i < names.length; ++i) {
                long value = this.getValue(names[i]);
                long otherValue = enumm.getValue(names[i]);
                if (names[i].equals(otherNames[i]) && value == otherValue) continue;
                return false;
            }
        }
        catch (NoSuchElementException e) {
            return false;
        }
        return true;
    }

    @Override
    public void replaceWith(DataType dataType) {
        this.bitGroups = null;
        if (!(dataType instanceof Enum)) {
            throw new IllegalArgumentException();
        }
        Enum enumm = (Enum)dataType;
        this.defs.removeAll();
        this.setLength(enumm.getLength());
        String[] names = enumm.getNames();
        for (int i = 0; i < names.length; ++i) {
            this.defs.put((Object)names[i], enumm.getValue(names[i]));
        }
        this.stateChanged(null);
    }

    @Override
    public void dataTypeSizeChanged(DataType dt) {
    }

    @Override
    public void dataTypeDeleted(DataType dt) {
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
    }

    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
    }

    @Override
    public boolean dependsOn(DataType dt) {
        return false;
    }

    @Override
    public String getDefaultLabelPrefix() {
        return this.name == null ? null : this.name.toUpperCase();
    }
}

