/*
 * Decompiled with CFR 0.152.
 */
package docking.menu;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

class InvertableImageIcon
implements Icon {
    private ImageIcon icon;
    private ImageIcon originalIcon;
    private ImageIcon invertedIcon;

    public InvertableImageIcon(ImageIcon imageIcon) {
        this.originalIcon = imageIcon;
        this.icon = imageIcon;
    }

    private Image createInvertedImage(Image i) {
        RGBImageFilter filter = new RGBImageFilter(){

            @Override
            public int filterRGB(int x, int y, int rgb) {
                if ((rgb & 0xFF000000) == -16777216) {
                    rgb = ~rgb | 0xFF000000;
                }
                return rgb;
            }
        };
        FilteredImageSource prod = new FilteredImageSource(i.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(prod);
    }

    public void setInverted(boolean inverted) {
        if (this.invertedIcon == null) {
            Image image = this.originalIcon.getImage();
            Image invertedImage = this.createInvertedImage(image);
            this.invertedIcon = ResourceManager.getImageIconFromImage((String)this.originalIcon.getDescription(), (Image)invertedImage);
        }
        this.icon = inverted ? this.invertedIcon : this.originalIcon;
    }

    public boolean isInverted() {
        return this.icon == this.originalIcon;
    }

    @Override
    public int getIconHeight() {
        return this.icon.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.icon.getIconWidth();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.icon.paintIcon(c, g, x, y);
    }
}

