/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constraint;

import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.ColumnData;
import docking.widgets.table.constraint.TableFilterContext;
import docking.widgets.table.constrainteditor.AutocompletingStringConstraintEditor;
import docking.widgets.table.constrainteditor.ColumnConstraintEditor;
import docking.widgets.table.constrainteditor.StringConstraintEditor;
import ghidra.util.HTMLUtilities;
import ghidra.util.UserSearchUtils;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class StringColumnConstraint
implements ColumnConstraint<String> {
    private static int MAX_AUTO_COMPLETE = 30000;
    private String patternString;
    private Pattern findsPattern;
    private String errorMessage;
    protected Pattern matchesPattern;

    protected StringColumnConstraint(String patternString, String errorMessage) {
        this.patternString = patternString;
        this.errorMessage = errorMessage;
        this.matchesPattern = this.generateMatchesPattern(patternString);
        if (this.matchesPattern == null) {
            throw new IllegalArgumentException();
        }
    }

    protected StringColumnConstraint(String patternString) {
        this(patternString, "Please enter a search pattern. You may use * and ? globbing characters");
    }

    @Override
    public String getGroup() {
        return "string";
    }

    @Override
    public boolean accepts(String value, TableFilterContext context) {
        if (value == null) {
            return false;
        }
        return this.matchesPattern.matcher(value).matches();
    }

    protected abstract Pattern generateMatchesPattern(String var1);

    protected Pattern generateFindsPattern() {
        String regexString = UserSearchUtils.createPatternString((String)this.patternString, (boolean)true);
        return Pattern.compile("(" + regexString + ")", 66);
    }

    @Override
    public ColumnConstraintEditor<String> getEditor(ColumnData<String> columnDataSource) {
        if (columnDataSource.getCount() < MAX_AUTO_COMPLETE) {
            return new AutocompletingStringConstraintEditor(this, columnDataSource);
        }
        return new StringConstraintEditor(this, this.errorMessage);
    }

    public abstract ColumnConstraint<String> copy(String var1);

    public String getPatternString() {
        return this.patternString;
    }

    @Override
    public Class<String> getColumnType() {
        return String.class;
    }

    @Override
    public String getConstraintValueTooltip() {
        return "\"" + HTMLUtilities.italic((String)this.getConstraintValueString()) + "\"";
    }

    @Override
    public String getConstraintValueString() {
        return this.patternString;
    }

    @Override
    public ColumnConstraint<String> parseConstraintValue(String newValue, Object dataSource) {
        return this.copy(newValue);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.getPatternString());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        StringColumnConstraint otherConstraint = (StringColumnConstraint)o;
        return this.getPatternString().equals(otherConstraint.getPatternString());
    }

    public Matcher getHighlightMatcher(String value) {
        if (this.findsPattern == null) {
            this.findsPattern = this.generateFindsPattern();
        }
        return this.findsPattern.matcher(value);
    }

    public boolean isValidPatternString(String value) {
        return value.length() > 0;
    }
}

