/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.renderer;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.vertex.AbstractVisualVertexRenderer;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;

public class VisualVertexSatelliteRenderer<V extends VisualVertex, E extends VisualEdge<V>>
extends AbstractVisualVertexRenderer<V, E> {
    protected void paintIconForVertex(RenderContext<V, E> rc, V v, Layout<V, E> layout) {
        double empahsis;
        GraphicsDecorator defaultGraphics = rc.getGraphicsContext();
        if (v.isSelected()) {
            Shape shape = this.getFullShape(rc, layout, v);
            Rectangle bounds = shape.getBounds();
            this.paintHighlight(rc, v, defaultGraphics, bounds);
        }
        if ((empahsis = v.getEmphasis()) == 0.0) {
            super.paintIconForVertex(rc, v, layout);
            return;
        }
        super.paintIconForVertex(rc, v, layout);
    }

    protected Shape prepareFinalVertexShape(RenderContext<V, E> rc, V v, Layout<V, E> layout, int[] coords) {
        return this.getCompactShape(rc, layout, v);
    }

    @Override
    protected void paintHighlight(RenderContext<V, E> rc, V vertex, GraphicsDecorator g, Rectangle bounds) {
        if (!vertex.isSelected()) {
            return;
        }
        Paint oldPaint = g.getPaint();
        int halfishTransparency = 150;
        Color yellowWithTransparency = new Color(255, 255, 0, halfishTransparency);
        g.setPaint((Paint)yellowWithTransparency);
        int offset = 10;
        offset = (int)this.adjustValueForCurrentScale(rc, offset, 0.9);
        g.fillOval(bounds.x - offset, bounds.y - offset, bounds.width + offset * 2, bounds.height + offset * 2);
        if (this.isGraphScaledEnoughToBeDifficultToSee(rc)) {
            g.setColor(Color.BLACK);
            g.drawOval(bounds.x - offset, bounds.y - offset, bounds.width + offset * 2, bounds.height + offset * 2);
            g.drawOval(bounds.x - offset - 1, bounds.y - offset - 1, bounds.width + offset * 2 + 2, bounds.height + offset * 2 + 2);
            g.drawOval(bounds.x - offset - 2, bounds.y - offset - 2, bounds.width + offset * 2 + 4, bounds.height + offset * 2 + 4);
        }
        g.setPaint(oldPaint);
    }

    private boolean isGraphScaledEnoughToBeDifficultToSee(RenderContext<V, E> rc) {
        double scale = this.getScale(rc);
        return scale < 0.05;
    }
}

