/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.checksums;

import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.util.MemoryByteIterator;
import java.io.IOException;
import java.io.InputStream;

class MemoryInputStream
extends InputStream {
    MemoryByteIterator it;

    MemoryInputStream(Memory mem, AddressSetView set) {
        this.it = new MemoryByteIterator(mem, set);
    }

    @Override
    public int read() throws IOException {
        try {
            if (this.it.hasNext()) {
                return this.it.next() & 0xFF;
            }
        }
        catch (MemoryAccessException e) {
            StackTraceElement ste = e.getStackTrace()[0];
            throw new IOException(e.toString());
        }
        return -1;
    }
}

