/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.KeyBindingData;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import javax.swing.KeyStroke;

public class EditFieldAction
extends CompositeEditorTableAction {
    public static final String ACTION_NAME = "Edit Component Field";
    private static final String GROUP_NAME = "1_BASIC_EDITOR_ACTION";
    private static final String DESCRIPTION = "Edit the first editable field of the selected component.";
    private KeyStroke keyStroke = KeyStroke.getKeyStroke(113, 0);
    private static String[] popupPath = new String[]{"Edit Component Field"};
    private static String[] menuPath = new String[]{"Edit Component Field"};

    public EditFieldAction(CompositeEditorProvider provider) {
        super(provider, "Editor: Edit Component Field", GROUP_NAME, popupPath, menuPath, null);
        this.setDescription(DESCRIPTION);
        this.setKeyBindingData(new KeyBindingData(this.keyStroke));
        this.adjustEnablement();
    }

    public void actionPerformed(ActionContext context) {
        if (this.model != null) {
            int column;
            int row = this.model.getRow();
            if (this.model.isCellEditable(row, column = this.model.getColumn())) {
                this.model.beginEditingField(row, column);
                return;
            }
            int firstEditableColumn = this.model.getFirstEditableColumn(row);
            this.model.beginEditingField(row, firstEditableColumn);
        }
        this.requestTableFocus();
    }

    @Override
    public void adjustEnablement() {
        boolean shouldEnableEdit = false;
        if (this.model.isSingleRowSelection()) {
            int[] rows = this.model.getSelectedRows();
            int firstEditableColumn = this.model.getFirstEditableColumn(rows[0]);
            shouldEnableEdit = this.model.isEditFieldAllowed(rows[0], firstEditableColumn);
        }
        this.setEnabled(shouldEnableEdit);
    }
}

