/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.dex.format.EncodedTypeAddressPair;
import ghidra.file.formats.android.dex.util.Leb128;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class EncodedCatchHandler
implements StructConverter {
    private int size;
    private int sizeLength;
    private List<EncodedTypeAddressPair> handlers = new ArrayList<EncodedTypeAddressPair>();
    private int catchAllAddress;
    private int catchAllAddressLength;

    public EncodedCatchHandler(BinaryReader reader) throws IOException {
        this.size = Leb128.readSignedLeb128(reader.readByteArray(reader.getPointerIndex(), 5));
        this.sizeLength = Leb128.signedLeb128Size(this.size);
        reader.readNextByteArray(this.sizeLength);
        for (int i = 0; i < Math.abs(this.size); ++i) {
            this.handlers.add(new EncodedTypeAddressPair(reader));
        }
        if (this.size <= 0) {
            this.catchAllAddress = Leb128.readUnsignedLeb128(reader.readByteArray(reader.getPointerIndex(), 5));
            this.catchAllAddressLength = Leb128.unsignedLeb128Size(this.catchAllAddress);
            reader.readNextByteArray(this.catchAllAddressLength);
        }
    }

    public int getSize() {
        return this.size;
    }

    public List<EncodedTypeAddressPair> getPairs() {
        return this.handlers;
    }

    public int getCatchAllAddress() {
        return this.catchAllAddress;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("encoded_catch_handler_" + this.sizeLength + "_" + this.catchAllAddressLength + "_" + this.handlers.size());
        StructureDataType structure = new StructureDataType(builder.toString(), 0);
        structure.add((DataType)new ArrayDataType(BYTE, this.sizeLength, BYTE.getLength()), "size", null);
        int index = 0;
        for (EncodedTypeAddressPair pair : this.handlers) {
            DataType dataType = pair.toDataType();
            structure.add(dataType, "handler_" + index, null);
            builder.append(pair.getDataTypeIdString());
        }
        if (this.size <= 0) {
            structure.add((DataType)new ArrayDataType(BYTE, this.catchAllAddressLength, BYTE.getLength()), "catch_all_addr", null);
        }
        structure.setCategoryPath(new CategoryPath("/dex/encoded_catch_handler"));
        try {
            structure.setName(builder.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return structure;
    }
}

