/*
 * Decompiled with CFR 0.152.
 */
package generic.stl;

import generic.stl.ComparableMultiSetSTL;
import generic.stl.IteratorSTL;
import generic.stl.Pair;
import generic.stl.RedBlackNode;
import generic.stl.RedBlackTree;
import generic.stl.ReverseSetIterator;
import generic.stl.SetIterator;
import java.util.Comparator;

public class MultiSetSTL<K> {
    RedBlackTree<K, K> rbTree;

    public MultiSetSTL(Comparator<K> comparator) {
        this.rbTree = new RedBlackTree(comparator, true);
    }

    public void insert(K key) {
        this.rbTree.put(key, key);
    }

    public boolean contains(K key) {
        return this.rbTree.containsKey(key);
    }

    public boolean remove(K key) {
        return this.rbTree.remove(key) != null;
    }

    public IteratorSTL<K> begin() {
        return new SetIterator<K>(this.rbTree, this.rbTree.getFirst());
    }

    public IteratorSTL<K> end() {
        return new SetIterator<K>(this.rbTree, null);
    }

    public IteratorSTL<K> rBegin() {
        return new ReverseSetIterator<K>(this.rbTree, this.rbTree.getLast());
    }

    public IteratorSTL<K> rEnd() {
        return new ReverseSetIterator<K>(this.rbTree, null);
    }

    public IteratorSTL<K> lower_bound(K key) {
        RedBlackNode<K, K> node = this.rbTree.lowerBound(key);
        return new SetIterator<K>(this.rbTree, node);
    }

    public IteratorSTL<K> upper_bound(K key) {
        RedBlackNode<K, K> node = this.rbTree.upperBound(key);
        SetIterator<K> it = new SetIterator<K>(this.rbTree, node);
        return it;
    }

    public static void main(String[] args) {
        ComparableMultiSetSTL set = new ComparableMultiSetSTL();
        set.insert(7);
        set.insert(3);
        set.insert(9);
        set.insert(20);
        set.insert(15);
        set.insert(1);
        set.insert(20);
        set.insert(20);
        set.insert(4);
        set.insert(50);
    }

    public IteratorSTL<K> insert(IteratorSTL<K> low, K key) {
        Pair<RedBlackNode<K, K>, Boolean> pair = this.rbTree.put(key, key);
        return new SetIterator<K>(this.rbTree, (RedBlackNode)pair.first);
    }

    public void erase(IteratorSTL<K> position) {
        SetIterator setIterator = (SetIterator)position;
        RedBlackNode node = setIterator.node;
        if (node == null) {
            throw new IndexOutOfBoundsException();
        }
        setIterator.node = node.getSuccessor();
        setIterator.erased = true;
        this.rbTree.deleteEntry(node);
    }
}

