/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.prop;

import ghidra.util.exception.AssertException;
import ghidra.util.exception.NoValueException;
import ghidra.util.exception.NotYetImplementedException;
import ghidra.util.prop.PropertyPage;
import ghidra.util.prop.PropertySet;
import ghidra.util.prop.PropertyVisitor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class BytePropertySet
extends PropertySet {
    private static final long serialVersionUID = 1L;

    public BytePropertySet(String name) {
        super(name, null);
    }

    @Override
    public int getDataSize() {
        return 1;
    }

    public void putByte(long index, byte value) {
        PropertyPage page = this.getOrCreatePage(this.getPageID(index));
        int n = page.getSize();
        page.addByte(this.getPageOffset(index), value);
        this.numProperties += page.getSize() - n;
    }

    public byte getByte(long index) throws NoValueException {
        PropertyPage page = this.getPage(this.getPageID(index));
        if (page != null) {
            return page.getByte(this.getPageOffset(index));
        }
        throw noValueException;
    }

    @Override
    protected void moveIndex(long from, long to) {
        try {
            byte value = this.getByte(from);
            this.remove(from);
            this.putByte(to, value);
        }
        catch (NoValueException noValueException) {
            // empty catch block
        }
    }

    @Override
    protected void saveProperty(ObjectOutputStream oos, long index) throws IOException {
        try {
            oos.writeByte(this.getByte(index));
        }
        catch (NoValueException e) {
            throw new AssertException(e.getMessage());
        }
    }

    @Override
    protected void restoreProperty(ObjectInputStream ois, long index) throws IOException {
        this.putByte(index, ois.readByte());
    }

    @Override
    public void applyValue(PropertyVisitor visitor, long addr) {
        throw new NotYetImplementedException();
    }
}

