/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.cmd;

import ghidra.app.util.demangler.DemangledObject;
import ghidra.feature.fid.db.FidQueryService;
import ghidra.feature.fid.service.FidSearchResult;
import ghidra.feature.fid.service.FidService;
import ghidra.feature.fid.service.MatchNameAnalysis;
import ghidra.feature.fid.service.NameVersions;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSetViewAdapter;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ApplyFidEntriesCommand
extends BackgroundCommand {
    public static final String FID_CONFLICT = "FID_conflict:";
    public static final int MAGIC_MULTIPLE_MATCH_LIMIT = 10;
    public static final int MAGIC_MULTIPLE_LIBRARY_LIMIT = 5;
    public static final int MAX_PLATE_COMMENT_LINE_LENGTH = 58;
    private MatchNameAnalysis nameAnalysis = new MatchNameAnalysis();
    private AddressSet affectedLocations = new AddressSet();
    private boolean alwaysApplyFidLabels;
    private float scoreThreshold;
    private float multiNameScoreThreshold;
    private boolean createBookmarksEnabled;

    public ApplyFidEntriesCommand(AddressSetView set, float scoreThreshold, float multiThreshold, boolean alwaysApplyFidLabels, boolean createBookmarksEnabled) {
        super("ApplyFidEntriesCommand", true, true, false);
        this.scoreThreshold = scoreThreshold;
        this.multiNameScoreThreshold = multiThreshold;
        this.alwaysApplyFidLabels = alwaysApplyFidLabels;
        this.createBookmarksEnabled = createBookmarksEnabled;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        FidService service = new FidService();
        if (!(obj instanceof Program)) return false;
        Program program = (Program)obj;
        if (!service.canProcess(program.getLanguage())) {
            return false;
        }
        try (FidQueryService fidQueryService = service.openFidQueryService(program.getLanguage(), false);){
            List<FidSearchResult> processProgram = service.processProgram(program, fidQueryService, this.scoreThreshold, monitor);
            if (processProgram == null) {
                boolean bl = false;
                return bl;
            }
            Iterator<FidSearchResult> iterator = processProgram.iterator();
            while (iterator.hasNext()) {
                FidSearchResult entry = iterator.next();
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
                if (entry.function.isThunk()) continue;
                if (!entry.matches.isEmpty()) {
                    this.processMatches(entry, program, monitor);
                    continue;
                }
                Msg.trace((Object)((Object)this), (Object)("no results for function " + entry.function.getName() + " at " + entry.function.getEntryPoint()));
            }
            return true;
        }
        catch (CancelledException e) {
            return false;
        }
        catch (VersionException | IOException e) {
            this.setStatusMsg(e.getMessage());
            return false;
        }
    }

    private void processMatches(FidSearchResult result, Program program, TaskMonitor monitor) throws CancelledException {
        Object bookmarkContents = null;
        Object plateCommentContents = null;
        if (result.matches.size() == 0) {
            return;
        }
        this.nameAnalysis.analyzeNames(result.matches, program, monitor);
        if (this.nameAnalysis.getMostOptimisticCount() > 1 && this.nameAnalysis.getOverallScore() < this.multiNameScoreThreshold) {
            return;
        }
        this.nameAnalysis.analyzeLibraries(result.matches, 5, monitor);
        String newFunctionName = null;
        if (this.nameAnalysis.numNames() == 1) {
            newFunctionName = this.nameAnalysis.getNameIterator().next();
        }
        if (this.nameAnalysis.numSimilarNames() == 1) {
            bookmarkContents = "Library Function - Single Match, ";
            plateCommentContents = "Library Function - Single Match";
        } else {
            bookmarkContents = "Library Function - Multiple Matches, ";
            plateCommentContents = "Library Function - Multiple Matches";
            if (this.nameAnalysis.numNames() == 1) {
                plateCommentContents = (String)plateCommentContents + " With Same Base Name";
                bookmarkContents = (String)bookmarkContents + "Same ";
            } else {
                plateCommentContents = (String)plateCommentContents + " With Different Base Names";
                bookmarkContents = (String)bookmarkContents + "Different ";
            }
        }
        plateCommentContents = this.generateComment((String)plateCommentContents, true, false, monitor);
        bookmarkContents = this.generateBookmark((String)bookmarkContents, true, false, monitor);
        this.applyMarkup(result.function, newFunctionName, (String)plateCommentContents, (String)bookmarkContents, monitor);
    }

    private String listNames(TaskMonitor monitor) throws CancelledException {
        StringBuilder buffer = new StringBuilder();
        int counter = 0;
        if (this.nameAnalysis.numNames() < 10) {
            buffer.append("Name: ");
            Iterator<String> iterator = this.nameAnalysis.getNameIterator();
            while (iterator.hasNext()) {
                monitor.checkCanceled();
                if (counter != 0) {
                    buffer.append(", ");
                }
                buffer.append(iterator.next());
                ++counter;
            }
        } else {
            buffer.append("Names: " + this.nameAnalysis.numSimilarNames() + " - too many to list");
        }
        return buffer.toString();
    }

    private String listLibraries(TaskMonitor monitor) throws CancelledException {
        StringBuilder buffer = new StringBuilder();
        if (this.nameAnalysis.numLibraries() == 1) {
            buffer.append("Library: ");
        } else {
            buffer.append("Libraries: ");
        }
        int counter = 0;
        if (this.nameAnalysis.numLibraries() < 5) {
            Iterator<String> iterator = this.nameAnalysis.getLibraryIterator();
            while (iterator.hasNext()) {
                monitor.checkCanceled();
                if (counter != 0) {
                    buffer.append(", ");
                }
                buffer.append(iterator.next());
                ++counter;
            }
        } else {
            buffer.append(this.nameAnalysis.numLibraries() + " - too many to list");
        }
        return buffer.toString();
    }

    private String generateComment(String header, boolean includeNames, boolean includeNamespaces, TaskMonitor monitor) throws CancelledException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(header);
        buffer.append("\n");
        buffer.append(this.listNames(monitor));
        buffer.append("\n");
        buffer.append(this.listLibraries(monitor));
        return buffer.toString();
    }

    private String generateBookmark(String bookmark, boolean includeNames, boolean includeNamespaces, TaskMonitor monitor) throws CancelledException {
        StringBuilder buffer = new StringBuilder();
        if (this.createBookmarksEnabled) {
            buffer.append(bookmark);
            buffer.append(" ");
            buffer.append(this.listNames(monitor));
            buffer.append(", ");
            buffer.append(this.listLibraries(monitor));
        }
        return buffer.toString();
    }

    private void applyMarkup(Function function, String newFunctionName, String plateCommentContents, String bookmarkContents, TaskMonitor monitor) throws CancelledException {
        int numUniqueLabelNames;
        if (!this.alwaysApplyFidLabels && this.hasUserOrImportedSymbols(function)) {
            return;
        }
        if (newFunctionName != null) {
            this.addFunctionLabel(function, newFunctionName, monitor);
            numUniqueLabelNames = 1;
        } else {
            numUniqueLabelNames = this.addFunctionLabelMultipleMatches(function, monitor);
        }
        if (numUniqueLabelNames < 10) {
            if (plateCommentContents != null && !plateCommentContents.equals("")) {
                function.setComment(plateCommentContents);
            }
            if (bookmarkContents != null && !bookmarkContents.equals("")) {
                function.getProgram().getBookmarkManager().setBookmark(function.getEntryPoint(), "Analysis", "Function ID Analyzer", bookmarkContents);
            }
        }
    }

    private boolean hasUserOrImportedSymbols(Function function) {
        Symbol[] symbols;
        Program program = function.getProgram();
        SymbolTable symbolTable = program.getSymbolTable();
        for (Symbol symbol : symbols = symbolTable.getSymbols(function.getEntryPoint())) {
            SourceType sourceType = symbol.getSource();
            if (sourceType != SourceType.USER_DEFINED && sourceType != SourceType.IMPORTED) continue;
            return true;
        }
        return false;
    }

    private void addFunctionLabel(Function function, String newFunctionName, TaskMonitor monitor) throws CancelledException {
        this.removeConflictSymbols(function, newFunctionName, monitor);
        this.addSymbolToFunction(function, newFunctionName);
    }

    private void removeConflictSymbols(Function function, String matchName, TaskMonitor monitor) throws CancelledException {
        Program program = function.getProgram();
        SymbolTable symTab = program.getSymbolTable();
        BookmarkManager bkMgr = program.getBookmarkManager();
        Iterator bkmkIterator = bkMgr.getBookmarksIterator("Function ID Analyzer");
        block0: while (bkmkIterator.hasNext()) {
            Symbol[] symbols;
            monitor.checkCanceled();
            Bookmark nextBkmark = (Bookmark)bkmkIterator.next();
            for (Symbol symbol : symbols = symTab.getSymbols(nextBkmark.getAddress())) {
                monitor.checkCanceled();
                String name = symbol.getName();
                if (!name.startsWith(FID_CONFLICT)) continue;
                String baseName = name.substring(FID_CONFLICT.length());
                Address symAddr = symbol.getAddress();
                if (!baseName.equals(matchName)) continue;
                symbol.delete();
                this.removeConflictFromSymbolWhenOnlyOneLeft(symTab, symAddr, monitor);
                continue block0;
            }
        }
    }

    private void removeConflictFromSymbolWhenOnlyOneLeft(SymbolTable symTab, Address symAddr, TaskMonitor monitor) throws CancelledException {
        Symbol[] symbols = symTab.getSymbols(symAddr);
        if (symbols.length == 1) {
            if (symbols[0].getName().startsWith(FID_CONFLICT)) {
                this.removeConflictFromSymbol(symbols[0].getSource(), symbols[0]);
            }
        } else {
            int conflictCount = 0;
            Symbol keepSymbol = null;
            SourceType keepSymbolSource = null;
            for (Symbol symbol : symbols) {
                monitor.checkCanceled();
                if (conflictCount > 1) {
                    keepSymbol = null;
                    keepSymbolSource = null;
                    break;
                }
                if (!symbol.getName().startsWith(FID_CONFLICT)) continue;
                ++conflictCount;
                keepSymbol = symbol;
                keepSymbolSource = symbol.getSource();
            }
            if (keepSymbol != null) {
                this.removeConflictFromSymbol(keepSymbolSource, keepSymbol);
            }
        }
    }

    private void removeConflictFromSymbol(SourceType sourceType, Symbol symbol) {
        String newName = symbol.getName().substring(FID_CONFLICT.length());
        try {
            symbol.setName(newName, sourceType);
        }
        catch (DuplicateNameException e) {
            Msg.warn(SymbolUtilities.class, (Object)("Duplicate symbol name \"" + newName + "\" at " + symbol.getAddress()));
        }
        catch (InvalidInputException e) {
            throw new AssertException((Throwable)e);
        }
    }

    private int addFunctionLabelMultipleMatches(Function function, TaskMonitor monitor) throws CancelledException {
        Program program = function.getProgram();
        Set<String> matchNames = this.nameAnalysis.getAppriateNamesSet();
        if (matchNames.size() >= 10) {
            return matchNames.size();
        }
        Set<String> unusedNames = this.getFIDNamesThatDontExistSomewhereElse(program, matchNames);
        for (String baseName : unusedNames) {
            monitor.checkCanceled();
            String functionName = this.getFunctionNameForBaseName(program, baseName, unusedNames);
            this.addSymbolToFunction(function, functionName);
        }
        return unusedNames.size();
    }

    private String getFunctionNameForBaseName(Program program, String baseName, Set<String> unusedNames) {
        if (unusedNames.size() == 1) {
            return baseName;
        }
        DemangledObject demangledObj = NameVersions.demangle(program, baseName);
        if (demangledObj != null) {
            baseName = demangledObj.getName();
        }
        return FID_CONFLICT + baseName;
    }

    private Set<String> getFIDNamesThatDontExistSomewhereElse(Program program, Set<String> matchNames) {
        HashSet<String> unusedNames = new HashSet<String>();
        for (String name : matchNames) {
            if (this.nameExistsSomewhereElse(program.getSymbolTable(), name)) continue;
            unusedNames.add(name);
        }
        return unusedNames;
    }

    private boolean nameExistsSomewhereElse(SymbolTable symTab, String baseName) {
        List globalSymbols = symTab.getLabelOrFunctionSymbols(baseName, null);
        if (!globalSymbols.isEmpty()) {
            return true;
        }
        globalSymbols = symTab.getLabelOrFunctionSymbols("_" + baseName, null);
        if (!globalSymbols.isEmpty()) {
            return true;
        }
        globalSymbols = symTab.getLabelOrFunctionSymbols("__" + baseName, null);
        return !globalSymbols.isEmpty();
    }

    private void addSymbolToFunction(Function function, String name) {
        SymbolTable symbolTable = function.getProgram().getSymbolTable();
        Address address = function.getEntryPoint();
        try {
            symbolTable.createLabel(address, name, null, SourceType.ANALYSIS);
            this.affectedLocations.add(address);
        }
        catch (InvalidInputException e) {
            Msg.warn(SymbolUtilities.class, (Object)("Invalid symbol name: \"" + name + "\" at " + address));
        }
    }

    public AddressSetView getFIDLocations() {
        return new AddressSetViewAdapter((AddressSetView)this.affectedLocations);
    }
}

